/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.util.UWCDomainCache;
import com.sun.uwc.common.util.UWCDomainManager;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import com.sun.uwc.common.util.UWCUtils;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;

public class UWCConfigManager {
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CONFIG_DEFAULTLOCALE = "defaultlocale";
    public static final String CONFIG_IDENTITY_ENABLED = "uwcauth.identity.enabled";
    public static final String LDAP_ATTRIBUTE_NAME_PREFERRED_LANGUAGE = "preferredLanguage";
    public static final String LDAP_ATTRIBUTE_NAME_PREFERRED_LOCALE = "preferredLocale";
    private HashMap domainmap = new HashMap();
    private HashMap themecache = new HashMap();
    private String rootdirectory;
    private UWCPreferences uwcconfig;
    private UWCPreferences uwcauthconfig;
    private UWCPreferences prefs = UWCPreferences.getSystemRootInstance();
    private UWCPreferences defaultRB;
    private static final String SEP = File.separator;
    private static final Logger log = UWCLogger.getLogger("uwc");
    private String defaultLocale = null;
    private String defaultDomain = null;
    private UWCDomainManager domainManager = null;
    private boolean isISEnabled = false;
    private String CLASS_NAME = "UWCConfigManager";

    public void init(String string) throws UWCException {
        this.rootdirectory = string;
        this.loadUWCConfig();
        this.loadUWCAuthConfig();
        this.domainManager = new UWCDomainManager();
        this.domainManager.init(this.uwcconfig, this.uwcauthconfig);
        this.loadDefaultDomainProperties();
        this.loadDefaultTheme();
    }

    public String load(String string, String string2, String string3) throws UWCException {
        log.entering(this.CLASS_NAME, "load(" + string + "," + string2 + "," + string3 + ")");
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        if (!this.isDomainLoaded(string)) {
            this.loadUWCDomainConfig(string);
        }
        UWCDomainCache uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        String string4 = uWCDomainCache.resolveLocale(string2, string3);
        log.finest("Resolved locale is " + string4);
        if (string4 != null && !uWCDomainCache.isThemeLoaded(string4)) {
            uWCDomainCache.loadUWCTheme(string4);
        }
        log.exiting(this.CLASS_NAME, "load()");
        return string4;
    }

    public void loadDomainConfig(String string) throws UWCException {
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        if (!this.isDomainLoaded(string)) {
            this.loadUWCDomainConfig(string);
        }
    }

    public String loadResourceBundle(String string, String string2, String string3) throws UWCException {
        UWCDomainCache uWCDomainCache;
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        if (!this.isDomainLoaded(string)) {
            this.loadUWCDomainConfig(string);
        }
        if ((uWCDomainCache = (UWCDomainCache)this.domainmap.get(string)) == null) {
            throw new UWCException("Unable to load domain");
        }
        String string4 = uWCDomainCache.resolveLocale(string2, string3);
        log.finest("Locale Resolved is " + string4);
        return string4;
    }

    public void loadTheme(String string, String string2) throws UWCException {
        UWCDomainCache uWCDomainCache;
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        if (!this.isDomainLoaded(string)) {
            this.loadUWCDomainConfig(string);
        }
        if ((uWCDomainCache = (UWCDomainCache)this.domainmap.get(string)) == null) {
            throw new UWCException("Unable to load domain");
        }
        if (string2 != null && !uWCDomainCache.isThemeLoaded(string2)) {
            uWCDomainCache.loadUWCTheme(string2);
        }
    }

    public UWCPreferences getUWCConfigProperties() {
        return this.uwcconfig;
    }

    public UWCPreferences getUWCAuthConfigProperties() {
        return this.uwcauthconfig;
    }

    public UWCPreferences getUWCResourceBundle(String string, String string2) throws UWCException {
        log.entering(this.CLASS_NAME, "getUWCResourceBundle(" + string + "," + string2 + ")");
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        UWCDomainCache uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        if (uWCDomainCache == null) {
            this.loadUWCDomainConfig(string);
            uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        }
        if (uWCDomainCache != null) {
            if (string2 != null) {
                return uWCDomainCache.getResourceBundle(string2);
            }
            return uWCDomainCache.getDefaultResourceBundle();
        }
        log.exiting(this.CLASS_NAME, "getUWCResourceBundl()");
        return null;
    }

    public void setDomainLocale(String string, String string2) throws UWCException {
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        UWCDomainCache uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        if (uWCDomainCache == null) {
            this.loadUWCDomainConfig(string);
            uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        }
    }

    public UWCPreferences getUWCDomainProperties(String string) throws UWCException {
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        UWCDomainCache uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        if (uWCDomainCache == null) {
            this.loadUWCDomainConfig(string);
            uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        }
        if (uWCDomainCache != null) {
            return uWCDomainCache.getDomainProperties();
        }
        return null;
    }

    public UWCPreferences getUWCThemeProperties(String string, String string2) throws UWCException {
        if (string == null) {
            throw new UWCException("Domain is null");
        }
        UWCDomainCache uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        if (uWCDomainCache == null) {
            this.loadUWCDomainConfig(string);
            uWCDomainCache = (UWCDomainCache)this.domainmap.get(string);
        }
        if (uWCDomainCache != null) {
            String string3 = string2 != null ? uWCDomainCache.getTheme(string2) : uWCDomainCache.getDefaultTheme();
            UWCPreferences uWCPreferences = this.getUWCTheme(string3);
            if (null == uWCPreferences) {
                return this.getDefaultUWCTheme();
            }
            return uWCPreferences;
        }
        return null;
    }

    private UWCPreferences getUWCTheme(String string) {
        if (string == null) {
            return this.getDefaultUWCTheme();
        }
        if (this.themecache.containsKey(string)) {
            return this.prefs.getNode((String)this.themecache.get(string));
        }
        if (!this.loadUWCTheme(string)) {
            return null;
        }
        return this.prefs.getNode((String)this.themecache.get(string));
    }

    private UWCPreferences getDefaultUWCTheme() {
        if (this.themecache.containsKey("Default")) {
            return this.prefs.getNode((String)this.themecache.get("Default"));
        }
        return null;
    }

    private boolean loadUWCTheme(String string) {
        try {
            UWCPreferences uWCPreferences = this.prefs.loadNode(this.rootdirectory + SEP + "skin" + SEP + string + SEP + "themes.properties", "skin/" + string);
            if (uWCPreferences != null) {
                this.themecache.put(string, "skin/" + string);
                return true;
            }
            return false;
        }
        catch (UWCException uWCException) {
            log.warning("Cannot load theme" + string + "; file missing");
            return false;
        }
    }

    private void loadDefaultTheme() {
        try {
            UWCPreferences uWCPreferences = this.prefs.loadNode(this.rootdirectory + SEP + "skin" + SEP + "themes.properties", "skin/");
            if (uWCPreferences != null) {
                this.themecache.put("Default", "skin/");
                return;
            }
        }
        catch (UWCException uWCException) {
            log.warning("Cannot load default theme");
        }
    }

    private boolean isDomainLoaded(String string) {
        return this.domainmap.containsKey(string);
    }

    private void loadUWCConfig() throws UWCException {
        try {
            this.uwcconfig = this.prefs.loadNode(this.rootdirectory + SEP + "config" + SEP + "uwcconfig.properties", "uwcconfig");
        }
        catch (UWCException uWCException) {
            log.severe("Cannot load UWC Configuration file");
            throw new UWCException(uWCException.getMessage());
        }
        if (null == this.uwcconfig) {
            throw new UWCException("unable to load UWC Configuration");
        }
    }

    private void loadUWCAuthConfig() throws UWCException {
        try {
            this.uwcauthconfig = this.prefs.loadNode(this.rootdirectory + SEP + "config" + SEP + "uwcauth.properties", "uwcauth");
        }
        catch (UWCException uWCException) {
            log.severe("Cannot load UWC Auth Configuration file");
            throw new UWCException(uWCException.getMessage());
        }
        if (null == this.uwcauthconfig) {
            throw new UWCException("unable to load UWC Configuration");
        }
        this.defaultDomain = this.uwcauthconfig.get(CONFIG_DEFAULTDOMAIN, null);
        this.defaultLocale = this.uwcauthconfig.get(CONFIG_DEFAULTLOCALE, "en");
        this.defaultLocale = UWCUtils.convertUnderScoreToHypen(this.defaultLocale);
        this.isISEnabled = this.uwcauthconfig.getBoolean(CONFIG_IDENTITY_ENABLED, false);
    }

    private void loadUWCDomainConfig(String string) throws UWCException {
        String string2 = this.domainManager.getAttributeValue(string, LDAP_ATTRIBUTE_NAME_PREFERRED_LANGUAGE);
        string2 = null == string2 || string2.length() == 0 ? this.defaultLocale : UWCUtils.convertUnderScoreToHypen(string2);
        UWCDomainCache uWCDomainCache = new UWCDomainCache(string, this.rootdirectory, this.prefs, string2);
        this.domainmap.put(string, uWCDomainCache);
    }

    private void loadDefaultDomainProperties() throws UWCException {
        UWCPreferences uWCPreferences = null;
        try {
            uWCPreferences = this.prefs.loadNode(this.rootdirectory + SEP + "domain" + SEP + "uwcdomainconfig.properties", "domain/defaultdomain");
        }
        catch (UWCException uWCException) {
            log.warning("Unable to load default domain properties for UWC ");
        }
        try {
            this.domainManager.loadDomain(this.defaultDomain);
        }
        catch (UWCException uWCException) {
            log.warning("Unable to load default domain properties for LDAP");
        }
        this.loadDomainConfig(this.defaultDomain);
    }

    private void loadDefaultResourceBundle() {
        try {
            this.defaultRB = this.prefs.loadNode(this.rootdirectory + SEP + "domain" + SEP + "i18n.properties", "domain/defaultresourcebundle");
        }
        catch (UWCException uWCException) {
            log.warning("Unable to load default resource bundle for UWC ");
        }
    }

    public UWCDomainManager getDomainManager() {
        return this.domainManager;
    }
}

