/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.sun.uwc.common.util.UWCConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class OrderedMap
implements Serializable {
    private int mapSize = 0;
    private ArrayList keys = new ArrayList();
    private HashMap keyMap = new HashMap();
    public static final transient int INDEX_NOT_FOUND = -1;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.mapSize);
        objectOutputStream.writeObject(this.keys);
        objectOutputStream.writeObject(this.keyMap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mapSize = objectInputStream.readInt();
        this.keys = (ArrayList)objectInputStream.readObject();
        this.keyMap = (HashMap)objectInputStream.readObject();
    }

    public int size() {
        return this.mapSize;
    }

    public int getKeyIndex(String string) {
        if (null == string) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.mapSize; ++i) {
            if (!string.equals((String)this.keys.get(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean containsKey(String string) {
        if (null == string) {
            return false;
        }
        return this.keyMap.containsKey(string);
    }

    public Object get(String string) {
        if (null == string) {
            return null;
        }
        return this.keyMap.get(string);
    }

    public String getKey(int n) {
        return (String)this.keys.get(n);
    }

    public Object getValue(int n) {
        String string = this.getKey(n);
        if (null == string) {
            return null;
        }
        return this.keyMap.get(string);
    }

    public void put(String string, Object object) {
        if (null == string || null == object) {
            return;
        }
        int n = this.getKeyIndex(string);
        if (-1 == n) {
            this.keys.add(string);
            ++this.mapSize;
        } else {
            this.keys.set(n, string);
        }
        this.keyMap.put(string, object);
    }

    public Object remove(String string) {
        if (null == string) {
            return null;
        }
        int n = this.getKeyIndex(string);
        if (-1 != n) {
            this.keys.remove(n);
            --this.mapSize;
            return this.keyMap.remove(string);
        }
        return null;
    }

    public String[] getKeys() {
        return this.keys.toArray(UWCConstants.ZERO_STRING_ARRAY);
    }

    public Object[] getValues() {
        return this.keyMap.values().toArray();
    }

    public Object[] getValues(Object[] objectArray) {
        return this.keyMap.values().toArray(objectArray);
    }

    public Object[] getValuesInOrder() {
        ArrayList arrayList = this.getValuesListInOrder();
        if (null == arrayList) {
            return null;
        }
        return arrayList.toArray();
    }

    public Object[] getValuesInOrder(Object[] objectArray) {
        ArrayList arrayList = this.getValuesListInOrder();
        if (null == arrayList) {
            return null;
        }
        return arrayList.toArray(objectArray);
    }

    public ArrayList getValuesListInOrder() {
        String[] stringArray = this.getKeys();
        if (null == stringArray) {
            return null;
        }
        if (stringArray.length < 1) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.get(stringArray[i]));
        }
        return arrayList;
    }
}

