/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.iabs.coresrv.CorePersonalStore;
import com.iplanet.iabs.coresrv.CorePersonalStoreFactory;
import com.iplanet.iabs.coresrv.DBHandler;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.ldapplug.LDAP2XMLTranslatable;
import com.iplanet.xslui.auth.LDAPUserSession;
import com.iplanet.xslui.auth.LDAPUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.ldap.LDAPPool;
import com.sun.uwc.common.util.UWCPreferences;
import com.sun.uwc.common.util.UWCUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import org.w3c.dom.Element;

public class MigratePab
extends Thread {
    private static Hashtable _progress = new Hashtable();
    private String _uid;
    private String _domain;
    private String _udn;
    private String _pabDn;
    private static PropertyReader _property = null;
    private int _pabDelete;
    private HashMap _pabIabsGroupMap = null;
    private CorePersonalStore _cps = null;
    private String[] _bookEntryIds = new String[1];
    private UserSession _userSession;
    private int _grpCnt = 0;
    private int _grpDupCnt = 0;
    private int _contactCnt = 0;
    private int _contactDupCnt = 0;
    private static boolean _initiated = false;
    private static DbTranslation _dbTranslator = null;
    private LDAPPool _ldapConnPool = null;
    private HashMap _req = null;
    private static LDAPPool _userLdapConnPool = null;
    private static UserSessionFactory _userFactory = null;
    private static File _migrateConfigFile;
    private static File _configRoot;
    private static CorePersonalStoreFactory _cpsFactory;
    private static boolean _migReq;
    private static LinkedList _jobQue;
    private static Hashtable _pabPools;
    private static String _host;
    private static String _port;
    private static boolean _emailReqd;
    private static String _from;
    private static String _subject;
    private String _email = null;
    private static final String PABLDAPPOOLMIN = "pabldappoolmin";
    private static final String PABLDAPPOOLMAX = "pabldappoolmax";
    private static final String PABLDAPPOOLTIMEOUT = "pabldappooltimeout";
    private static final String BASEDN = "userbasedn";
    private static final String USERDNSDOMAIN = "userdnsdomain";
    private static final String MAIL = "mail";
    private static final String USER_LDAPPOOL_MIN = "ldapusersession.ldappoolmin";
    private static final String USER_LDAPPOOL_MAX = "ldapusersession.ldappoolmax";
    private static final String USER_LDAPPOOL_TIMEOUT = "ldapusersession.ldappooltimeout";
    private static final String USER_LDAP_HOST = "ldapusersession.ldaphost";
    private static final String USER_LDAP_PORT = "ldapusersession.ldapport";
    private static final String USER_LDAP_AUTHDN = "ldapusersession.ldapbinddn";
    private static final String USER_LDAP_AUTHCRED = "ldapusersession.ldapbindcred";
    private static final String USER_LDAP_VERSION = "3";
    private static final String USER_LDAP_SSLENABLE_FLAG = "ldapusersession.ldapsslenabled";
    private static final String LOGFILE = "logfile";
    private static final String DEF_LOG_FILE = "migrate.log";
    private static final String LOGLEVEL = "loglevel";
    private static final int DEF_LOG_LEVEL = 3;
    private static final int LDAPVERSION = 2;
    private static final String MEPABMIGRATION = "nswmextendeduserprefs";
    private static final String MAILHOST = "mailhost";
    private static final String PABURI = "paburi";
    private static final String PSROOT = "psRoot";
    private static final String DEFAULTHOST = "alwaysusedefaulthost";
    private static final String PABDELETE = "delete_pabentry";
    private static final String PABHOSTS = "pabhosts";
    private static final String PABPORTS = "pabports";
    private static final String PABBINDDNS = "pabbinddns";
    private static final String PABBINDPASSWDS = "pabpasswds";
    private static final String PABDEFAULTBASEDN = "o=pab";
    private static final String PABLDAPBASEDN = "ldapbasedn";
    private static final String THREADCOUNT = "maxthreads";
    private static final int DEFAULTMAXTHREADS = 20;
    private static final String UWCAUTHCONFIG = "uwcauth.properties";
    private static final String PAB_MIG_FNAME = "migrate.properties";
    private static final int GROUP = 0;
    private static final int CONTACT = 1;

    private static boolean initUserFactory() {
        File file;
        if (_userFactory == null && !(_userFactory = new LDAPUserSessionFactory()).init(file = new File(_configRoot.getPath(), UWCAUTHCONFIG))) {
            Logging.error((int)32, (String)"Cant init LDAPUserSessionFactory, cannt proceed with migration");
            return false;
        }
        return true;
    }

    private static boolean initCpsf() {
        if (_cpsFactory != null) {
            return true;
        }
        _cpsFactory = new CorePersonalStoreFactory();
        return _cpsFactory.init(_configRoot);
    }

    public boolean initPab(HashMap hashMap) {
        this._userSession = _userFactory.newUserSession(this._uid, this._udn, this._domain);
        this._email = this._userSession.getUserAttrib(MAIL);
        Logging.trace((int)32, (String)("email of user:" + this._email));
        this._pabDn = (String)hashMap.get("pabDn");
        this._pabDelete = _property.getIntProperty(PABDELETE, 1);
        String string = (String)hashMap.get("pabHost");
        int n = (Integer)hashMap.get("pabPort");
        String string2 = (String)hashMap.get("pabBindDn");
        String string3 = (String)hashMap.get("pabBindPasswd");
        String string4 = (String)hashMap.get("mailHost");
        int n2 = _property.getIntProperty(string4 + "." + PABLDAPPOOLMIN, 4);
        int n3 = _property.getIntProperty(string4 + "." + PABLDAPPOOLMAX, 12);
        int n4 = _property.getIntProperty(string4 + "." + PABLDAPPOOLTIMEOUT, 10);
        this._ldapConnPool = MigratePab.getLdPool(n2, n3, n4, string, n, string2, string3);
        if (this._ldapConnPool == null) {
            Logging.trace((int)32, (String)"not able to get pab ldpool");
            return false;
        }
        Logging.trace((int)32, (String)"pab initiated successfully ");
        return true;
    }

    public static boolean resolvePabData(HashMap hashMap) {
        String string;
        String string2;
        int n;
        String string3;
        String string4;
        int n2;
        UserSession userSession = null;
        String string5 = (String)hashMap.get("uid");
        String string6 = (String)hashMap.get("domain");
        String string7 = (String)hashMap.get("udn");
        Logging.trace((int)32, (String)("IN initPab" + string5 + ":" + string6));
        userSession = _userFactory.newUserSession(string5, string7, string6);
        if (userSession == null) {
            Logging.error((int)32, (String)("uid=" + string5 + ":" + "couldnt create user session " + string5 + "(domain " + string6 + ")"));
            return false;
        }
        LDAPUserSession lDAPUserSession = (LDAPUserSession)userSession;
        String[] stringArray = lDAPUserSession.getUserAttribs("nswmExtendedUserPrefs");
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!stringArray[n2].equals("mepabmigration=1")) continue;
            Logging.trace((int)32, (String)("uid=" + string5 + ":" + "This user is already migrated so, will not try to migrate again"));
            return false;
        }
        String string8 = userSession.getUserAttrib(MAILHOST);
        Logging.trace((int)32, (String)userSession.toString());
        n2 = _property.getIntProperty(string8 + "." + DEFAULTHOST, 1);
        Logging.trace((int)32, (String)userSession.getUserId());
        Logging.trace((int)32, (String)userSession.getDN());
        Logging.trace((int)32, (String)string8);
        String string9 = userSession.getUserAttrib(PABURI);
        Logging.trace((int)32, (String)string9);
        if (string8 == null || string9 == null && n2 == 0) {
            Logging.error((int)32, (String)("uid=" + string5 + ":" + "check mailhost and paburi for this user" + string5 + "(domain " + string6 + ")"));
            return false;
        }
        String[] stringArray2 = _property.getStringArrayProperty(string8 + "." + PABHOSTS, "");
        String[] stringArray3 = _property.getStringArrayProperty(string8 + "." + PABPORTS, "");
        String[] stringArray4 = _property.getStringArrayProperty(string8 + "." + PABBINDDNS, "");
        String[] stringArray5 = _property.getStringArrayProperty(string8 + "." + PABBINDPASSWDS, "");
        String string10 = _property.getStringProperty(string8 + "." + PABLDAPBASEDN, PABDEFAULTBASEDN);
        if (n2 == 0) {
            int n4;
            string4 = string9.substring(string9.lastIndexOf(47) + 1);
            string3 = string9.substring(7, string9.lastIndexOf(58));
            n = Integer.parseInt(string9.substring(string9.lastIndexOf(58) + 1, string9.lastIndexOf(47)));
            boolean bl = false;
            int n5 = stringArray2.length;
            for (n4 = 0; n4 < n5; ++n4) {
                Logging.error((int)32, (String)("uid=" + string5 + ":" + stringArray2[n4] + ":" + string3 + ":"));
                if (!string3.equalsIgnoreCase(stringArray2[n4])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Logging.error((int)32, (String)("uid=" + string5 + ":" + "Please check the pab configuration"));
                return false;
            }
            string2 = stringArray4[n4];
            string = stringArray5[n4];
        } else {
            string4 = "ou=" + string5 + "," + string7.substring(string7.indexOf(44) + 1, string7.length()) + " ," + string10;
            Logging.trace((int)32, (String)("pabdn=" + string4));
            string3 = stringArray2[0];
            n = Integer.parseInt(stringArray3[0]);
            string2 = stringArray4[0];
            string = stringArray5[0];
        }
        int n6 = _property.getIntProperty(PABDELETE, 1);
        hashMap.put("mailHost", string8);
        hashMap.put("pabDn", string4);
        hashMap.put("pabHost", string3);
        hashMap.put("pabPort", new Integer(n));
        hashMap.put("pabBindDn", string2);
        hashMap.put("pabBindPasswd", string);
        Logging.trace((int)32, (String)"pab initiated successfully ");
        return true;
    }

    public static synchronized boolean initUgLdap() {
        Logging.trace((int)32, (String)"in initUgLdap");
        if (_userLdapConnPool != null) {
            return true;
        }
        try {
            UWCPreferences uWCPreferences = UWCPreferences.getSystemRootInstance(_configRoot.getAbsolutePath());
            uWCPreferences = uWCPreferences.loadNode(UWCAUTHCONFIG, "/");
            if (uWCPreferences == null) {
                Logging.error((int)32, (String)"Error in loading the authentication configuration file");
                return false;
            }
            _userLdapConnPool = new LDAPPool(uWCPreferences.getInt(USER_LDAPPOOL_MIN, 30), uWCPreferences.getInt(USER_LDAPPOOL_MAX, 100), uWCPreferences.getInt(USER_LDAPPOOL_TIMEOUT, 30), uWCPreferences.get(USER_LDAP_HOST, null), uWCPreferences.getInt(USER_LDAP_PORT, 389), uWCPreferences.get(USER_LDAP_AUTHDN, null), uWCPreferences.get(USER_LDAP_AUTHCRED, null), uWCPreferences.getInt(USER_LDAP_VERSION, 3), uWCPreferences.getBoolean(USER_LDAP_SSLENABLE_FLAG, false));
        }
        catch (LDAPException lDAPException) {
            Logging.error((int)32, (String)("Couldn't create pool:  " + lDAPException.getMessage()));
            return false;
        }
        catch (UWCException uWCException) {
            Logging.error((int)32, (String)("Couldn't create pool:  " + uWCException.getMessage()));
            return false;
        }
        return _userLdapConnPool != null;
    }

    public synchronized void run() {
        while (_migReq) {
            try {
                this._req = MigratePab.getRequest();
                if (this._req != null) {
                    this.initMigration(this._req);
                    continue;
                }
                try {
                    this.wait(10000L);
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                }
            }
            catch (InterruptedException interruptedException) {
                Logging.error((int)32, (String)UWCUtils.getStackTraceString(interruptedException.getStackTrace()));
            }
            catch (Exception exception) {
                Logging.error((int)32, (String)UWCUtils.getStackTraceString(exception.getStackTrace()));
            }
        }
        Logging.trace((int)32, (String)(this.getName() + " is terminating"));
    }

    public static synchronized boolean initGlobals(String string, LDAPPool lDAPPool) {
        _migrateConfigFile = new File(string + File.separator + PAB_MIG_FNAME);
        _configRoot = new File(string);
        _userLdapConnPool = lDAPPool;
        return MigratePab.initGlobals();
    }

    public static synchronized boolean initGlobals(File file, File file2) {
        _migrateConfigFile = file;
        _configRoot = file2;
        return MigratePab.initGlobals();
    }

    private static synchronized boolean initGlobals() {
        if (_initiated) {
            return true;
        }
        if (!(MigratePab.initProperty(_migrateConfigFile) && MigratePab.initUserFactory() && MigratePab.initUgLdap() && MigratePab.initCpsf())) {
            return false;
        }
        int n = _property.getIntProperty(THREADCOUNT, 20);
        if (!MigratePab.initThreadPool(n)) {
            return false;
        }
        MigratePab.initEmailAttribs();
        _initiated = true;
        return true;
    }

    private static void initEmailAttribs() {
        _emailReqd = _property.getBooleanProperty("emailReqd", "true");
        if (_emailReqd) {
            _host = _property.getStringProperty("smtphost", null);
            _port = _property.getStringProperty("smtpport", "25");
            _subject = _property.getStringProperty("mailsubject", "Pab Migration Status");
            _from = _property.getStringProperty("from", "admin");
        }
    }

    private void initMigration(HashMap hashMap) {
        long l = System.currentTimeMillis();
        try {
            this._uid = (String)hashMap.get("uid");
            this._domain = (String)hashMap.get("domain");
            this._udn = (String)hashMap.get("udn");
            Logging.trace((int)32, (String)("started serving:" + this._uid + ":" + this._domain + ":" + this._udn));
            Logging.trace((int)32, (String)("Before initGlobals:" + this.getName()));
            if (!_initiated && !MigratePab.initGlobals()) {
                Logging.error((int)32, (String)("FAILED TO MIGRATE _uid=" + this._uid + " becuase initGlobals failed"));
                Logging.trace((int)32, (String)("After initGlobals:" + this.getName()));
                return;
            }
            Logging.trace((int)32, (String)("After initGlobals:" + this.getName()));
            Logging.trace((int)32, (String)("Before initPab:" + this.getName()));
            if (!this.initPab(hashMap)) {
                Logging.error((int)32, (String)("FAILED TO MIGRATE _uid=" + this._uid + " becuase initPab failed"));
                Logging.trace((int)32, (String)("After initPab:" + this.getName()));
                return;
            }
            Logging.trace((int)32, (String)("After initPab:" + this.getName()));
            Logging.trace((int)32, (String)("Before migrate:" + this.getName()));
            if (!this.migrate()) {
                MigratePab.cleanUp(this._udn);
                Logging.trace((int)32, (String)("After migrate:" + this.getName()));
                return;
            }
            Logging.trace((int)32, (String)("After migrate:" + this.getName()));
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)("FAILED TO MIGRATE _uid=" + this._uid + " due to " + exception.getMessage() + UWCUtils.getStackTraceString(exception.getStackTrace())));
            return;
        }
        Logging.trace((int)32, (String)("Time taken to migrate " + this._uid + " pab data :" + (System.currentTimeMillis() - l) + "millisecs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getRequest() {
        HashMap hashMap = null;
        try {
            LinkedList linkedList = _jobQue;
            synchronized (linkedList) {
                if (_jobQue.size() == 0) {
                    return null;
                }
                hashMap = (HashMap)_jobQue.removeFirst();
                Logging.trace((int)32, (String)("number of pending jobs:" + _jobQue.size()));
            }
            return hashMap;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static boolean initThreadPool(int n) {
        try {
            for (int i = 0; i < n; ++i) {
                MigratePab migratePab = new MigratePab();
            }
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public static void allDone() {
        _migReq = false;
    }

    private static synchronized LDAPPool getLdPool(int n, int n2, int n3, String string, int n4, String string2, String string3) {
        Logging.trace((int)32, (String)"in getLdPool");
        LDAPPool lDAPPool = null;
        String string4 = string + ":" + n4;
        lDAPPool = (LDAPPool)_pabPools.get(string4);
        if (lDAPPool != null) {
            return lDAPPool;
        }
        try {
            lDAPPool = new LDAPPool(n, n2, n3, string, n4, string2, string3, 2, false);
            if (lDAPPool != null) {
                _pabPools.put(string4, lDAPPool);
            }
        }
        catch (LDAPException lDAPException) {
            Logging.trace((int)32, (String)("cant create pool for " + string4 + " because " + lDAPException.getMessage()));
        }
        return lDAPPool;
    }

    public boolean migrate() {
        String string = "(objectclass=pabperson)";
        String string2 = "(objectclass=pabgroup)";
        this._pabIabsGroupMap = new HashMap();
        LDAPSearchResults lDAPSearchResults = null;
        LDAPSearchResults lDAPSearchResults2 = null;
        LDAPConnection lDAPConnection = null;
        String string3 = null;
        String string4 = null;
        this._grpCnt = 0;
        this._grpDupCnt = 0;
        this._contactCnt = 0;
        this._contactDupCnt = 0;
        try {
            Object object;
            Object object2;
            lDAPConnection = MigratePab.getConnection(this._ldapConnPool);
            if (lDAPConnection == null) {
                Logging.trace((int)32, (String)("uid=" + this._uid + ": Not able to get connection from pool:" + this.getName()));
                MigratePab.putBackReqInQ(this._req);
                return true;
            }
            Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ": Got conn in migration"));
            try {
                lDAPSearchResults = lDAPConnection.search(this._pabDn, 2, string2, null, false);
                lDAPSearchResults2 = lDAPConnection.search(this._pabDn, 2, string, null, false);
            }
            catch (LDAPException lDAPException) {
                Logging.error((int)32, (String)("uid=" + this._uid + ":" + lDAPException.getMessage() + ":" + lDAPException.getLDAPResultCode() + " while searching pab entries"));
                Logging.trace((int)32, (String)("CLOSING CONN because there is an error occured while searching pab entries for user :" + this._uid));
                this._ldapConnPool.close(lDAPConnection);
                return false;
            }
            Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ": Got groupsandentries for migration"));
            int n = lDAPSearchResults.getCount();
            int n2 = lDAPSearchResults2.getCount();
            if (n == 0 && n2 == 0) {
                Logging.trace((int)32, (String)("CLOSING CONN because there are no pab entries for user:" + this._uid));
                this._ldapConnPool.close(lDAPConnection);
                return false;
            }
            Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ":" + "Going to migrate " + n + " pab groups and " + n2 + " pab contacts"));
            Logging.trace((int)32, (String)(this.getName() + "uid=" + this._uid + ":" + "before calling newsessionobject"));
            this._cps = (CorePersonalStore)_cpsFactory.newSessionObject(this._userSession, this._domain);
            if (this._cps == null) {
                Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ":" + "CLOSING CONN not able to get sessionobject from cps"));
                this._ldapConnPool.close(lDAPConnection);
                MigratePab.putBackReqInQ(this._req);
                return true;
            }
            Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ":" + "before calling initDbTranslator"));
            if (_dbTranslator == null && !MigratePab.initDbTrans()) {
                Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ":" + "CLOSING CONN not able to initate dbtranslator"));
                this._ldapConnPool.close(lDAPConnection);
                return false;
            }
            this._bookEntryIds[0] = this._cps.getDefaultBook("abook").getEntryID();
            boolean bl = true;
            int n3 = 0;
            int n4 = 0;
            while (lDAPSearchResults.hasMoreElements()) {
                ++n3;
                object2 = lDAPSearchResults.next();
                if (this.storeGroupInABS((LDAPEntry)object2)) continue;
                bl = false;
            }
            Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ":" + "Group migrate done"));
            object2 = new Vector();
            while (lDAPSearchResults2.hasMoreElements()) {
                ++n4;
                object = lDAPSearchResults2.next();
                if (this.storeEntryInABS((LDAPEntry)object)) {
                    ((Vector)object2).add(object.getDN());
                    continue;
                }
                bl = false;
            }
            Logging.trace((int)32, (String)(this.getName() + ":uid=" + this._uid + ":" + "contact migrate done"));
            if (n3 == this._grpCnt + this._grpDupCnt && n4 == this._contactCnt + this._contactDupCnt) {
                bl = true;
            }
            string4 = this._grpCnt + " out of " + n3 + " groups were successfully migrated. ";
            if (this._grpDupCnt > 0) {
                string4 = string4 + this._grpDupCnt + " groups were not migrated as they were already present in the Address Book Server.";
            }
            Logging.trace((int)32, (String)("uid=" + this._uid + string4));
            string3 = this._contactCnt + " out of " + n4 + " contacts were successfully migrated. ";
            if (this._contactDupCnt > 0) {
                string3 = string3 + this._contactDupCnt + " contacts were not migrated as they were already present in the Address Book Server.";
            }
            object = "Groups and Contacts from old webmail have been migrated to new Address Book Server. Here is the status of migration:";
            Logging.trace((int)32, (String)("uid=" + this._uid + string3));
            if (this._pabDelete == 1 && bl) {
                Logging.trace((int)32, (String)("uid=" + this._uid + ":" + "entries in Pab is getting deleted now.."));
                Object object3 = this._pabIabsGroupMap.keySet().iterator();
                while (object3.hasNext()) {
                    this.deleteEntry(lDAPConnection, "un=" + object3.next() + "," + this._pabDn);
                }
                object3 = ((Vector)object2).elements();
                while (object3.hasMoreElements()) {
                    this.deleteEntry(lDAPConnection, (String)object3.nextElement());
                }
            }
            if (bl) {
                this.updateUserEntry();
                if (_emailReqd) {
                    this.sendEmail((String)object + "\n\n" + string3 + "\n" + string4);
                }
            }
        }
        catch (LDAPException lDAPException) {
            Logging.error((int)32, (String)("uid=" + this._uid + ": LDAPException in migrate:" + lDAPException.getMessage() + UWCUtils.getStackTraceString(lDAPException.getStackTrace())));
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)("uid=" + this._uid + ": General Exception in migrate:" + exception.getMessage() + UWCUtils.getStackTraceString(exception.getStackTrace())));
        }
        Logging.trace((int)32, (String)("uid=" + this._uid + ":CLOSING CONN normal close migrate done:" + this.getName()));
        this._ldapConnPool.close(lDAPConnection);
        MigratePab.cleanUp(this._udn);
        return true;
    }

    private void sendEmail(String string) {
        try {
            Properties properties = new Properties();
            properties.put("mail.smtp.host", _host);
            properties.put("mail.smtp.port", _port);
            Session session = Session.getDefaultInstance((Properties)properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(_from));
            InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(this._email)};
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
            mimeMessage.setSubject(_subject);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setText(string);
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException messagingException) {
            Logging.error((int)32, (String)"Not able to send emial notification to user");
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)UWCUtils.getStackTraceString(exception.getStackTrace()));
        }
    }

    private void updateUserEntry() {
        String string = "(objectclass=*)";
        LDAPConnection lDAPConnection = null;
        LDAPModification lDAPModification = null;
        try {
            LDAPAttribute lDAPAttribute;
            lDAPConnection = MigratePab.getConnection(_userLdapConnPool);
            if (this._pabDelete == 1) {
                lDAPAttribute = new LDAPAttribute(PABURI);
                lDAPModification = new LDAPModification(1, lDAPAttribute);
                lDAPConnection.modify(this._udn, lDAPModification);
            }
            lDAPAttribute = new LDAPAttribute(MEPABMIGRATION, "mepabmigration=1");
            lDAPModification = new LDAPModification(0, lDAPAttribute);
            lDAPConnection.modify(this._udn, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            Logging.error((int)32, (String)("uid=" + this._uid + ":LDAPException while setting mepabmigration to 1 in user entry:" + lDAPException.getMessage() + ":" + lDAPException.getLDAPResultCode()));
        }
        Logging.trace((int)32, (String)(this.getName() + "uid=" + this._uid + ":CLOSING CONN updated user entry so closing conn"));
        _userLdapConnPool.close(lDAPConnection);
    }

    private void deleteEntry(LDAPConnection lDAPConnection, String string) {
        try {
            lDAPConnection.delete(string);
        }
        catch (LDAPException lDAPException) {
            Logging.trace((int)32, (String)("uid=" + this._uid + ":LDAPException while deleting the pabentry at source " + lDAPException.getLDAPResultCode() + ":" + lDAPException.getMessage()));
        }
    }

    private boolean storeGroupInABS(LDAPEntry lDAPEntry) {
        String string = this.addEntry(lDAPEntry, 0);
        if (string != null) {
            this.updateMap(lDAPEntry, string);
            return true;
        }
        return false;
    }

    private void updateMap(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = new String[1];
        stringArray = lDAPEntry.getAttribute("un").getStringValueArray();
        this._pabIabsGroupMap.put(stringArray[0], string);
    }

    private boolean storeEntryInABS(LDAPEntry lDAPEntry) {
        LDAPEntry lDAPEntry2 = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("memberofpabgroup");
        if (lDAPAttribute != null) {
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            lDAPAttributeSet.remove("memberofpabgroup");
            String[] stringArray = new String[lDAPAttribute.size()];
            int n = 0;
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                String string = (String)this._pabIabsGroupMap.get(enumeration.nextElement());
                stringArray[n++] = string;
            }
            lDAPAttributeSet.add(new LDAPAttribute("memberofpabgroup", stringArray));
            lDAPEntry2 = new LDAPEntry(lDAPEntry.getDN(), lDAPAttributeSet);
        } else {
            lDAPEntry2 = lDAPEntry;
        }
        return this.addEntry(lDAPEntry2, 1) != null;
    }

    private String addEntry(LDAPEntry lDAPEntry, int n) {
        String string;
        block7: {
            Element element = null;
            string = null;
            try {
                element = _dbTranslator.translate((DbTranslatable)new LDAP2XMLTranslatable(MigratePab.unescapeEntry(lDAPEntry)));
                Logging.trace((int)32, (String)("entry after translation:" + element.toString()));
            }
            catch (DbTransException dbTransException) {
                Logging.trace((int)32, (String)("uid=" + this._uid + ":" + "failed to translate the entry:" + lDAPEntry.getDN()));
                Logging.trace((int)32, (String)("uid=" + this._uid + ":" + dbTransException.getMessage()));
                return null;
            }
            try {
                Logging.trace((int)32, (String)("book entry id" + this._bookEntryIds[0]));
                string = this._cps.addEntry(this._bookEntryIds, element);
                Logging.trace((int)32, (String)("uid=" + this._uid + ":" + "pab entry: " + lDAPEntry.getDN() + " is migrated. Its abs entryId is: " + string));
                if (n == 1) {
                    ++this._contactCnt;
                } else {
                    ++this._grpCnt;
                }
            }
            catch (PStoreException pStoreException) {
                Logging.trace((int)32, (String)("uid=" + this._uid + ":" + "failed to add the entry into pstore:" + lDAPEntry.getDN()));
                Logging.trace((int)32, (String)("uid=" + this._uid + ":" + pStoreException.getMessage()));
                if (pStoreException.getReason() != 19 || (string = pStoreException.getExtraDetails()) == null) break block7;
                if (n == 1) {
                    ++this._contactDupCnt;
                }
                ++this._grpDupCnt;
            }
        }
        return string;
    }

    private static LDAPConnection getConnection(LDAPPool lDAPPool) {
        Logging.trace((int)32, (String)"in getConnection");
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = lDAPPool.getConnection();
        }
        catch (LDAPException lDAPException) {
            Logging.error((int)32, (String)("LDAPException when tried to get conn from pool:" + lDAPException.getMessage()));
        }
        if (lDAPConnection == null) {
            Logging.trace((int)32, (String)"request for a connection from pool time out");
        }
        return lDAPConnection;
    }

    private static void cleanUp(String string) {
        Logging.trace((int)32, (String)("USER UNLOCKED:" + string));
        _progress.remove(string);
    }

    public MigratePab() {
        Logging.trace((int)32, (String)(this.getName() + " is started"));
        this.start();
    }

    private static boolean initProperty(File file) {
        if (_property != null) {
            return true;
        }
        Logging.trace((int)32, (String)"in initproperty");
        try {
            _property = new PropertyReader(file);
            String string = _property.getStringProperty(LOGFILE, _configRoot + File.separator + DEF_LOG_FILE);
            int n = _property.getIntProperty(LOGLEVEL, 3);
            Logging logging = new Logging(new File(string));
            Logging.setState((int)n);
        }
        catch (IOException iOException) {
            Logging.error((int)32, (String)("Cant read config at: " + _migrateConfigFile.getAbsolutePath() + ":" + iOException.getMessage()));
            return false;
        }
        return true;
    }

    public static void destroyMigration() {
        if (!_pabPools.isEmpty()) {
            Iterator iterator = _pabPools.values().iterator();
            while (iterator.hasNext()) {
                LDAPPool lDAPPool = (LDAPPool)iterator.next();
                lDAPPool.destroy();
            }
        }
        if (_userLdapConnPool != null) {
            _userLdapConnPool.destroy();
        }
        _migReq = false;
    }

    private static boolean inProgress(String string) {
        return _progress.containsKey(string);
    }

    private static synchronized boolean initDbTrans() {
        try {
            Logging.trace((int)32, (String)("ConfPath:" + _configRoot.getPath()));
            _dbTranslator = new DbTranslation(new File(_configRoot.getPath(), "ldappstore" + File.separator + "migrate"));
        }
        catch (DbTransException dbTransException) {
            Logging.error((int)32, (String)dbTransException.getMessage());
            return false;
        }
        return true;
    }

    private static LDAPEntry unescapeEntry(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttributeSet lDAPAttributeSet2 = new LDAPAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String[] stringArray = lDAPAttribute.getStringValueArray();
            String[] stringArray2 = new String[stringArray.length];
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = MigratePab.unescape(stringArray[i]);
            }
            lDAPAttributeSet2.add(new LDAPAttribute(MigratePab.remLangQal(lDAPAttribute.getName()), stringArray2));
        }
        enumeration = new LDAPEntry(lDAPEntry.getDN(), lDAPAttributeSet2);
        return enumeration;
    }

    private static String remLangQal(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String unescape(String string) {
        char[] cArray = string.toCharArray();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (cArray[i] == '\\') {
                if (cArray[i + 1] == '2' && cArray[i + 2] == '4') {
                    stringBuffer.append('$');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == 'a') {
                    stringBuffer.append(':');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '2') {
                    stringBuffer.append('\"');
                } else if (cArray[i + 1] == '7' && cArray[i + 2] == 'c') {
                    stringBuffer.append('|');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '5') {
                    stringBuffer.append('%');
                } else if (cArray[i + 1] == '5' && cArray[i + 2] == 'e') {
                    stringBuffer.append('^');
                } else if (cArray[i + 1] == '5' && cArray[i + 2] == 'c') {
                    stringBuffer.append('\\');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '8') {
                    stringBuffer.append('(');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '9') {
                    stringBuffer.append(')');
                }
                i += 2;
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private static synchronized String getPsRootVal(HashMap hashMap) {
        if (!MigratePab.initCpsf() || !MigratePab.resolvePabData(hashMap)) {
            Logging.error((int)32, (String)"MigratePab.getPsRootVal: cant initialize cps or not able to resolv pab data");
            return null;
        }
        String string = (String)hashMap.get("udn");
        String string2 = (String)hashMap.get("uid");
        String string3 = (String)hashMap.get("domain");
        String string4 = (String)hashMap.get("pabHost") + "." + ((Integer)hashMap.get("pabPort")).toString();
        String string5 = _property.getStringProperty(string4 + ".abhostport", null);
        if (string5 == null) {
            string5 = (String)hashMap.get("pabHost") + ":" + ((Integer)hashMap.get("pabPort")).toString();
        }
        Logging.trace((int)32, (String)("hostport of abs set for " + string4 + " is:" + string5));
        DBHandler dBHandler = _cpsFactory.getDBHandler(string3);
        String string6 = dBHandler.getDefaultPsRootPattern();
        String string7 = string6.substring(string6.lastIndexOf(47), string6.indexOf(61));
        String string8 = string6.substring(string6.lastIndexOf(44), string6.length());
        String string9 = string6.replaceAll("///", "//" + string5 + "/");
        string9 = string9.replaceAll("%U", string2);
        string9 = string9.replaceAll("%D", string3);
        return string9;
    }

    static boolean setPsRoot(HashMap hashMap) {
        String string = null;
        String string2 = null;
        boolean bl = true;
        LDAPConnection lDAPConnection = null;
        try {
            if (!MigratePab.initUgLdap()) {
                Logging.error((int)32, (String)"MigratePab.startMigration: Cannot initialize UG LDAP.");
                return false;
            }
            string = (String)hashMap.get("udn");
            string2 = MigratePab.getPsRootVal(hashMap);
            if (string2 == null) {
                Logging.error((int)32, (String)"MigratePab.setPsRoot: nota ble to compute psroot val");
                return false;
            }
            LDAPModification lDAPModification = null;
            Logging.trace((int)32, (String)("Setting psroot to:" + string + " with psRoot value as:" + string2));
            try {
                lDAPConnection = MigratePab.getConnection(_userLdapConnPool);
                LDAPAttribute lDAPAttribute = new LDAPAttribute(PSROOT, string2);
                lDAPModification = new LDAPModification(0, lDAPAttribute);
                lDAPConnection.modify(string, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                Logging.error((int)32, (String)("user DN = " + string + ":LDAPException while setting value of psRoot as " + string2 + ":" + lDAPException.getMessage() + ":" + lDAPException.getLDAPResultCode()));
                if (lDAPException.getLDAPResultCode() != 20) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)("user DN = " + string + ":Exception while setting value of psRoot as " + string2 + ":" + exception.getMessage()));
            bl = false;
        }
        if (lDAPConnection != null) {
            _userLdapConnPool.close(lDAPConnection);
        }
        if (bl) {
            Logging.trace((int)32, (String)("Setting psroot to " + string + " is successful"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startMigration(String string, String string2, String string3) {
        if (MigratePab.inProgress(string3)) {
            return;
        }
        Logging.trace((int)32, (String)("NEW Request to Migrate: uid=" + string + ",domain=" + string2 + ",dn=" + string3));
        Object var3_3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", string);
        hashMap.put("domain", string2);
        hashMap.put("udn", string3);
        Logging.trace((int)32, (String)("USER LOCKED:" + string3));
        _progress.put(string3, "");
        if (!MigratePab.setPsRoot(hashMap)) {
            MigratePab.cleanUp(string3);
            return;
        }
        LinkedList linkedList = _jobQue;
        synchronized (linkedList) {
            _jobQue.add(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putBackReqInQ(HashMap hashMap) {
        LinkedList linkedList = _jobQue;
        synchronized (linkedList) {
            _jobQue.add(hashMap);
            Logging.trace((int)32, (String)("FAILOVER FOR:" + (String)hashMap.get("uid") + " number of pending jobs:" + _jobQue.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2;
        LDAPAttribute lDAPAttribute;
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = null;
        PropertyReader propertyReader = null;
        String string4 = null;
        if (stringArray.length < 3) {
            System.out.println("usage is java MigratePab <obsolute filename of migrate.properties> <obsolute path of ABS config directory>  <inetbasedomaindn>");
            return;
        }
        String string5 = stringArray[0];
        string3 = stringArray[2];
        Logging.trace((int)32, (String)"Started Batch Migration from PAB To ABS");
        if (!MigratePab.initGlobals(new File(string5), new File(stringArray[1]))) {
            MigratePab.destroyMigration();
            return;
        }
        LDAPConnection lDAPConnection = MigratePab.getConnection(_userLdapConnPool);
        LDAPSearchResults lDAPSearchResults = null;
        try {
            propertyReader = new PropertyReader(new File(stringArray[1] + File.separator + UWCAUTHCONFIG));
        }
        catch (IOException iOException) {
            Logging.error((int)32, (String)("not able to read uwcauth.properties file from:" + stringArray[1] + File.separator + UWCAUTHCONFIG));
            MigratePab.destroyMigration();
            return;
        }
        string4 = propertyReader.getStringProperty("ldapusersession.defaultugfilter", null);
        string4 = string4 == null ? "uid" : string4.substring(0, string4.lastIndexOf(61));
        String[] stringArray3 = new String[]{string4};
        String string6 = "(&(objectclass=inetmailuser)(!(nswmextendeduserprefs=mepabmigration=1)))";
        try {
            lDAPSearchResults = lDAPConnection.search(string3, 2, string6, stringArray3, false);
            stringArray3[0] = "o";
            object2 = lDAPConnection.search(string3, 0, null, stringArray3, false);
            if (object2.hasMoreElements()) {
                object = object2.next();
                lDAPAttribute = object.getAttribute("o");
                stringArray2 = lDAPAttribute.getStringValueArray();
                string2 = stringArray2[0];
            }
        }
        catch (LDAPException lDAPException) {
            Logging.error((int)32, (String)("LDAPException while finding the domain value of user:" + lDAPException.getMessage() + ":" + lDAPException.getLDAPResultCode()));
            MigratePab.destroyMigration();
            return;
        }
        Logging.trace((int)32, (String)("number users undergoing migration:" + lDAPSearchResults.getCount()));
        if (lDAPSearchResults.getCount() == 0) {
            Logging.trace((int)32, (String)"CLOSING CONN");
            _userLdapConnPool.close(lDAPConnection);
            MigratePab.destroyMigration();
            return;
        }
        while (lDAPSearchResults.hasMoreElements()) {
            try {
                object2 = null;
                try {
                    object2 = lDAPSearchResults.next();
                }
                catch (LDAPException lDAPException) {
                    Logging.error((int)32, (String)("LDAPException while retrieving user entries:" + lDAPException.getLDAPResultCode() + ":" + lDAPException.getMessage()));
                    continue;
                }
                object = object2.getDN();
                lDAPAttribute = object2.getAttribute(string4);
                if (lDAPAttribute == null) {
                    System.out.println(object2.toString());
                    continue;
                }
                stringArray2 = lDAPAttribute.getStringValueArray();
                string = stringArray2[0];
                MigratePab.startMigration(string, string2, object2.getDN());
            }
            catch (Exception exception) {
                Logging.error((int)32, (String)("Got following exception: " + exception.getMessage() + "while migrating user: " + string));
            }
        }
        object2 = new Integer("1");
        while (true) {
            int n;
            if ((n = MigratePab.getQsize()) == 0) break;
            lDAPAttribute = object2;
            synchronized (lDAPAttribute) {
                try {
                    object2.wait(50000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        MigratePab.destroyMigration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getQ() {
        String string = null;
        LinkedList linkedList = _jobQue;
        synchronized (linkedList) {
            string = _jobQue.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getQsize() {
        int n = 0;
        LinkedList linkedList = _jobQue;
        synchronized (linkedList) {
            n = _jobQue.size();
        }
        return n;
    }

    static {
        _cpsFactory = null;
        _migReq = true;
        _jobQue = new LinkedList();
        _pabPools = new Hashtable();
        _host = null;
        _port = null;
        _emailReqd = false;
        _from = null;
        _subject = null;
    }
}

