/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.ldap.LDAPUtil;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class MailUserPreferencesModel
extends UserPreferencesModel {
    private static final String CLASS_NAME = "MailUserPreferencesModel";
    public static final String UWC_MAIL_PREFERENCES_INITIALIZED = "UWCMailPreferencesInitialized";
    public static final String MAIL_EXTENDED_USER_PREFS = "nswmExtendedUserPrefs";
    public static final String ME_REPLY_TO_ADDRESS = "meReplyToAddress";
    public static final String ME_AUTO_SIGN = "meAutoSign";
    public static final String ME_SIGNATURE = "meSignature";
    public static final String ME_INCLUDE_VCARD = "meIncludeVCard";
    public static final String ME_VCARD = "vCard";
    public static final String ME_TRASH_FOLDER = "meTrashFolder";
    public static final String ME_PREV_TRASH_FOLDER = "mePrevTrash";
    public static final String ME_EXPUNGE_ON_EXIT = "meExpungeOnExit";
    public static final String ME_OPEN_NEXT_MESSAGE = "meOpenNextMessage";
    public static final String ME_SENT_FOLDER = "meSentFolder";
    public static final String ME_DRAFT_FOLDER = "meDraftFolder";
    public static final String ME_AUTO_SPELL = "meAutoSpell";
    public static final String ME_VIEW_SIZE = "meViewSize";
    public static final String ME_SORT_ORDER = "meSortOrder";
    public static final String ME_VIEW_RTF = "meViewRtf";
    public static final String ME_INITIALIZED = "meInitialized";
    public static final String ME_DISPLAY_COLUMNS = "meDisplayColumns";
    public static final String ME_AUTO_QUOTE = "meAutoQuote";
    public static final String ME_POP_ACCOUNT = "mePopAccount";
    public static final String ME_SMIME_SIGN = "meSMIMESign";
    public static final String ME_SMIME_ENCRYPT = "meSMIMEEncrypt";
    public static final String ME_DATE_FORMAT = "meDateFormat";
    public static final String ME_SIGNCERT = "meSignCertInfo";
    public static final String VACATION_END_DATE = "vacationEndDate";
    public static final String VACATION_START_DATE = "vacationStartDate";
    public static final String MAIL_ALTERNATE_ADDRESS = "mailAlternateAddress";
    public static final String MAIL_AUTO_REPLY_MODE = "mailAutoReplyMode";
    public static final String MAIL_AUTO_REPLY_SUBJECT = "mailAutoReplySubject";
    public static final String MAIL_AUTO_REPLY_TEXT_INTERNAL = "mailAutoReplyTextInternal";
    public static final String MAIL_AUTO_REPLY_TIMEOUT = "mailAutoReplyTimeout";
    public static final String MAIL_AUTO_REPLY_TEXT = "mailAutoReplyText";
    public static final String MAIL_FORWARDING_ADDRESS = "mailForwardingAddress";
    public static final String MAIL_DELIVERY_OPTION = "mailDeliveryOption";
    public static final String MAIL_SIEVE_RULE_SOURCE = "mailSieveRuleSource";
    public static final String ME_UC_MAIL_SEND_PROFILES = "sunUCMailSendProfiles";
    private static String[] _mailUserAttrs = new String[]{"nswmExtendedUserPrefs", "vacationEndDate", "vacationStartDate", "mailAlternateAddress", "mailAutoReplyMode", "mailAutoReplySubject", "mailAutoReplyTextInternal", "mailAutoReplyTimeout", "mailAutoReplyText", "mailForwardingAddress", "mailDeliveryOption", "mailSieveRuleSource"};
    private static final String LANG_SUFFIX = ";lang-";
    private static String[] _mailUserLangTypedAttrs = new String[]{"mailAutoReplySubject;lang-", "mailAutoReplyTextInternal;lang-", "mailAutoReplyText;lang-"};
    private static String[] _mailUserMultiValuedAttrs = new String[]{"nswmExtendedUserPrefs", "mailForwardingAddress", "mailDeliveryOption", "mailSieveRuleSource"};
    private static String[] _mailUserMailExtendedPrefAttrs = new String[]{"UWCMailPreferencesInitialized", "meReplyToAddress", "meAutoSign", "meSignature", "meIncludeVCard", "vCard", "meTrashFolder", "mePrevTrash", "meExpungeOnExit", "meOpenNextMessage", "meSentFolder", "meDraftFolder", "meAutoSpell", "meViewSize", "meSortOrder", "meViewRtf", "meInitialized", "meDisplayColumns", "meAutoQuote", "mePopAccount", "meSMIMESign", "meSMIMEEncrypt", "meSignCertInfo", "meDateFormat"};
    private static String[][] _mailUserMultiValuedAttrsSubTypes = new String[][]{_mailUserMailExtendedPrefAttrs, {" "}, {" "}, {" "}};

    public MailUserPreferencesModel() throws UWCException {
    }

    public MailUserPreferencesModel(RequestContext requestContext) throws UWCException {
        super(requestContext);
    }

    public void initializeMailPreferences() throws UWCException {
        Hashtable hashtable = new Hashtable();
        String[] stringArray = this.getAllMailUserAttrs(_mailUserAttrs, _mailUserLangTypedAttrs);
        if (this._isAnonymous) {
            hashtable = this.initializeForAnonAccess(stringArray, _mailUserMultiValuedAttrs, _mailUserMultiValuedAttrsSubTypes, hashtable);
        } else {
            hashtable = this.initializeForAuthUser();
            _prefsLogger.finest("BNA: obtained prefs:" + hashtable.toString());
        }
        this.setAttrValuesInSession(hashtable, stringArray, _mailUserMultiValuedAttrs, _mailUserMultiValuedAttrsSubTypes);
    }

    protected Hashtable initializeForAuthUser() throws UWCException {
        Hashtable hashtable;
        LDAPConnection lDAPConnection;
        block19: {
            _prefsLogger.entering(CLASS_NAME, "initializeForAuthUser()");
            lDAPConnection = null;
            String string = null;
            LDAPUtil lDAPUtil = null;
            string = this.getUserDN();
            if (null == string) {
                _prefsLogger.warning("Empty User DN");
                throw new UWCException("User DN is empty!");
            }
            try {
                lDAPConnection = this.getLdapConnection();
            }
            catch (LDAPException lDAPException) {
                _prefsLogger.warning("Unable to obtain LDAP Connection");
                throw new UWCException(lDAPException.getMessage());
            }
            if (null == lDAPConnection) {
                _prefsLogger.warning("Timedout in obtaining LDAP Connection");
                throw new UWCException("Could not obtain LDAP Connection object");
            }
            try {
                lDAPUtil = new LDAPUtil(lDAPConnection, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _prefsLogger.warning("Couldnot obtain LDAPUtil object!");
                throw new UWCException(illegalArgumentException.getMessage());
            }
            try {
                lDAPUtil.loadValues();
            }
            catch (LDAPException lDAPException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Couldnot Load entry for DN: " + string);
                }
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                throw new UWCException(lDAPException.getMessage());
            }
            String string2 = "meInitialized=true";
            String string3 = "UWCMailPreferencesInitialized=true";
            boolean bl = lDAPUtil.isValuePresentIgnoreCase(MAIL_EXTENDED_USER_PREFS, string2);
            boolean bl2 = lDAPUtil.isValuePresentIgnoreCase(MAIL_EXTENDED_USER_PREFS, string3);
            boolean bl3 = false == bl && false == bl2;
            hashtable = new Hashtable();
            String[] stringArray = this.getAllMailUserAttrs(_mailUserAttrs, _mailUserLangTypedAttrs);
            this.initializeAndObtainPrefs(lDAPUtil, stringArray, _mailUserMultiValuedAttrs, _mailUserMultiValuedAttrsSubTypes, hashtable, bl3);
            if (bl3) {
                try {
                    lDAPUtil.modifyAttribute(0, MAIL_EXTENDED_USER_PREFS, string3);
                }
                catch (LDAPException lDAPException) {
                    if (_prefsLogger.isLoggable(Level.WARNING)) {
                        _prefsLogger.warning("Unable to add the value \"" + string3 + "\" to attribute \"" + MAIL_EXTENDED_USER_PREFS + "\" in " + string);
                    }
                    this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                    throw new UWCException(lDAPException.getMessage());
                }
            }
            try {
                this.migrateVacationAttribs(lDAPUtil);
            }
            catch (LDAPException lDAPException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Unable to migrate the vacation attributes" + lDAPException.getMessage());
                }
            }
            catch (UWCException uWCException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Unable to migrate the vacation attributes" + uWCException.getMessage());
                }
            }
            catch (Exception exception) {
                if (!_prefsLogger.isLoggable(Level.WARNING)) break block19;
                _prefsLogger.warning("Unable to migrate the vacation attributes" + exception.getMessage());
            }
        }
        this.releaseLdapConnection(lDAPConnection);
        _prefsLogger.exiting(CLASS_NAME, "initializeForAuthUser()");
        return hashtable;
    }

    private void migrateVacationAttribs(LDAPUtil lDAPUtil) throws LDAPException, UWCException {
        String string;
        Hashtable hashtable = lDAPUtil.getValues();
        if (hashtable == null) {
            return;
        }
        Hashtable hashtable2 = new Hashtable();
        boolean bl = false;
        Object object = hashtable.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (!bl && (string.equalsIgnoreCase(MAIL_AUTO_REPLY_SUBJECT) || string.equalsIgnoreCase(MAIL_AUTO_REPLY_TEXT_INTERNAL) || string.equalsIgnoreCase(MAIL_AUTO_REPLY_TEXT))) {
                bl = true;
            }
            if (!string.startsWith("mailAutoReplyText;") && !string.startsWith("mailAutoReplyTextInternal;") && !string.startsWith("mailAutoReplySubject;")) continue;
            hashtable2.put(string, hashtable.get(string));
        }
        if (hashtable2.isEmpty()) {
            return;
        }
        if (!bl && !hashtable2.isEmpty()) {
            object = UWCUserHelper.getLanguage(this._reqCtx);
            string = null;
            if (object != null) {
                String[] stringArray = (String[])hashtable2.get("mailAutoReplySubject;lang-" + (String)object);
                String[] stringArray2 = (String[])hashtable2.get("mailAutoReplyText;lang-" + (String)object);
                String[] stringArray3 = (String[])hashtable2.get("mailAutoReplyTextInternal;lang-" + (String)object);
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                if (stringArray != null) {
                    lDAPModificationSet.add(0, new LDAPAttribute(MAIL_AUTO_REPLY_SUBJECT, stringArray[0]));
                }
                if (stringArray2 != null) {
                    lDAPModificationSet.add(0, new LDAPAttribute(MAIL_AUTO_REPLY_TEXT, stringArray2[0]));
                }
                if (stringArray3 != null) {
                    lDAPModificationSet.add(0, new LDAPAttribute(MAIL_AUTO_REPLY_TEXT_INTERNAL, stringArray3[0]));
                }
                if (lDAPModificationSet.size() > 0) {
                    this.modifyMultipleAttributes(lDAPModificationSet);
                    if (stringArray != null) {
                        this.setValueInSession(MAIL_AUTO_REPLY_SUBJECT, stringArray[0]);
                    }
                    if (stringArray2 != null) {
                        this.setValueInSession(MAIL_AUTO_REPLY_TEXT, stringArray2[0]);
                    }
                    if (stringArray3 != null) {
                        this.setValueInSession(MAIL_AUTO_REPLY_TEXT_INTERNAL, stringArray3[0]);
                    }
                }
            }
        }
        if (!hashtable2.isEmpty()) {
            lDAPUtil.modifyAttribute(1, hashtable2);
        }
    }

    public void updateMailPreferences() throws UWCException {
        String[] stringArray = this.getAllMailUserAttrs(_mailUserAttrs, _mailUserLangTypedAttrs);
        super.updatePreferences(stringArray, _mailUserMultiValuedAttrs, _mailUserMultiValuedAttrsSubTypes);
    }

    private String[] getAllMailUserAttrs(String[] stringArray, String[] stringArray2) {
        String string;
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
                ++n;
            }
        }
        if (null != (string = UWCUserHelper.getLanguage(null)) && null != stringArray2) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i] + string);
                ++n;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private String getLangTypedAttributeValue(String string) {
        String string2;
        if (null == string) {
            return null;
        }
        String string3 = UWCUserHelper.getLanguage(null);
        if (null != string3 && null != (string2 = (String)this.getValue(string + LANG_SUFFIX + string3))) {
            return string2;
        }
        return (String)this.getValue(string);
    }

    private void setLangTypedAttributeValue(String string, String string2) {
        if (null == string || null == string2) {
            return;
        }
        String string3 = UWCUserHelper.getLanguage(null);
        if (null != string3) {
            this.setValue(string + LANG_SUFFIX + string3, string2);
        } else {
            this.setValue(string, string2);
        }
    }

    public String getReplyToAddress() {
        return (String)this.getValue(ME_REPLY_TO_ADDRESS);
    }

    public boolean getAutoSign() {
        return new Boolean((String)this.getValue(ME_AUTO_SIGN));
    }

    public String getSignature() {
        return (String)this.getValue(ME_SIGNATURE);
    }

    public boolean getIncludeVCard() {
        return new Boolean((String)this.getValue(ME_INCLUDE_VCARD));
    }

    public String getVCard() {
        return (String)this.getValue(ME_VCARD);
    }

    public String getTrashFolder() {
        String string = (String)this.getValue(ME_TRASH_FOLDER);
        if (string != null && string.trim().length() == 0 || string == null) {
            string = " ";
        }
        return string;
    }

    public String getPrevTrashFolder() {
        return (String)this.getValue(ME_PREV_TRASH_FOLDER);
    }

    public boolean getExpungeOnExit() {
        return new Boolean((String)this.getValue(ME_EXPUNGE_ON_EXIT));
    }

    public boolean getOpenNextMessage() {
        return new Boolean((String)this.getValue(ME_OPEN_NEXT_MESSAGE));
    }

    public String getSentFolder() {
        String string = (String)this.getValue(ME_SENT_FOLDER);
        if (string != null && string.trim().length() == 0 || string == null) {
            string = " ";
        }
        return string;
    }

    public String getDraftFolder() {
        String string = (String)this.getValue(ME_DRAFT_FOLDER);
        if (string != null && string.trim().length() == 0 || string == null) {
            string = " ";
        }
        return string;
    }

    public String getCert() {
        String string = (String)this.getValue(ME_SIGNCERT);
        _prefsLogger.finest("certin getCert:" + string);
        if (string != null && string.trim().length() == 0 || string == null) {
            string = " ";
        }
        return string;
    }

    public boolean getAutoSpell() {
        return new Boolean((String)this.getValue(ME_AUTO_SPELL));
    }

    public int getViewSize() {
        try {
            return Integer.parseInt((String)this.getValue(ME_VIEW_SIZE));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getSortOrder() {
        return (String)this.getValue(ME_SORT_ORDER);
    }

    public boolean getViewRTF() {
        return new Boolean((String)this.getValue(ME_VIEW_RTF));
    }

    public boolean getInitialized() {
        return new Boolean((String)this.getValue(ME_INITIALIZED));
    }

    public String getDisplayColumns() {
        return (String)this.getValue(ME_DISPLAY_COLUMNS);
    }

    public boolean getAutoQuote() {
        String string = (String)this.getValue(ME_AUTO_QUOTE);
        if (string == null) {
            string = "true";
        }
        return new Boolean(string);
    }

    public String getPopAccount() {
        return (String)this.getValue(ME_POP_ACCOUNT);
    }

    public String getSignAll() {
        return (String)this.getValue(ME_SMIME_SIGN);
    }

    public String getEncryptAll() {
        return (String)this.getValue(ME_SMIME_ENCRYPT);
    }

    public String getDateFormat() {
        return (String)this.getValue(ME_DATE_FORMAT);
    }

    private String getValidDate(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(84) != -1) {
            return string;
        }
        return string.substring(0, 8) + 'T' + string.substring(8, string.length());
    }

    private String setValidDate(String string) {
        return string.substring(0, 8) + string.substring(9, string.length());
    }

    public String getVacationEndDate() {
        return this.getValidDate((String)this.getValue(VACATION_END_DATE));
    }

    public String getVacationStartDate() {
        return this.getValidDate((String)this.getValue(VACATION_START_DATE));
    }

    public String getMailAlternateAddress() {
        return (String)this.getValue(MAIL_ALTERNATE_ADDRESS);
    }

    public String getMailAutoReplyMode() {
        return (String)this.getValue(MAIL_AUTO_REPLY_MODE);
    }

    public String getMailAutoReplySubject() {
        return (String)this.getValue(MAIL_AUTO_REPLY_SUBJECT);
    }

    public String getMailAutoReplyTextInternal() {
        _prefsLogger.info("BNA getMailAutoReplyTextInternal():" + this.getValue(MAIL_AUTO_REPLY_TEXT_INTERNAL));
        return (String)this.getValue(MAIL_AUTO_REPLY_TEXT_INTERNAL);
    }

    public String getMailAutoReplyTimeout() {
        return (String)this.getValue(MAIL_AUTO_REPLY_TIMEOUT);
    }

    public String getMailAutoReplyText() {
        _prefsLogger.info("BNA getMailAutoReplyText():" + this.getValue(MAIL_AUTO_REPLY_TEXT));
        return (String)this.getValue(MAIL_AUTO_REPLY_TEXT);
    }

    public String[] getMailForwardingAddress() {
        String string = (String)this.getValue(MAIL_FORWARDING_ADDRESS);
        return this.convertDelimiterSeperatedString(string, "!!!INTERNAL_DELIMITER!!!");
    }

    public String[] getMailDeliveryOption() {
        String string = (String)this.getValue(MAIL_DELIVERY_OPTION);
        return this.convertDelimiterSeperatedString(string, "!!!INTERNAL_DELIMITER!!!");
    }

    public String[] getMailSieveRuleSource() {
        String string = (String)this.getValue(MAIL_SIEVE_RULE_SOURCE);
        String[] stringArray = this.convertDelimiterSeperatedString(string, "!!!INTERNAL_DELIMITER!!!");
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = UWCUtils.escape_crlf(stringArray[i]);
            }
        }
        return stringArray2;
    }

    public void setReplyToAddress(String string) {
        this.setValue(ME_REPLY_TO_ADDRESS, string);
    }

    public void setAutoSign(boolean bl) {
        this.setValue(ME_AUTO_SIGN, new Boolean(bl).toString());
    }

    public void setSignature(String string) {
        this.setValue(ME_SIGNATURE, string);
    }

    public void setIncludeVCard(boolean bl) {
        this.setValue(ME_INCLUDE_VCARD, new Boolean(bl).toString());
    }

    public void setVCard(String string) {
        this.setValue(ME_VCARD, string);
    }

    public void setTrashFolder(String string) {
        this.setValue(ME_TRASH_FOLDER, string);
    }

    public void setPrevTrashFolder(String string) {
        this.setValue(ME_PREV_TRASH_FOLDER, string);
    }

    public void setExpungeOnExit(boolean bl) {
        this.setValue(ME_EXPUNGE_ON_EXIT, new Boolean(bl).toString());
    }

    public void setOpenNextMessage(boolean bl) {
        this.setValue(ME_OPEN_NEXT_MESSAGE, new Boolean(bl).toString());
    }

    public void setSentFolder(String string) {
        this.setValue(ME_SENT_FOLDER, string);
    }

    public void setDraftFolder(String string) {
        this.setValue(ME_DRAFT_FOLDER, string);
    }

    public void setCert(String string) {
        this.setValue(ME_SIGNCERT, string);
    }

    public void setAutoSpell(boolean bl) {
        this.setValue(ME_AUTO_SPELL, new Boolean(bl).toString());
    }

    public void setViewSize(int n) {
        this.setValue(ME_VIEW_SIZE, Integer.toString(n));
    }

    public void setSortOrder(String string) {
        this.setValue(ME_SORT_ORDER, string);
    }

    public void setViewRTF(boolean bl) {
        this.setValue(ME_VIEW_RTF, new Boolean(bl).toString());
    }

    public void setInitialized(boolean bl) {
        this.setValue(ME_INITIALIZED, new Boolean(bl).toString());
    }

    public void setDisplayColumns(String string) {
        this.setValue(ME_DISPLAY_COLUMNS, string);
    }

    public void setAutoQuote(boolean bl) {
        this.setValue(ME_AUTO_QUOTE, new Boolean(bl).toString());
    }

    public void setPopAccount(String string) {
        this.setValue(ME_POP_ACCOUNT, string);
    }

    public void setSignAll(String string) {
        this.setValue(ME_SMIME_SIGN, string);
    }

    public void setEncryptAll(String string) {
        this.setValue(ME_SMIME_ENCRYPT, string);
    }

    public void setDateFormat(String string) {
        this.setValue(ME_DATE_FORMAT, string);
    }

    public void setVacationEndDate(String string) {
        this.setValue(VACATION_END_DATE, this.setValidDate(string));
    }

    public void setVacationStartDate(String string) {
        this.setValue(VACATION_START_DATE, this.setValidDate(string));
    }

    public void setMailAlternateAddress(String string) {
        this.setValue(MAIL_ALTERNATE_ADDRESS, string);
    }

    public void setMailAutoReplyMode(String string) {
        this.setValue(MAIL_AUTO_REPLY_MODE, string);
    }

    public void setMailAutoReplySubject(String string) {
        this.setValue(MAIL_AUTO_REPLY_SUBJECT, string);
    }

    public void setMailAutoReplyTextInternal(String string) {
        this.setValue(MAIL_AUTO_REPLY_TEXT_INTERNAL, string);
    }

    public void setMailAutoReplyTimeout(String string) {
        this.setValue(MAIL_AUTO_REPLY_TIMEOUT, string);
    }

    public void setMailAutoReplyText(String string) {
        this.setValue(MAIL_AUTO_REPLY_TEXT, string);
    }

    public void setMailForwardingAddress(String[] stringArray) {
        String string = UWCUtils.getDelimiterSeperatedString(stringArray, "!!!INTERNAL_DELIMITER!!!");
        if (null != string) {
            this.setValue(MAIL_FORWARDING_ADDRESS, string);
        }
    }

    public void setMailDeliveryOption(String[] stringArray) {
        String string = UWCUtils.getDelimiterSeperatedString(stringArray, "!!!INTERNAL_DELIMITER!!!");
        if (null != string) {
            this.setValue(MAIL_DELIVERY_OPTION, string);
        }
    }

    public void setMailSieveRuleSource(String[] stringArray) {
        String string = UWCUtils.getDelimiterSeperatedString(stringArray, "!!!INTERNAL_DELIMITER!!!");
        if (null != string) {
            this.setValue(MAIL_SIEVE_RULE_SOURCE, string);
        }
    }
}

