/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.sun.uwc.common.model.FilterAction;
import com.sun.uwc.common.model.FilterCondition;
import com.sun.uwc.common.model.FilterConstants;
import com.sun.uwc.common.model.Token;
import com.sun.uwc.common.util.UWCLogger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class FilterRecord
implements Comparator {
    String name;
    String order;
    FilterCondition[] condList;
    FilterAction[] actionList;
    boolean isConjunction;
    int numConditions;
    int numActions;
    int mobileIndex = -1;
    String type;
    String extraComments = "";
    protected static Logger _frLogger = null;
    private static final transient String CLASS_NAME = "FilterRecord";
    private RequestContext _reqCtx;
    public static final String ALL_INCOMING_MESG = "ALL_INCOMING_MESG";
    public static final String SPAM_DETECT = "SPAM_DETECT";
    public static final String DEFAULT_TYPE = "DEFAULT_TYPE";
    public static final String SENDER_HEADERS = "From,Sender,Resent-from,Resent-sender,Return-path";
    public static final String RECIP_HEADERS = "To,Cc,Bcc,Resent-to,Resent-cc,Resent-bcc";
    public static final String SUBJECT_HEADERS = "Subject, Comments, Keywords";
    public static final String BeginFilterMark = "#BEGINFILTER";
    public static final String EndFilterMark = "#ENDFILTER";
    private static HashMap actCmdRequireMap;
    private static HashMap testCmdRequireMap;

    public FilterRecord(String string, String string2, boolean bl, FilterCondition[] filterConditionArray, FilterAction[] filterActionArray, RequestContext requestContext) {
        this.name = string;
        this.order = string2;
        this.isConjunction = bl;
        this.condList = filterConditionArray;
        this.actionList = filterActionArray;
        this.numConditions = this.condList.length;
        this.numActions = this.actionList.length;
        this.type = DEFAULT_TYPE;
        this._reqCtx = requestContext;
    }

    public FilterRecord(FilterRecord filterRecord, RequestContext requestContext) {
        this(filterRecord.name, filterRecord.order, filterRecord.isConjunction, filterRecord.condList, filterRecord.actionList, requestContext);
        this.type = filterRecord.type;
    }

    public FilterRecord(String string, String string2, String string3, String string4, RequestContext requestContext) {
        Object object;
        Object object2;
        String string5;
        Object object3;
        _frLogger.entering(CLASS_NAME, "FilterRecord(name, ord, type, sieve)");
        Token token = new Token(string4, FilterConstants.testListCmdRegex.getRegex());
        String string6 = token.getNextToken();
        Vector<Object> vector = new Vector<Object>();
        this.name = string;
        this.order = string2;
        this.type = string3;
        this.mobileIndex = -1;
        if (string6 != null) {
            token.setText(string6);
            object3 = token.getNextToken(FilterConstants.testListOp);
            this.isConjunction = ((String)object3).equals("allof");
            string5 = token.getNextToken(FilterConstants.testListRegex);
            token.setText(string5);
            if (string3.equals(ALL_INCOMING_MESG)) {
                object2 = token.getNextToken(FilterConstants.totalSingleTestCmdRegex);
                vector.addElement(FilterCondition.getAllTrueCondition());
            } else {
                object2 = token.getNextToken(FilterConstants.totalSingleTestCmdRegex);
                while (object2 != null) {
                    object = new FilterCondition((String)object2, requestContext);
                    vector.addElement(object);
                    object2 = token.getNextToken(FilterConstants.totalSingleTestCmdRegex);
                }
            }
        } else {
            string6 = token.getNextToken(FilterConstants.totalSingleTestCmdRegex);
            object3 = new FilterCondition(string6, requestContext);
            vector.addElement(object3);
            this.isConjunction = true;
        }
        this.condList = new FilterCondition[vector.size()];
        this.condList = vector.toArray(this.condList);
        this.numConditions = vector.size();
        object3 = new Token(string4, FilterConstants.blockRegex.getRegex());
        string5 = ((Token)object3).getNextToken();
        object2 = new Vector();
        if (string5 != null) {
            object = new Token(string5, FilterConstants.actionCmdRegex.getRegex());
            String string7 = ((Token)object).getNextToken();
            while (string7 != null) {
                FilterAction filterAction = new FilterAction(string7);
                ((Vector)object2).addElement(filterAction);
                string7 = ((Token)object).getNextToken();
            }
            this.actionList = new FilterAction[((Vector)object2).size()];
            this.actionList = ((Vector)object2).toArray(this.actionList);
            this.numActions = ((Vector)object2).size();
        }
        this._reqCtx = requestContext;
        _frLogger.exiting(CLASS_NAME, "FilterRecord(name, ord, type, sieve)");
    }

    public FilterRecord(String string, String string2, String string3, RequestContext requestContext) {
        this(string, string2, DEFAULT_TYPE, string3, requestContext);
    }

    public String getName() {
        return this.name;
    }

    public String getOrder() {
        return this.order;
    }

    public FilterCondition[] getConditionList() {
        return this.condList;
    }

    public FilterAction[] getActionList() {
        return this.actionList;
    }

    public int getNumConditions() {
        return this.numConditions;
    }

    public int getNumActions() {
        return this.numActions;
    }

    public String getType() {
        return this.type;
    }

    public int getMobileIndex() {
        return this.mobileIndex;
    }

    public boolean isAnd() {
        return this.isConjunction;
    }

    public void setOrder(String string) {
        this.order = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setMobileIndex(int n) {
        this.mobileIndex = n;
    }

    public void setExtraComments(String string) {
        this.extraComments = string;
    }

    public String getNameLine() {
        String string = "#RULE: $Name=\"" + this.name + "\"   $Order=" + this.order + "   $Type=\"" + this.type + "\"";
        string = this.mobileIndex != -1 ? string + "   $Mobile=" + this.mobileIndex + "\n" : string + "\n";
        return string;
    }

    public String toSieve(boolean bl) {
        String string;
        String string2;
        String string3 = this.isConjunction ? "allof" : "anyof";
        String string4 = this.condList[0].toSieve();
        String string5 = (String)testCmdRequireMap.get(this.condList[0].getCommandName());
        if (string5 == null) {
            string5 = "";
        }
        for (int i = 1; i < this.numConditions; ++i) {
            string2 = (String)testCmdRequireMap.get(this.condList[i].getCommandName());
            if (string2 != null) {
                string5 = string5 + string2;
            }
            string4 = string4 + "," + this.condList[i].toSieve();
        }
        string4 = "(" + string4.trim() + ")";
        string3 = string3 + string4;
        String string6 = this.actionList[0].toSieve();
        string2 = (String)actCmdRequireMap.get(this.actionList[0].getCommandName());
        if (string2 == null) {
            string2 = "";
        }
        for (int i = 1; i < this.numActions; ++i) {
            string = (String)actCmdRequireMap.get(this.actionList[i].getCommandName());
            if (string != null) {
                string2 = string2 + string;
            }
            string6 = string6 + "\n" + this.actionList[i].toSieve();
        }
        String string7 = "#BEGINFILTER\nif " + string3 + "{\n" + string6 + "\n}\n" + EndFilterMark + "\n";
        if (this.extraComments.length() > 0) {
            this.extraComments = "\n\n" + this.extraComments;
        }
        string = (bl ? "" : this.getNameLine()) + string5 + string2 + string7 + this.extraComments;
        return string;
    }

    public String toSieve() {
        return this.toSieve(false);
    }

    public static void sort(FilterRecord[] filterRecordArray) {
        Arrays.sort(filterRecordArray, filterRecordArray[0]);
    }

    public int compare(Object object, Object object2) {
        FilterRecord filterRecord = (FilterRecord)object;
        FilterRecord filterRecord2 = (FilterRecord)object2;
        int n = 0;
        int n2 = 0;
        try {
            n = Math.abs(Integer.parseInt(filterRecord.order));
            n2 = Math.abs(Integer.parseInt(filterRecord2.order));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n - n2;
    }

    public static void main(String[] stringArray) {
    }

    static {
        _frLogger = UWCLogger.getLogger("uwc");
        actCmdRequireMap = new HashMap();
        testCmdRequireMap = new HashMap();
        testCmdRequireMap.put("envelope", "require \"envelope\";\n");
        actCmdRequireMap.put("fileinto", "require \"fileinto\";\n");
    }
}

