/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.FilterConstants;
import com.sun.uwc.common.model.Token;
import com.sun.uwc.common.util.UWCLogger;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterCondition {
    String commandName;
    String compOperator;
    String type;
    String[] fieldNameList;
    String[] fieldValueList;
    boolean negate;
    boolean sizeFlag = false;
    private static RequestContext _reqCtx = null;
    protected static Logger _fcLogger = null;
    private static final transient String CLASS_NAME = "FilterCondition";

    public FilterCondition() {
        this.compOperator = "";
        this.commandName = "";
        this.type = "DEFAULT_TYPE";
        this.fieldValueList = null;
        this.fieldNameList = null;
        this.negate = false;
    }

    public FilterCondition(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl, String string3) {
        this.commandName = string;
        this.compOperator = string2;
        this.fieldNameList = stringArray;
        this.fieldValueList = stringArray2;
        this.negate = bl;
        this.type = string3;
    }

    public FilterCondition(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        this(string, stringArray, string2, stringArray2, bl, "DEFAULT_TYPE");
    }

    public FilterCondition(FilterCondition filterCondition) {
        this(filterCondition.commandName, filterCondition.fieldNameList, filterCondition.compOperator, filterCondition.fieldValueList, filterCondition.negate);
    }

    public FilterCondition(String string, String string2, RequestContext requestContext) {
        String string3;
        _fcLogger.entering(CLASS_NAME, "FilterCondition(sieveSyntax, tp, reqCtx)");
        if (requestContext == null) {
            requestContext = RequestManager.getRequestContext();
        }
        _reqCtx = requestContext;
        Token token = new Token(string = string.trim());
        String string4 = token.getNextToken("not");
        this.negate = string4 != null;
        this.type = string2;
        this.commandName = token.getNextToken(FilterConstants.cmdRegex);
        this.sizeFlag = this.commandName.equals("size");
        this.compOperator = token.getNextToken(FilterConstants.opRegex);
        string4 = token.getNextToken(FilterConstants.fieldListRegex);
        this.fieldNameList = this._processFieldList(string4);
        string4 = token.getNextToken(FilterConstants.fieldListRegex);
        if (string4 != null) {
            this.fieldValueList = this._processFieldList(string4);
        } else {
            this.fieldValueList = this.fieldNameList;
            string3 = this.fieldValueList[0].trim();
            char c = string3.charAt(string3.length() - 1);
            int n = 1;
            if (c == 'M') {
                n = 1024;
            } else if (c == 'G') {
                n = 0x100000;
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string3.substring(0, string3.length() - 1));
                n2 *= n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.sizeFlag) {
                this.fieldValueList[0] = n2 + "K";
            }
            this.fieldNameList = null;
        }
        if (_fcLogger.isLoggable(Level.FINE)) {
            _fcLogger.fine("checking for Spam detection...");
        }
        string3 = UWCUserHelper.getPerDomainConfigAttrValue(_reqCtx, "uwc-mail-options-", "isSpamDetectEnabled", "false");
        if (_fcLogger.isLoggable(Level.FINE)) {
            _fcLogger.fine("isSpamDetectEnabled: " + string3);
        }
        if (string3 != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
            String string5 = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderName", "uwc-mail-options-", "");
            String string6 = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderValue", "uwc-mail-options-", "");
            if (this.fieldNameList != null && this.fieldNameList[0].equalsIgnoreCase(string5) && this.fieldValueList != null && this.fieldValueList[0].equalsIgnoreCase(string6)) {
                this.type = "SPAM_DETECT";
            }
        }
        _fcLogger.exiting(CLASS_NAME, "FilterCondition(sieveSyntax, tp)");
    }

    public FilterCondition(String string, RequestContext requestContext) {
        this(string, "DEFAULT_TYPE", requestContext);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCompOperator() {
        return this.compOperator;
    }

    public String[] getFieldNameList() {
        return this.fieldNameList;
    }

    public String[] getFieldValueList() {
        return this.fieldValueList;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSizePresent() {
        return this.sizeFlag;
    }

    public static FilterCondition getAllTrueCondition() {
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.type = "ALL_INCOMING_MESG";
        return filterCondition;
    }

    public static FilterCondition getSpamDetectCondition() {
        if (_reqCtx == null) {
            _reqCtx = RequestManager.getRequestContext();
        }
        String string = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderName", "uwc-mail-options-", "");
        String string2 = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderValue", "uwc-mail-options-", "");
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{string2};
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.type = "SPAM_DETECT";
        filterCondition.fieldNameList = stringArray;
        filterCondition.fieldValueList = stringArray2;
        filterCondition.commandName = "header";
        filterCondition.compOperator = ":contains";
        return filterCondition;
    }

    public static FilterCondition getSizeCondition(boolean bl, String string, boolean bl2) {
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.sizeFlag = true;
        filterCondition.commandName = "size";
        filterCondition.compOperator = bl ? ":over" : ":under";
        filterCondition.fieldValueList = new String[]{string};
        filterCondition.negate = bl2;
        return filterCondition;
    }

    public String toSieve() {
        if (this.type.equals("ALL_INCOMING_MESG")) {
            return "true";
        }
        String string = this.commandName + " " + this.compOperator + " ";
        String string2 = "";
        if (this.fieldNameList != null) {
            string2 = "\"" + this.fieldNameList[0] + "\"";
            if (this.fieldNameList.length > 1) {
                for (int i = 1; i < this.fieldNameList.length; ++i) {
                    string2 = string2 + ",\"" + this.fieldNameList[i] + "\"";
                }
                string2 = "[" + string2 + "]";
            }
        }
        String string3 = this.fieldValueList[0];
        if (!this.sizeFlag) {
            string3 = "\"" + string3 + "\"";
        }
        if (this.fieldValueList.length > 1) {
            for (int i = 1; i < this.fieldValueList.length; ++i) {
                string3 = string3 + ",\"" + this.fieldValueList[i] + "\"";
            }
            string3 = "[" + string3 + "]";
        }
        string = string + (string2.length() > 0 ? string2 + " " : "") + string3;
        if (this.negate) {
            string = "not " + string;
        }
        return string;
    }

    private String[] _processFieldList(String string) {
        String[] stringArray;
        _fcLogger.entering(CLASS_NAME, "_processFieldList");
        if (string.startsWith("[")) {
            Token token = new Token(string);
            Vector<String> vector = new Vector<String>();
            String string2 = token.getNextToken(FilterConstants.singleArg);
            while (string2 != null) {
                String[] stringArray2 = string2.split("\"");
                String string3 = stringArray2[stringArray2.length - 1];
                vector.addElement(string3);
                string2 = token.getNextToken(FilterConstants.singleArg);
            }
            stringArray = new String[vector.size()];
            stringArray = vector.toArray(stringArray);
        } else {
            String string4;
            stringArray = new String[1];
            String[] stringArray3 = string.split("\"");
            stringArray[0] = string4 = stringArray3[stringArray3.length - 1];
        }
        _fcLogger.exiting(CLASS_NAME, "_processFieldList");
        return stringArray;
    }

    static {
        _fcLogger = UWCLogger.getLogger("uwc");
    }
}

