/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.sun.uwc.calclient.model.CalendarGroup;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.ldap.LDAPUtil;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class CalUserPreferencesModel
extends UserPreferencesModel {
    public static final String UC_CALENDAR_PREFERENCES_INITIALIZED = "sunCalInitialized";
    public static final String UC_CALENDAR_EXTENDED_USER_PREFS_ATTR = "icsExtendedUserPrefs";
    public static final String CE_SHOW_COMPLETED_TASKS = "ceShowCompletedTasks";
    public static final String CE_DEFAULT_CATEGORY = "ceDefaultCategory";
    public static final String CE_DAY_HEAD = "ceDayHead";
    public static final String CE_DAY_TAIL = "ceDayTail";
    public static final String CE_INTERVAL = "ceInterval";
    public static final String ICS_FIRST_DAY = "icsFirstDay";
    public static final String CE_WEEKEND_DAYS = "ceWeekEndDays";
    public static final String CE_INCLUDE_WEEKEND_IN_VIEWS = "ceIncludeWeekendInViews";
    public static final String ICS_CALENDAR_ATTR = "icsCalendar";
    public static final String CE_SINGLE_CALENDAR_TZID = "ceSingleCalendarTZID";
    public static final String CE_ALL_CALENDAR_TZIDS = "ceAllCalendarTZIDs";
    public static final String CE_DEFAULT_ALARM_START = "ceDefaultAlarmStart";
    public static final String CE_NOTIFY_ENABLE = "ceNotifyEnable";
    public static final String CE_DEFAULT_ALARM_EMAIL = "ceDefaultAlarmEmail";
    public static final String CE_NOTIFY_EMAIL = "ceNotifyEmail";
    public static final String CE_DEFAULT_VIEW = "ceDefaultView";
    public static final String CAL_EVENT_FILTER = "sunCalEventfilter";
    public static final String ICS_SUBSCRIBED_ATTR = "icsSubscribed";
    public static final String ICS_SET_ATTR = "icsSet";
    private static String[] _calUserPrefsAttrs = new String[]{"icsExtendedUserPrefs", "icsFirstDay", "icsCalendar", "icsSubscribed"};
    private static String[] _calUserPrefsMultiValAttrs = new String[]{"icsExtendedUserPrefs", "icsSubscribed"};
    private static String[][] _calUserPrefsMultiValAttrSubTypes = new String[][]{{"sunCalInitialized", "ceShowCompletedTasks", "ceDefaultCategory", "ceDayHead", "ceDayTail", "ceInterval", "ceWeekEndDays", "ceIncludeWeekendInViews", "ceSingleCalendarTZID", "ceAllCalendarTZIDs", "ceDefaultAlarmStart", "ceNotifyEnable", "ceDefaultAlarmEmail", "ceNotifyEmail", "ceDefaultView", "sunCalEventfilter"}, {" "}};
    private static final String CLASS_NAME = "CalUserPreferencesModel";

    public CalUserPreferencesModel() throws UWCException {
        _prefsLogger.entering(CLASS_NAME, "CalUserPreferencesModel()");
        _prefsLogger.exiting(CLASS_NAME, "CalUserPreferencesModel()");
    }

    public CalUserPreferencesModel(RequestContext requestContext) throws UWCException {
        super(requestContext);
        _prefsLogger.entering(CLASS_NAME, "CalUserPreferencesModel(RequestContext)");
        _prefsLogger.exiting(CLASS_NAME, "CalUserPreferencesModel(RequestContext)");
    }

    public void initializeCalendarPreferences() throws UWCException {
        boolean bl = false;
        boolean bl2 = false;
        _prefsLogger.entering(CLASS_NAME, "initializeCalendarPreferences()");
        Hashtable hashtable = new Hashtable();
        if (this._isAnonymous) {
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("Anonymous Access");
            }
            hashtable = this.initializeForAnonAccess(_calUserPrefsAttrs, _calUserPrefsMultiValAttrs, _calUserPrefsMultiValAttrSubTypes, hashtable);
        } else {
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("Not Anonymous Access");
            }
            hashtable = this.initializeForAuthUser();
        }
        this.setAttrValuesInSession(hashtable, _calUserPrefsAttrs, _calUserPrefsMultiValAttrs, _calUserPrefsMultiValAttrSubTypes);
        _prefsLogger.exiting(CLASS_NAME, "initializeCalendarPreferences()");
    }

    protected Hashtable initializeForAuthUser() throws UWCException {
        String string;
        _prefsLogger.entering(CLASS_NAME, "initializeForAuthUser()");
        boolean bl = false;
        boolean bl2 = false;
        LDAPUtil lDAPUtil = null;
        Hashtable hashtable = new Hashtable();
        try {
            lDAPUtil = this.getLDAPUtilObj();
        }
        catch (UWCException uWCException) {
            _prefsLogger.log(Level.WARNING, "Couldnot obtain LDAPUtil object!");
            throw uWCException;
        }
        try {
            lDAPUtil.loadValues();
        }
        catch (LDAPException lDAPException) {
            _prefsLogger.log(Level.WARNING, "Couldnot Load entry for DN: " + this.getUserDN());
            this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
            throw new UWCException(lDAPException.getMessage());
        }
        String string2 = "sunCalInitialized=true";
        if (lDAPUtil.isValuePresentIgnoreCase(UC_CALENDAR_EXTENDED_USER_PREFS_ATTR, string2)) {
            bl = true;
            bl2 = true;
        }
        if (lDAPUtil.isValuePresentIgnoreCase(UC_CALENDAR_EXTENDED_USER_PREFS_ATTR, string = "sunCalInitialized=false")) {
            bl = true;
            bl2 = false;
        }
        hashtable = this.initializeAndObtainPrefs(lDAPUtil, _calUserPrefsAttrs, _calUserPrefsMultiValAttrs, _calUserPrefsMultiValAttrSubTypes, hashtable, !bl2);
        if (!bl2) {
            if (bl) {
                LDAPModificationSet lDAPModificationSet = null;
                lDAPModificationSet = this.constructModificationSet(lDAPModificationSet, 1, UC_CALENDAR_EXTENDED_USER_PREFS_ATTR, new String[]{string});
                lDAPModificationSet = this.constructModificationSet(lDAPModificationSet, 0, UC_CALENDAR_EXTENDED_USER_PREFS_ATTR, new String[]{string2});
                try {
                    this.modifyMultipleAttributes(lDAPModificationSet);
                }
                catch (LDAPException lDAPException) {
                    _prefsLogger.log(Level.WARNING, "Unable to modify attr: icsExtendedUserPrefs:sunCalInitialized");
                    throw new UWCException(lDAPException.getMessage());
                }
            }
            try {
                lDAPUtil.modifyAttribute(0, UC_CALENDAR_EXTENDED_USER_PREFS_ATTR, "sunCalInitialized=true");
            }
            catch (LDAPException lDAPException) {
                _prefsLogger.log(Level.WARNING, "Unable to add attr: sunCalInitialized to true in " + this.getUserDN());
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                throw new UWCException(lDAPException.getMessage());
            }
        }
        this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
        _prefsLogger.exiting(CLASS_NAME, "initializeForAuthUser()");
        return hashtable;
    }

    public void updateCalendarUserPrefs() throws UWCException {
        _prefsLogger.entering(CLASS_NAME, "updateCalendarUserPrefs()");
        super.updatePreferences(_calUserPrefsAttrs, _calUserPrefsMultiValAttrs, _calUserPrefsMultiValAttrSubTypes);
        _prefsLogger.exiting(CLASS_NAME, "updateCalendarUserPrefs()");
    }

    public boolean getInitialized() {
        _prefsLogger.entering(CLASS_NAME, "getInitialized()");
        String string = (String)this.getValue(UC_CALENDAR_PREFERENCES_INITIALIZED);
        if (string == null) {
            string = "false";
        }
        _prefsLogger.exiting(CLASS_NAME, "getInitialized()");
        return new Boolean(string);
    }

    public String getShowCompletedTasks() {
        _prefsLogger.entering(CLASS_NAME, "getShowCompletedTasks()");
        _prefsLogger.exiting(CLASS_NAME, "getShowCompletedTasks()");
        return (String)this.getValue(CE_SHOW_COMPLETED_TASKS);
    }

    public String getDefaultCategory() {
        _prefsLogger.entering(CLASS_NAME, "getDefaultCategory()");
        _prefsLogger.exiting(CLASS_NAME, "getDefaultCategory()");
        return (String)this.getValue(CE_DEFAULT_CATEGORY);
    }

    public String getDayHead() {
        _prefsLogger.entering(CLASS_NAME, "getDayHead()");
        _prefsLogger.exiting(CLASS_NAME, "getDayHead()");
        return (String)this.getValue(CE_DAY_HEAD);
    }

    public String getDayTail() {
        _prefsLogger.entering(CLASS_NAME, "getDayTail()");
        _prefsLogger.exiting(CLASS_NAME, "getDayTail()");
        return (String)this.getValue(CE_DAY_TAIL);
    }

    public String getInterval() {
        _prefsLogger.entering(CLASS_NAME, "getInterval()");
        _prefsLogger.exiting(CLASS_NAME, "getInterval()");
        return (String)this.getValue(CE_INTERVAL);
    }

    public String getFirstDay() {
        _prefsLogger.entering(CLASS_NAME, "getFirstDay()");
        _prefsLogger.exiting(CLASS_NAME, "getFirstDay()");
        return (String)this.getValue(ICS_FIRST_DAY);
    }

    public String getWeekendDays() {
        _prefsLogger.entering(CLASS_NAME, "getWeekendDays()");
        _prefsLogger.exiting(CLASS_NAME, "getWeekendDays()");
        return (String)this.getValue(CE_WEEKEND_DAYS);
    }

    public String getDisplayWeekend() {
        _prefsLogger.entering(CLASS_NAME, "getDisplayWeekend()");
        _prefsLogger.exiting(CLASS_NAME, "getDisplayWeekend()");
        return (String)this.getValue(CE_INCLUDE_WEEKEND_IN_VIEWS);
    }

    public String getSingleCalendarTZID() {
        _prefsLogger.entering(CLASS_NAME, "getSingleCalendarTZID()");
        _prefsLogger.exiting(CLASS_NAME, "getSingleCalendarTZID()");
        return (String)this.getValue(CE_SINGLE_CALENDAR_TZID);
    }

    public String getAllCalendarTZIDs() {
        _prefsLogger.entering(CLASS_NAME, "getAllCalendarTZIDs()");
        _prefsLogger.exiting(CLASS_NAME, "getAllCalendarTZIDs()");
        return (String)this.getValue(CE_ALL_CALENDAR_TZIDS);
    }

    public String getDefaultAlarmStart() {
        _prefsLogger.entering(CLASS_NAME, "getDefaultAlarmStart()");
        _prefsLogger.exiting(CLASS_NAME, "getDefaultAlarmStart()");
        return (String)this.getValue(CE_DEFAULT_ALARM_START);
    }

    public String getNotifyEnable() {
        _prefsLogger.entering(CLASS_NAME, "getNotifyEnable()");
        _prefsLogger.exiting(CLASS_NAME, "getNotifyEnable()");
        return (String)this.getValue(CE_NOTIFY_ENABLE);
    }

    public String getDefaultAlarmEmail() {
        _prefsLogger.entering(CLASS_NAME, "getDefaultAlarmEmail()");
        _prefsLogger.exiting(CLASS_NAME, "getDefaultAlarmEmail()");
        return (String)this.getValue(CE_DEFAULT_ALARM_EMAIL);
    }

    public String getNotifyEmail() {
        _prefsLogger.entering(CLASS_NAME, "getNotifyEmail()");
        _prefsLogger.exiting(CLASS_NAME, "getNotifyEmail()");
        return (String)this.getValue(CE_NOTIFY_EMAIL);
    }

    public String getDefaultView() {
        _prefsLogger.entering(CLASS_NAME, "getDefaultView()");
        _prefsLogger.exiting(CLASS_NAME, "getDefaultView()");
        return (String)this.getValue(CE_DEFAULT_VIEW);
    }

    public String getDefaultCalendarId() {
        _prefsLogger.entering(CLASS_NAME, "getDefaultCalendarId()");
        _prefsLogger.exiting(CLASS_NAME, "getDefaultCalendarId()");
        return (String)this.getValue(ICS_CALENDAR_ATTR);
    }

    public String[] getSubscribedCalendarIDs() {
        _prefsLogger.entering(CLASS_NAME, "getSubscribedCalendarIDs()");
        String[] stringArray = null;
        String string = (String)super.getValue(ICS_SUBSCRIBED_ATTR);
        if (_prefsLogger.isLoggable(Level.INFO)) {
            _prefsLogger.info("icsSubscribed in session: " + string);
        }
        if (string != null) {
            stringArray = this.convertDelimiterSeperatedString(string, "!!!INTERNAL_DELIMITER!!!");
        }
        _prefsLogger.exiting(CLASS_NAME, "getSubscribedCalendarIDs()");
        return stringArray;
    }

    public String[] getEventFilter() {
        _prefsLogger.entering(CLASS_NAME, "getEventFilter()");
        String string = (String)this.getValue(CAL_EVENT_FILTER);
        if (_prefsLogger.isLoggable(Level.INFO)) {
            _prefsLogger.info("EventFilter in session: " + string);
        }
        String[] stringArray = UWCUtils.parseDelimiterSeperatedString(string, ",");
        if (_prefsLogger.isLoggable(Level.FINE)) {
            if (null == stringArray) {
                _prefsLogger.fine("EventFilter is null");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    _prefsLogger.fine("EventFilter[" + i + "]: \"" + stringArray[i] + "\"");
                }
            }
        }
        _prefsLogger.exiting(CLASS_NAME, "getEventFilter()");
        return stringArray;
    }

    public HashMap getCalendarGroups() {
        _prefsLogger.entering(CLASS_NAME, "getCalendarGroups()");
        LDAPUtil lDAPUtil = null;
        HashMap<String, CalendarGroup> hashMap = null;
        try {
            lDAPUtil = this.getLDAPUtilObj();
        }
        catch (UWCException uWCException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Failed to obtain LDAPUti object: " + uWCException.getMessage());
            }
            if (lDAPUtil != null) {
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
            }
            return null;
        }
        String[] stringArray = null;
        try {
            stringArray = lDAPUtil.getValues(ICS_SET_ATTR);
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Failed to obtain icsSet attr: " + lDAPException.getMessage());
            }
            if (lDAPUtil != null) {
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
            }
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            hashMap = new HashMap<String, CalendarGroup>();
            CalendarGroup calendarGroup = null;
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("Obtained icsSet attribute values!");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                calendarGroup = null;
                try {
                    calendarGroup = new CalendarGroup(stringArray[i]);
                }
                catch (UWCException uWCException) {
                    if (!_prefsLogger.isLoggable(Level.WARNING)) continue;
                    _prefsLogger.warning("Failed to construct CalendarGroup object for icsSet: " + stringArray[i]);
                    continue;
                }
                String string = calendarGroup.getGroupName();
                if (string == null || string.length() <= 0) continue;
                hashMap.put(string, calendarGroup);
            }
        }
        _prefsLogger.exiting(CLASS_NAME, "getCalendarGroups()");
        if (lDAPUtil != null) {
            this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
        }
        return hashMap;
    }

    public void setShowCompletedTasks(String string) {
        _prefsLogger.entering(CLASS_NAME, "setShowCompletedTasks()");
        this.setValue(CE_SHOW_COMPLETED_TASKS, string);
        _prefsLogger.exiting(CLASS_NAME, "setShowCompletedTasks()");
    }

    public void setDefaultCategory(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDefaultCategory()");
        this.setValue(CE_DEFAULT_CATEGORY, string);
        _prefsLogger.exiting(CLASS_NAME, "setDefaultCategory()");
    }

    public void setDayHead(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDayHead()");
        this.setValue(CE_DAY_HEAD, string);
        _prefsLogger.exiting(CLASS_NAME, "setDayHead()");
    }

    public void setDayTail(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDayTail()");
        this.setValue(CE_DAY_TAIL, string);
        _prefsLogger.exiting(CLASS_NAME, "setDayTail()");
    }

    public void setInterval(String string) {
        _prefsLogger.entering(CLASS_NAME, "setInterval()");
        this.setValue(CE_INTERVAL, string);
        _prefsLogger.exiting(CLASS_NAME, "setInterval()");
    }

    public void setFirstDay(String string) {
        _prefsLogger.entering(CLASS_NAME, "setFirstDay()");
        this.setValue(ICS_FIRST_DAY, string);
        _prefsLogger.exiting(CLASS_NAME, "setFirstDay()");
    }

    public void setWeekendDays(String string) {
        _prefsLogger.entering(CLASS_NAME, "setWeekendDays()");
        this.setValue(CE_WEEKEND_DAYS, string);
        _prefsLogger.exiting(CLASS_NAME, "setWeekendDays()");
    }

    public void setDisplayWeekend(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDisplayWeekend()");
        this.setValue(CE_INCLUDE_WEEKEND_IN_VIEWS, string);
        _prefsLogger.exiting(CLASS_NAME, "setDisplayWeekend()");
    }

    public void setSingleCalendarTZID(String string) {
        _prefsLogger.entering(CLASS_NAME, "setSingleCalendarTZID()");
        this.setValue(CE_SINGLE_CALENDAR_TZID, string);
        _prefsLogger.exiting(CLASS_NAME, "setSingleCalendarTZID()");
    }

    public void setAllCalendarTZIDs(String string) {
        _prefsLogger.entering(CLASS_NAME, "setAllCalendarTZIDs()");
        this.setValue(CE_ALL_CALENDAR_TZIDS, string);
        _prefsLogger.exiting(CLASS_NAME, "setAllCalendarTZIDs()");
    }

    public void setNotifyEnable(String string) {
        _prefsLogger.entering(CLASS_NAME, "setNotifyEnable()");
        this.setValue(CE_NOTIFY_ENABLE, string);
        _prefsLogger.exiting(CLASS_NAME, "setNotifyEnable()");
    }

    public void setDefaultAlarmEmail(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDefaultAlarmEmail()");
        this.setValue(CE_DEFAULT_ALARM_EMAIL, string);
        _prefsLogger.exiting(CLASS_NAME, "setDefaultAlarmEmail()");
    }

    public void setNotifyEmail(String string) {
        _prefsLogger.entering(CLASS_NAME, "setNotifyEmail()");
        this.setValue(CE_NOTIFY_EMAIL, string);
        _prefsLogger.exiting(CLASS_NAME, "setNotifyEmail()");
    }

    public void setDefaultView(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDefaultView()");
        this.setValue(CE_DEFAULT_VIEW, string);
        _prefsLogger.exiting(CLASS_NAME, "setDefaultView()");
    }

    public void setDefaultAlarmStart(String string) {
        _prefsLogger.entering(CLASS_NAME, "setDefaultAlarmStart()");
        this.setValue(CE_DEFAULT_ALARM_START, string);
        _prefsLogger.exiting(CLASS_NAME, "setDefaultAlarmStart()");
    }

    public void setSubscribedCalendarIDs(String[] stringArray) {
        _prefsLogger.entering(CLASS_NAME, "setSubscribedCalendarIDs()");
        String string = new String("");
        Object[] objectArray = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (_prefsLogger.isLoggable(Level.INFO)) {
                    _prefsLogger.info("Delimiting: " + stringArray[i]);
                }
                string = string + new String(stringArray[i] + "!!!INTERNAL_DELIMITER!!!");
            }
            if (string != null && string.length() > 0) {
                objectArray = new String[]{new String(string.substring(0, string.length() - "!!!INTERNAL_DELIMITER!!!".length()))};
                if (_prefsLogger.isLoggable(Level.INFO)) {
                    _prefsLogger.info("icsSubscribed after delimiting, being set into dirty cache: " + (String)objectArray[0]);
                }
                this.setValues(ICS_SUBSCRIBED_ATTR, objectArray);
            }
        }
        _prefsLogger.exiting(CLASS_NAME, "setSubscribedCalendarIDs()");
    }

    public void setEventFilter(String[] stringArray) {
        _prefsLogger.entering(CLASS_NAME, "setEventFilter()");
        if (_prefsLogger.isLoggable(Level.FINE)) {
            if (null == stringArray) {
                _prefsLogger.fine("EventFilter is null");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    _prefsLogger.fine("EventFilter[" + i + "]: \"" + stringArray[i] + "\"");
                }
            }
        }
        if (null != stringArray && stringArray.length > 0) {
            String string = UWCUtils.getDelimiterSeperatedString(stringArray, ",");
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("EventFilter after delimiting, being set into dirty cache: " + string);
            }
            this.setValue(CAL_EVENT_FILTER, string);
        }
        _prefsLogger.exiting(CLASS_NAME, "setEventFilter()");
    }

    public void setCalendarGroups(HashMap hashMap) throws UWCException {
        _prefsLogger.entering(CLASS_NAME, "setCalendarGroups()");
        LDAPUtil lDAPUtil = null;
        if (hashMap != null) {
            Collection collection = hashMap.values();
            String[] stringArray = new String[hashMap.size()];
            String string = null;
            Iterator iterator = collection.iterator();
            for (int i = 0; i < collection.size(); ++i) {
                CalendarGroup calendarGroup = (CalendarGroup)iterator.next();
                string = calendarGroup.toString();
                if (string == null) {
                    if (_prefsLogger.isLoggable(Level.INFO)) {
                        _prefsLogger.info("Could not convert CalendarGroup to String");
                    }
                    throw new UWCException("Failed to convert CalendarGroup object to String");
                }
                stringArray[i] = string;
            }
            if (stringArray != null) {
                try {
                    lDAPUtil = this.getLDAPUtilObj();
                }
                catch (UWCException uWCException) {
                    if (_prefsLogger.isLoggable(Level.WARNING)) {
                        _prefsLogger.warning("Could not obtain LDAPUtil obj!");
                    }
                    if (lDAPUtil != null) {
                        this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                    }
                    throw uWCException;
                }
                try {
                    lDAPUtil.modifyAttribute(2, ICS_SET_ATTR, stringArray);
                }
                catch (LDAPException lDAPException) {
                    if (_prefsLogger.isLoggable(Level.WARNING)) {
                        _prefsLogger.warning("Failed to REPLACE icsSet attribute: " + lDAPException.getMessage());
                    }
                    this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                    throw new UWCException("Failed to update Calendar Groups: " + lDAPException.getMessage());
                }
            }
        } else if (_prefsLogger.isLoggable(Level.INFO)) {
            _prefsLogger.info("Nothing to Modify!");
        }
        if (lDAPUtil != null) {
            this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
        }
    }
}

