/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.comclient.calendar.DateTime;
import com.sun.uwc.UWCServletBase;
import com.sun.uwc.common.ISUserHelper;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.auth.IdentitySSO;
import com.sun.uwc.common.auth.UWCIdentitySSOTokenListener;
import com.sun.uwc.common.util.UWCDomainManager;
import com.sun.uwc.common.util.UWCUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class IdentitySSOAuthFilter
extends AuthFilter {
    public static final String CONFIG_FILENAME = "uwcauth.properties";
    public static final String CONFIG_IDENTITY_URL = "uwcauth.identity.login.url";
    public static final String CONFIG_IDENTITY_COOKIE = "uwcauth.identity.cookiename";
    private final transient String IS_AUTH_ERR_INDICATOR = "err";
    private static final String AUTH_ONLY_PARAM = "authOnly";
    public String AUTH_ERROR = "autherror";
    private String _defaultDomain = null;
    private String _identityCookieName = null;
    private String _cookieDomain = null;
    private String _config_filename = null;
    private String _identityURL = null;
    private boolean _enabled = true;
    private boolean _sslEnabled = false;
    private IdentitySSO _identitySSO = null;
    private Hashtable _orgToDomainMap;
    static int _uwcPort = 80;
    static int _uwcSSLPort = 443;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        Preferences preferences = super.getPreferences();
        this._defaultDomain = preferences.get("defaultdomain", "iplanet.com");
        this._sslEnabled = preferences.getBoolean("uwcauth.ssl.enabled", false);
        _uwcSSLPort = preferences.getInt("uwcauth.https.port", 443);
        _uwcPort = preferences.getInt("uwcauth.http.port", 80);
        this._identityURL = preferences.get(CONFIG_IDENTITY_URL, null);
        this._identityCookieName = preferences.get(CONFIG_IDENTITY_COOKIE, "iPlanetDirectoryPro");
        this._cookieDomain = preferences.get("uwcauth.cookiedomain", "iplanet.com");
        this._identitySSO = new IdentitySSO(preferences);
        this._orgToDomainMap = new Hashtable(3);
    }

    public static int getdcount(String string) {
        int n = 0;
        while (string.indexOf(".") != -1) {
            ++n;
            string = string.substring(string.indexOf(".") + 1);
        }
        return n;
    }

    private String extractISHostFromURL() {
        int n = this._identityURL.indexOf("//");
        int n2 = this._identityURL.indexOf("/", n + 3);
        return this._identityURL.substring(n + 2, n2);
    }

    private String isPortFromURL() {
        String string = this.extractISHostFromURL();
        int n = string.indexOf(":");
        if (n != -1) {
            return string.substring(n);
        }
        return "";
    }

    private String constructIsHost(HttpServletRequest httpServletRequest) {
        String string = this.extractISHostFromURL();
        String string2 = UWCUtils.getHostHeaderFromURL(httpServletRequest);
        return string.substring(0, string.indexOf(".") + 1) + string2.substring(string2.indexOf(".") + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        String string;
        HttpSession httpSession;
        HttpServletRequest httpServletRequest;
        boolean bl;
        String string2;
        String string3;
        block50: {
            String string4;
            String string5;
            Object object2;
            authLogger.entering("IdentitySSOAuthFilter:", " doFilter");
            if (!this._identityEnabled) {
                authLogger.entering("IdentitySSOAuthFilter:", " identity not enabled");
                authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String string6 = "false";
            string3 = null;
            string2 = null;
            bl = false;
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String string7 = this._identityURL;
            UWCDomainManager uWCDomainManager = UWCServletBase.getApplicationConfigMgr().getDomainManager();
            string2 = UWCUtils.domainFromURL(httpServletRequest, uWCDomainManager);
            if (string2 != null) {
                object2 = super.getPreferences();
                string4 = ((Preferences)object2).get((string5 = UWCUtils.getHostHeaderFromURL(httpServletRequest)) + ".isvirtualhostname", null);
                if (string4 == null) {
                    string4 = this.constructIsHost(httpServletRequest);
                }
                string4 = string4 + this.isPortFromURL();
                try {
                    if (string4 != null) {
                        int n = this._identityURL.indexOf("//");
                        string7 = this._identityURL.substring(0, n + 2);
                        n = this._identityURL.indexOf("/", n + 3);
                        string7 = string7 + string4 + this._identityURL.substring(n);
                    }
                }
                catch (Exception exception) {
                    this.dump_stack(exception);
                }
            }
            if (string2 == null) {
                string2 = this._defaultDomain;
            }
            httpServletRequest.setAttribute("identityURL", (Object)string7);
            object2 = httpServletRequest.getServerName();
            string5 = httpServletRequest.getContextPath();
            if (string5 == null || string5 != null && string5.equals("/")) {
                string5 = "";
            }
            string4 = new NonSyncStringBuffer();
            if (this._sslEnabled) {
                string4.append("https://");
                string4.append((String)object2);
                string4.append(":");
                string4.append(_uwcSSLPort);
                string4.append(string5);
                string4.append("/");
            } else {
                string4.append("http://");
                string4.append((String)object2);
                string4.append(":");
                string4.append(_uwcPort);
                string4.append(string5);
                string4.append("/");
            }
            String string8 = "goto=" + string4.toString();
            httpServletRequest.setAttribute("goto=", (Object)string8);
            NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("gotoOnFail=");
            nonSyncStringBuffer.append(string4.toString());
            nonSyncStringBuffer.append("?");
            nonSyncStringBuffer.append("err");
            nonSyncStringBuffer.append("=1");
            string8 = nonSyncStringBuffer.toString();
            httpServletRequest.setAttribute("gotoOnFail=", (Object)string8);
            httpServletRequest.setAttribute("defaultdomain", (Object)this._defaultDomain);
            httpServletRequest.setAttribute("defaultdomain", (Object)string2);
            String string9 = IdentitySSOAuthFilter.getUserFromRequest(httpServletRequest);
            string = IdentitySSOAuthFilter.getPasswordFromRequest(httpServletRequest);
            String string10 = httpServletRequest.getParameter("fromlogin");
            if (string9 != null && string9.length() > 0 && string != null && string.length() > 0) {
                int n = string9.lastIndexOf("@");
                if (n != -1) {
                    string3 = string9.substring(0, n);
                    string2 = string9.substring(n + 1);
                } else {
                    string3 = string9;
                    if (string2 == null) {
                        string2 = this._defaultDomain;
                    }
                }
                if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                    authLogger.fine("uid... " + string3 + "domain..." + string2);
                }
                authLogger.fine("username... " + string9);
                object = httpServletRequest.getParameter(AUTH_ONLY_PARAM);
                if (object != null && ((String)object).equalsIgnoreCase("true")) {
                    bl = true;
                    break block50;
                } else {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
            Map map = httpServletRequest.getParameterMap();
            if (map != null && map.containsKey("err")) {
                authLogger.warning("IS Auth Error!");
                string6 = "true";
                servletRequest.setAttribute(this.AUTH_ERROR, (Object)string6);
                servletRequest.setAttribute("defaultdomain", (Object)this._defaultDomain);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (string10 != null && string10.equals("true")) {
                string6 = "true";
                servletRequest.setAttribute(this.AUTH_ERROR, (Object)string6);
                servletRequest.setAttribute("defaultdomain", (Object)this._defaultDomain);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        try {
            String string11;
            String string12;
            Object object3;
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("1. session is not present.. get token manager.. ");
            }
            SSOToken sSOToken = null;
            object = this._identitySSO.getAdminStoreConnection();
            if (bl) {
                object3 = this.getSearchBase(string2, (AMStoreConnection)object);
                this._orgToDomainMap.put(string2, object3);
                sSOToken = IdentitySSO.getSSOToken((String)object3, string3, string);
                if (sSOToken == null) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            } else {
                boolean bl2;
                object3 = SSOTokenManager.getInstance();
                sSOToken = object3.createSSOToken(httpServletRequest);
                if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                    authLogger.fine("2. check for the token validity ");
                }
                if (!(bl2 = object3.isValidToken(sSOToken))) {
                    authLogger.fine("3. Invalid Response");
                    authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("3. Valid Response create session");
            }
            httpSession = httpServletRequest.getSession(true);
            object3 = sSOToken.getTokenID();
            httpSession.setAttribute("identitytokenid", (Object)object3.toString());
            String string13 = new DateTime(TimeZone.getTimeZone("GMT")).toISO8601();
            sSOToken.setProperty("uwcstatus", "active");
            httpSession.setAttribute("identitylastaccessGMTtime", (Object)string13);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("5. get the amuser ");
            }
            AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
            String string14 = aMUser.getStringAttribute("uid");
            String string15 = aMUser.getOrganizationDN();
            String string16 = aMUser.getDN();
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("6. userDN is " + string16);
            }
            String string17 = aMUser.getStringAttribute("mail");
            String string18 = aMUser.getStringAttribute("cn");
            String string19 = aMUser.getStringAttribute("inetUserStatus");
            if (string19 != null && string19.length() == 0) {
                string19 = null;
            }
            String string20 = aMUser.getStringAttribute("preferredLanguage");
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("9. preferredLanguage is " + string20);
            }
            if ((string12 = aMUser.getStringAttribute("cn;lang-" + string20)) == null || string12 != null && string12.length() == 0) {
                string12 = aMUser.getStringAttribute("cn");
            }
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("10. commonName is " + string12);
            }
            AMOrganization aMOrganization = object.getOrganization(string15);
            string2 = aMOrganization.getStringAttribute("sunPreferredDomain");
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("11. domainName is " + string2);
            }
            if ((string11 = aMOrganization.getStringAttribute("inetDomainStatus")) != null && string11.length() == 0) {
                string11 = null;
            }
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("12. inetDomainStatus is " + string11);
            }
            if (string11 != null && string11.equalsIgnoreCase("inactive")) {
                httpSession.setAttribute("mail.service.enabled", (Object)"false");
                httpSession.setAttribute("calendar.service.enabled", (Object)"false");
            } else {
                boolean bl3 = ISUserHelper.getMailServiceStatus(aMUser, aMOrganization);
                httpSession.setAttribute("mail.service.enabled", (Object)String.valueOf(bl3));
                bl3 = ISUserHelper.getCalendarServiceStatus(aMUser, aMOrganization);
                httpSession.setAttribute("calendar.service.enabled", (Object)String.valueOf(bl3));
            }
            String string21 = null;
            httpSession.setAttribute("uid", (Object)string14);
            httpSession.setAttribute("userdn", (Object)string16);
            httpSession.setAttribute("userauthdn", (Object)string16);
            httpSession.setAttribute("domaindn", (Object)string15);
            httpSession.setAttribute("domainname", (Object)string2);
            httpSession.setAttribute("userlang", (Object)string20);
            if (string17 != null) {
                httpSession.setAttribute("email", (Object)string17);
            }
            if (string18 != null) {
                httpSession.setAttribute("cn", (Object)string18);
            }
            httpSession.setAttribute("com.sun.uwc.newsession", (Object)"true");
            string21 = httpServletRequest.getHeader("user-agent");
            if (string21 != null) {
                httpSession.setAttribute("useragent", (Object)string21);
            }
            if ((string21 = httpServletRequest.getHeader("accept-language")) != null) {
                httpSession.setAttribute("acceptlang", (Object)string21);
            }
            if ((string21 = httpServletRequest.getHeader("accept-charset")) != null) {
                httpSession.setAttribute("charsetenc", (Object)string21);
            }
            httpSession.setAttribute("username", (Object)string12);
            authLogger.fine("Valid Response");
            UWCIdentitySSOTokenListener uWCIdentitySSOTokenListener = new UWCIdentitySSOTokenListener();
            sSOToken.addSSOTokenListener((SSOTokenListener)uWCIdentitySSOTokenListener);
            authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (SSOException sSOException) {
            authLogger.warning("SSOException.." + sSOException.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (AMException aMException) {
            authLogger.warning("AMException.." + aMException.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            authLogger.warning("Exception.." + exception.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
    }

    private void dump_stack(Exception exception) {
        authLogger.finest("*** Start Stack Trace ******");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            authLogger.finest(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "@" + stackTraceElement.getLineNumber());
        }
        authLogger.finest("****** End Stack Trace ******");
    }

    public void destroy() {
    }

    private void removeIdentityCookie(ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string = null;
        String string2 = null;
        if (cookieArray != null && cookieArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!cookieArray[i].getName().equalsIgnoreCase(this._identityCookieName)) continue;
                bl = true;
                string = cookieArray[i].getPath();
                string2 = cookieArray[i].getDomain();
                authLogger.fine("cDomain: " + string2);
                break;
            }
            if (bl) {
                Cookie cookie = new Cookie(this._identityCookieName, null);
                if (string != null) {
                    cookie.setPath(string);
                } else {
                    cookie.setPath("/");
                }
                if (string2 != null) {
                    cookie.setDomain(string2);
                } else if (this._cookieDomain != null) {
                    cookie.setDomain(this._cookieDomain);
                }
                cookie.setMaxAge(0);
                httpServletResponse.addCookie(cookie);
            }
        }
    }

    public String getSearchBase(String string, AMStoreConnection aMStoreConnection) throws SSOException {
        String string2 = null;
        if (this._orgToDomainMap.containsKey(string)) {
            return (String)this._orgToDomainMap.get(string);
        }
        try {
            if (aMStoreConnection != null) {
                string2 = aMStoreConnection.getOrganizationDN(string, null);
            }
        }
        catch (AMException aMException) {
            throw new SSOException(aMException.toString());
        }
        return string2;
    }
}

