/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.auth.GZIPResponseStream;
import com.sun.uwc.common.util.UWCLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse _response = null;
    protected ServletOutputStream _outputStream = null;
    protected PrintWriter _writer = null;
    private static final Logger _logger = UWCLogger.getLogger("uwc");

    public GZIPResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this._response = httpServletResponse;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new GZIPResponseStream(this._response);
    }

    public void finishResponse() {
        try {
            if (this._writer != null) {
                this._writer.close();
            } else if (this._outputStream != null) {
                this._outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        this._outputStream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._writer != null) {
            throw new IllegalStateException("Writer is already in use!!");
        }
        if (this._outputStream == null) {
            this._outputStream = this.createOutputStream();
        }
        return this._outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer != null) {
            return this._writer;
        }
        if (this._outputStream != null) {
            throw new IllegalStateException("Output Stream is already in use!!");
        }
        this._outputStream = this.createOutputStream();
        this._writer = new PrintWriter(new OutputStreamWriter((OutputStream)this._outputStream, "UTF-8"));
        return this._writer;
    }

    public void setContentLength(int n) {
    }
}

