/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.util.UWCLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZIPResponseStream
extends ServletOutputStream {
    protected ByteArrayOutputStream _outStream = null;
    protected GZIPOutputStream _gzipOutStream = null;
    protected boolean _closed = false;
    protected HttpServletResponse _response = null;
    protected ServletOutputStream _output = null;
    private static final Logger _logger = UWCLogger.getLogger("uwc");

    public GZIPResponseStream(HttpServletResponse httpServletResponse) throws IOException {
        this._response = httpServletResponse;
        this._output = httpServletResponse.getOutputStream();
        this._outStream = new ByteArrayOutputStream();
        this._gzipOutStream = new GZIPOutputStream(this._outStream);
    }

    public void close() throws IOException {
        if (this._closed) {
            return;
        }
        this._gzipOutStream.finish();
        byte[] byArray = this._outStream.toByteArray();
        this._response.addHeader("Content-Length", Integer.toString(byArray.length));
        this._response.addHeader("Content-Encoding", "gzip");
        this._output.write(byArray);
        this._output.flush();
        this._output.close();
        this._closed = true;
    }

    public void flush() throws IOException {
        if (this._closed) {
            return;
        }
        this._gzipOutStream.flush();
    }

    public void write(int n) throws IOException {
        if (this._closed) {
            throw new IOException("Error: Output stream already closed. Can't write the contents");
        }
        this._gzipOutStream.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._closed) {
            throw new IOException("Error: Output stream already closed. Can't write the contents");
        }
        this._gzipOutStream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this._closed;
    }
}

