/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.auth.AuthFilter;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AnonymousFilter
extends AuthFilter {
    public static final String CONFIG_FILENAME = "uwcauth.properties";
    private String _config_filename = null;
    private String _defaultDomain = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        Preferences preferences = super.getPreferences();
        this._defaultDomain = preferences.get("defaultdomain", "iplanet.com");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        authLogger.entering("AnonymousFilter:", " doFilter");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getServletPath();
        String string3 = httpServletRequest.getPathInfo();
        String string4 = httpServletRequest.getParameter("calid");
        String string5 = httpServletRequest.getParameter("anon");
        boolean bl = false;
        Object var12_12 = null;
        if (httpSession != null) {
            String string6 = (String)httpSession.getAttribute("anon");
            String string7 = (String)httpSession.getAttribute("calid");
            if (string6 != null && string6.equalsIgnoreCase("true") && string7 != null && string4 != null && !string7.equals(string4)) {
                httpSession.invalidate();
                httpSession = httpServletRequest.getSession(true);
                this.setSessionAttributes(httpServletRequest, httpSession, string4);
                this.setNewSessionAttributes(httpServletRequest, httpSession);
            }
            authLogger.exiting("AnonymousFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (string2 != null && string4 != null) {
            if (string5 != null && string5.equalsIgnoreCase("true")) {
                httpSession = httpServletRequest.getSession(true);
                bl = true;
                httpSession.setAttribute("anon", (Object)"true");
                httpSession.setAttribute("calid", (Object)string4);
                this.setNewSessionAttributes(httpServletRequest, httpSession);
            } else if ("auth".equals(string2) || "/auth".equals(string2)) {
                httpSession = httpServletRequest.getSession(true);
                bl = true;
                this.setSessionAttributes(httpServletRequest, httpSession, string4);
                this.setNewSessionAttributes(httpServletRequest, httpSession);
            }
        }
        authLogger.exiting("AnonymousFilter:", " doFilter");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private void setSessionAttributes(HttpServletRequest httpServletRequest, HttpSession httpSession, String string) {
        if (httpServletRequest != null && httpSession != null && string != null) {
            String string2 = null;
            httpSession.setAttribute("anon", (Object)"true");
            httpSession.setAttribute("calid", (Object)string);
            string2 = httpServletRequest.getParameter("tzid");
            if (string2 != null) {
                authLogger.fine("tzid is " + string2);
                httpSession.setAttribute("tzid", (Object)string2);
            }
            if ((string2 = httpServletRequest.getParameter("view")) != null) {
                authLogger.fine("view is " + string2);
                httpSession.setAttribute("view", (Object)string2);
            }
            authLogger.fine("Created session for root context & calid " + string);
        }
    }

    private void setNewSessionAttributes(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        String string = "true";
        httpSession.setAttribute("com.sun.uwc.newsession", (Object)"true");
        string = httpServletRequest.getHeader("user-agent");
        if (string != null) {
            httpSession.setAttribute("useragent", (Object)string);
        }
        if ((string = httpServletRequest.getHeader("accept-language")) != null) {
            httpSession.setAttribute("acceptlang", (Object)string);
        }
        if ((string = httpServletRequest.getHeader("accept-charset")) != null) {
            httpSession.setAttribute("charsetenc", (Object)string);
        }
        if (this._defaultDomain != null) {
            httpSession.setAttribute("domainname", (Object)this._defaultDomain);
        }
        httpSession.setMaxInactiveInterval(180);
    }
}

