/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.util.UWCLogger;
import java.util.logging.Logger;

public class ISUserHelper {
    private static final String CLASS_NAME = "ISUserHelper";
    private static final Logger _log = UWCLogger.getLogger("uwc.common");

    private ISUserHelper() {
    }

    public static void invalidateISssoToken(String string) {
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(string);
        }
        catch (SSOException sSOException) {
            _log.severe("invalidateISSession: Error occured: " + sSOException.getMessage());
        }
        try {
            if (null != sSOToken) {
                sSOTokenManager.destroyToken(sSOToken);
            }
        }
        catch (SSOException sSOException) {
            _log.severe("invalidateISSession: BNA destroy failed: " + sSOException.getMessage());
        }
    }

    public static boolean getMailServiceStatus(AMUser aMUser, AMOrganization aMOrganization) throws AMException, SSOException {
        String string = aMOrganization.getStringAttribute("mailDomainStatus");
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null && !string.equalsIgnoreCase("active") && !string.equalsIgnoreCase("overquota")) {
            return false;
        }
        String string2 = aMUser.getStringAttribute("mailUserStatus");
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 != null && !string2.equalsIgnoreCase("active") && !string2.equalsIgnoreCase("overquota")) {
            return false;
        }
        String string3 = aMUser.getStringAttribute("mailAllowedServiceAccess");
        return UWCUserHelper.isHttpMailServiceAllowed(string3);
    }

    public static boolean getCalendarServiceStatus(AMUser aMUser, AMOrganization aMOrganization) throws AMException, SSOException {
        boolean bl = true;
        String string = aMOrganization.getStringAttribute("icsStatus");
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null && !string.equalsIgnoreCase("active")) {
            bl = false;
        } else {
            String string2 = aMUser.getStringAttribute("icsStatus");
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if (string2 != null && !string2.equalsIgnoreCase("active")) {
                bl = false;
            }
        }
        return bl;
    }
}

