/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeekViewTimeSlotModel
extends DefaultModel
implements RetrievingModel,
RequestParticipant {
    private static Logger _modelLogger = null;
    private static final String CLASS_NAME = "WeekViewTimeSlotModel";
    protected static boolean _isFINELoggable;
    protected static boolean _isINFOLoggable;
    private Duration interval = null;
    private DateTime start;
    private DateTime end;
    private String usersTimeFormatPref = null;
    private RequestContext _reqCtx = null;
    public static final String FIELD_TIMESLOT_HOURMINUTES = "timeslot";
    public static final String FIELD_TIMESLOT_AMPM = "ampm";
    public static final String FIELD_TIMESLOT_START = "timeslotstart";
    public static final String FIELD_TIMESLOT_END = "timeslotend";
    private DateTime[] startslot = new DateTime[48];
    private DateTime[] endslot = new DateTime[48];

    protected static void setLoggableFlags() {
        _isFINELoggable = _modelLogger.isLoggable(Level.FINE);
        _isINFOLoggable = _modelLogger.isLoggable(Level.INFO);
    }

    public WeekViewTimeSlotModel() {
    }

    public WeekViewTimeSlotModel(String string) {
        super(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        this._reqCtx = requestContext;
    }

    public void setStartTime(DateTime dateTime) {
        this.start = (DateTime)dateTime.clone();
    }

    public void setEndTime(DateTime dateTime) {
        this.end = (DateTime)dateTime.clone();
    }

    public void setDuration(Duration duration) {
        this.interval = duration;
    }

    public void setTimeFormat(String string) {
        this.usersTimeFormatPref = string;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        }
        return object;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _modelLogger.entering(CLASS_NAME, "retrieve");
        if (_isFINELoggable) {
            _modelLogger.fine("start Time is " + this.start.toISO8601());
            _modelLogger.fine("end  Time is " + this.end.toISO8601());
        }
        boolean bl = true;
        DateTime dateTime = this.start;
        int n = 0;
        String string = null;
        if (this.usersTimeFormatPref == null) {
            this.usersTimeFormatPref = "12";
        }
        while (bl) {
            this.appendRow();
            this.startslot[n] = (DateTime)dateTime.clone();
            UWCUtils.getDisplayableTime(this._reqCtx, dateTime, this.usersTimeFormatPref);
            string = "24".equals(this.usersTimeFormatPref) ? UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime, "uwc-calclient-24hr-timeslot-startPattern", 1) : UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime, "uwc-calclient-12hr-timeslot-startPattern", 1);
            this.setValue(FIELD_TIMESLOT_HOURMINUTES, string);
            dateTime.add(10, this.interval.getHours());
            dateTime.add(12, this.interval.getMinutes());
            this.endslot[n] = (DateTime)dateTime.clone();
            if (_isINFOLoggable) {
                _modelLogger.info("Time in TimeSlotModel is " + dateTime.toString());
            }
            ++n;
            if (!dateTime.equals((Object)this.end) && dateTime.before((Object)this.end)) continue;
            bl = false;
        }
        this.beforeFirst();
        _modelLogger.exiting(CLASS_NAME, "retrieve");
        return null;
    }

    public DateTime[] getSlotStartList() {
        return this.startslot;
    }

    public DateTime[] getSlotEndList() {
        return this.endslot;
    }

    static {
        _modelLogger = UWCLogger.getLogger("uwc.common.model");
        WeekViewTimeSlotModel.setLoggableFlags();
    }
}

