/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TasksPaneModel
extends DefaultModel
implements RetrievingModel,
RequestParticipant {
    public static final String FIELD_TASKTITLE = "tasktitle";
    public static final String FIELD_TASKDUEDATE = "duedate";
    public static final String FIELD_CALNAME = "calname";
    public static final String FIELD_TASKURL = "taskurl";
    public static final String FIELD_TASKID = "taskid";
    public static final String FIELD_TASK_RID = "taskrid";
    public static final String FIELD_CALID = "calid";
    public static final String FIELD_MODIFIABLE = "modifiable";
    public static final String FIELD_DELETEABLE = "deleteable";
    public static final String FIELD_ISCONFIDENTIAL = "isConfidential";
    private RequestContext _reqCtx = null;
    private static Logger _tasksPaneModelLogger = null;
    private static final String CLASS_NAME = "TasksPaneModel";
    private static final String UNTITLED_TASK_CAPTION = "untitled-caption";
    private static final String NONE_CAPTION = "none";
    private static String EDIT_TASK_URL = "../calclient/ViewTask?update=true&";
    private static String VIEW_TASK_URL = "../calclient/ViewTask?";
    private static String TASK_ID_PARAM = "todoUid=";
    private static String TASK_RID_PARAM = "rid=";
    private CalendarBaseModel calendarBaseModelObject = null;
    private UserPreferencesModel _userPrefsModel = null;
    private ArrayList tasks = null;
    private String _originalCtxName = null;
    private String dateFormat = null;
    private String dateDelimiter = null;
    private String timeFormat = null;
    private String _userId = null;
    private String[] ownedCalIds = null;
    private HashMap calendars = null;

    public TasksPaneModel() {
        _tasksPaneModelLogger.entering(CLASS_NAME, "TasksPaneModel()");
        this.setUseDefaultValues(false);
        this.getCalendarBaseModel();
        this.getUserPrefsModel();
        _tasksPaneModelLogger.exiting(CLASS_NAME, "TasksPaneModel()");
    }

    public TasksPaneModel(String string) {
        super(string);
        _tasksPaneModelLogger.entering(CLASS_NAME, "TasksPaneModel( " + string + ")");
        this.setUseDefaultValues(false);
        this.getCalendarBaseModel();
        this.getUserPrefsModel();
        _tasksPaneModelLogger.exiting(CLASS_NAME, "TasksPaneModel( " + string + ")");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _tasksPaneModelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        if (this.dateFormat == null) {
            this.dateFormat = this._userPrefsModel.getDateFormat();
        }
        if (this.timeFormat == null) {
            this.timeFormat = this._userPrefsModel.getTimeFormat();
        }
        if (this.dateDelimiter == null) {
            this.dateDelimiter = this._userPrefsModel.getDateDelimiter();
        }
        if ((string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.FETCH_OVERDUE_TASKS_CONTEXT).equals(CalendarExecutionModelContext.FETCH_OVERDUE_TASKS_CONTEXT)) {
            this.tasks = this.fetchOverDueTasks();
        } else if (string.equals(CalendarExecutionModelContext.FETCH_DUE_TASKS_CONTEXT)) {
            this.tasks = this.fetchDueTasks();
        } else if (string.equals(CalendarExecutionModelContext.FETCH_COMPLETED_TASKS_CONTEXT)) {
            this.tasks = this.fetchCompletedTasks();
        }
        this._originalCtxName = this.getCalendarBaseModel().getCurrentContextName();
        _tasksPaneModelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _tasksPaneModelLogger.entering(CLASS_NAME, "retrieve()");
        if (this._userId == null) {
            this._userId = UWCUserHelper.getUID(this._reqCtx);
        }
        String string = null;
        if (modelExecutionContext != null) {
            string = modelExecutionContext.getOperationName();
        }
        if (string == null) {
            string = CalendarExecutionModelContext.FETCH_OVERDUE_TASKS_CONTEXT;
        }
        this.clear();
        if (this.tasks != null && this.tasks.size() > 0) {
            for (int i = 0; i < this.tasks.size(); ++i) {
                this.appendRow();
                VTodo vTodo = (VTodo)this.tasks.get(i);
                DateTime dateTime = null;
                DateTime dateTime2 = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                Object var12_12 = null;
                Object var13_13 = null;
                Object var14_14 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                UWCCalendar uWCCalendar = null;
                Object var23_23 = null;
                String string10 = null;
                try {
                    string2 = vTodo.getSummary();
                    string9 = vTodo.getClassification();
                    dateTime = vTodo.getDueTime();
                    string3 = vTodo.getID();
                    if (vTodo.isRecurring()) {
                        dateTime2 = vTodo.getRecurrenceID();
                        String string11 = string4 = dateTime2 != null ? dateTime2.toISOString() : null;
                    }
                    bl4 = !vTodo.isAllDay();
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    string2 = null;
                    dateTime = null;
                    string3 = null;
                    dateTime2 = null;
                    string4 = null;
                    string9 = null;
                }
                catch (CalendarComponentException calendarComponentException) {
                    string2 = null;
                    dateTime = null;
                    string3 = null;
                    dateTime2 = null;
                    string4 = null;
                    string9 = null;
                }
                if (string3 != null) {
                    this.setValue(FIELD_TASKID, string3);
                }
                if (string4 != null) {
                    this.setValue(FIELD_TASK_RID, string4);
                }
                if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                    _tasksPaneModelLogger.info("Formatting date to display");
                }
                if (dateTime != null) {
                    if (this.dateDelimiter == null) {
                        this.dateDelimiter = "/";
                    }
                    if (this.dateFormat == null) {
                        this.dateFormat = UWCConstants.dateFormatValues[0];
                    }
                    string8 = this.timeFormat.equals(UWCConstants.timeFormatValues[0]) ? UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime, "uwc-calclient-view-taskDueTimePattern12hr", 3) : UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime, "uwc-calclient-view-taskDueTimePattern24hr", 3);
                    string7 = UWCUtils.getDisplayableDate(this._reqCtx, dateTime, this.dateFormat, this.dateDelimiter);
                    if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                        _tasksPaneModelLogger.info("Formatted date to display: " + string8 + " " + string7);
                    }
                    if (string8 != null && string7 != null) {
                        if (bl4) {
                            this.setValue(FIELD_TASKDUEDATE, string8 + " " + string7);
                        } else {
                            this.setValue(FIELD_TASKDUEDATE, string7);
                        }
                    } else {
                        this.setValue(FIELD_TASKDUEDATE, UWCUserHelper.getLocalizedLabel(this._reqCtx, NONE_CAPTION, "uwc-calclient-common-", "None"));
                    }
                } else {
                    this.setValue(FIELD_TASKDUEDATE, UWCUserHelper.getLocalizedLabel(this._reqCtx, NONE_CAPTION, "uwc-calclient-common-", "None"));
                }
                if (this.ownedCalIds == null) {
                    this.ownedCalIds = UWCUserHelper.getOwnedCalIDs(this._reqCtx);
                }
                if (this.calendars == null) {
                    this.calendars = this.calendarBaseModelObject.getCalendars();
                }
                String string12 = null;
                SOCSCalendar sOCSCalendar = null;
                string6 = "";
                try {
                    string12 = vTodo.getCalID();
                    uWCCalendar = (UWCCalendar)this.calendars.get(string12);
                    if (uWCCalendar != null) {
                        sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                    }
                    if (sOCSCalendar != null) {
                        string6 = sOCSCalendar.getRelativeCalId();
                    }
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    string6 = "";
                }
                catch (CalendarComponentException calendarComponentException) {
                    string6 = "";
                }
                catch (Exception exception) {
                    if (_tasksPaneModelLogger.isLoggable(Level.WARNING)) {
                        _tasksPaneModelLogger.warning("Exception: " + exception.getMessage());
                    }
                    string6 = "";
                }
                if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                    _tasksPaneModelLogger.info("CalID of Task: " + string6);
                }
                this.setValue(FIELD_CALID, string6);
                try {
                    bl2 = UWCUserHelper.isUserTheCalendarOwner(uWCCalendar, this._userId);
                }
                catch (UWCException uWCException) {
                    if (_tasksPaneModelLogger.isLoggable(Level.WARNING)) {
                        _tasksPaneModelLogger.warning("Failed to verify if the user is (co)owner of the calendar: " + string6);
                    }
                    bl2 = false;
                }
                try {
                    bl = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userId, "c", "d");
                }
                catch (UWCException uWCException) {
                    if (_tasksPaneModelLogger.isLoggable(Level.WARNING)) {
                        _tasksPaneModelLogger.warning("Failed to verify the permissions of the calendar: " + string6);
                    }
                    bl = false;
                }
                try {
                    bl3 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userId, "c", "w");
                }
                catch (UWCException uWCException) {
                    if (_tasksPaneModelLogger.isLoggable(Level.WARNING)) {
                        _tasksPaneModelLogger.warning("Failed to verify the write permissions of the calendar: " + string6);
                    }
                    bl3 = false;
                }
                if (string9 != null && string9.equalsIgnoreCase("CONFIDENTIAL")) {
                    if (bl2) {
                        if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                            _tasksPaneModelLogger.info("User is the owner of Calendar");
                            _tasksPaneModelLogger.info("Setting that Todo is not Confidential");
                        }
                        this.setValue(FIELD_ISCONFIDENTIAL, "F");
                    } else {
                        if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                            _tasksPaneModelLogger.info("User is not the owner of Calendar");
                            _tasksPaneModelLogger.info("Setting that Todo is Confidential");
                        }
                        this.setValue(FIELD_ISCONFIDENTIAL, "T");
                    }
                } else {
                    if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                        _tasksPaneModelLogger.info("No Privacy Information in Todo");
                    }
                    this.setValue(FIELD_ISCONFIDENTIAL, "F");
                }
                if (string2 != null) {
                    if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                        _tasksPaneModelLogger.info("Summary: " + string2);
                    }
                    try {
                        this.setValue(FIELD_TASKTITLE, string2.length() > 80 ? string2.substring(0, 80) + "..." : string2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.setValue(FIELD_TASKTITLE, string2);
                    }
                } else {
                    this.setValue(FIELD_TASKTITLE, UWCUserHelper.getLocalizedLabel(this._reqCtx, UNTITLED_TASK_CAPTION, "uwc-calclient-view-", "Untitled Task"));
                }
                if (!bl2) {
                    try {
                        if (uWCCalendar != null) {
                            string10 = uWCCalendar.getCalendar().getDisplayName();
                        }
                    }
                    catch (CalendarException calendarException) {
                        string10 = null;
                    }
                    catch (OperationNotSupportedException operationNotSupportedException) {
                        string10 = null;
                    }
                    if (string10 != null) {
                        this.setValue(FIELD_CALNAME, UWCUtils.getCalendarNameToDisplay(string6, string10));
                    }
                }
                if (!bl) {
                    this.setValue(FIELD_DELETEABLE, "F");
                } else {
                    this.setValue(FIELD_DELETEABLE, "T");
                }
                if (!bl3) {
                    this.setValue(FIELD_MODIFIABLE, "F");
                } else {
                    this.setValue(FIELD_MODIFIABLE, "T");
                }
                NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("");
                if (bl3) {
                    nonSyncStringBuffer.append(EDIT_TASK_URL);
                    nonSyncStringBuffer.append(TASK_ID_PARAM);
                    nonSyncStringBuffer.append(string3);
                    nonSyncStringBuffer.append("&");
                    nonSyncStringBuffer.append(FIELD_CALID);
                    nonSyncStringBuffer.append("=");
                    nonSyncStringBuffer.append(string6);
                } else {
                    nonSyncStringBuffer.append(VIEW_TASK_URL);
                    nonSyncStringBuffer.append(TASK_ID_PARAM);
                    nonSyncStringBuffer.append(string3);
                    nonSyncStringBuffer.append("&");
                    nonSyncStringBuffer.append(FIELD_CALID);
                    nonSyncStringBuffer.append("=");
                    nonSyncStringBuffer.append(string6);
                }
                if (string4 != null) {
                    nonSyncStringBuffer.append("&");
                    nonSyncStringBuffer.append(TASK_RID_PARAM);
                    nonSyncStringBuffer.append(string4);
                }
                string5 = nonSyncStringBuffer.toString();
                this.setValue(FIELD_TASKURL, string5);
            }
        } else if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
            _tasksPaneModelLogger.info("No tasks obtained!");
        }
        this.tasks = null;
        this.beforeFirst();
        _tasksPaneModelLogger.exiting(CLASS_NAME, "retrieve()");
        return null;
    }

    private ArrayList fetchOverDueTasks() {
        _tasksPaneModelLogger.entering(CLASS_NAME, "fetchOverDueTasks()");
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList2 = this.getCalendarBaseModel().getOverDueTodos();
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList = (ArrayList)arrayList2.clone();
            if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                _tasksPaneModelLogger.info("No. of Overdue Todos: " + arrayList.size());
            }
        } else if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
            _tasksPaneModelLogger.info("No Overdue Todos!");
        }
        _tasksPaneModelLogger.exiting(CLASS_NAME, "fetchOverDueTasks()");
        return arrayList;
    }

    private ArrayList fetchDueTasks() {
        _tasksPaneModelLogger.entering(CLASS_NAME, "fetchDueTasks()");
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList2 = this.getCalendarBaseModel().getDueTodos();
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList = (ArrayList)arrayList2.clone();
            if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                _tasksPaneModelLogger.info("No. of Due Todos: " + arrayList.size());
            }
        } else if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
            _tasksPaneModelLogger.info("No Due Todos!");
        }
        _tasksPaneModelLogger.exiting(CLASS_NAME, "fetchDueTasks()");
        return arrayList;
    }

    private ArrayList fetchCompletedTasks() {
        _tasksPaneModelLogger.entering(CLASS_NAME, "fetchCompletedTasks()");
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList2 = this.getCalendarBaseModel().getCompletedTodos();
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList = (ArrayList)arrayList2.clone();
            if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
                _tasksPaneModelLogger.info("No. of Completed Todos: " + arrayList.size());
            }
        } else if (_tasksPaneModelLogger.isLoggable(Level.INFO)) {
            _tasksPaneModelLogger.info("No Completed Todos!");
        }
        _tasksPaneModelLogger.exiting(CLASS_NAME, "fetchCompletedTasks()");
        return arrayList;
    }

    public void setRequestContext(RequestContext requestContext) {
        _tasksPaneModelLogger.entering(CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _tasksPaneModelLogger.exiting(CLASS_NAME, "setRequestContext()");
    }

    private CalendarBaseModel getCalendarBaseModel() {
        _tasksPaneModelLogger.entering(CLASS_NAME, "getCalendarBaseModel()");
        if (this.calendarBaseModelObject == null) {
            this.calendarBaseModelObject = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        }
        _tasksPaneModelLogger.exiting(CLASS_NAME, "getCalendarBaseModel()");
        return this.calendarBaseModelObject;
    }

    private UserPreferencesModel getUserPrefsModel() {
        _tasksPaneModelLogger.entering(CLASS_NAME, "getUserPrefsModel()");
        if (this._userPrefsModel == null) {
            this._userPrefsModel = UWCUserHelper.getUserPrefModel(this._reqCtx);
        }
        _tasksPaneModelLogger.exiting(CLASS_NAME, "getUserPrefsModel()");
        return this._userPrefsModel;
    }

    static {
        _tasksPaneModelLogger = UWCLogger.getLogger("uwc.calclient.model");
    }
}

