/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ExecutingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.uwc.calclient.model.CalendarACL;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.CalendarListModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ICalendarModel
extends DefaultModel
implements ExecutingModel,
RequestParticipant {
    public static final String UWC_CAL_NAME = "CALNAME";
    public static final String UWC_CAL_DISPLAY_NAME = "NAME";
    public static final String UWC_CAL_DESCRIPTION = "DESCRIPTION";
    public static final String UWC_CAL_ADDRESS = "CALADDRESS";
    public static final String UWC_CAL_PRIMARY_OWNER_DISPLAY = "PRIMARY-OWNER-DISPLAY";
    public static final String UWC_CAL_PRIMARY_OWNER = "PRIMARY-OWNER";
    public static final String UWC_CAL_OWNERS = "OWNERS";
    public static final String UWC_CAL_TIMEZONE = "TZID";
    public static final String UWC_CAL_ADD_FOR_FREEBUSY = "FREE-BUSY";
    public static final String UWC_CAL_SHARING = "ACCESS-CONTROL-ENTRY";
    public static final String UWC_CAL_ID = "calid";
    private Logger _calModelLogger = UWCLogger.getLogger("uwc.calclient.model");
    private UWCCalendar _cal;
    private CalendarBaseModel _calBaseModel = UWCUserHelper.getCalendarBaseModel(this._requestContext);
    private RequestContext _requestContext;
    private boolean _isAnonymous = false;
    private static final String UWC_CAL_ID_SEPARATOR = ":";
    private static final String CLASS_NAME = "ICalendarModel";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public ICalendarModel() {
    }

    public ICalendarModel(String string) {
        super(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        this._requestContext = requestContext;
    }

    private void loadCalendar() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "loadCalendar");
        if (this._cal == null) {
            String string = this.getCalID();
            this._calModelLogger.info("Calendar doesn't exist, load it from CBM " + string);
            if (string == null) {
                throw new UWCException(54);
            }
            this._calBaseModel.addCalid(string);
            this._calBaseModel.loadCalendar();
            HashMap hashMap = this._calBaseModel.getCalendars();
            this._cal = (UWCCalendar)hashMap.get(string);
        }
        if (this._cal == null) {
            throw new UWCException("calendar load failed");
        }
        this.initializeModel();
        this._calModelLogger.exiting(CLASS_NAME, "loadCalendar");
    }

    private void initializeModel() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "initializeModel");
        if (this._cal != null) {
            try {
                String string;
                block7: {
                    ICalendar iCalendar = this._cal.getCalendar();
                    Properties properties = iCalendar.getCalProps();
                    this.setValue(UWC_CAL_ID, iCalendar.getCalID());
                    this.setValue(UWC_CAL_NAME, this.getCalName(iCalendar.getCalID()));
                    this.setValue(UWC_CAL_DISPLAY_NAME, properties.getProperty(UWC_CAL_DISPLAY_NAME));
                    this.setValue(UWC_CAL_DESCRIPTION, properties.getProperty(UWC_CAL_DESCRIPTION));
                    this.setValue(UWC_CAL_PRIMARY_OWNER, properties.getProperty(UWC_CAL_PRIMARY_OWNER));
                    this.setValue(UWC_CAL_OWNERS, properties.getProperty(UWC_CAL_OWNERS));
                    this.setValue(UWC_CAL_SHARING, properties.getProperty(UWC_CAL_SHARING));
                    this.setValue(UWC_CAL_TIMEZONE, properties.getProperty(UWC_CAL_TIMEZONE));
                    this.setValue(UWC_CAL_ADD_FOR_FREEBUSY, properties.getProperty("FB-INCLUDE"));
                    this.setValue(UWC_CAL_ADDRESS, UWCUtils.getAnonAccessURL(this._requestContext, iCalendar.getCalID()));
                    string = properties.getProperty(UWC_CAL_PRIMARY_OWNER);
                    try {
                        String string2 = ((SOCSCalendar)iCalendar).getOwnerCommonName();
                        if (null != string2) {
                            string = null == string ? string2 : string + " (" + string2 + ")";
                        }
                    }
                    catch (Exception exception) {
                        if (!this._calModelLogger.isLoggable(Level.WARNING)) break block7;
                        this._calModelLogger.warning("getOwnerCommonName of calendar failed: " + exception);
                    }
                }
                this.setValue(UWC_CAL_PRIMARY_OWNER_DISPLAY, string);
            }
            catch (CalendarException calendarException) {
                throw new UWCException(60);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                throw new UWCException(60);
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "initializeModel");
    }

    private void addCalendar() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "addCalendar");
        if (this.getValue(UWC_CAL_NAME) == null) {
            throw new UWCException(61);
        }
        String string = UWCUserHelper.getUID(this._requestContext) + UWC_CAL_ID_SEPARATOR + (String)this.getValue(UWC_CAL_NAME);
        Properties properties = this.fillCalProperties();
        properties.put("subscribe", "1");
        this._calBaseModel.addCalendar((String)this.getValue(UWC_CAL_NAME), properties);
        HashMap<String, UWCCalendar> hashMap = UWCUserHelper.getOwnedCalendars(this._requestContext);
        boolean bl = false;
        if (hashMap == null) {
            bl = true;
            hashMap = new HashMap<String, UWCCalendar>();
        }
        UWCCalendar uWCCalendar = UWCUtils.getUWCCalendar(this._requestContext, string, true, false, false);
        hashMap.put(string, uWCCalendar);
        if (bl) {
            CalendarListModel calendarListModel = UWCUserHelper.getCalendarListModel(this._requestContext);
            calendarListModel.updateOwnedCalendars(hashMap);
        }
        this._calModelLogger.exiting(CLASS_NAME, "addCalendar");
    }

    private Properties fillCalProperties() {
        Properties properties = new Properties();
        String string = (String)this.getValue(UWC_CAL_DISPLAY_NAME);
        if (string != null) {
            properties.setProperty(UWC_CAL_DISPLAY_NAME, string);
        }
        if ((string = (String)this.getValue(UWC_CAL_DESCRIPTION)) != null) {
            properties.setProperty("desc", string);
        }
        if ((string = (String)this.getValue(UWC_CAL_PRIMARY_OWNER)) != null) {
            properties.setProperty(UWC_CAL_PRIMARY_OWNER, string);
        }
        if ((string = (String)this.getValue(UWC_CAL_OWNERS)) != null) {
            properties.setProperty(UWC_CAL_OWNERS, string);
        }
        if ((string = (String)this.getValue(UWC_CAL_TIMEZONE)) != null) {
            properties.setProperty(UWC_CAL_TIMEZONE, string);
        }
        if ((string = (String)this.getValue(UWC_CAL_ADD_FOR_FREEBUSY)) != null) {
            properties.setProperty("fbinclude", string);
        }
        if ((string = (String)this.getValue(UWC_CAL_SHARING)) != null) {
            properties.setProperty("acl", string);
        }
        return properties;
    }

    private void editCalendar() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "editCalendar");
        String string = this.getCalID();
        if (string == null) {
            throw new UWCException(54);
        }
        Properties properties = this.fillCalProperties();
        this._calBaseModel.modifyCalendar(string, properties);
        HashMap hashMap = UWCUserHelper.getOwnedCalendars(this._requestContext);
        UWCCalendar uWCCalendar = UWCUtils.getUWCCalendar(this._requestContext, string, true, false, false);
        if (uWCCalendar == null) {
            throw new UWCException("Could not obtain the uwccalendar for the calid supplied");
        }
        if (hashMap != null && hashMap.containsKey(string)) {
            hashMap.put(string, uWCCalendar);
            return;
        }
        hashMap = UWCUserHelper.getSubscribedCalendars(this._requestContext);
        if (hashMap != null && hashMap.containsKey(string)) {
            hashMap.put(string, uWCCalendar);
            return;
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put(string, uWCCalendar);
        this._calModelLogger.exiting(CLASS_NAME, "editCalendar");
    }

    private void deleteCalendar() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "deleteCalendar");
        String string = this.getCalID();
        if (string == null) {
            throw new UWCException(54);
        }
        this._calBaseModel.deleteCalendar(string);
        this._calBaseModel.removeCalid(string);
        HashMap hashMap = UWCUserHelper.getOwnedCalendars(this._requestContext);
        if (hashMap != null) {
            hashMap.remove(string);
        }
        this._calModelLogger.exiting(CLASS_NAME, "deleteCalendar");
    }

    private void subscribeToCalendar() throws UWCException {
        int n;
        Cloneable cloneable;
        this._calModelLogger.entering(CLASS_NAME, "subscribeToCalendar");
        String[] stringArray = this.getCalIDs();
        if (stringArray == null || stringArray != null && stringArray.length == 0) {
            throw new UWCException(54);
        }
        CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._requestContext);
        String[] stringArray2 = calUserPreferencesModel.getSubscribedCalendarIDs();
        String[] stringArray3 = null;
        this._calModelLogger.info("How many subscribed calendars - " + String.valueOf(stringArray2.length));
        if (stringArray2 != null) {
            if (this._calModelLogger.isLoggable(Level.INFO)) {
                this._calModelLogger.info("----- There are subscribed calids: ---- ");
            }
            cloneable = new ArrayList();
            for (n = 0; n < stringArray2.length; ++n) {
                ((ArrayList)cloneable).add(stringArray2[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                ((ArrayList)cloneable).add(stringArray[n]);
            }
            stringArray3 = ((ArrayList)cloneable).toArray(EMPTY_STRING_ARRAY);
        } else {
            this._calModelLogger.info(" --- There aren't any subscribed calids yet, so add supplied ones ---");
            stringArray3 = stringArray;
        }
        calUserPreferencesModel.setSubscribedCalendarIDs(stringArray3);
        calUserPreferencesModel.updateCalendarUserPrefs();
        cloneable = UWCUserHelper.getSubscribedCalendars(this._requestContext);
        n = 0;
        if (cloneable == null) {
            n = 1;
            cloneable = new HashMap();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = stringArray[i].indexOf("$");
            String string = -1 == n2 ? stringArray[i] : stringArray[i].substring(0, n2);
            ((HashMap)cloneable).put(string, UWCUtils.getUWCCalendar(this._requestContext, string, true, false, false));
        }
        if (n != 0) {
            CalendarListModel calendarListModel = UWCUserHelper.getCalendarListModel(this._requestContext);
            calendarListModel.updateSubscribedCalendars((HashMap)cloneable);
        }
        this._calModelLogger.exiting(CLASS_NAME, "subscribeToCalendar");
    }

    private void unsubscribeCalendar() throws UWCException {
        int n;
        this._calModelLogger.entering(CLASS_NAME, "unsubscribeCalendar");
        String[] stringArray = this.getCalIDs();
        if (stringArray == null) {
            throw new UWCException(54);
        }
        CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._requestContext);
        String[] stringArray2 = calUserPreferencesModel.getSubscribedCalendarIDs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n] + "$";
                if (!stringArray2[i].startsWith(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(stringArray2[i]);
        }
        String[] stringArray3 = arrayList.toArray(EMPTY_STRING_ARRAY);
        if (stringArray3.length == 0) {
            stringArray3 = new String[]{""};
        }
        calUserPreferencesModel.setSubscribedCalendarIDs(stringArray3);
        calUserPreferencesModel.updateCalendarUserPrefs();
        HashMap hashMap = UWCUserHelper.getSubscribedCalendars(this._requestContext);
        if (hashMap != null) {
            for (n = 0; n < stringArray.length; ++n) {
                int n2 = stringArray[n].indexOf("$");
                String string = -1 == n2 ? stringArray[n] : stringArray[n].substring(0, n2);
                hashMap.remove(string);
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "unsubscribeCalendar");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this._calModelLogger.entering(CLASS_NAME, "execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_CALENDAR_CONTEXT;
        try {
            if (string.equals(CalendarExecutionModelContext.LOAD_CALENDAR_CONTEXT)) {
                this.loadCalendar();
            }
            if (string.equals(CalendarExecutionModelContext.ADD_CALENDAR_CONTEXT)) {
                this.addCalendar();
            }
            if (string.equals(CalendarExecutionModelContext.MODIFY_CALENDAR_CONTEXT)) {
                this.editCalendar();
            }
            if (string.equals(CalendarExecutionModelContext.DELETE_CALENDAR_CONTEXT)) {
                this.deleteCalendar();
            }
            if (string.equals(CalendarExecutionModelContext.SUBSCRIBE_CALENDAR_CONTEXT)) {
                this.subscribeToCalendar();
            }
            if (string.equals(CalendarExecutionModelContext.UNSUBSCRIBE_CALENDAR_CONTEXT)) {
                this.unsubscribeCalendar();
            }
        }
        catch (UWCException uWCException) {
            if (this._calModelLogger.isLoggable(Level.SEVERE)) {
                this._calModelLogger.severe("[Error:execute] - " + uWCException.getMessage());
            }
            if (uWCException.getReason() == 54) {
                throw new ModelControlException("Error[ICalendarModel:execute] - No calid's has been supplied!!");
            }
            throw new ModelControlException("Error[ICalendarModel:execute] - " + uWCException.getMessage());
        }
        this._calModelLogger.exiting(CLASS_NAME, "execute");
        return null;
    }

    public void setCalID(String string) {
        this._cal = null;
        if (string == null) {
            this.setValues(UWC_CAL_ID, null);
        } else {
            Object[] objectArray = new String[]{string};
            this.setValues(UWC_CAL_ID, objectArray);
        }
    }

    public void setCalIDs(String[] stringArray) {
        this._cal = null;
        if (stringArray == null) {
            this.setValues(UWC_CAL_ID, null);
        } else {
            this.setValues(UWC_CAL_ID, stringArray);
        }
    }

    public String getCalID() {
        return (String)this.getValue(UWC_CAL_ID);
    }

    public String[] getCalIDs() {
        String string = (String)this.getValue(UWC_CAL_ID);
        if (string == null) {
            return null;
        }
        String[] stringArray = (String[])this.getValues(UWC_CAL_ID);
        return stringArray;
    }

    public UWCCalendar getCalendar() {
        return this._cal;
    }

    public void setCalendar(UWCCalendar uWCCalendar) {
        this.setValues(UWC_CAL_ID, null);
        this._cal = uWCCalendar;
    }

    public CalendarACL getCalendarACL() {
        return this._cal == null ? null : this._cal.getACL();
    }

    public void setPermissions(CalendarACL calendarACL, int n, String string) {
        if (calendarACL == null || string == null) {
            throw new IllegalArgumentException("Either of CalendarACL or uid argument is null");
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        if (this._calModelLogger.isLoggable(Level.INFO)) {
            this._calModelLogger.info("id --> " + string + "; permission --> " + String.valueOf(n));
        }
        switch (n) {
            case 0: {
                string3 = "";
                string2 = "";
                string4 = "rwdfsi";
                break;
            }
            case 1: {
                string3 = "f";
                string4 = "swdr";
                break;
            }
            case 2: {
                string3 = "r";
                string4 = "fswd";
                break;
            }
            case 3: {
                string3 = "rf";
                string4 = "swd";
                break;
            }
            case 4: {
                string3 = "s";
                string4 = "frwd";
                break;
            }
            case 5: {
                string3 = "sf";
                string4 = "rwd";
                break;
            }
            case 6: {
                string3 = "sr";
                string4 = "fwd";
                break;
            }
            case 7: {
                string3 = "srf";
                string4 = "wd";
                break;
            }
            case 8: {
                string2 = "d";
                string4 = "wrfs";
                break;
            }
            case 9: {
                string3 = "f";
                string2 = "d";
                string4 = "swr";
                break;
            }
            case 10: {
                string3 = "r";
                string2 = "d";
                string4 = "wfs";
                break;
            }
            case 11: {
                string3 = "rf";
                string2 = "d";
                string4 = "sw";
                break;
            }
            case 12: {
                string3 = "s";
                string2 = "d";
                string4 = "fwr";
                break;
            }
            case 13: {
                string3 = "sf";
                string2 = "d";
                string4 = "wr";
                break;
            }
            case 14: {
                string3 = "sr";
                string2 = "d";
                string4 = "fw";
                break;
            }
            case 15: {
                string3 = "srf";
                string2 = "d";
                string4 = "w";
                break;
            }
            case 16: {
                string2 = "w";
                string4 = "drfs";
                break;
            }
            case 17: {
                string3 = "f";
                string2 = "w";
                string4 = "drs";
                break;
            }
            case 18: {
                string3 = "r";
                string2 = "w";
                string4 = "dfs";
                break;
            }
            case 19: {
                string3 = "rf";
                string2 = "w";
                string4 = "ds";
                break;
            }
            case 20: {
                string3 = "s";
                string2 = "w";
                string4 = "dfr";
                break;
            }
            case 21: {
                string3 = "fs";
                string2 = "w";
                string4 = "dr";
                break;
            }
            case 22: {
                string3 = "sr";
                string2 = "w";
                string4 = "df";
                break;
            }
            case 23: {
                string3 = "sfr";
                string2 = "w";
                string4 = "d";
                break;
            }
            case 24: {
                string2 = "wd";
                string4 = "rfs";
                break;
            }
            case 25: {
                string3 = "f";
                string2 = "wd";
                string4 = "rs";
                break;
            }
            case 26: {
                string3 = "r";
                string2 = "wd";
                string4 = "fs";
                break;
            }
            case 27: {
                string3 = "rf";
                string2 = "wd";
                string4 = "s";
                break;
            }
            case 28: {
                string3 = "s";
                string2 = "wd";
                string4 = "fr";
                break;
            }
            case 29: {
                string3 = "sf";
                string2 = "wd";
                string4 = "r";
                break;
            }
            case 30: {
                string3 = "sr";
                string2 = "wd";
                string4 = "f";
                break;
            }
            case 31: {
                string3 = "sfr";
                string2 = "wd";
            }
        }
        if (n > 0) {
            if (this._calModelLogger.isLoggable(Level.INFO)) {
                this._calModelLogger.info("Setting p with r");
            }
            calendarACL.setPermission(string, "p", "r", "g");
        }
        if (string2 != null) {
            if (this._calModelLogger.isLoggable(Level.INFO)) {
                this._calModelLogger.info("Setting c with " + string2);
            }
            calendarACL.setPermission(string, "c", string2, "g");
        }
        if (string3 != null) {
            if (this._calModelLogger.isLoggable(Level.INFO)) {
                this._calModelLogger.info("Setting a with " + string3);
            }
            calendarACL.setPermission(string, "a", string3, "g");
        }
        if (string4 != null) {
            if (this._calModelLogger.isLoggable(Level.INFO)) {
                this._calModelLogger.info("Setting deny for c with " + string4);
            }
            calendarACL.setPermission(string, "c", string4, "d");
        }
    }

    private String getCalName(String string) {
        int n = string.indexOf(UWC_CAL_ID_SEPARATOR);
        if (n > 1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public void setAnonymous(boolean bl) {
        this._isAnonymous = bl;
    }
}

