/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ExecutingModel;
import com.iplanet.jato.model.InvalidContextException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.uwc.calclient.model.CalendarACL;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.CalendarGroup;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.util.CalendarData;
import com.sun.uwc.common.util.OrderedMap;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;

public class CalendarListModel
extends DefaultModel
implements ExecutingModel,
RequestParticipant {
    public static final String SELECTED_CALENDARS_TILE_VIEW_CONTEXT = "SelectedCalendarsTileViewContext";
    public static final String CAL_ID = "calid";
    public static final String CAL_DISPLAY_NAME = "calname";
    public static final String CAL_DESCRIPTION = "caldesc";
    public static final String CAL_PRIMARY_OWNER = "calowner";
    public static final String CAL_ACL = "calacl";
    public static final String CAL_TYPE = "caltype";
    public static final String IS_CALENDAR_SELECTED = "IsCalendarSelected";
    public static final String CAL_SEARCH_STRING = "calsearchstring";
    public static final String IS_SUBSCRIBED = "IsSubscribed";
    public static final String ALLOW_CAL_SELECTION = "AllowCalSelection";
    public static final String CAL_DISPLAYABLE_INFO = "CalDisplayableInfo";
    private Logger _calModelLogger;
    private Logger _log;
    private String[] _calids;
    private UWCCalendar[] _cals;
    private ICalendar[] _searchedCals;
    private CalendarData[] _selectedCalData;
    private OrderedMap _selectedCalids;
    private String _searchMode;
    private HashMap _subscribedMap;
    private int _calendarTilesCount;
    private RequestContext _requestContext;
    private String _methodTitle;
    private static final String CLASS_NAME = "CalendarListModel";

    public CalendarListModel() {
        this._log = this._calModelLogger = UWCLogger.getLogger("uwc.calclient.model");
        this._searchedCals = null;
        this._selectedCalData = null;
        this._selectedCalids = null;
        this._searchMode = null;
        this._subscribedMap = null;
        this._calendarTilesCount = 0;
    }

    public CalendarListModel(String string) {
        super(string);
        this._log = this._calModelLogger = UWCLogger.getLogger("uwc.calclient.model");
        this._searchedCals = null;
        this._selectedCalData = null;
        this._selectedCalids = null;
        this._searchMode = null;
        this._subscribedMap = null;
        this._calendarTilesCount = 0;
    }

    public void setRequestContext(RequestContext requestContext) {
        this._requestContext = requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchMyCalendarList() throws UWCException {
        HashMap hashMap;
        HashMap hashMap2;
        Object object;
        this._calModelLogger.entering(CLASS_NAME, "fetchMyCalendarList");
        HttpSession httpSession = this._requestContext.getRequest().getSession(false);
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._requestContext);
        CalendarExecutionModelContext calendarExecutionModelContext = new CalendarExecutionModelContext(CalendarExecutionModelContext.FETCH_OWNED_CALENDARS_CONTEXT);
        try {
            calendarBaseModel.execute((ModelExecutionContext)calendarExecutionModelContext);
        }
        catch (ModelControlException modelControlException) {
            throw new UWCException("[Error:LOAD_MY_CALENDARS_CONTEXT] - " + modelControlException.getMessage());
        }
        HashMap hashMap3 = (HashMap)calendarBaseModel.getOwnedCalendars().clone();
        if (hashMap3 != null) {
            object = hashMap3;
            synchronized (object) {
                httpSession.setAttribute("com.sun.uwc.calclient.ownedcal", (Object)hashMap3);
            }
        }
        if (!((CalUserPreferencesModel)((Object)(object = UWCUserHelper.getCalUserPrefModel(this._requestContext)))).getInitialized()) {
            this._calModelLogger.info("getSubscribedCalendars: Initializing calendar preference in CalUserPreferencesModel");
            ((CalUserPreferencesModel)((Object)object)).initializeCalendarPreferences();
        }
        if ((hashMap2 = this.getSubscribedCalendars((CalUserPreferencesModel)((Object)object))) != null) {
            hashMap = hashMap2;
            synchronized (hashMap) {
                httpSession.setAttribute("com.sun.uwc.calclient.subscribedcal", (Object)hashMap2);
            }
        }
        if ((hashMap = ((CalUserPreferencesModel)((Object)object)).getCalendarGroups()) != null) {
            HashMap hashMap4 = hashMap;
            synchronized (hashMap4) {
                httpSession.setAttribute("com.sun.uwc.calclient.calgroups", (Object)hashMap);
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "fetchMyCalendarList");
    }

    private HashMap getSubscribedCalendars(CalUserPreferencesModel calUserPreferencesModel) throws UWCException {
        String[] stringArray = calUserPreferencesModel.getSubscribedCalendarIDs();
        if (null == stringArray) {
            this._calModelLogger.warning("getSubscribedCalendars: No Subscribed Calendars found!!");
            return null;
        }
        CalendarStore calendarStore = UWCUserHelper.getCalStore(this._requestContext, false);
        ICalendar iCalendar = null;
        UWCCalendar uWCCalendar = null;
        int n = stringArray.length;
        HashMap<String, UWCCalendar> hashMap = new HashMap<String, UWCCalendar>();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            this._calModelLogger.info("getSubscribedCalendars: subscribedCalid before '$' split: " + string);
            if (null != string) {
                int n2 = string.indexOf("$");
                this._calModelLogger.info("getSubscribedCalendars: dollorIndex: " + n2);
                if (n2 > -1) {
                    string = string.substring(0, n2);
                }
            }
            this._calModelLogger.info("getSubscribedCalendars: subscribedCalid after '$' split: " + string);
            if (null == string || string.trim().equals("")) {
                this._calModelLogger.info("subscribedCalid is null or blank. Not adding or processing");
                continue;
            }
            String string2 = calUserPreferencesModel.getDefaultCalendarId();
            String string3 = UWCUserHelper.getUID(this._requestContext);
            this._calModelLogger.info("defaultCalid: " + string2);
            this._calModelLogger.info("uid: " + string3);
            if (null != string2 && string.equals(string2)) {
                this._calModelLogger.info(string + ": Equals to default calid. Not adding or processing");
                continue;
            }
            if (null != string3) {
                if (string.equals(string3)) {
                    this._calModelLogger.info(string + ": Equals to userId. Not adding or processing");
                    continue;
                }
                if (string.startsWith(string3 + ":")) {
                    this._calModelLogger.info("getSubscribedCalendars(): " + string + ": Starts with userID. Not adding or processing");
                    continue;
                }
            }
            try {
                iCalendar = calendarStore.openCalendar(string);
                iCalendar.getCalProps();
                uWCCalendar = new UWCCalendar(iCalendar);
            }
            catch (CalendarStoreException calendarStoreException) {
                this._calModelLogger.severe("Unable to get ICalendar object");
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                this._calModelLogger.severe("OperationNotSupported Exception for getCalProps");
            }
            catch (CalendarException calendarException) {
                this._calModelLogger.severe("getCalProps Failed: Calendar Store Exception");
            }
            this._calModelLogger.info("Putting - " + iCalendar.getCalID() + " and " + uWCCalendar);
            hashMap.put(iCalendar.getCalID(), uWCCalendar);
            uWCCalendar = null;
        }
        return hashMap;
    }

    private void fetchSubscribedCalendars() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "fetchSubscribedCalendars");
        HashMap hashMap = UWCUserHelper.getSubscribedCalendars(this._requestContext);
        String string = UWCUserHelper.getLanguage(this._requestContext);
        Collator collator = Collator.getInstance(new Locale(string));
        TreeMap treeMap = null;
        if (hashMap != null) {
            treeMap = new TreeMap(collator);
            treeMap.putAll(hashMap);
        }
        this.clear();
        if (treeMap != null) {
            Set<Object> set = treeMap.keySet();
            Iterator<Object> iterator = set.iterator();
            for (int i = 0; i < treeMap.size(); ++i) {
                String string2 = (String)iterator.next();
                UWCCalendar uWCCalendar = (UWCCalendar)treeMap.get(string2);
                this.appendRow();
                this.setValue(CAL_TYPE, "subscribed");
                if (uWCCalendar == null) {
                    this._calModelLogger.info("Couldn't get the UWCCalendar for the subscribed calendar: " + string2);
                    this.setValue(CAL_ID, string2);
                    this.setValue(CAL_DISPLAY_NAME, null);
                    this.setValue(CAL_DESCRIPTION, null);
                    this.setValue(CAL_PRIMARY_OWNER, null);
                    this.setValue(CAL_ACL, null);
                    continue;
                }
                ICalendar iCalendar = uWCCalendar.getCalendar();
                if (iCalendar == null) {
                    throw new UWCException(52, "Error[fetchSubscribedCalendars] - Could not obtain the calendar");
                }
                try {
                    Properties properties = iCalendar.getCalProps();
                    String string3 = properties.getProperty("NAME");
                    this.setValue(CAL_ID, string2);
                    if (string3 != null) {
                        this.setValue(CAL_DISPLAY_NAME, UWCUtils.getCalendarNameToDisplay(string2, string3));
                    } else {
                        this.setValue(CAL_DISPLAY_NAME, string2);
                    }
                    this.setValue(CAL_DESCRIPTION, properties.getProperty("DESCRIPTION"));
                    this.setValue(CAL_PRIMARY_OWNER, properties.getProperty("PRIMARY-OWNER"));
                    this.setValue(CAL_ACL, uWCCalendar.getACL());
                    this._calModelLogger.info((String)this.getValue(CAL_DISPLAY_NAME) + " - " + (String)this.getValue(CAL_DESCRIPTION) + " - " + (String)this.getValue(CAL_PRIMARY_OWNER));
                    continue;
                }
                catch (Exception exception) {
                    this._calModelLogger.severe("[Error:fetchSubscribedCalendars] - Failed to get properties for " + string2 + " : " + exception.getMessage());
                    this.setValue(CAL_ID, string2);
                    this.setValue(CAL_DISPLAY_NAME, null);
                    this.setValue(CAL_DESCRIPTION, null);
                    this.setValue(CAL_PRIMARY_OWNER, null);
                    this.setValue(CAL_ACL, null);
                }
            }
            try {
                this.beforeFirst();
            }
            catch (ModelControlException modelControlException) {
                this._calModelLogger.severe("[Error:fetchSubscribedCalendars] - " + modelControlException.getMessage());
                throw new UWCException(modelControlException.getMessage());
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "fetchSubscribedCalendars");
    }

    private void fetchOwnedCalendars() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "fetchOwnedCalendars");
        HashMap hashMap = UWCUserHelper.getOwnedCalendars(this._requestContext);
        String string = UWCUserHelper.getLanguage(this._requestContext);
        Collator collator = Collator.getInstance(new Locale(string));
        TreeMap treeMap = null;
        if (hashMap != null) {
            treeMap = new TreeMap(collator);
            treeMap.putAll(hashMap);
        }
        this.clear();
        if (treeMap != null) {
            Set<Object> set = treeMap.keySet();
            Iterator<Object> iterator = set.iterator();
            this._calModelLogger.info("****************");
            this._calModelLogger.info("Calids are: ");
            while (iterator.hasNext()) {
                this._calModelLogger.info((String)iterator.next());
            }
            this._calModelLogger.info("****************");
            Iterator<Object> iterator2 = set.iterator();
            for (int i = 0; i < treeMap.size(); ++i) {
                this.appendRow();
                String string2 = (String)iterator2.next();
                UWCCalendar uWCCalendar = (UWCCalendar)treeMap.get(string2);
                if (uWCCalendar == null) {
                    this.setValue(CAL_ID, string2);
                    this.setValue(CAL_DISPLAY_NAME, null);
                    this.setValue(CAL_DESCRIPTION, null);
                    this.setValue(CAL_PRIMARY_OWNER, null);
                    this.setValue(CAL_ACL, null);
                    continue;
                }
                ICalendar iCalendar = uWCCalendar.getCalendar();
                if (iCalendar == null) {
                    this.setValue(CAL_ID, string2);
                    this.setValue(CAL_DISPLAY_NAME, null);
                    this.setValue(CAL_DESCRIPTION, null);
                    this.setValue(CAL_PRIMARY_OWNER, null);
                    this.setValue(CAL_ACL, null);
                }
                try {
                    Properties properties = iCalendar.getCalProps();
                    this.setValue(CAL_TYPE, "owned");
                    String string3 = properties.getProperty("NAME");
                    this.setValue(CAL_ID, string2);
                    if (string3 != null) {
                        this.setValue(CAL_DISPLAY_NAME, UWCUtils.getCalendarNameToDisplay(string2, string3));
                    } else {
                        this.setValue(CAL_DISPLAY_NAME, string2);
                    }
                    this.setValue(CAL_DESCRIPTION, properties.getProperty("DESCRIPTION"));
                    this.setValue(CAL_PRIMARY_OWNER, properties.getProperty("PRIMARY-OWNER"));
                    this.setValue(CAL_ACL, uWCCalendar.getACL());
                    this._calModelLogger.info((String)this.getValue(CAL_DISPLAY_NAME) + " - " + (String)this.getValue(CAL_DESCRIPTION) + " - " + (String)this.getValue(CAL_PRIMARY_OWNER));
                    continue;
                }
                catch (Exception exception) {
                    this._calModelLogger.severe("[Error:fetchSubscribedCalendars] - Failed to get properties for " + string2 + " : " + exception.getMessage());
                    this.setValue(CAL_ID, string2);
                    this.setValue(CAL_DISPLAY_NAME, null);
                    this.setValue(CAL_DESCRIPTION, null);
                    this.setValue(CAL_PRIMARY_OWNER, null);
                    this.setValue(CAL_ACL, null);
                }
            }
            try {
                this.beforeFirst();
            }
            catch (ModelControlException modelControlException) {
                this._calModelLogger.severe("[Error:fetchCalendarGroups] - " + modelControlException.getMessage());
                throw new UWCException(modelControlException.getMessage());
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "fetchOwnedCalendars");
    }

    private void fetchCalendarGroups() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "fetchCalendarGroups(");
        HashMap hashMap = UWCUserHelper.getCalendarGroups(this._requestContext);
        String string = UWCUserHelper.getLanguage(this._requestContext);
        Collator collator = Collator.getInstance(new Locale(string));
        TreeMap treeMap = null;
        if (hashMap != null) {
            treeMap = new TreeMap(collator);
            treeMap.putAll(hashMap);
        }
        this.clear();
        if (treeMap != null) {
            Set<Object> set = treeMap.keySet();
            Iterator<Object> iterator = set.iterator();
            for (int i = 0; i < treeMap.size(); ++i) {
                String string2 = (String)iterator.next();
                CalendarGroup calendarGroup = (CalendarGroup)treeMap.get(string2);
                if (calendarGroup == null) {
                    throw new UWCException(52, "Error[fetchCalendarGroups] - Could not obtain the calendar group");
                }
                this.appendRow();
                this.setValue(CAL_TYPE, "group");
                this.setValue(CAL_ID, string2);
                this.setValue(CAL_DISPLAY_NAME, string2);
                this.setValue(CAL_DESCRIPTION, calendarGroup.getGroupDescription());
                this.setValue(CAL_PRIMARY_OWNER, null);
                this.setValue(CAL_ACL, null);
            }
            try {
                this.beforeFirst();
            }
            catch (ModelControlException modelControlException) {
                this._calModelLogger.severe("[Error:fetchCalendarGroups] - " + modelControlException.getMessage());
                throw new UWCException(modelControlException.getMessage());
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "fetchCalendarGroups");
    }

    private void fetchAdHocList() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "fetchAdHocList");
        if (this._cals == null) {
            if (this._calids == null) {
                throw new UWCException(52, "Error[fetchAdHocList] - Either of calids or calendars should be set prior to this context");
            }
            CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._requestContext);
            for (int i = 0; i < this._calids.length; ++i) {
                calendarBaseModel.addCalid(this._calids[i]);
            }
            calendarBaseModel.loadCalendar();
            HashMap hashMap = calendarBaseModel.getCalendars();
            if (hashMap != null) {
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                for (int i = 0; i < hashMap.size(); ++i) {
                    String string = (String)iterator.next();
                    UWCCalendar uWCCalendar = (UWCCalendar)hashMap.get(string);
                    if (uWCCalendar == null) {
                        throw new UWCException(52, "Error[fetchAdHocList] - Could not obtain the calendar");
                    }
                    ICalendar iCalendar = uWCCalendar.getCalendar();
                    if (iCalendar == null) {
                        throw new UWCException(52, "Error[fetchAdHocList] - Could not obtain the calendar");
                    }
                    try {
                        Properties properties = iCalendar.getCalProps();
                        String string2 = properties.getProperty("NAME");
                        if (string2 != null) {
                            this.setValue(CAL_DISPLAY_NAME, UWCUtils.getCalendarNameToDisplay(string, string2));
                        } else {
                            this.setValue(CAL_DISPLAY_NAME, string);
                        }
                        this.setValue(CAL_DESCRIPTION, properties.getProperty("DESCRIPTION"));
                        this.setValue(CAL_PRIMARY_OWNER, properties.getProperty("PRIMARY-OWNER"));
                        this.setValue(CAL_ACL, uWCCalendar.getACL());
                        continue;
                    }
                    catch (Exception exception) {
                        this._calModelLogger.severe("[Error:fetchAdHocList] - Failed to get properties for " + string + " : " + exception.getMessage());
                        throw new UWCException(52, "Error[fetchAdHocList] - Could not obtain the calendar");
                    }
                }
            }
        }
        this._calModelLogger.exiting(CLASS_NAME, "fetchAdHocList");
    }

    public void searchCalendars() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "searchCalendars()");
        this._searchedCals = null;
        try {
            CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._requestContext);
            calendarBaseModel.setCalendarSearchFilter((String)this.getValue(CAL_SEARCH_STRING));
            calendarBaseModel.execute((ModelExecutionContext)new CalendarExecutionModelContext(CalendarExecutionModelContext.SEARCH_CALENDARS_CONTEXT));
            OrderedMap orderedMap = calendarBaseModel.getSearchedCalendars();
            if (null != orderedMap) {
                this._searchedCals = (ICalendar[])orderedMap.getValuesInOrder(new ICalendar[0]);
            }
        }
        catch (ModelControlException modelControlException) {
            if (this._log.isLoggable(Level.SEVERE)) {
                this._log.severe("Search calendars by search string failed. Reason: " + (Object)((Object)modelControlException));
            }
            UWCUtils.printStackTrace((Exception)((Object)modelControlException));
            this._log.exiting(CLASS_NAME, "searchCalendars()");
            throw new UWCException(59, "Search calendars by search string failed.");
        }
        this._calModelLogger.exiting(CLASS_NAME, "searchCalendars()");
    }

    public void loadSearchedCalendars() throws ModelControlException {
        this._calModelLogger.entering(CLASS_NAME, "loadSearchedCalendars()");
        this.clear();
        this._calendarTilesCount = 0;
        if (null == this._searchedCals || this._searchedCals.length < 1) {
            this.beforeFirst();
            this._log.exiting(CLASS_NAME, "loadSearchedCalendars()");
            return;
        }
        HashMap hashMap = null;
        try {
            hashMap = UWCUserHelper.getOwnedCalDisplay(this._requestContext);
        }
        catch (Exception exception) {
            hashMap = null;
        }
        try {
            this._subscribedMap = UWCUserHelper.getSubscribedCalDisplay(this._requestContext);
        }
        catch (Exception exception) {
            this._subscribedMap = null;
        }
        for (int i = 0; i < this._searchedCals.length; ++i) {
            String string = this._searchedCals[i].getCalID();
            if (null == this._searchedCals[i] || null == string || "subscribe".equalsIgnoreCase(this._searchMode) && null != hashMap && hashMap.containsKey(string) && null != hashMap.get(string)) continue;
            this.appendRow();
            ++this._calendarTilesCount;
            try {
                this.writeCalendarTileData(this._searchedCals[i]);
                continue;
            }
            catch (Exception exception) {
                if (this._log.isLoggable(Level.SEVERE)) {
                    this._log.severe("Calendar load failed. Reason: " + exception);
                }
                UWCUtils.printStackTrace(exception);
            }
        }
        this.beforeFirst();
        this._log.exiting(CLASS_NAME, "loadSearchedCalendars()");
    }

    public void loadSelectedCalendars() throws ModelControlException {
        this._log.entering(CLASS_NAME, "loadSelectedCalendars()");
        this.clear();
        if (null == this._selectedCalData || this._selectedCalData.length < 1) {
            this.beforeFirst();
            this._log.exiting(CLASS_NAME, "loadSelectedCalendars()");
            return;
        }
        for (int i = 0; i < this._selectedCalData.length; ++i) {
            if (null == this._selectedCalData[i]._calid && !this._selectedCalData[i]._calid.trim().equals("")) continue;
            this.appendRow();
            String string = this._selectedCalData[i]._calid;
            String string2 = this._selectedCalData[i]._dispName;
            String string3 = null;
            string3 = null == string2 || string2.trim().equals("") ? string : UWCUtils.getCalendarNameToDisplay(string, string2);
            this.setValue(CAL_ID, this._selectedCalData[i]._calid);
            this.setValue(CAL_DISPLAY_NAME, this._selectedCalData[i]._dispName);
            this.setValue(CAL_PRIMARY_OWNER, this._selectedCalData[i]._ownerCN);
            this.setValue(CAL_DISPLAYABLE_INFO, string3);
        }
        this.beforeFirst();
        this._log.exiting(CLASS_NAME, "loadSelectedCalendars()");
    }

    private boolean checkAnyCalPermsSet(ICalendar iCalendar, String[] stringArray) {
        if (null == stringArray || null == iCalendar) {
            return false;
        }
        try {
            String string = UWCUserHelper.getUID(this._requestContext);
            UWCCalendar uWCCalendar = new UWCCalendar(iCalendar);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!UWCUserHelper.hasCalendarPermission(uWCCalendar, string, "c", stringArray[i])) continue;
                return true;
            }
        }
        catch (Exception exception) {
            UWCUtils.printStackTrace(exception);
            return false;
        }
        return false;
    }

    private void writeCalendarTileData(ICalendar iCalendar) throws UWCException {
        if (null == iCalendar) {
            throw new UWCException(59, "Couldn't get ICalendar object");
        }
        try {
            Properties properties = null;
            try {
                properties = iCalendar.getCalProps();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = iCalendar.getCalID();
            String string2 = null;
            String string3 = null;
            String string4 = null == properties ? null : properties.getProperty("DESCRIPTION");
            String string5 = null;
            String string6 = "false";
            String string7 = "true";
            try {
                string2 = iCalendar.getDisplayName();
            }
            catch (Exception exception) {
                string2 = null;
            }
            string3 = null == string2 || string2.trim().equals("") ? string : UWCUtils.getCalendarNameToDisplay(string, string2);
            if (null == string2 || string2.trim().equals("")) {
                string2 = "";
            }
            try {
                string5 = ((SOCSCalendar)iCalendar).getOwnerCommonName();
            }
            catch (Exception exception) {
                string5 = null;
            }
            if ((null == string5 || string5.trim().equals("")) && null != properties) {
                string5 = properties.getProperty("PRIMARY-OWNER");
            }
            if (null != this._selectedCalids && this._selectedCalids.containsKey(string)) {
                string7 = "false";
            } else if ("subscribe".equalsIgnoreCase(this._searchMode)) {
                if (null != this._subscribedMap && this._subscribedMap.containsKey(string)) {
                    string6 = "true";
                }
                if ("true".equalsIgnoreCase(string6)) {
                    string7 = "false";
                }
            }
            this.setValue(CAL_ID, string);
            this.setValue(CAL_DISPLAY_NAME, string2);
            this.setValue(CAL_DISPLAYABLE_INFO, string3);
            this.setValue(CAL_DESCRIPTION, string4);
            this.setValue(CAL_PRIMARY_OWNER, string5);
            this.setValue(IS_SUBSCRIBED, string6);
            this.setValue(ALLOW_CAL_SELECTION, string7);
        }
        catch (Exception exception) {
            if (this._log.isLoggable(Level.SEVERE)) {
                this._log.severe("Couldn't load the calendar. Reason: " + exception);
            }
            UWCUtils.printStackTrace(exception);
            throw new UWCException(59, "Couldn't load the calendar.");
        }
    }

    private void dumpCalendarTileData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCalendarGroups(HashMap hashMap) {
        if (hashMap != null) {
            HttpSession httpSession = this._requestContext.getRequest().getSession(false);
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                httpSession.setAttribute("com.sun.uwc.calclient.calgroups", (Object)hashMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscribedCalendars(HashMap hashMap) {
        if (hashMap != null) {
            HttpSession httpSession = this._requestContext.getRequest().getSession(false);
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                httpSession.setAttribute("com.sun.uwc.calclient.subscribedcal", (Object)hashMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOwnedCalendars(HashMap hashMap) {
        if (hashMap != null) {
            HttpSession httpSession = this._requestContext.getRequest().getSession(false);
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                httpSession.setAttribute("com.sun.uwc.calclient.ownedcal", (Object)hashMap);
            }
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this._calModelLogger.entering(CLASS_NAME, "execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_MY_CALENDARS_CONTEXT;
        try {
            if (string.equals(CalendarExecutionModelContext.LOAD_MY_CALENDARS_CONTEXT)) {
                this.fetchMyCalendarList();
            }
            if (string.equals(CalendarExecutionModelContext.FETCH_SUBSCRIBED_CALENDARS_CONTEXT)) {
                this.fetchSubscribedCalendars();
            }
            if (string.equals(CalendarExecutionModelContext.FETCH_OWNED_CALENDARS_CONTEXT)) {
                this.fetchOwnedCalendars();
            }
            if (string.equals(CalendarExecutionModelContext.FETCH_CALENDAR_GROUPS_CONTEXT)) {
                this.fetchCalendarGroups();
            }
            if (string.equals(CalendarExecutionModelContext.FETCH_ADHOC_LIST_CONTEXT)) {
                this.fetchAdHocList();
            }
            if (string.equals(CalendarExecutionModelContext.SEARCH_CALENDARS_CONTEXT)) {
                this.searchCalendars();
            }
        }
        catch (UWCException uWCException) {
            if (uWCException.getReason() == 54) {
                this._calModelLogger.warning("No calid's been supplied for operations to work on!!");
            }
            throw new ModelControlException("Error[CalendarListModel:execute] - " + uWCException.getMessage());
        }
        this._calModelLogger.exiting(CLASS_NAME, "execute");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.SEARCH_CALENDARS_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.SEARCH_CALENDARS_CONTEXT)) {
            this.loadSearchedCalendars();
        } else if (string.equals(SELECTED_CALENDARS_TILE_VIEW_CONTEXT)) {
            this.loadSelectedCalendars();
        } else {
            throw new UWCModelControlException((Throwable)new InvalidContextException("Calendar retrieve context failed: \"" + string + "\" is invalid Calendar retrieve context"));
        }
        return null;
    }

    public void setSearchedCalendars(ICalendar[] iCalendarArray) {
        this._searchedCals = iCalendarArray;
    }

    public ICalendar[] getSearchedCalendars() {
        return this._searchedCals;
    }

    public void setSearchString(String string) {
        this.setValue(CAL_SEARCH_STRING, string);
    }

    public String getSearchString() {
        return (String)this.getValue(CAL_SEARCH_STRING);
    }

    public void setSearchMode(String string) {
        this._searchMode = string;
    }

    public String getSearchMode() {
        return this._searchMode;
    }

    public int getCalendarTilesCount() {
        return this._calendarTilesCount;
    }

    public void setSelectedCalendarData(CalendarData[] calendarDataArray) {
        this._selectedCalData = calendarDataArray;
    }

    public void setSelectedCalids(OrderedMap orderedMap) {
        this._selectedCalids = orderedMap;
    }

    public OrderedMap getSelectedCalids() {
        return this._selectedCalids;
    }

    public void setCalIDs(String[] stringArray) {
        this._calids = stringArray;
    }

    public String[] getCalIDs() {
        return this._calids;
    }

    public UWCCalendar[] getCalendars() {
        return this._cals;
    }

    public void setCalendars(UWCCalendar[] uWCCalendarArray) {
        this._cals = uWCCalendarArray;
    }

    public CalendarACL getACL() {
        return (CalendarACL)this.getValue(CAL_ACL);
    }
}

