/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ExecutingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.uwc.calclient.model.CalendarGroup;
import com.sun.uwc.calclient.model.CalendarListModel;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.util.UWCLogger;
import java.util.HashMap;
import java.util.logging.Logger;

public class CalendarGroupModel
extends DefaultModel
implements ExecutingModel,
RequestParticipant {
    public static final String CAL_GROUP_NAME = "groupname";
    public static final String CAL_GROUP_MEMBERS = "groupmembers";
    public static final String CAL_GROUP_DESCRIPTION = "groupdesc";
    private Logger _calModelLogger = UWCLogger.getLogger("uwc.calclient");
    private CalendarGroup _calGroup;
    private String _icsSetString;
    private RequestContext _requestContext;
    private static final String CLASS_NAME = "CalendarGroupModel";

    public CalendarGroupModel() {
    }

    public CalendarGroupModel(String string) {
        super(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        this._requestContext = requestContext;
    }

    private void loadGroup() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "loadGroup");
        if (this._calGroup == null) {
            if (this._icsSetString == null) {
                String string = this.getCalendarGroupName();
                if (string == null) {
                    throw new UWCException("[Error:CalendarGroupModel] - None of required information to load a group provided");
                }
                HashMap hashMap = UWCUserHelper.getCalendarGroups(this._requestContext);
                if (hashMap != null) {
                    this._calGroup = (CalendarGroup)hashMap.get(string);
                } else {
                    CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._requestContext);
                    hashMap = calUserPreferencesModel.getCalendarGroups();
                    if (hashMap != null) {
                        this._calGroup = (CalendarGroup)hashMap.get(string);
                    }
                }
            } else {
                this._calGroup = new CalendarGroup(this._icsSetString);
            }
        }
        if (this._calGroup == null) {
            throw new UWCException(73, "Calendar group doesn't exist for the supplied information");
        }
        this.setValue(CAL_GROUP_NAME, this._calGroup.getGroupName());
        this.setValues(CAL_GROUP_MEMBERS, this._calGroup.getGroupMembers());
        this.setValue(CAL_GROUP_DESCRIPTION, this._calGroup.getGroupDescription());
        this._calModelLogger.exiting(CLASS_NAME, "loadGroup");
    }

    private void updateGroup(boolean bl) throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "addGroup");
        String string = (String)this.getValue(CAL_GROUP_NAME);
        if (string == null) {
            throw new UWCException(61);
        }
        if (bl) {
            this._calGroup = new CalendarGroup();
        }
        this._calGroup.setGroupName(string);
        Object[] objectArray = this.getValues(CAL_GROUP_MEMBERS);
        String[] stringArray = null;
        if (null != objectArray && objectArray.length > 0) {
            stringArray = (String[])objectArray;
        }
        this._calGroup.setGroupMembers(stringArray);
        this._calGroup.setGroupDescription((String)this.getValue(CAL_GROUP_DESCRIPTION));
        CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._requestContext);
        HashMap<String, CalendarGroup> hashMap = calUserPreferencesModel.getCalendarGroups();
        if (hashMap == null) {
            hashMap = new HashMap<String, CalendarGroup>();
        }
        hashMap.put(string, this._calGroup);
        calUserPreferencesModel.setCalendarGroups(hashMap);
        CalendarListModel calendarListModel = UWCUserHelper.getCalendarListModel(this._requestContext);
        calendarListModel.updateCalendarGroups(hashMap);
        this._calModelLogger.exiting(CLASS_NAME, "addGroup");
    }

    private void deleteGroup() throws UWCException {
        this._calModelLogger.entering(CLASS_NAME, "deleteGroup");
        String string = (String)this.getValue(CAL_GROUP_NAME);
        if (string == null) {
            throw new UWCException(61);
        }
        CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._requestContext);
        HashMap hashMap = calUserPreferencesModel.getCalendarGroups();
        if (hashMap.containsKey(string)) {
            hashMap.remove(string);
        }
        calUserPreferencesModel.setCalendarGroups(hashMap);
        CalendarListModel calendarListModel = UWCUserHelper.getCalendarListModel(this._requestContext);
        calendarListModel.updateCalendarGroups(hashMap);
        this._calModelLogger.exiting(CLASS_NAME, "deleteGroup");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this._calModelLogger.entering(CLASS_NAME, "execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_GROUP_CONTEXT;
        try {
            if (string.equals(CalendarExecutionModelContext.LOAD_GROUP_CONTEXT)) {
                this.loadGroup();
            }
            if (string.equals(CalendarExecutionModelContext.ADD_GROUP_CONTEXT)) {
                this.updateGroup(true);
            }
            if (string.equals(CalendarExecutionModelContext.MODIFY_GROUP_CONTEXT)) {
                this.updateGroup(false);
            }
            if (string.equals(CalendarExecutionModelContext.DELETE_GROUP_CONTEXT)) {
                this.deleteGroup();
            }
        }
        catch (UWCException uWCException) {
            throw new ModelControlException("Error[ICalendarModel:execute] - " + uWCException.getMessage());
        }
        this._calModelLogger.exiting(CLASS_NAME, "execute");
        return null;
    }

    public void setIcsString(String string) {
        this._calGroup = null;
        this._icsSetString = string;
    }

    public String getIcsString() {
        return this._icsSetString;
    }

    public CalendarGroup getCalendarGroup() {
        return this._calGroup;
    }

    public void setCalendarGroup(CalendarGroup calendarGroup) {
        this._calGroup = calendarGroup;
    }

    public String getCalendarGroupName() {
        return (String)this.getValue(CAL_GROUP_NAME);
    }

    public void setCalendarGroupName(String string) {
        this._icsSetString = null;
        this._calGroup = null;
        this.setValue(CAL_GROUP_NAME, string);
    }
}

