/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.abclient;

import com.iplanet.xslui.auth.ABUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.util.UWCLogger;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ABInitFilter
extends AuthFilter {
    private Preferences _preferences;
    private static final String CLASS_NAME = "ABInitFilter";
    private static Logger _abLogger = UWCLogger.getLogger("uwc.abclient");

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this._preferences = super.getPreferences();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        _abLogger.entering(CLASS_NAME, "doFilter");
        HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession(false);
        if (httpSession == null) {
            _abLogger.warning("Session is not created, user not authenticated!!");
            servletRequest.setAttribute("integration", (Object)"true");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            _abLogger.warning("Address Book session already set!!");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (userSession == null && httpSession != null) {
            _abLogger.info(" --- Creating ABUserSession --- ");
            object = new ABUserSessionFactory();
            userSession = object.newUserSession(httpSession);
        }
        if (userSession == null) {
            _abLogger.warning("Failed in preparing Address Book!!");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        httpSession.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
        httpSession.setAttribute("integration", (Object)"true");
        object = (String)httpSession.getAttribute("sunAbInitialized");
        _abLogger.fine(" What is sunAbInitialized: " + (String)object);
        if (object == null || object != null && !((String)object).equals("true")) {
            this.initializeABPrefs(httpSession, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            return;
        }
        _abLogger.exiting(CLASS_NAME, "doFilter");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void initializeABPrefs(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        _abLogger.entering(CLASS_NAME, "initializeABPrefs");
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getContextPath();
        if (string3 != null && !string3.equals("/")) {
            string2 = string2.substring(string3.length());
        }
        if ((string = httpServletRequest.getQueryString()) != null) {
            string2 = string2 + "?" + URLEncoder.encode(string);
        }
        try {
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/abclient/ABInit?gotoUri=" + string2);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        catch (Exception exception) {
            _abLogger.severe("Error - " + exception.getMessage());
            _abLogger.exiting(CLASS_NAME, "initializeABPrefs");
            return;
        }
    }

    public void destroy() {
    }
}

