/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.wabpc;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.ClientPStore;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WABPClientPStore
implements ClientPStore {
    private static String boundary = "---------------------------7d226f700d0";
    static final int BUFF_SIZE = 1024;
    static final byte[] buffer = new byte[1024];
    private static String sessionid;
    private static XMLDOMBuilder _domBuilder;
    private String iabsurl = null;

    public WABPClientPStore(String serverURL) throws PStoreException {
        try {
            if (serverURL != null) {
                String path;
                URL _serverURL = new URL(serverURL);
                this.iabsurl = new String("http://") + _serverURL.getHost();
                if (_serverURL.getPort() != -1) {
                    this.iabsurl = this.iabsurl + ":" + Integer.toString(_serverURL.getPort());
                }
                if ((path = _serverURL.getPath()) != null && path.length() > 0) {
                    this.iabsurl = this.iabsurl + "/" + path;
                }
                this.iabsurl = this.iabsurl + new String("/wabp/");
            } else {
                this.iabsurl = new String("http://localhost/wabp/");
            }
            URLConnection conn = this.SendGetCommand(serverURL);
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node sessionidnode = attrlist.getNamedItem("sessionstring");
            sessionid = sessionidnode.getNodeValue();
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "Malformed URL (" + serverURL + "): " + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed:" + xpe.getMessage());
        }
    }

    public WABPClientPStore(String serverURL, String user, String password) throws PStoreException {
        try {
            if (serverURL != null) {
                String path;
                URL _serverURL = new URL(serverURL);
                serverURL = serverURL + "/wabp/login.wabp";
                this.iabsurl = new String("http://") + _serverURL.getHost();
                if (_serverURL.getPort() != -1) {
                    this.iabsurl = this.iabsurl + ":" + Integer.toString(_serverURL.getPort());
                }
                if ((path = _serverURL.getPath()) != null && path.length() > 0) {
                    this.iabsurl = this.iabsurl + path;
                }
                this.iabsurl = this.iabsurl + new String("/wabp/");
            } else {
                this.iabsurl = new String("http://localhost/wabp/");
            }
            Properties extraProps = new Properties();
            String userpassword = user + ":" + password;
            String base64userpassword = StringUtils.b64Encode((String)userpassword);
            extraProps.put("Authorization", "Basic " + base64userpassword);
            extraProps.put("authOnly", "true");
            URLConnection conn = this.SendGetCommand(serverURL, extraProps);
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node sessionidnode = attrlist.getNamedItem("sessionstring");
            if (sessionidnode == null) {
                throw new IOException("Authentication failed");
            }
            sessionid = sessionidnode.getNodeValue();
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "Malformed URL (" + serverURL + "): " + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed:" + xpe.getMessage());
        }
    }

    public WABPClientPStore(String serverURL, String adminUser, String adminPassword, String proxyUser) throws PStoreException {
        try {
            if (serverURL != null) {
                String path;
                URL _serverURL = new URL(serverURL);
                serverURL = serverURL + "/wabp/login.wabp?proxyauth=" + proxyUser;
                this.iabsurl = new String("http://") + _serverURL.getHost();
                if (_serverURL.getPort() != -1) {
                    this.iabsurl = this.iabsurl + ":" + Integer.toString(_serverURL.getPort());
                }
                if ((path = _serverURL.getPath()) != null && path.length() > 0) {
                    this.iabsurl = this.iabsurl + path;
                }
                this.iabsurl = this.iabsurl + new String("/wabp/");
            } else {
                this.iabsurl = new String("http://localhost/wabp/");
            }
            URLConnection conn = this.SendGetCommand(serverURL);
            String userpassword = adminUser + ":" + adminPassword;
            String base64userpassword = StringUtils.b64Encode((String)userpassword);
            conn.setRequestProperty("Authorization", "Basic " + base64userpassword);
            conn.setRequestProperty("authOnly", "true");
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node sessionidnode = attrlist.getNamedItem("sessionstring");
            sessionid = sessionidnode.getNodeValue();
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "Malformed URL (" + serverURL + "): " + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed:" + xpe.getMessage());
        }
    }

    public static WABPClientPStore getConnection(String serverURL, String user, String password) throws PStoreException {
        WABPClientPStore wcps = new WABPClientPStore(serverURL, user, password);
        return wcps;
    }

    public static WABPClientPStore getConnection(String serverURL, String adminUser, String adminPassword, String proxyUser) throws PStoreException {
        WABPClientPStore wcps = new WABPClientPStore(serverURL, adminUser, adminPassword, proxyUser);
        return wcps;
    }

    private static void writeParam(String name, String value, DataOutputStream out) throws PStoreException {
        try {
            out.writeBytes("content-disposition: form-data; name=\"" + name + "\"\r\n\r\n");
            out.writeBytes(value);
            out.writeBytes("\r\n--" + boundary + "\r\n");
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabpc failed:" + e.getMessage());
        }
    }

    private static void postxmlFile(String name, Document doc, DataOutputStream out) throws PStoreException {
        try {
            out.writeBytes("content-disposition: form-data; name=\"file\"; \r\n");
            out.writeBytes("content-type: application/xml\r\n\r\n");
            XMLDOMBuilder.dumpNode((Node)doc, (OutputStream)out);
            out.writeBytes("\r\n--" + boundary + "\r\n");
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc: failed" + xpe.getMessage());
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabpc failed:" + e.getMessage());
        }
    }

    private static void postFile(String name, InputStream in, DataOutputStream out) throws PStoreException {
        try {
            String fullString = new String();
            fullString = "content-disposition: form-data; name=\"file\"; \r\n";
            fullString = fullString + "content-type: application/octet-stream \r\n\r\n";
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String input = new String();
            while ((input = reader.readLine()) != null) {
                fullString = fullString + input + "\r\n";
            }
            out.writeBytes(fullString);
            out.writeBytes("\r\n--" + boundary + "--\r\n");
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabpc failed:" + e.getMessage());
        }
    }

    private URLConnection SetPostCommand(String url) throws MalformedURLException, IOException {
        URL servlet = new URL(url);
        URLConnection conn = servlet.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-type", "multipart/form-data; boundary=" + boundary);
        conn.setRequestProperty("Cache-Control", "no-cache");
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes("--" + boundary + "\r\n");
        return conn;
    }

    private void SendCommand(URLConnection conn) throws MalformedURLException, IOException {
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.flush();
        out.close();
    }

    private URLConnection SendGetCommand(String url) throws MalformedURLException, IOException {
        return this.SendGetCommand(url, null);
    }

    private URLConnection SendGetCommand(String url, Properties extraProps) throws MalformedURLException, IOException {
        URL servlet = new URL(url);
        URLConnection conn = servlet.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
        if (extraProps != null) {
            Set<Object> keys = extraProps.keySet();
            String[] sKeys = keys.toArray(new String[0]);
            for (int i = 0; i < sKeys.length; ++i) {
                String prop = sKeys[i];
                String propValue = (String)extraProps.get(prop);
                conn.setRequestProperty(prop, propValue);
            }
        }
        int res_code = ((HttpURLConnection)conn).getResponseCode();
        String nextUrl = conn.getHeaderField("Location");
        if (res_code == 302) {
            String cookieHeader = null;
            int i = 0;
            while (true) {
                String headerName = conn.getHeaderFieldKey(i);
                String headerValue = conn.getHeaderField(i);
                if (headerName == null && headerValue == null) break;
                if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                    int x = headerValue.indexOf(";");
                    if (x > -1) {
                        headerValue = headerValue.substring(0, x);
                    }
                    cookieHeader = cookieHeader != null ? cookieHeader + ";" + headerValue : headerValue;
                }
                ++i;
            }
            Properties props = null;
            if (cookieHeader != null) {
                props = new Properties();
                props.put("Cookie", cookieHeader);
            }
            conn = this.SendGetCommand(nextUrl, props);
        }
        return conn;
    }

    private void checkResponseError(URLConnection conn) throws PStoreException {
        try {
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node errornode = attrlist.getNamedItem("errorcode");
            String errornostr = errornode.getNodeValue();
            int errorno = Integer.parseInt(errornostr);
            if (errorno != 0) {
                Node errorstringnode = attrlist.getNamedItem("rawmsg");
                String errorstring = errorstringnode.getNodeValue();
                throw new PStoreException(errorno, new String(errorstring.substring(errorstring.indexOf(":") + 2)));
            }
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed : " + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc: failed" + xpe.getMessage());
        }
    }

    private PStoreException ThrowError(Document EntryDoc) throws PStoreException {
        Element Entryroot = EntryDoc.getDocumentElement();
        NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
        Node wabpnode = listofnodes.item(0);
        NamedNodeMap attrlist = wabpnode.getAttributes();
        Node errornode = attrlist.getNamedItem("errorcode");
        String errornostr = errornode.getNodeValue();
        int errorno = Integer.parseInt(errornostr);
        if (errorno != 0) {
            Node errorstringnode = attrlist.getNamedItem("rawmsg");
            String errorstring = errorstringnode.getNodeValue();
            return new PStoreException(errorno, new String(errorstring.substring(errorstring.indexOf(":") + 2)));
        }
        return null;
    }

    public Book[] listBooks(String bookType) throws PStoreException {
        Object listOfBook = null;
        Book[] bookArray = null;
        if (bookType == null) {
            throw new PStoreException(6, "listBooks: no bookType");
        }
        bookType = URLEncoder.encode(bookType);
        String cmdurl = this.iabsurl + new String("list_books.wabp") + sessionid + new String("?booktype=") + bookType;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            NodeList listofnodes = EntryDoc.getElementsByTagName("book");
            if (listofnodes == null) {
                return null;
            }
            int nbBooks = listofnodes.getLength();
            if (nbBooks == 0) {
                return null;
            }
            bookArray = new Book[nbBooks];
            for (int i = 0; i < nbBooks; ++i) {
                bookArray[i] = new Book((Element)listofnodes.item(i));
            }
            return bookArray;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed : " + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Book getBook(String bookEntryID) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "getBook: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        String cmdurl = this.iabsurl + new String("get_book.wabp") + sessionid + new String("?bookid=") + bookEntryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("book");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            Book result = new Book((Element)listofnodes.item(0));
            return result;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Book getDefaultBook(String bookType) throws PStoreException {
        String cmdurl = this.iabsurl + new String("get_defaultbook.wabp") + sessionid;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element EntryRoot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("book");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            Book result = new Book((Element)listofnodes.item(0));
            return result;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public String getServerTime() throws PStoreException {
        String cmdurl = this.iabsurl + new String("get_servertime.wabp");
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element EntryRoot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            return ((Element)listofnodes.item(0)).getAttribute("servertime");
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Element getUserPrefs() throws PStoreException {
        String cmdurl = this.iabsurl + new String("get_userprefs.wabp") + sessionid;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            NodeList listofnodes = EntryDoc.getElementsByTagName("profileinfo");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            return (Element)listofnodes.item(0);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public String getVersion() throws PStoreException {
        String cmdurl = this.iabsurl + new String("get_version.wabp") + sessionid;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element EntryRoot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            return ((Element)listofnodes.item(0)).getAttribute("version");
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public String addBook(Element bookElement) throws PStoreException {
        return this.addBook(bookElement, false);
    }

    public String addBook(Element bookElement, boolean orderCheck) throws PStoreException {
        String cmdurl = this.iabsurl + new String("create_book.wabp") + sessionid;
        try {
            if (bookElement == null) {
                throw new PStoreException(6, "addBook: null bookElement");
            }
            Document doc = bookElement.getOwnerDocument();
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            WABPClientPStore.postxmlFile("file", doc, out);
            this.SendCommand(conn);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node entryidnode = attrlist.getNamedItem("entryID");
            String entryid = null;
            entryid = entryidnode.getNodeValue();
            if (entryid == null) {
                return null;
            }
            return entryid;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public void modifyBook(String bookEntryID, Element bookElement) throws PStoreException {
        this.modifyBook(bookEntryID, bookElement, false);
    }

    public void modifyBook(String bookEntryID, Element bookElement, boolean orderCheck) throws PStoreException {
        String cmdurl = this.iabsurl + new String("modify_book.wabp") + sessionid;
        try {
            if (bookEntryID == null) {
                throw new PStoreException(6, "modifyBook: null bookEntryID");
            }
            bookEntryID = URLEncoder.encode(bookEntryID);
            if (bookElement == null) {
                throw new PStoreException(6, "modifyBook: null bookElement");
            }
            Document doc = bookElement.getOwnerDocument();
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (bookEntryID != null) {
                WABPClientPStore.writeParam("entryid", bookEntryID, out);
            }
            WABPClientPStore.postxmlFile("file", doc, out);
            this.SendCommand(conn);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public void deleteBook(String bookEntryID) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "deleteBook: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        String cmdurl = this.iabsurl + new String("delete_book.wabp") + sessionid + new String("?bookid=") + bookEntryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public Element search(String bookEntryId, String filter, String[] retFields, String[] entryType, String sortBy) throws PStoreException {
        int i;
        if (filter == null) {
            throw new PStoreException(6, "psearchBook: no filter");
        }
        filter = URLEncoder.encode(filter);
        if (bookEntryId == null) {
            throw new PStoreException(6, "psearchBook: no bookEntryID");
        }
        bookEntryId = URLEncoder.encode(bookEntryId);
        String cmdurl = this.iabsurl + new String("search_entry.wabp") + sessionid + new String("?bookid=") + bookEntryId + new String("&filter=") + filter + new String("&type=");
        for (i = 0; i < entryType.length; ++i) {
            if (i != 0) {
                cmdurl = cmdurl + ",";
            }
            cmdurl = cmdurl + entryType[i];
        }
        i = 0;
        if (retFields != null) {
            cmdurl = cmdurl + new String("&attrlist=");
            for (i = 0; i < retFields.length; ++i) {
                if (i != 0) {
                    cmdurl = cmdurl + ",";
                }
                cmdurl = cmdurl + URLEncoder.encode(retFields[i]);
            }
        }
        cmdurl = cmdurl + new String("&sortby=") + sortBy;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("searchresult");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            return (Element)listofnodes.item(0);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public String pagedSearch(String bookEntryId, String filter, String[] retFields, String[] entryType, String sortBy, int entriesPerPage) throws PStoreException {
        int i;
        if (filter == null) {
            throw new PStoreException(6, "psearchBook: no filter");
        }
        filter = URLEncoder.encode(filter);
        if (bookEntryId == null) {
            throw new PStoreException(6, "psearchBook: no bookEntryID");
        }
        bookEntryId = URLEncoder.encode(bookEntryId);
        if (entriesPerPage <= 0) {
            throw new PStoreException(6, "psearchBook: invalid entries per page:" + Integer.toString(entriesPerPage));
        }
        String cmdurl = this.iabsurl + new String("search_entry.wabp") + sessionid + new String("?bookid=") + bookEntryId + new String("&filter=") + filter + new String("&type=");
        for (i = 0; i < entryType.length; ++i) {
            if (i != 0) {
                cmdurl = cmdurl + ",";
            }
            cmdurl = cmdurl + entryType[i];
        }
        i = 0;
        if (retFields != null) {
            cmdurl = cmdurl + new String("&attrlist=");
            for (i = 0; i < retFields.length; ++i) {
                if (i != 0) {
                    cmdurl = cmdurl + ",";
                }
                cmdurl = cmdurl + URLEncoder.encode(retFields[i]);
            }
        }
        cmdurl = cmdurl + new String("&sortby=") + sortBy + new String("&entriesperpage=") + Integer.toString(entriesPerPage);
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node searchidnode = attrlist.getNamedItem("searchid");
            String searchid = null;
            searchid = searchidnode.getNodeValue();
            if (searchid == null) {
                return null;
            }
            return searchid;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Element getPagedSearchResult(String searchID, int firstEntry) throws PStoreException {
        if (searchID == null) {
            throw new PStoreException(6, "getResult: null searchID");
        }
        searchID = URLEncoder.encode(searchID);
        String cmdurl = this.iabsurl + new String("getresult.wabp") + sessionid + new String("?searchid=") + searchID + new String("&firstentry=") + Integer.toString(firstEntry);
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("searchresult");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            return (Element)listofnodes.item(0);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public void stopPagedSearch(String searchID) throws PStoreException {
        if (searchID == null) {
            throw new PStoreException(6, "stopSearch: null searchID");
        }
        searchID = URLEncoder.encode(searchID);
        String cmdurl = this.iabsurl + new String("stopsearch.wabp") + sessionid + new String("?searchid=") + searchID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public Entry getEntry(String bookEntryID, String entryID) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "getEntry: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        if (entryID == null) {
            throw new PStoreException(6, "getEntry: no entryID");
        }
        entryID = URLEncoder.encode(entryID);
        String cmdurl = this.iabsurl + new String("get_entry.wabp") + sessionid + new String("?bookid=") + bookEntryID + new String("&entryid=") + entryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            NodeList listofnodes = EntryDoc.getElementsByTagName("abperson");
            if (!(listofnodes != null && listofnodes.getLength() != 0 || (listofnodes = EntryDoc.getElementsByTagName("profileinfo")) != null && listofnodes.getLength() != 0 || (listofnodes = EntryDoc.getElementsByTagName("group")) != null)) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            Entry result = new Entry((Element)listofnodes.item(0));
            return result;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Entry getEntry(String entryID) throws PStoreException {
        if (entryID == null) {
            throw new PStoreException(6, "getEntry: no entryID");
        }
        entryID = URLEncoder.encode(entryID);
        String cmdurl = this.iabsurl + new String("get_entry.wabp") + sessionid + new String("?entryid=") + entryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("abperson");
            if (!(listofnodes != null && listofnodes.getLength() != 0 || (listofnodes = EntryDoc.getElementsByTagName("profileinfo")) != null && listofnodes.getLength() != 0 || (listofnodes = EntryDoc.getElementsByTagName("group")) != null)) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            Entry result = new Entry((Element)listofnodes.item(0));
            return result;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public String addEntry(String[] bookEntryIDs, Element entryElement) throws PStoreException {
        return this.addEntry(bookEntryIDs, entryElement, null, false);
    }

    public String addEntry(String[] bookEntryIDs, Element entryElement, String entry_id, boolean orderCheck) throws PStoreException {
        String cmdurl = this.iabsurl + new String("create_entry.wabp") + sessionid;
        try {
            if (entryElement == null) {
                throw new PStoreException(6, "addEntry: null entryElement");
            }
            Document doc = entryElement.getOwnerDocument();
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (bookEntryIDs == null) {
                throw new PStoreException(6, "addEntry: no bookEntryID");
            }
            String bookEntryString = StringUtils.stringArrayToString((String[])bookEntryIDs);
            WABPClientPStore.writeParam("bookid", bookEntryString, out);
            WABPClientPStore.postxmlFile("file", doc, out);
            this.SendCommand(conn);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("wabp");
            Node wabpnode = listofnodes.item(0);
            NamedNodeMap attrlist = wabpnode.getAttributes();
            Node entryidnode = attrlist.getNamedItem("entryID");
            String entryid = null;
            entryid = entryidnode.getNodeValue();
            if (entryid == null) {
                return null;
            }
            return entryid;
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public void modifyEntry(String bookEntryID, String entryID, Element modifyElt) throws PStoreException {
        this.modifyEntry(bookEntryID, entryID, modifyElt, false);
    }

    public void modifyEntry(String bookEntryID, String entryID, Element modifyElt, boolean orderCheck) throws PStoreException {
        String cmdurl = this.iabsurl + new String("modify_entry.wabp") + sessionid;
        try {
            if (entryID == null) {
                throw new PStoreException(6, "modifyEntry: no entryID");
            }
            if (bookEntryID == null) {
                throw new PStoreException(6, "modifyEntry: no bookEntryID");
            }
            if (modifyElt == null) {
                throw new PStoreException(6, "The parameter provided is invalid : modifyEntry: null  modifyElt");
            }
            Document doc = modifyElt.getOwnerDocument();
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (bookEntryID != null) {
                WABPClientPStore.writeParam("bookid", bookEntryID, out);
            }
            if (entryID != null) {
                WABPClientPStore.writeParam("entryid", entryID, out);
            }
            WABPClientPStore.postxmlFile("file", doc, out);
            this.SendCommand(conn);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public void modifyEntry(String entryID, Element modifyElt) throws PStoreException {
        this.modifyEntry(entryID, modifyElt, false);
    }

    public void modifyEntry(String entryID, Element modifyElt, boolean orderCheck) throws PStoreException {
        String cmdurl = this.iabsurl + new String("modify_entry.wabp") + sessionid;
        try {
            if (entryID == null) {
                throw new PStoreException(6, "modifyEntry: no entryID");
            }
            if (modifyElt == null) {
                throw new PStoreException(6, "The parameter provided is invalid : modifyBook: null modifyElt");
            }
            Document doc = modifyElt.getOwnerDocument();
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            WABPClientPStore.writeParam("entryid", entryID, out);
            WABPClientPStore.postxmlFile("file", doc, out);
            this.SendCommand(conn);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public void deleteEntry(String bookEntryID, String entryID) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "deleteEntry: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        if (entryID == null) {
            throw new PStoreException(6, "deleteEntry: no entryID");
        }
        entryID = URLEncoder.encode(entryID);
        String cmdurl = this.iabsurl + new String("delete_entry.wabp") + sessionid + new String("?entryid=") + entryID + new String("&bookid=") + bookEntryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public Element getProfile(String profileName) throws PStoreException {
        String cmdurl = this.iabsurl + new String("get_profile.wabp") + sessionid;
        if (profileName != null) {
            profileName = URLEncoder.encode(profileName);
            cmdurl = cmdurl + new String("?name=") + profileName;
        }
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            PStoreException pse = this.ThrowError(EntryDoc);
            if (pse != null) {
                throw pse;
            }
            Element Entryroot = EntryDoc.getDocumentElement();
            NodeList listofnodes = EntryDoc.getElementsByTagName("profileinfo");
            if (listofnodes == null) {
                return null;
            }
            if (listofnodes.getLength() == 0) {
                return null;
            }
            return (Element)listofnodes.item(0);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Element getUserProfile(String profileName, boolean reload) {
        return null;
    }

    public void modifyProfile(String profileName, Element profileElement) throws PStoreException {
        String cmdurl = this.iabsurl + new String("modify_profile.wabp") + sessionid;
        try {
            if (profileElement == null) {
                throw new PStoreException(20, "The parameter provided is invalid : modifyProfile: null ProfileElement");
            }
            Document doc = profileElement.getOwnerDocument();
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (profileName != null) {
                WABPClientPStore.writeParam("name", profileName, out);
            }
            WABPClientPStore.postxmlFile("file", doc, out);
            this.SendCommand(conn);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    public boolean addBookMember(String bookEntryID, String memberEntryID) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "addBookMember: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        if (memberEntryID == null) {
            throw new PStoreException(6, "addBookMember: no memberEntryID");
        }
        memberEntryID = URLEncoder.encode(memberEntryID);
        String cmdurl = this.iabsurl + new String("add_bookmember.wabp") + sessionid + new String("?entryid=") + memberEntryID + new String("&bookid=") + bookEntryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        return true;
    }

    public boolean removeBookMember(String bookEntryID, String memberEntryID) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "removeBookMember: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        if (memberEntryID == null) {
            throw new PStoreException(6, "removeBookMember: no memberEntryID");
        }
        memberEntryID = URLEncoder.encode(memberEntryID);
        String cmdurl = this.iabsurl + new String("remove_bookmember.wabp") + sessionid + new String("?entryid=") + memberEntryID + new String("&bookid=") + bookEntryID;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        return true;
    }

    public boolean addGroupMember(String bookEntryID, String groupEntryID, String[] memberEntryIDs) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "addGroupMember: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        if (memberEntryIDs != null) {
            for (int i = 0; i < memberEntryIDs.length; ++i) {
                memberEntryIDs[i] = URLEncoder.encode(memberEntryIDs[i]);
            }
        } else {
            throw new PStoreException(6, "addGroupMember: no memberEntryID");
        }
        if (groupEntryID == null) {
            throw new PStoreException(6, "addGroupMember: no groupEntryID");
        }
        groupEntryID = URLEncoder.encode(groupEntryID);
        String cmdurl = this.iabsurl + new String("add_groupmember.wabp") + sessionid + "?bookid=" + bookEntryID + "&groupid=" + groupEntryID;
        for (int i = 0; i < memberEntryIDs.length; ++i) {
            cmdurl = cmdurl + "&entryid=" + memberEntryIDs[i];
        }
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        return true;
    }

    public boolean removeGroupMember(String bookEntryID, String groupEntryID, String[] memberEntryIDs) throws PStoreException {
        if (bookEntryID == null) {
            throw new PStoreException(6, "removeGroupMember: no bookEntryID");
        }
        bookEntryID = URLEncoder.encode(bookEntryID);
        if (groupEntryID == null) {
            throw new PStoreException(6, "removeGroupMember: no groupEntryID");
        }
        groupEntryID = URLEncoder.encode(groupEntryID);
        if (memberEntryIDs != null) {
            for (int i = 0; i < memberEntryIDs.length; ++i) {
                memberEntryIDs[i] = URLEncoder.encode(memberEntryIDs[i]);
            }
        } else {
            throw new PStoreException(6, "removeGroupMember: no memberEntryID");
        }
        String cmdurl = this.iabsurl + new String("remove_groupmember.wabp") + sessionid + "?bookid=" + bookEntryID + "&groupid=" + groupEntryID;
        for (int i = 0; i < memberEntryIDs.length; ++i) {
            cmdurl = cmdurl + "&entryid=" + memberEntryIDs[i];
        }
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        return true;
    }

    public void importEntry(String bookEntryID, String format, InputStream inStream, Element resElt) throws PStoreException {
        String cmdurl = this.iabsurl + new String("import.wabp") + sessionid;
        try {
            URLConnection conn = this.SetPostCommand(cmdurl);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            WABPClientPStore.writeParam("bookid", bookEntryID, out);
            WABPClientPStore.writeParam("format", format, out);
            WABPClientPStore.postFile("file", inStream, out);
            this.SendCommand(conn);
            Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
            Element Entryroot = EntryDoc.getDocumentElement();
            Document resultTree = resElt.getOwnerDocument();
            _domBuilder.copyChildren((Node)Entryroot, (Node)resElt);
            _domBuilder.copyAttributes(Entryroot, resElt);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public void exportEntry(String bookId, String filter, String exportFormat, String language, OutputStream outStream) throws PStoreException {
        String cmdurl = this.iabsurl + new String("export.wabp") + sessionid + new String("?bookid=") + bookId + new String("&format=") + exportFormat;
        if (filter != null) {
            filter = URLEncoder.encode(filter);
            cmdurl = cmdurl + new String("&filter=") + filter;
        }
        if (language != null) {
            cmdurl = cmdurl + new String("&lang=") + language;
        }
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            String contenttype = conn.getContentType();
            if (contenttype.indexOf("text/xml") != -1) {
                Document EntryDoc = _domBuilder.parse(conn.getInputStream(), true);
                Element Entryroot = EntryDoc.getDocumentElement();
                PStoreException pse = this.ThrowError(EntryDoc);
                if (pse != null) {
                    throw pse;
                }
            } else {
                int inputChar;
                InputStream in = conn.getInputStream();
                int EOF = -1;
                while ((inputChar = in.read()) != EOF) {
                    outStream.write(inputChar);
                }
            }
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed : " + ioe.getMessage());
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(20, "wabpc failed :" + xpe.getMessage());
        }
    }

    public Element expandGroup(String bookEntryID, String entryID, String[] entryType, String sortBy, String noExpandOnXPath) throws PStoreException {
        Element value = null;
        return value;
    }

    public int getEntriesCount() {
        return 0;
    }

    public void disconnect() throws PStoreException {
        String cmdurl = this.iabsurl + new String("logout.wabp") + sessionid;
        try {
            URLConnection conn = this.SendGetCommand(cmdurl);
            this.checkResponseError(conn);
        }
        catch (MalformedURLException mfe) {
            throw new PStoreException(20, "wabpc failed :" + mfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "wabpc failed :" + ioe.getMessage());
        }
    }

    static {
        _domBuilder = null;
    }
}

