/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupMembersHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null XML Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null pStore");
            return;
        }
        String sEntryID = request.getParameter("entryid");
        if (sEntryID == null || sEntryID.length() == 0) {
            this._logHandler.error("GroupMembershipHandler.expand: no entryID");
            xmlElt.setAttribute("error", "Error: No entryID provided");
            return;
        }
        String sBookID = request.getParameter("bookid");
        if (sBookID == null || sBookID.length() == 0) {
            String bookType = request.getParameter("booktype");
            if (!(bookType != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
                bookType = "abook";
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                this._logHandler.error("GroupMembershipHandler.expand: listBooks returned: " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
            if (defaultBook == null) {
                this._logHandler.error("GroupMembershipHandler.expand: null defaultBook");
                return;
            }
            sBookID = defaultBook.getEntryID();
        }
        Book curBook = null;
        try {
            curBook = pStore.getBook(sBookID);
        }
        catch (PStoreException pe) {
            this._logHandler.error("GroupMembershipHandler.expand: getBook returned: " + pe.getReason() + " : " + pe.getMessage());
            return;
        }
        if (curBook == null) {
            this._logHandler.error("GroupMembershipHandler.expand: curBook is null!");
            xmlElt.setAttribute("error", "Error: Current Book is null");
            return;
        }
        String baseURL = null;
        baseURL = curBook.getBookRemoteURL();
        String sortBy = xmlElt.getAttribute("sortby");
        if (sortBy == null || sortBy.length() == 0) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = xmlElt.getAttribute("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        try {
            if (baseURL != null) {
                Entry groupEntry = pStore.getEntry(sBookID, sEntryID);
                pStore.expandGroup(sBookID, groupEntry.getEntryElement(), null, entryType, sortBy, xmlElt);
            } else {
                pStore.searchBook("*", "memberofgroup=" + sEntryID, null, entryType, sortBy, xmlElt);
            }
        }
        catch (PStoreException pe) {
            this._logHandler.error("GroupMembersHandler.expand: searchBook returned: " + pe.getReason() + " : " + pe.getMessage());
            xmlElt.setAttribute("error", "Error " + pe.getReason() + " : " + pe.getMessage());
            return;
        }
    }
}

