/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.FormHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeleteBookFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("DeleteBookFormHandler.Process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("DeleteBookFormHandler.Process: null Error Doc");
            return false;
        }
        String sEntryID = request.getParameter("entryid");
        if (sEntryID == null || sEntryID.length() == 0) {
            Element errorElt = null;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
            if (sEntryID == null || sEntryID.length() == 0) {
                this._logHandler.error("DeleteBookFormHandler.Process: HTML field entryid is missing or invalid: " + sEntryID);
                Element paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "entryid");
                errorElt.appendChild(paramElt);
            }
            errorRootElt.appendChild(errorElt);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("DeleteBookFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("DeleteBookFormHandler.process: null pStore");
            return false;
        }
        try {
            Book book = pStore.getBook(sEntryID);
            String sBookName = book.getDisplayName();
            pStore.deleteBook(sEntryID);
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "0");
            errorElt.setAttribute("errnum", "10");
            errorElt.setAttribute("displayname", sBookName);
            errorElt.setAttribute("entryid", sEntryID);
            errorRootElt.appendChild(errorElt);
            return true;
        }
        catch (PStoreException pse) {
            this._logHandler.error("DeleteBookFormHandler.Process : Can not delete address book: " + pse.getMessage());
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            switch (pse.getReason()) {
                case 4: {
                    errorElt.setAttribute("errnum", "276");
                    break;
                }
                case 8: {
                    errorElt.setAttribute("errnum", "275");
                    break;
                }
                default: {
                    errorElt.setAttribute("errnum", "274");
                }
            }
            errorElt.setAttribute("rawmsg", "DeleteBookFormHandler.Process : Can not delete address book: " + pse.getMessage());
            errorRootElt.appendChild(errorElt);
            return false;
        }
    }
}

