/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BookListHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("BookListHandler.expand: null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("BookListHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("BookListHandler.expand: null XML Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("BookListHandler.expand: null pStore");
            return;
        }
        String bookType = request.getParameter("booktype");
        if (!(bookType != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
            bookType = "abook";
        }
        Book[] bookArray = null;
        try {
            bookArray = pStore.listBooks(bookType);
        }
        catch (PStoreException pe) {
            this._logHandler.error("BookListHandler: listBooks returned: " + pe.getReason() + " : " + pe.getMessage());
            return;
        }
        try {
            Node childNode = null;
            for (int i = 0; i < bookArray.length; ++i) {
                Book currentBook = bookArray[i];
                childNode = this._domBuilder.copyNode((Node)currentBook.getEntryElement(), xmlDoc);
                xmlElt.appendChild(childNode);
            }
        }
        catch (XMLProcessingException xpe) {
            this._logHandler.error("IabablistHandler: Error while copying: " + xpe.getMessage());
            return;
        }
    }
}

