/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BookEntryHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        String sEntryID;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("BookEntryHandler.expand: null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("BookEntryHandler.expand: null XML Element");
            return;
        }
        if (errorRootElt == null) {
            this._logHandler.error("BookEntryHandler.expand: null Error Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("BookEntryHandler.expand: null XML Doc");
            return;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("BookEntryHandler.expand: null Error Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("BookEntryHandler.expand: null pStore");
            return;
        }
        boolean bIsLocal = false;
        String sIsLocal = xmlElt.getAttribute("islocal");
        bIsLocal = sIsLocal != null && sIsLocal.length() == 1 && sIsLocal.equals("1");
        String sBookID = request.getParameter("bookid");
        if (sBookID == null || sBookID.length() == 0) {
            String bookType = request.getParameter("booktype");
            if (!(bookType != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
                bookType = "abook";
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                this._logHandler.error("BookEntryHandler: listBooks returned: " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
            if (defaultBook == null) {
                this._logHandler.error("BookEntryHandler: null defaultBook");
                return;
            }
            sBookID = defaultBook.getEntryID();
        }
        if ((sEntryID = request.getParameter("entryid")) == null || sEntryID.length() == 0) {
            this._logHandler.error("BookEntryHandler.expand: no entryID");
            return;
        }
        try {
            Entry entry = null;
            entry = bIsLocal ? pStore.getEntry(sEntryID, xmlElt) : pStore.getEntry(sBookID, sEntryID, xmlElt);
        }
        catch (PStoreException pe) {
            this._logHandler.error("BookEntryHandler.expand: getEntry returned: " + pe.getReason() + ": " + pe.getMessage());
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "270");
            errorElt.setAttribute("rawmsg", "BookEntryHandler.expand: getEntry returned: " + pe.getReason() + ": " + pe.getMessage());
            errorElt.setAttribute("entryid", sEntryID);
            errorElt.setAttribute("bookid", sBookID);
            errorRootElt.appendChild(errorElt);
            return;
        }
    }
}

