/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.FormHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddGroupMembersFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("AddGroupFormHandler.Process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("AddGroupFormHandler.Process: null Error Doc");
            return false;
        }
        Object fte = null;
        String sBookID = request.getParameter("bookid");
        String sEntryID = request.getParameter("entryid");
        String sIdsToAdd = request.getParameter("idstoadd");
        if (sEntryID == null || sEntryID.length() == 0 || sBookID == null || sBookID.length() == 0 || sIdsToAdd == null) {
            Element paramElt;
            Element errorElt = null;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
            if (sEntryID == null || sEntryID.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field entryid is missing or invalid: " + sEntryID);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "entryid");
                errorElt.appendChild(paramElt);
            }
            if (sBookID == null || sBookID.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field bookid is missing or invalid: " + sBookID);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "bookid");
                errorElt.appendChild(paramElt);
            }
            if (sIdsToAdd == null) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field idstoadd is missing: " + sIdsToAdd);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "idstoadd");
                errorElt.appendChild(paramElt);
            }
            errorRootElt.appendChild(errorElt);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("AddGroupMembersFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("AddGroupMembersFormHandler.process: null pStore");
            return false;
        }
        String delim = request.getParameter("valueseparator");
        Object sCurID = null;
        if (delim == null || delim.length() == 0) {
            delim = ";";
        }
        String[] idsToAdd = sIdsToAdd.split(delim);
        try {
            Entry eEntry = pStore.getEntry(sBookID, sEntryID);
            this._logHandler.debug("AddGroupMembersFormHandler.Process : Calling addGroupMember('" + sBookID + "','" + sEntryID + "'");
            pStore.addGroupMember(sBookID, sEntryID, idsToAdd);
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "0");
            errorElt.setAttribute("errnum", "4");
            errorElt.setAttribute("displayname", eEntry.getDisplayName());
            errorElt.setAttribute("bookid", sBookID);
            errorRootElt.appendChild(errorElt);
            return true;
        }
        catch (PStoreException pse) {
            this._logHandler.error("AddGroupMembersFormHandler.Process: Add member to group failed: " + pse.getMessage() + ": error " + pse.getReason());
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            switch (pse.getReason()) {
                case 11: {
                    errorElt.setAttribute("errnum", "268");
                    try {
                        errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                    }
                    catch (PStoreException e) {}
                    break;
                }
                case 13: {
                    errorElt.setAttribute("errnum", "269");
                    try {
                        errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                    }
                    catch (PStoreException e) {}
                    break;
                }
                default: {
                    errorElt.setAttribute("errnum", "266");
                }
            }
            errorElt.setAttribute("rawmsg", "AddGroupMembersFormHandler.Process: Can not add member(s) to group : " + pse.getMessage());
            errorRootElt.appendChild(errorElt);
            return false;
        }
    }
}

