/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddGroupFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("AddGroupFormHandler.Process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("AddGroupFormHandler.Process: null Error Doc");
            return false;
        }
        FormTranslatableEntry fte = null;
        String sEntryID = null;
        String sPrefix = request.getParameter("prefix");
        String sBookID = request.getParameter("bookid");
        String sIdsToAdd = request.getParameter("idstoadd");
        if (sPrefix == null || sPrefix.length() == 0 || sBookID == null || sBookID.length() == 0 || sIdsToAdd == null) {
            Element paramElt;
            Element errorElt = null;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
            if (sPrefix == null || sPrefix.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field prefix is missing or invalid: " + sPrefix);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "prefix");
                errorElt.appendChild(paramElt);
            }
            if (sBookID == null || sBookID.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field bookid is missing or invalid: " + sBookID);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "bookid");
                errorElt.appendChild(paramElt);
            }
            if (sIdsToAdd == null) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field idstoadd is missing: " + sIdsToAdd);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "idstoadd");
                errorElt.appendChild(paramElt);
            }
            errorRootElt.appendChild(errorElt);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("AddGroupFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("AddGroupFormHandler.process: null pStore");
            return false;
        }
        String dn = null;
        if (sPrefix != null && !sPrefix.equals("")) {
            try {
                fte = new FormTranslatableEntry((ServletRequest)request, sPrefix);
                if (fte == null) {
                    this._logHandler.error("AddGroupFormHandler.Process: Can not create the FormTranslatableEntry");
                    return false;
                }
                Element elt = this._dbTranslation.translate((DbTranslatable)fte);
                if (elt == null) {
                    this._logHandler.error("AddGroupFormHandler.Process: Element is null");
                    return false;
                }
                String[] bookIDs = XPathTools.getValuesByXPath((Node)elt, (String)"memberofbook");
                dn = XPathTools.getValueByXPath((Node)elt, (String)"entry/displayname");
                if (dn == null || dn.length() == 0) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "129");
                    Element fieldElt = errorDoc.createElement("field");
                    fieldElt.setAttribute("elementname", "displayname");
                    errorElt.appendChild(fieldElt);
                    errorRootElt.appendChild(errorElt);
                    return false;
                }
                sEntryID = pStore.addEntry(bookIDs, elt);
                if (sEntryID == null || sEntryID.length() <= 0) {
                    this._logHandler.error("AddGroupFormHandler.Process: Add group failed");
                    return false;
                }
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "0");
                errorElt.setAttribute("errnum", "2");
                errorElt.setAttribute("bookid", sBookID);
                errorElt.setAttribute("displayname", dn);
                errorRootElt.appendChild(errorElt);
            }
            catch (PStoreException pse) {
                this._logHandler.error("AddGroupFormHandler.Process: Can not add group : " + pse.getMessage());
                if (pse.getReason() == 17) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "133");
                    errorElt.setAttribute("rawmsg", pse.getMessage());
                    errorRootElt.appendChild(errorElt);
                } else {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "256");
                    if (dn != null) {
                        errorElt.setAttribute("displayname", dn);
                    }
                    errorElt.setAttribute("rawmsg", "AddGroupFormHandler.Process: Can not add group : " + pse.getMessage());
                    errorRootElt.appendChild(errorElt);
                }
                return false;
            }
            catch (XSLProcessingException xpe) {
                this._logHandler.error("AddGroupFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorElt.setAttribute("rawmsg", "AddGroupFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (DbTransException dbe) {
                this._logHandler.error("AddGroupFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorElt.setAttribute("rawmsg", "AddGroupFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
        } else {
            this._logHandler.error("AddGroupFormHandler.Process: Incorrect value for prefix : " + sPrefix);
            return false;
        }
        String delim = request.getParameter("valueseparator");
        if (delim == null || delim.length() == 0) {
            delim = ";";
        }
        String[] idsToAdd = sIdsToAdd.split(delim);
        try {
            this._logHandler.debug("AddGroupFormHandler.Process : Calling addGroupMember('" + sBookID + "','" + sEntryID + "')");
            pStore.addGroupMember(sBookID, sEntryID, idsToAdd);
        }
        catch (PStoreException pse) {
            this._logHandler.error("AddGroupFormHandler.Process: Add member to group failed: " + pse.getMessage() + ": error " + pse.getReason() + ". Last processed entry: " + sEntryID);
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            switch (pse.getReason()) {
                case 11: {
                    errorElt.setAttribute("errnum", "268");
                    try {
                        errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                    }
                    catch (PStoreException e) {}
                    break;
                }
                case 13: {
                    errorElt.setAttribute("errnum", "269");
                    try {
                        errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                    }
                    catch (PStoreException e) {}
                    break;
                }
                default: {
                    errorElt.setAttribute("errnum", "266");
                }
            }
        }
        return true;
    }
}

