/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddEntryFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("AddEntryFormHandler.Process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("AddEntryFormHandler.Process: null Error Doc");
            return false;
        }
        FormTranslatableEntry fte = null;
        String sPrefix = request.getParameter("prefix");
        this._logHandler.debug("AddEntryFormHandler.Process : sPrefix = " + sPrefix);
        if (sPrefix == null || sPrefix.length() == 0) {
            Element errorElt = null;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
            this._logHandler.error("AddEntryFormHandler.Process: HTML field prefix is missing or invalid: " + sPrefix);
            Element paramElt = errorDoc.createElement("parameter");
            paramElt.setAttribute("paramname", "prefix");
            errorElt.appendChild(paramElt);
            errorRootElt.appendChild(errorElt);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("AddEntryFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("AddEntryFormHandler.process: null pStore");
            return false;
        }
        if (sPrefix != null && !sPrefix.equals("")) {
            String dn = null;
            try {
                fte = new FormTranslatableEntry((ServletRequest)request, sPrefix);
                if (fte == null) {
                    this._logHandler.error("AddEntryFormHandler.Process: Can not create the FormTranslatableEntry");
                    return false;
                }
                Element elt = this._dbTranslation.translate((DbTranslatable)fte);
                if (elt == null) {
                    this._logHandler.error("AddEntryFormHandler.Process : Element is null");
                    return false;
                }
                String[] bookIDs = XPathTools.getValuesByXPath((Node)elt, (String)"memberofbook");
                if (bookIDs == null || bookIDs.length == 0) {
                    String sBookID = request.getParameter("actionbookid");
                    if (sBookID == null || sBookID.length() == 0) {
                        sBookID = request.getParameter("bookid");
                    }
                    if (sBookID == null || sBookID.length() == 0) {
                        Element errorElt = errorDoc.createElement("error");
                        errorElt.setAttribute("errtype", "2");
                        errorElt.setAttribute("errnum", "129");
                        Element fieldElt = errorDoc.createElement("field");
                        fieldElt.setAttribute("elementname", "memberofbook");
                        errorElt.appendChild(fieldElt);
                        errorRootElt.appendChild(errorElt);
                        return false;
                    }
                    bookIDs = new String[]{sBookID};
                }
                if ((dn = XPathTools.getValueByXPath((Node)elt, (String)"entry/displayname")) == null || dn.length() == 0) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "129");
                    Element fieldElt = errorDoc.createElement("field");
                    fieldElt.setAttribute("elementname", "displayname");
                    errorElt.appendChild(fieldElt);
                    errorRootElt.appendChild(errorElt);
                    return false;
                }
                String sEntryID = pStore.addEntry(bookIDs, elt);
                this._logHandler.debug("AddEntryFormHandler.Process: sEntryID = " + sEntryID);
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "0");
                errorElt.setAttribute("errnum", "3");
                errorElt.setAttribute("elementname", elt.getTagName());
                errorElt.setAttribute("displayname", dn);
                errorElt.setAttribute("bookid", bookIDs[0]);
                String allBooks = pStore.getBook(bookIDs[0]).getDisplayName();
                for (int k = 1; k < bookIDs.length; ++k) {
                    allBooks = allBooks + ", " + pStore.getBook(bookIDs[k]).getDisplayName();
                }
                errorElt.setAttribute("booksdisplaynames", allBooks);
                errorRootElt.appendChild(errorElt);
                return true;
            }
            catch (PStoreException pse) {
                this._logHandler.error("AddEntryFormHandler.Process: Can not add entry: " + pse.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                if (pse.getReason() == 17) {
                    errorElt.setAttribute("errnum", "133");
                } else if (pse.getReason() == 19) {
                    errorElt.setAttribute("errnum", "287");
                } else {
                    errorElt.setAttribute("errnum", "262");
                }
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorElt.setAttribute("rawmsg", pse.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (XSLProcessingException xpe) {
                this._logHandler.error("AddEntryFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorElt.setAttribute("rawmsg", "AddEntryFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (DbTransException dbe) {
                this._logHandler.error("AddEntryFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorElt.setAttribute("rawmsg", "AddEntryFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (NullPointerException npe) {
                this._logHandler.debug("AddEntryFormHandler.Process: Null displayname " + npe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "AddEntryFormHandler.Process: Null displayname " + npe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
        }
        this._logHandler.error("AddEntryFormHandler.Process: Incorrect value for prefix: " + sPrefix);
        return false;
    }
}

