/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddBookFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        FormTranslatableEntry fte = null;
        String sPrefix = request.getParameter("prefix");
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("AddBookFormHandler.process: null session");
            return false;
        }
        if (errorRootElt == null) {
            this._logHandler.error("AddBookFormHandler.process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("AddBookFormHandler.process: null Error Doc");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("AddBookFormHandler.process: null pStore");
            return false;
        }
        if (sPrefix != null && !sPrefix.equals("")) {
            try {
                fte = new FormTranslatableEntry((ServletRequest)request, sPrefix);
                if (fte == null) {
                    this._logHandler.error("AddBookFormHandler.Process: Can not create the FormTranslatableEntry");
                    return false;
                }
                Element elt = this._dbTranslation.translate((DbTranslatable)fte);
                if (elt == null) {
                    this._logHandler.error("AddBookFormHandler.Process: dbTranslation rendered null");
                    return false;
                }
                String dn = XPathTools.getValueByXPath((Node)elt, (String)"entry/displayname");
                if (dn == null || dn.length() == 0) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "129");
                    Element fieldElt = errorDoc.createElement("field");
                    fieldElt.setAttribute("elementname", "displayname");
                    errorElt.appendChild(fieldElt);
                    errorRootElt.appendChild(errorElt);
                    return false;
                }
                String sEntryID = pStore.addBook(elt);
                Book eBook = pStore.getBook(sEntryID);
                this._logHandler.debug("AddBookFormHandler.Process: sEntryID = " + sEntryID);
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "0");
                errorElt.setAttribute("errnum", "1");
                errorElt.setAttribute("displayname", eBook.getDisplayName());
                errorRootElt.appendChild(errorElt);
                return true;
            }
            catch (PStoreException pse) {
                this._logHandler.error(((Object)((Object)this)).getClass().toString() + ".Process: Can not add entry: " + pse.getMessage());
                if (pse.getReason() == 17) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "133");
                    errorElt.setAttribute("rawmsg", pse.getMessage());
                    errorRootElt.appendChild(errorElt);
                } else {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "260");
                    errorElt.setAttribute("rawmsg", "AddBookFormHandler.Process: Can not add entry: " + pse.getMessage());
                    errorRootElt.appendChild(errorElt);
                }
                return false;
            }
            catch (XSLProcessingException xpe) {
                this._logHandler.error("AddBookFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "AddBookFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (DbTransException dbe) {
                this._logHandler.error("AddBookFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "AddBookFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                errorRootElt.appendChild(errorElt);
                return false;
            }
        }
        this._logHandler.error("AddBookFormHandler.Process: Incorrect value for prefix : " + sPrefix);
        return false;
    }
}

