/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import com.iplanet.iabs.importexport.propertyRecord;
import com.iplanet.iabs.importexport.vCardParser;
import com.iplanet.xslui.tools.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class vCard2_1Parser
implements vCardParser {
    private BufferedReader _br = null;
    private Vector _vcardFormatVector;
    private Vector _vcardRec;
    private int _curRecord = 0;
    private String _lastImported = null;
    private int _lastImportedCount = 0;
    private boolean _brokenRecord = false;
    private String SEMICOLON = ";";
    private String COLON = ":";
    private String NEWLINE = "\n";
    private String SPACE = " ";

    public void vCard2_1Parser() {
    }

    public void init(InputStream in, String encoding) throws IOException {
        Properties p = null;
        String vCardConversion = "\nBEGIN:VCARD, \nVERSION:2.1, \nN:db:surName;db:givenName;db:middleName, \nNICKNAME:db:nickName, \nFN:db:displayName, \nBDAY:db:dateOfBirth, \nANNIVERSARYDATE:db:anniversary, \nORG:db:company;db:orgUnit, \nTITLE:db:jobTitle, \nTEL;WORK;VOICE:db:telWork, \nTEL;HOME;VOICE:db:telHome,  \nTEL;CELL;VOICE:db:telMobile, \nTEL;PAGER;VOICE:db:telPager, \nTEL;WORK;FAX:db:telFax, \nEMAIL;PREF;INTERNET:db:email1, \nEMAIL;INTERNET;PREF1:db:email2, \nEMAIL;INTERNET;PREF2:db:email3, \nADR;WORK:;db:workPostalAddress;db:workCity;db:workState;db:workPostalCode;db:workCountry  , \nADR;HOME:;db:homePostalAddress;db:homeCity;db:homeState;db:homePostalCode;db:homeCountry, \nNOTE:db:Notes, \nURL;HOME:db:urlh, \nURL;WORK:db:urlw, \nCALURI:db:inetcalendar, \nFBURL:db:inetfreebusy, :\nEND:VCARD";
        p = new Properties();
        p.setProperty("vCard2_1FormatLineTokenizer", ",");
        p.setProperty("vCard2_1Format", vCardConversion);
        String _vcardFormatLineTokenizer = p.getProperty("vCard2_1FormatLineTokenizer");
        String _vcardFormat = p.getProperty("vCard2_1Format");
        this._vcardFormatVector = new Vector();
        StringTokenizer st = new StringTokenizer(_vcardFormat, _vcardFormatLineTokenizer);
        while (st.hasMoreTokens()) {
            this._vcardFormatVector.add(st.nextToken());
        }
        if (in == null) {
            throw new IOException("Empty vCard inputstream !");
        }
        try {
            this._br = new BufferedReader(new InputStreamReader(in, encoding));
        }
        catch (IOException xe) {
            throw new IOException("Couldn't read vCard input stream " + xe);
        }
    }

    public Map getNextMap(Hashtable hTable) throws IOException {
        Hashtable map = new Hashtable(hTable);
        boolean flag = this.readNextRecord();
        if (!flag) {
            try {
                this._br.close();
            }
            catch (IOException e) {
                throw new IOException("Unable to close buffered reader " + e.toString());
            }
            return null;
        }
        for (int i = 0; i < this._vcardRec.size(); ++i) {
            String str = this._vcardRec.get(i).toString();
            this.parseLine(str, map);
        }
        return map;
    }

    private void parseLine(String line, Map map) throws IOException {
        boolean allPropMustMatch = false;
        boolean allPropMatch = false;
        propertyRecord pr = new propertyRecord(line, this.SEMICOLON, this.COLON);
        String property = pr.getPropertyName();
        if (property.startsWith("ADR") || property.startsWith("adr")) {
            boolean defaultFlag = false;
            for (int z = 0; z < pr.propertyParameterVectorSize(); ++z) {
                String t1 = pr.getPropertyParameter(z);
                if (!t1.equals("HOME") && !t1.equals("WORK")) continue;
                defaultFlag = true;
            }
            if (!defaultFlag) {
                pr.setNextPropertyParameter("HOME");
            }
        }
        if (property.startsWith("TEL")) {
            boolean flag = false;
            for (int z1 = 0; z1 < pr.propertyParameterVectorSize(); ++z1) {
                String t2 = pr.getPropertyParameter(z1);
                if (!t2.equals("HOME") && !t2.equals("WORK") && !t2.equals("FAX") && !t2.equals("PAGER") && !t2.equals("MOBILE") && !t2.equals("CELL")) continue;
                flag = true;
            }
            if (!flag) {
                pr.setNextPropertyParameter("HOME");
            }
        }
        if (property.startsWith("X-")) {
            String vCardConversion = new String();
            vCardConversion = vCardConversion + "\n";
            vCardConversion = vCardConversion + property;
            vCardConversion = vCardConversion + ":db:";
            vCardConversion = vCardConversion + property;
            this._vcardFormatVector.add(vCardConversion);
        }
        for (int i = 0; i < this._vcardFormatVector.size(); ++i) {
            String str = this._vcardFormatVector.get(i).toString();
            propertyRecord formatRecord = new propertyRecord(str, this.SEMICOLON, this.COLON);
            if (formatRecord.propertyValueVectorSize() == 0 || !formatRecord.getPropertyName().equalsIgnoreCase(pr.getPropertyName())) continue;
            for (int j = 0; j < formatRecord.propertyValueVectorSize(); ++j) {
                if (formatRecord.getPropertyValue(j) == null || pr.getPropertyValue(j) == null) continue;
                String val = formatRecord.getPropertyValue(j);
                int idx = 0;
                idx = val.indexOf("db:");
                if (idx == -1) continue;
                int len = val.length();
                val = val.substring(idx + 3, len);
                formatRecord.resetPropertyValue(j, val);
                if (formatRecord.getPropertyName().equals("TEL") || formatRecord.getPropertyName().equalsIgnoreCase("ADR") || formatRecord.getPropertyName().equals("URL") || formatRecord.getPropertyName().equals("EMAIL")) {
                    block4: for (int l = 0; l < formatRecord.propertyParameterVectorSize(); ++l) {
                        int m;
                        String type = formatRecord.getPropertyParameter(l);
                        String propName = formatRecord.getPropertyName();
                        if (propName.equals("ADR") && !type.equals("HOME") && !type.equals("WORK")) continue;
                        if (propName.equals("EMAIL") || propName.equals("TEL")) {
                            allPropMustMatch = true;
                        }
                        if (formatRecord.propertyParameterVectorSize() != pr.propertyParameterVectorSize() && allPropMustMatch) {
                            allPropMustMatch = false;
                            allPropMatch = false;
                            break;
                        }
                        if (!allPropMustMatch) {
                            for (m = 0; m < pr.propertyParameterVectorSize(); ++m) {
                                if (!pr.getPropertyParameter(m).equals(type)) continue;
                                String decoded_val = this.decode(pr.getPropertyValue(j), this.getCharset(pr), this.getTransferEncoding(pr));
                                decoded_val = StringUtils.replaceSubstring((String)decoded_val, (String)"\r", (String)"");
                                map.put(formatRecord.getPropertyValue(j), decoded_val);
                                continue block4;
                            }
                            continue;
                        }
                        for (m = 0; m < pr.propertyParameterVectorSize(); ++m) {
                            if (pr.getPropertyParameter(m).equals(type)) {
                                allPropMatch = true;
                                break;
                            }
                            allPropMatch = false;
                        }
                        if (!allPropMatch) break;
                    }
                    if (allPropMustMatch && allPropMatch) {
                        String decoded_val = this.decode(pr.getPropertyValue(j), this.getCharset(pr), this.getTransferEncoding(pr));
                        decoded_val = StringUtils.replaceSubstring((String)decoded_val, (String)"\r", (String)"");
                        map.put(formatRecord.getPropertyValue(j), decoded_val);
                    }
                    allPropMustMatch = false;
                    allPropMatch = false;
                    continue;
                }
                String decoded_val = this.decode(pr.getPropertyValue(j), this.getCharset(pr), this.getTransferEncoding(pr));
                decoded_val = StringUtils.replaceSubstring((String)decoded_val, (String)"\r", (String)"");
                map.put(formatRecord.getPropertyValue(j), decoded_val);
            }
        }
    }

    private String decode(String value, String charset_encoding, String transfer_encoding) throws IOException {
        InputStreamReader isr = null;
        String decoded_value = "";
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(value.getBytes(charset_encoding));
            isr = new InputStreamReader((InputStream)bis, charset_encoding);
            int i = 0;
            while ((i = isr.read()) != -1) {
                char ch = (char)i;
                decoded_value = decoded_value + ch;
            }
            isr.close();
            return decoded_value;
        }
        catch (Exception e) {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw new IOException("Unable to decode Inputstream " + e);
        }
    }

    private String getTransferEncoding(propertyRecord pr) {
        String transfer_encoding = "uuencode";
        for (int x = 0; x < pr.propertyParameterVectorSize(); ++x) {
            String param = pr.getPropertyParameter(x);
            if (param.indexOf("QUOTED-PRINTABLE") != -1) {
                return "QUOTED-PRINTABLE";
            }
            if (param.indexOf("BASE64") == -1) continue;
            return "BASE64";
        }
        return transfer_encoding;
    }

    private String getCharset(propertyRecord pr) {
        String charset_encoding = "UTF-8";
        for (int x = 0; x < pr.propertyParameterVectorSize(); ++x) {
            String param = pr.getPropertyParameter(x);
            int idx = 0;
            idx = param.indexOf("CHARSET=");
            if (idx != -1) {
                return param.substring(idx + 1);
            }
            idx = 0;
            idx = param.indexOf("ISO-8859");
            if (idx == -1) continue;
            return param.substring(idx + 1);
        }
        return charset_encoding;
    }

    private String convertQuotedPrintableToText(String str) {
        String temp = str;
        int idx = 0;
        while ((idx = temp.indexOf("=0D=0A=")) != -1) {
            String temp1 = temp.substring(0, idx);
            String temp2 = temp.substring(idx + 7, temp.length());
            temp = temp1 + "\n" + temp2;
        }
        int i = 0;
        while ((i = temp.indexOf("=0D=0A")) != -1) {
            String temp1 = temp.substring(0, i);
            String temp2 = temp.substring(i + 6, temp.length());
            temp = temp1 + "\n" + temp2;
        }
        int id = 0;
        while ((id = temp.indexOf("=3B")) != -1) {
            String temp1 = temp.substring(0, id);
            String temp2 = temp.substring(id + 3, temp.length());
            temp = temp1 + ";" + temp2;
        }
        return temp;
    }

    boolean readNextRecord() throws IOException {
        this._vcardRec = new Vector();
        ++this._curRecord;
        String line = null;
        String prevLine = null;
        int loopCount = 0;
        while ((line = this._br.readLine()) != null) {
            if (line.trim().equals(this.NEWLINE) || line.trim().equals("")) continue;
            if (!this._brokenRecord) {
                if (loopCount++ == 0) {
                    if (this.isHeader(line)) continue;
                    this._brokenRecord = true;
                    while ((line = this._br.readLine()) != null && !this.isHeader(line)) {
                    }
                    throw new IOException("Record does not start with Header.. ");
                }
                if (this.isHeader(line)) {
                    this._brokenRecord = true;
                    throw new IOException("Can not have next Header line without a proper footer line.. ");
                }
            }
            if (this.isFooter(line)) break;
            if (prevLine != null) {
                if (line.startsWith(this.SPACE)) {
                    this._vcardRec.add(prevLine + this.SPACE + line.trim());
                    prevLine = null;
                    continue;
                }
                this._vcardRec.add(prevLine);
                prevLine = line;
                continue;
            }
            prevLine = line;
        }
        if (prevLine != null) {
            this._vcardRec.add(prevLine);
        }
        this._brokenRecord = false;
        return this._vcardRec.size() > 0;
    }

    private boolean isHeader(String line) {
        if (line != null) {
            String temp = line.trim().toUpperCase();
            if (temp.length() < 11) {
                return false;
            }
            String mid = temp.substring(5, temp.length() - 5);
            mid = mid.trim();
            return temp.startsWith("BEGIN") && temp.endsWith("VCARD") && mid.equals(":");
        }
        return false;
    }

    private boolean isFooter(String line) {
        if (line != null) {
            String temp = line.trim().toUpperCase();
            if (temp.length() < 9) {
                return false;
            }
            String mid = temp.substring(3, temp.length() - 5);
            mid = mid.trim();
            return temp.startsWith("END") && temp.endsWith("VCARD") && mid.equals(":");
        }
        return false;
    }

    private Map unitTestmethod() {
        ++this._curRecord;
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("displayName", "testname");
        map.put("givenName", "testgivenname");
        map.put("surName", "testsurnname");
        map.put("middleName", "testMidnname");
        map.put("nickName", "testnickname");
        map.put("dateOfBirth", "01022000");
        map.put("company", "testcompany");
        map.put("orgUnit", "testorgunit");
        map.put("jobTitle", "tester");
        map.put("url1", "www.testurl.com");
        map.put("email1", "test@email.com");
        map.put("Notes", "testnotes");
        map.put("workPostalAddress", "teststreet");
        map.put("workCity", "testcity");
        map.put("workPostalCode", "30000");
        map.put("workState", "teststate");
        map.put("workCountry", "testcountry");
        map.put("homePostalAddress", "testaddress");
        map.put("homeCity", "testcity");
        map.put("homePostalCode", "20000");
        map.put("homeState", "teststate");
        map.put("homeCountry", "testcountry");
        map.put("telHome", "111111111");
        map.put("telWork", "222222222");
        map.put("telMobile", "333333333");
        map.put("telPager", "444444444");
        map.put("telFax", "555555555");
        if (this._curRecord == 1) {
            return map;
        }
        return null;
    }
}

