/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class propertyRecord {
    private String propertyName;
    private Vector propertyParameter;
    private Vector propertyValue;
    private String firstDelimiter = ";";
    private String secondDelimiter = ":";

    public propertyRecord(String line) throws IOException {
        this.init(line);
    }

    public propertyRecord(String line, String FirstD, String SecondD) throws IOException {
        this.firstDelimiter = FirstD;
        this.secondDelimiter = SecondD;
        this.init(line);
    }

    public void init(String line) throws IOException {
        this.propertyParameter = new Vector();
        this.propertyValue = new Vector();
        this.parseLine(line);
    }

    public void setPropertyName(String str) {
        this.propertyName = str;
    }

    public void setNextPropertyValue(String str) {
        this.propertyValue.add(str.trim());
    }

    public void setNextPropertyParameter(String str) {
        str = str.trim();
        if (!this.propertyParameter.contains(str = str.toUpperCase())) {
            this.propertyParameter.add(str);
        }
    }

    public boolean containsPropertyParameter(String str) {
        str = str.trim();
        return this.propertyParameter.contains(str = str.toUpperCase());
    }

    public void resetPropertyValue(int index, String str) {
        if (index < this.propertyValue.size()) {
            this.propertyValue.removeElementAt(index);
            this.propertyValue.add(index, str);
        }
    }

    public void resetPropertyParameter(int index, String str) {
        if (index < this.propertyParameter.size()) {
            this.propertyParameter.removeElementAt(index);
            this.propertyParameter.add(index, str);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue(int index) {
        if (index < this.propertyValue.size()) {
            return (String)this.propertyValue.get(index);
        }
        return null;
    }

    public String getPropertyParameter(int index) {
        if (index < this.propertyParameter.size()) {
            return (String)this.propertyParameter.get(index);
        }
        return null;
    }

    public int propertyValueVectorSize() {
        return this.propertyValue.size();
    }

    public int propertyParameterVectorSize() {
        return this.propertyParameter.size();
    }

    private void parseLine(String line) throws IOException {
        String name = null;
        String value = null;
        int idx = line.indexOf(this.secondDelimiter);
        if (idx == -1) {
            throw new IOException("Error Have Incorrectly formatted line " + line);
        }
        String temp = line.substring(0, idx);
        value = line.substring(idx + 1, line.length());
        int j = 0;
        StringTokenizer stok = new StringTokenizer(value, this.firstDelimiter);
        while (stok.hasMoreTokens()) {
            this.setNextPropertyValue(stok.nextToken());
            ++j;
        }
        if (j == 0 && value.indexOf(this.firstDelimiter) == -1) {
            this.setNextPropertyValue(value);
        }
        StringTokenizer st = new StringTokenizer(temp, this.firstDelimiter);
        String tmp = null;
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i == 0) {
                name = st.nextToken().toUpperCase().trim();
                ++i;
                continue;
            }
            tmp = st.nextToken().toUpperCase().trim();
            this.setNextPropertyParameter(tmp);
            ++i;
        }
        if (i == 0) {
            name = temp.toUpperCase().trim();
        }
        if (name == null) {
            throw new IOException("Error got null PropertyName in line " + line);
        }
        this.setPropertyName(name);
    }

    public String getLine() {
        String line = "";
        String name = this.propertyName;
        String parameters = "";
        for (int i = 0; i < this.propertyParameter.size(); ++i) {
            String temp = this.propertyParameter.get(i).toString().trim();
            if (temp.equals("")) continue;
            parameters = parameters + this.firstDelimiter + temp;
        }
        String values = "";
        for (int j = 0; j < this.propertyValue.size(); ++j) {
            values = j == 0 ? values + this.propertyValue.get(j).toString() : values + this.firstDelimiter + this.propertyValue.get(j).toString();
        }
        if (values.trim().equals("")) {
            return null;
        }
        String str = values.trim();
        str = str.replace(';', ' ');
        if ((str = str.trim()).equals("")) {
            return null;
        }
        line = name + parameters + this.secondDelimiter + values;
        return line;
    }

    public void printAll() {
        int i;
        System.out.println(" -------- ");
        System.out.println("propertyName " + this.propertyName);
        for (i = 0; i < this.propertyValue.size(); ++i) {
            System.out.println(" propertyValue[ " + i + "] " + this.propertyValue.get(i));
        }
        for (i = 0; i < this.propertyParameter.size(); ++i) {
            System.out.println(" propertyParameter[ " + i + "] " + this.propertyParameter.get(i));
        }
        System.out.println(" -------- ");
    }
}

