/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import com.iplanet.iabs.importexport.ImportTranslatableEntry;
import com.iplanet.iabs.importexport.ImportedABParser;
import com.iplanet.iabs.importexport.vCard2_1Parser;
import com.iplanet.iabs.importexport.vCardParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ImportedvCardParser
implements ImportedABParser {
    private String _xlate;
    private InputStream _s;
    private String _default_parser_version = "2.1";
    private vCardParser _vCardParser = null;
    private Hashtable _tableToTranslate = null;

    public void ImportedvCardParser() {
    }

    public void loadFile(InputStream in, String xlateSuffix, String encoding, Hashtable defaultFields) throws IOException {
        this._xlate = xlateSuffix;
        if (in == null) {
            throw new IOException("Empty vCard inputstream !");
        }
        this._tableToTranslate = defaultFields != null && !defaultFields.isEmpty() ? new Hashtable(defaultFields) : new Hashtable();
        this._vCardParser = new vCard2_1Parser();
        this._vCardParser.init(in, encoding);
    }

    public ImportTranslatableEntry getNextEntry() throws IOException {
        ImportTranslatableEntry entry = null;
        Hashtable fields = new Hashtable(this._tableToTranslate);
        try {
            fields = (Hashtable)this._vCardParser.getNextMap(fields);
        }
        catch (Exception e) {
            throw new IOException("Error while getting next vCard Entry : " + e.toString());
        }
        if (fields != null) {
            entry = new ImportTranslatableEntry(this._xlate, fields);
            return entry;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion(InputStreamReader reader) throws IOException {
        String sVersion = this._default_parser_version;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(reader);
                String line = br.readLine();
                while (line != null) {
                    line = line.trim();
                    if ((line = line.toUpperCase()).startsWith("VERSION")) {
                        int idx = line.indexOf(58);
                        sVersion = line.substring(idx + 1, line.length());
                        break;
                    }
                    line = br.readLine();
                }
                Object var7_7 = null;
            }
            catch (Exception e) {
                throw new IOException("Unable to get version from vCard file" + e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException xe) {
                throw new IOException("Unable to close buffered reader for vCard file" + xe.toString());
            }
        }
        try {}
        catch (IOException xe) {
            throw new IOException("Unable to close buffered reader for vCard file" + xe.toString());
        }
        br.close();
        return sVersion.trim();
    }
}

