/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.DBPluginFactory;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.tools.PropertyReader;
import java.io.File;

public class DBInstance {
    public static final String CONFIG_DB_CLASS = "class";
    public static final String CONFIG_DB_URLMATCH = "urlmatch";
    public static final String CONFIG_DB_CONFIGPATH = "configpath";
    public static final String CONFIG_DB_WILDCARDSEARCH = "wildcardsearch";
    public static final String CONFIG_DB_RANDOMPAGING = "randompaging";
    public static final String CONFIG_DB_CORPORATE_DIR = "corporatedir";
    private String _urlMatch = null;
    private DBPlugin _dbPlugin = null;
    private int _minWildcardSearch = 0;
    private boolean _randomPaging = true;
    private boolean _corporatedir = false;

    public DBInstance(PropertyReader propertyReader, String string) throws PStoreException {
        this._urlMatch = propertyReader.getLowerCaseStringProperty(string + CONFIG_DB_URLMATCH, "");
        if (this._urlMatch.length() <= 0) {
            throw new PStoreException(1, "DBInstance.LoadDB: couldn't get urlMatch name for " + string);
        }
        File file = propertyReader.getFileProperty(string + CONFIG_DB_CONFIGPATH, "");
        if (file == null) {
            throw new PStoreException(1, "DBHandler.LoadDB: couldn't get configpath for " + string);
        }
        String string2 = propertyReader.getStringProperty(string + CONFIG_DB_CLASS, "");
        if (string2.length() <= 0) {
            throw new PStoreException(1, "DBHandler.LoadDB: couldn't get class name for " + string);
        }
        DBPluginFactory dBPluginFactory = null;
        try {
            Class<?> clazz = Class.forName(string2);
            dBPluginFactory = (DBPluginFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new PStoreException(1, "DBHandler.LoadDB: couldn't load" + string2 + " : " + exception.getMessage());
        }
        try {
            this._dbPlugin = dBPluginFactory.initConnection(file.getAbsolutePath(), 0);
        }
        catch (Exception exception) {
            throw new PStoreException(1, "DBHandler.LoadDB: InitConnection for " + string2 + " : " + exception.getMessage());
        }
        if (this._dbPlugin == null) {
            throw new PStoreException(1, "DBHandler.LoadDB: couldn't get an instance for" + string2);
        }
        this._minWildcardSearch = propertyReader.getIntProperty(string + CONFIG_DB_WILDCARDSEARCH, 0);
        this._randomPaging = propertyReader.getBooleanProperty(string + CONFIG_DB_RANDOMPAGING, "true");
        this._corporatedir = propertyReader.getBooleanProperty(string + CONFIG_DB_CORPORATE_DIR, "false");
    }

    public String getURLMatch() {
        return this._urlMatch;
    }

    public PS_DBPlugin getPSDBPlugin() {
        return (PS_DBPlugin)this._dbPlugin;
    }

    public DBPlugin getDBPlugin() {
        return this._dbPlugin;
    }

    public int getMinWildcardSearch() {
        return this._minWildcardSearch;
    }

    public boolean allowsRandomPaging() {
        return this._randomPaging;
    }

    public boolean isCorporateDir() {
        return this._corporatedir;
    }
}

