/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.beans.LDAPBasePropertySupport;

public class LDAPSimpleAuth
extends LDAPBasePropertySupport
implements Serializable {
    private transient String result = new String("");

    public LDAPSimpleAuth() {
    }

    public LDAPSimpleAuth(String string, int n) {
        this.setHost(string);
        this.setPort(n);
    }

    public LDAPSimpleAuth(String string, int n, String string2, String string3) {
        this.setHost(string);
        this.setPort(n);
        this.setAuthDN(string2);
        this.setAuthPassword(string3);
    }

    private void notifyResult(String string) {
        this.firePropertyChange("result", this.result, string);
        this.result = string;
    }

    public String authenticate() {
        LDAPConnection lDAPConnection = null;
        String string = "N";
        try {
            lDAPConnection = new LDAPConnection();
            System.out.println("Connecting to " + this.getHost() + " " + this.getPort());
            this.connect(lDAPConnection, this.getHost(), this.getPort());
        }
        catch (Exception exception) {
            System.out.println("Failed to connect to " + this.getHost() + ": " + exception.toString());
        }
        if (lDAPConnection.isConnected()) {
            System.out.println("Authenticating " + this.getAuthDN());
            try {
                lDAPConnection.authenticate(this.getAuthDN(), this.getAuthPassword());
                string = "Y";
            }
            catch (Exception exception) {
                System.out.println("Failed to authenticate to " + this.getHost() + ": " + exception.toString());
            }
        }
        try {
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                lDAPConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyResult(string);
        return string;
    }

    public String authenticate(String string, String string2) {
        this.setAuthDN(string);
        this.setAuthPassword(string2);
        return this.authenticate();
    }

    public void authenticate(ActionEvent actionEvent) {
        this.authenticate();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("       LDAPSimpleAuth host port DN password");
            System.exit(1);
        }
        LDAPSimpleAuth lDAPSimpleAuth = new LDAPSimpleAuth();
        lDAPSimpleAuth.setHost(stringArray[0]);
        lDAPSimpleAuth.setPort(Integer.parseInt(stringArray[1]));
        lDAPSimpleAuth.setAuthDN(stringArray[2]);
        lDAPSimpleAuth.setAuthPassword(stringArray[3]);
        String string = lDAPSimpleAuth.authenticate();
        System.out.println("Response: " + string);
        System.exit(0);
    }
}

