/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.beans.LDAPBasePropertySupport;

public class LDAPGetProperty
extends LDAPBasePropertySupport
implements Serializable {
    private String[] _dns = null;
    private String _attribute = new String("cn");
    private transient String[] _result;
    private Vector _resultV = null;
    private String _sResult = null;
    private String _errorMsg = null;

    public LDAPGetProperty() {
    }

    public LDAPGetProperty(String string, int n, String string2) {
        this.setHost(string);
        this.setPort(n);
        this.setBase(string2);
    }

    public String getAttribute() {
        return this._attribute;
    }

    public void setAttribute(String string) {
        this._attribute = string;
    }

    private void notifyResult(String[] stringArray) {
        String string = this.convertToString(stringArray);
        this.firePropertyChange("result", this._result, stringArray);
        this._sResult = string;
        this._result = stringArray;
    }

    private void notifyResult(Vector vector) {
        this.firePropertyChange("result", this._resultV, vector);
        this._resultV = (Vector)vector.clone();
    }

    private void notifyResult(String string) {
        this.firePropertyChange("error", this._errorMsg, string);
        this._errorMsg = string;
    }

    public void setDNs(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object != null && object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length == 0) {
                return;
            }
            this._dns = new String[stringArray.length];
            System.arraycopy(object, 0, this._dns, 0, stringArray.length);
            System.out.println("length of dns -> " + this._dns.length);
        }
    }

    public String[] getProperty(String string, int n, String string2, String string3, String string4) {
        this.setHost(string);
        this.setPort(n);
        this.setBase(string2);
        this.setFilter(string3);
        this.setAttribute(string4);
        return this.getProperty();
    }

    public void getProperty(ActionEvent actionEvent) {
        this.getProperty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getProperty() {
        int n;
        LDAPConnection lDAPConnection;
        Object[] objectArray;
        block29: {
            if (this._attribute.length() < 1 || this.getFilter().length() < 1) {
                this.printDebug("Invalid attribute name or filter");
                this.setErrorCode(1);
                this.notifyResult((String[])null);
                return null;
            }
            objectArray = null;
            try {
                lDAPConnection = new LDAPConnection();
                this.printDebug("Connecting to " + this.getHost() + " " + this.getPort());
                this.connect(lDAPConnection, this.getHost(), this.getPort());
            }
            catch (Exception exception) {
                this.printDebug("Failed to connect to " + this.getHost() + ": " + exception.toString());
                this.setErrorCode(2);
                this.notifyResult((String[])null);
                return null;
            }
            if (this._dns == null) {
                if (!this.getAuthDN().equals("") && !this.getAuthPassword().equals("")) {
                    this.printDebug("Authenticating " + this.getAuthDN() + " - " + this.getAuthPassword());
                    try {
                        lDAPConnection.authenticate(this.getAuthDN(), this.getAuthPassword());
                    }
                    catch (Exception exception) {
                        this.printDebug("Failed to authenticate to " + this.getHost() + ": " + exception.toString());
                        this.setErrorCode(3);
                        this.notifyResult((String[])null);
                        return null;
                    }
                }
            } else {
                for (n = 0; n < this._dns.length; ++n) {
                    try {
                        lDAPConnection.authenticate(this._dns[n], this.getAuthPassword());
                        break;
                    }
                    catch (Exception exception) {
                        if (n != this._dns.length - 1) continue;
                        this.printDebug("Failed to authenticate to " + this.getHost() + ": " + exception.toString());
                        this.setErrorCode(3);
                        this.notifyResult((String[])null);
                        return null;
                    }
                }
            }
            n = 0;
            try {
                String[] stringArray = new String[]{this._attribute};
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.getBase(), this.getScope(), this.getFilter(), stringArray, false);
                LDAPEntry lDAPEntry = null;
                LDAPEntry lDAPEntry2 = null;
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        lDAPEntry = lDAPSearchResults.next();
                        if (n == 0) {
                            lDAPEntry2 = lDAPEntry;
                        }
                        if (++n <= 1) continue;
                        this.printDebug("More than one entry found for " + this.getFilter());
                        this.setErrorCode(5);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!this.getDebug()) continue;
                        this.notifyResult(lDAPException.toString());
                    }
                }
                if (n != 1) break block29;
                this.printDebug("... " + lDAPEntry2.getDN());
                if (this._attribute.equalsIgnoreCase("dn")) {
                    objectArray = new String[]{lDAPEntry2.getDN()};
                    this.setErrorCode(0);
                    break block29;
                }
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry2.getAttributeSet();
                Enumeration enumeration = lDAPAttributeSet.getAttributes();
                if (enumeration.hasMoreElements()) {
                    LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                    this.printDebug(lDAPAttribute.getName() + " = ");
                    Enumeration enumeration2 = lDAPAttribute.getStringValues();
                    if (enumeration2 != null) {
                        Vector<String> vector = new Vector<String>();
                        while (enumeration2.hasMoreElements()) {
                            String string = (String)enumeration2.nextElement();
                            vector.addElement(string);
                            this.printDebug("\t\t" + string);
                        }
                        objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        this.setErrorCode(0);
                        break block29;
                    } else {
                        Enumeration enumeration3 = lDAPAttribute.getByteValues();
                        Vector<byte[]> vector = new Vector<byte[]>();
                        while (true) {
                            if (!enumeration3.hasMoreElements()) {
                                this.setErrorCode(0);
                                this.notifyResult(vector);
                                return null;
                            }
                            byte[] byArray = (byte[])enumeration3.nextElement();
                            vector.addElement(byArray);
                            this.printDebug("\t\t" + byArray);
                        }
                    }
                }
                this.printDebug("No properties found for " + this._attribute);
                this.setErrorCode(4);
            }
            catch (Exception exception) {
                if (this.getDebug()) {
                    this.printDebug("Failed to search for " + this.getFilter() + ": " + exception.toString());
                }
                this.setErrorCode(4);
            }
        }
        if (n == 0) {
            this.printDebug("No entries found for " + this.getFilter());
            this.setErrorCode(4);
        }
        try {
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                lDAPConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyResult((String[])objectArray);
        return objectArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.out.println("Usage: LDAPGetProperty host port base filter attribute");
            System.exit(1);
        }
        LDAPGetProperty lDAPGetProperty = new LDAPGetProperty();
        lDAPGetProperty.setHost(stringArray[0]);
        lDAPGetProperty.setPort(Integer.parseInt(stringArray[1]));
        lDAPGetProperty.setBase(stringArray[2]);
        lDAPGetProperty.setFilter(stringArray[3]);
        lDAPGetProperty.setAttribute(stringArray[4]);
        String[] stringArray2 = lDAPGetProperty.getProperty();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("\t" + stringArray2[i]);
            }
        }
        System.exit(0);
    }
}

