/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.beans.LDAPBasePropertySupport;

public class LDAPGetEntries
extends LDAPBasePropertySupport
implements Serializable {
    private String _attribute = "dn";
    private String[] _result;
    private String _sResult = null;
    private String _errorMsg = null;

    public LDAPGetEntries() {
    }

    public LDAPGetEntries(String string, int n, String string2) {
        this.setHost(string);
        this.setPort(n);
        this.setBase(string2);
    }

    public LDAPGetEntries(String string, int n, String string2, int n2) {
        this.setHost(string);
        this.setPort(n);
        this.setBase(string2);
        this.setScope(n2);
    }

    private void notifyResult(String string) {
        this.firePropertyChange("error", this._errorMsg, string);
        this._errorMsg = string;
    }

    private void notifyResult(String[] stringArray) {
        String string = this.convertToString(stringArray);
        this.firePropertyChange("result", this._result, stringArray);
        this._sResult = string;
        this._result = stringArray;
    }

    public String getAttribute() {
        return this._attribute;
    }

    public void setAttribute(String string) {
        this._attribute = string;
    }

    public void setResultString(String string) {
        this._sResult = string;
    }

    public String getResultString() {
        return this._sResult;
    }

    public String[] getEntries(String string, int n, String string2, int n2, String string3) {
        this.setHost(string);
        this.setPort(n);
        this.setBase(string2);
        this.setScope(n2);
        this.setFilter(string3);
        return this.getEntries();
    }

    public String[] getEntries(String string, int n, String string2, int n2, String string3, String string4) {
        this.setHost(string);
        this.setPort(n);
        this.setBase(string2);
        this.setScope(n2);
        if (string4 == null) {
            string4 = new String("");
        }
        this.setUserName(string4);
        if (string3 == null) {
            string3 = new String("");
        }
        this.setUserID(string3);
        return this.getEntries();
    }

    public void getEntries(ActionEvent actionEvent) {
        this.getEntries();
    }

    public String[] getEntries() {
        LDAPConnection lDAPConnection;
        Object[] objectArray;
        block30: {
            boolean bl = false;
            if (this.getUserName().length() < 1 && this.getUserID().length() < 1 && this.getFilter().length() < 1) {
                this.printDebug("No user name or user ID");
                bl = true;
            } else if (this.getHost().length() < 1 || this.getBase().length() < 1) {
                this.printDebug("Invalid host name or search base");
                bl = true;
            }
            if (bl) {
                this.setErrorCode(1);
                this.notifyResult((String)null);
                return null;
            }
            if (this.getFilter().length() < 1) {
                objectArray = new String("");
                if (this.getUserName().length() > 1 && this.getUserID().length() > 1) {
                    objectArray = "(|(cn=" + this.getUserName() + ")(uid=" + this.getUserID() + "))";
                } else if (this.getUserName().length() > 1) {
                    objectArray = "cn=" + this.getUserName();
                } else if (this.getUserID().length() > 1) {
                    objectArray = "uid=" + this.getUserID();
                }
                this.setFilter((String)objectArray);
            }
            objectArray = null;
            lDAPConnection = new LDAPConnection();
            try {
                try {
                    this.printDebug("Connecting to " + this.getHost() + " " + this.getPort());
                    this.connect(lDAPConnection, this.getHost(), this.getPort());
                }
                catch (Exception exception) {
                    this.printDebug("Failed to connect to " + this.getHost() + ": " + exception.toString());
                    this.setErrorCode(2);
                    this.notifyResult((String)null);
                    lDAPConnection = null;
                    throw new Exception();
                }
                if (!this.getAuthDN().equals("") && !this.getAuthPassword().equals("")) {
                    this.printDebug("Authenticating " + this.getAuthDN());
                    try {
                        lDAPConnection.authenticate(this.getAuthDN(), this.getAuthPassword());
                    }
                    catch (Exception exception) {
                        this.printDebug("Failed to authenticate: " + exception.toString());
                        this.setErrorCode(3);
                        this.notifyResult((String)null);
                        throw new Exception();
                    }
                }
                try {
                    this.printDebug("Searching " + this.getBase() + " for " + this.getFilter() + ", scope = " + this.getScope());
                    String[] stringArray = new String[]{this._attribute};
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.getBase(), this.getScope(), this.getFilter(), stringArray, false);
                    Vector<String> vector = new Vector<String>();
                    LDAPEntry lDAPEntry = null;
                    while (lDAPSearchResults.hasMoreElements()) {
                        try {
                            lDAPEntry = lDAPSearchResults.next();
                        }
                        catch (LDAPException lDAPException) {
                            if (!this.getDebug()) continue;
                            this.notifyResult(lDAPException.toString());
                            continue;
                        }
                        String string = "";
                        if (this._attribute.equals("dn")) {
                            string = lDAPEntry.getDN();
                        } else {
                            Enumeration enumeration;
                            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this._attribute);
                            if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
                                string = (String)enumeration.nextElement();
                            }
                        }
                        vector.addElement(string);
                        this.printDebug("... " + string);
                    }
                    if (vector.size() > 0) {
                        objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        vector.removeAllElements();
                        this.setErrorCode(0);
                        break block30;
                    }
                    this.printDebug("No entries found for " + this.getFilter());
                    this.setErrorCode(4);
                }
                catch (Exception exception) {
                    if (this.getDebug()) {
                        this.printDebug("Failed to search for " + this.getFilter() + ": " + exception.toString());
                    }
                    this.setErrorCode(4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                lDAPConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyResult((String[])objectArray);
        return objectArray;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"base", "one", "sub"};
        int n = -1;
        for (int i = 0; i < stringArray2.length && stringArray.length == 5; ++i) {
            if (!stringArray[3].equalsIgnoreCase(stringArray2[i])) continue;
            n = i;
            break;
        }
        if (n < 0) {
            System.out.println("Usage: LDAPGetEntries host port base scope filter");
            System.exit(1);
        }
        LDAPGetEntries lDAPGetEntries = new LDAPGetEntries();
        lDAPGetEntries.setHost(stringArray[0]);
        lDAPGetEntries.setPort(Integer.parseInt(stringArray[1]));
        lDAPGetEntries.setBase(stringArray[2]);
        lDAPGetEntries.setScope(n);
        lDAPGetEntries.setFilter(stringArray[4]);
        String[] stringArray3 = lDAPGetEntries.getEntries();
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                System.out.println("\t" + stringArray3[i]);
            }
        }
        System.exit(0);
    }
}

