/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Vector;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;

class LDAPMessageQueue
implements Serializable {
    static final long serialVersionUID = -7163312406176592277L;
    private Vector m_messageQueue = new Vector(1);
    private Vector m_requestList = new Vector(1);
    private LDAPException m_exception;
    private boolean m_asynchOp;
    private boolean m_timeConstrained;

    LDAPMessageQueue(boolean bl) {
        this.m_asynchOp = bl;
    }

    boolean isAsynchOp() {
        return this.m_asynchOp;
    }

    synchronized LDAPMessage nextMessage() throws LDAPException {
        while (this.m_requestList.size() != 0 && this.m_exception == null && this.m_messageQueue.size() == 0) {
            this.waitForMessage();
        }
        if (this.m_exception != null) {
            LDAPException lDAPException = this.m_exception;
            this.m_exception = null;
            throw lDAPException;
        }
        if (this.m_requestList.size() == 0) {
            return null;
        }
        LDAPMessage lDAPMessage = (LDAPMessage)this.m_messageQueue.elementAt(0);
        this.m_messageQueue.removeElementAt(0);
        if (lDAPMessage instanceof LDAPResponse) {
            this.removeRequest(lDAPMessage.getMessageID());
        }
        return lDAPMessage;
    }

    synchronized LDAPResponse completeRequest() throws LDAPException {
        while (true) {
            if (this.m_requestList.size() != 0 && this.m_exception == null && this.m_messageQueue.size() == 0) {
                this.waitForMessage();
                continue;
            }
            if (this.m_exception != null) {
                LDAPException lDAPException = this.m_exception;
                this.m_exception = null;
                throw lDAPException;
            }
            if (this.m_requestList.size() == 0) {
                return null;
            }
            for (int i = this.m_messageQueue.size() - 1; i >= 0; --i) {
                LDAPMessage lDAPMessage = (LDAPMessage)this.m_messageQueue.elementAt(i);
                if (!(lDAPMessage instanceof LDAPResponse)) continue;
                this.m_messageQueue.removeElementAt(i);
                return (LDAPResponse)lDAPMessage;
            }
            this.waitForMessage();
        }
    }

    private synchronized void waitForMessage() throws LDAPException {
        if (!this.m_timeConstrained) {
            try {
                this.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new LDAPInterruptedException("Interrupted LDAP operation");
            }
        }
        long l = Long.MAX_VALUE;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < this.m_requestList.size(); ++i) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(i);
            if (requestEntry.timeToComplete <= l2) {
                requestEntry.connection.abandon(requestEntry.id);
                throw new LDAPException("Time to complete operation exceeded", 85);
            }
            if (requestEntry.timeToComplete >= l) continue;
            l = requestEntry.timeToComplete;
        }
        long l3 = l == Long.MAX_VALUE ? 0L : l - l2;
        try {
            this.m_timeConstrained = l3 != 0L;
            this.wait(l3);
        }
        catch (InterruptedException interruptedException) {
            throw new LDAPInterruptedException("Interrupted LDAP operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(LDAPMessageQueue lDAPMessageQueue) {
        Thread.yield();
        LDAPMessageQueue lDAPMessageQueue2 = this;
        synchronized (lDAPMessageQueue2) {
            LDAPMessageQueue lDAPMessageQueue3 = lDAPMessageQueue;
            synchronized (lDAPMessageQueue3) {
                int n;
                for (n = 0; n < lDAPMessageQueue.m_messageQueue.size(); ++n) {
                    this.m_messageQueue.addElement(lDAPMessageQueue.m_messageQueue.elementAt(n));
                }
                if (lDAPMessageQueue.m_exception != null) {
                    this.m_exception = lDAPMessageQueue.m_exception;
                }
                for (n = 0; n < lDAPMessageQueue.m_requestList.size(); ++n) {
                    RequestEntry requestEntry = (RequestEntry)lDAPMessageQueue.m_requestList.elementAt(n);
                    this.m_requestList.addElement(requestEntry);
                    requestEntry.connThread.changeListener(requestEntry.id, this);
                }
                lDAPMessageQueue.reset();
                this.notifyAll();
            }
            this.notifyAll();
        }
    }

    synchronized Vector getAllMessages() {
        Vector vector = this.m_messageQueue;
        this.m_messageQueue = new Vector(1);
        return vector;
    }

    synchronized void addMessage(LDAPMessage lDAPMessage) {
        this.m_messageQueue.addElement(lDAPMessage);
        if (this.isAsynchOp()) {
            if (lDAPMessage.getType() == 1 && ((LDAPResponse)lDAPMessage).getResultCode() == 0) {
                this.getConnection(lDAPMessage.getMessageID()).markConnAsBound();
            }
        }
        this.notifyAll();
    }

    synchronized void setException(LDAPConnThread lDAPConnThread, LDAPException lDAPException) {
        this.m_exception = lDAPException;
        this.removeAllRequests(lDAPConnThread);
        this.notifyAll();
    }

    boolean isMessageReceived() {
        return this.m_messageQueue.size() != 0;
    }

    public int getMessageCount() {
        return this.m_messageQueue.size();
    }

    private int removeAllMessages(int n) {
        int n2 = 0;
        for (int i = this.m_messageQueue.size() - 1; i >= 0; --i) {
            LDAPMessage lDAPMessage = (LDAPMessage)this.m_messageQueue.elementAt(i);
            if (lDAPMessage.getMessageID() != n) continue;
            this.m_messageQueue.removeElementAt(i);
            ++n2;
        }
        return n2;
    }

    void reset() {
        this.m_exception = null;
        this.m_messageQueue.removeAllElements();
        this.m_requestList.removeAllElements();
        this.m_timeConstrained = false;
    }

    synchronized LDAPConnection getConnection(int n) {
        for (int i = 0; i < this.m_requestList.size(); ++i) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(i);
            if (n != requestEntry.id) continue;
            return requestEntry.connection;
        }
        return null;
    }

    synchronized LDAPConnThread getConnThread(int n) {
        for (int i = 0; i < this.m_requestList.size(); ++i) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(i);
            if (n != requestEntry.id) continue;
            return requestEntry.connThread;
        }
        return null;
    }

    synchronized int getMessageID() {
        int n = this.m_requestList.size();
        if (n == 0) {
            return -1;
        }
        RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n - 1);
        return requestEntry.id;
    }

    synchronized int[] getMessageIDs() {
        int[] nArray = new int[this.m_requestList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(i);
            nArray[i] = requestEntry.id;
        }
        return nArray;
    }

    synchronized void addRequest(int n, LDAPConnection lDAPConnection, LDAPConnThread lDAPConnThread, int n2) {
        this.m_requestList.addElement(new RequestEntry(n, lDAPConnection, lDAPConnThread, n2));
        if (n2 != 0) {
            this.m_timeConstrained = true;
        }
        this.notifyAll();
    }

    public int getRequestCount() {
        return this.m_requestList.size();
    }

    synchronized boolean removeRequest(int n) {
        for (int i = 0; i < this.m_requestList.size(); ++i) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(i);
            if (n != requestEntry.id) continue;
            this.m_requestList.removeElementAt(i);
            this.removeAllMessages(n);
            this.notifyAll();
            return true;
        }
        return false;
    }

    synchronized int removeAllRequests(LDAPConnThread lDAPConnThread) {
        int n = 0;
        for (int i = this.m_requestList.size() - 1; i >= 0; --i) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(i);
            if (lDAPConnThread != requestEntry.connThread) continue;
            this.m_requestList.removeElementAt(i);
            ++n;
            this.removeAllMessages(requestEntry.id);
        }
        this.notifyAll();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPMessageQueue:");
        stringBuffer.append(" requestIDs={");
        for (int i = 0; i < this.m_requestList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(((RequestEntry)this.m_requestList.elementAt((int)i)).id);
        }
        stringBuffer.append("} messageCount=" + this.m_messageQueue.size());
        return stringBuffer.toString();
    }

    private static class RequestEntry {
        int id;
        LDAPConnection connection;
        LDAPConnThread connThread;
        long timeToComplete;

        RequestEntry(int n, LDAPConnection lDAPConnection, LDAPConnThread lDAPConnThread, int n2) {
            this.id = n;
            this.connection = lDAPConnection;
            this.connThread = lDAPConnThread;
            this.timeToComplete = n2 == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)n2;
        }
    }
}

