/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.xslutil.XMLDOMContentHandler;
import com.iplanet.xslui.xslutil.XMLErrorHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDOMBuilder {
    private static XMLDOMBuilder _domBuilder;
    private static XMLDOMBuilder _domBuilderWithErrHandler;
    private static DocumentBuilderFactory _documentBuilderFactory;
    private DocumentBuilder _documentBuilder = null;
    private static final String basicIndent = " ";

    public static synchronized XMLDOMBuilder getInstance() throws XMLProcessingException {
        if (_domBuilder == null) {
            _domBuilder = new XMLDOMBuilder();
        }
        return _domBuilder;
    }

    public static synchronized XMLDOMBuilder getInstance(XSLXMLLogHandler errorHandler) throws XMLProcessingException {
        if (_domBuilderWithErrHandler == null) {
            _domBuilderWithErrHandler = new XMLDOMBuilder(errorHandler);
        }
        return _domBuilderWithErrHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLDOMBuilder() throws XMLProcessingException {
        DocumentBuilderFactory documentBuilderFactory = _documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                this._documentBuilder = _documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new XMLProcessingException("XMLDOMBuilder: Couldn't get a Factory: " + pce.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLDOMBuilder(XSLXMLLogHandler errorHandler) throws XMLProcessingException {
        DocumentBuilderFactory documentBuilderFactory = _documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                this._documentBuilder = _documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new XMLProcessingException("XMLDOMBuilder: Couldn't get a Factory: " + pce.getMessage());
            }
        }
        if (errorHandler != null) {
            this._documentBuilder.setErrorHandler(new XMLErrorHandler(errorHandler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(File xmlFile, boolean stripWhiteSpaceNodes) throws XMLProcessingException {
        Document xmlDoc = null;
        if (xmlFile == null) {
            throw new XMLProcessingException("File is null");
        }
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            try {
                xmlDoc = this._documentBuilder.parse(xmlFile);
            }
            catch (SAXException se) {
                throw new XMLProcessingException("parsing failed: " + se.getMessage());
            }
            catch (IOException ioe) {
                throw new XMLProcessingException("parsing failed: " + ioe.getMessage());
            }
        }
        if (stripWhiteSpaceNodes) {
            xmlDoc = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(xmlDoc);
        }
        return xmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(InputStream ip, boolean stripWhiteSpaceNodes) throws XMLProcessingException {
        Document xmlDoc = null;
        if (ip == null) {
            throw new XMLProcessingException("InputStream is null");
        }
        InputSource input = new InputSource(ip);
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            try {
                xmlDoc = this._documentBuilder.parse(input);
            }
            catch (SAXException se) {
                throw new XMLProcessingException("parsing failed: " + se.getMessage());
            }
            catch (IOException ioe) {
                throw new XMLProcessingException("parsing failed: " + ioe.getMessage());
            }
        }
        if (stripWhiteSpaceNodes) {
            xmlDoc = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(xmlDoc);
        }
        return xmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(Reader reader, boolean stripWhiteSpaceNodes) throws XMLProcessingException {
        Document xmlDoc = null;
        if (reader == null) {
            throw new XMLProcessingException("Reader is null");
        }
        InputSource input = new InputSource(reader);
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            try {
                xmlDoc = this._documentBuilder.parse(input);
            }
            catch (SAXException se) {
                throw new XMLProcessingException("parsing failed: " + se.getMessage());
            }
            catch (IOException ioe) {
                throw new XMLProcessingException("parsing failed: " + ioe.getMessage());
            }
        }
        if (stripWhiteSpaceNodes) {
            xmlDoc = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(xmlDoc);
        }
        return xmlDoc;
    }

    public Document parse(File xmlFile) throws XMLProcessingException {
        return this.parse(xmlFile, true);
    }

    public Document parse(String path, boolean stripWhiteSpaceNodes) throws XMLProcessingException {
        Document xmlDoc = null;
        File xmlFile = null;
        if (path == null) {
            throw new XMLProcessingException("path is null");
        }
        if (path.length() == 0) {
            throw new XMLProcessingException("path is empty");
        }
        xmlFile = new File(path);
        xmlDoc = this.parse(xmlFile);
        if (xmlDoc == null) {
            throw new XMLProcessingException("Couldn't parse " + path);
        }
        if (stripWhiteSpaceNodes) {
            xmlDoc = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(xmlDoc);
        }
        return xmlDoc;
    }

    public Document parse(String path) throws XMLProcessingException {
        return this.parse(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document newDocument() {
        Document doc = null;
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            doc = this._documentBuilder.newDocument();
        }
        return doc;
    }

    public Document newDocument(Document origDoc) throws XMLProcessingException {
        Document newDoc = (Document)this.copyNode(origDoc, null, null);
        return newDoc;
    }

    public Document newDocument(Document origDoc, XMLDOMContentHandler contentHandler) throws XMLProcessingException {
        Document newDoc = (Document)this.copyNode(origDoc, null, contentHandler);
        return newDoc;
    }

    public Node copyNode(Node origNode, Document newDoc) throws XMLProcessingException {
        return this.copyNode(origNode, newDoc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node copyNode(Node origNode, Document newDoc, XMLDOMContentHandler contentHandler) throws XMLProcessingException {
        NodeList nl;
        Node newNode = null;
        if (origNode == null) {
            throw new XMLProcessingException("copyNode: origNode is null");
        }
        short origNodeType = origNode.getNodeType();
        if (newDoc == null && origNodeType != 9) {
            throw new XMLProcessingException("copyNode: newDoc is null");
        }
        String origNodeNSURI = origNode.getNamespaceURI();
        String origNodeName = origNode.getNodeName();
        String origNodeValue = origNode.getNodeValue();
        switch (origNodeType) {
            case 2: {
                newNode = origNodeNSURI != null ? newDoc.createAttributeNS(origNodeNSURI, origNodeName) : newDoc.createAttribute(origNodeName);
                ((Attr)newNode).setValue(origNodeValue);
                break;
            }
            case 9: {
                DocumentBuilder documentBuilder = this._documentBuilder;
                synchronized (documentBuilder) {
                    newDoc = this._documentBuilder.newDocument();
                }
                newNode = newDoc;
                break;
            }
            case 10: {
                DocumentType origDT = (DocumentType)origNode;
                DOMImplementation domImpl = null;
                DocumentBuilder documentBuilder = this._documentBuilder;
                synchronized (documentBuilder) {
                    domImpl = this._documentBuilder.getDOMImplementation();
                }
                newNode = domImpl.createDocumentType(origDT.getName(), origDT.getPublicId(), origDT.getSystemId());
                break;
            }
            case 1: {
                if (contentHandler != null && contentHandler.SkipElementHandler(origNode)) {
                    return null;
                }
                newNode = origNodeNSURI != null ? newDoc.createElementNS(origNodeNSURI, origNodeName) : newDoc.createElement(origNodeName);
                if (contentHandler != null) {
                    contentHandler.preElementHandler((Element)newNode, newDoc);
                }
                NamedNodeMap nm = origNode.getAttributes();
                Node attrNode = null;
                for (int i = 0; i < nm.getLength(); ++i) {
                    attrNode = nm.item(i);
                    Attr newAttr = null;
                    String attrNodeNSURI = attrNode.getNamespaceURI();
                    String attrNodeName = attrNode.getNodeName();
                    String attrNodeValue = attrNode.getNodeValue();
                    newAttr = attrNodeNSURI != null ? newDoc.createAttributeNS(attrNodeNSURI, attrNodeName) : newDoc.createAttribute(attrNodeName);
                    newAttr.setValue(attrNodeValue);
                    ((Element)newNode).setAttributeNode(newAttr);
                    if (contentHandler == null) continue;
                    contentHandler.attributeHandler(newAttr, newDoc);
                }
                break;
            }
            case 3: {
                newNode = newDoc.createTextNode(origNodeValue);
                break;
            }
            case 7: {
                ProcessingInstruction origPI = (ProcessingInstruction)origNode;
                newNode = newDoc.createProcessingInstruction(origPI.getTarget(), origPI.getData());
                break;
            }
            case 8: {
                Comment origComment = (Comment)origNode;
                newNode = newDoc.createComment(origComment.getData());
                break;
            }
            default: {
                throw new XMLProcessingException("copyNode: can't copy Node of type: " + origNode.getNodeType());
            }
        }
        if (origNodeType != 3 && origNodeType != 2 && origNodeType != 10 && (nl = origNode.getChildNodes()).getLength() != 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node childNode;
                if (nl.item(i) == null || (childNode = this.copyNode(nl.item(i), newDoc, contentHandler)) == null || childNode.getNodeType() == 10) continue;
                newNode.appendChild(childNode);
            }
        }
        if (contentHandler != null) {
            switch (origNodeType) {
                case 2: {
                    contentHandler.attributeHandler((Attr)newNode, newDoc);
                    break;
                }
                case 1: {
                    contentHandler.elementHandler((Element)newNode, newDoc);
                    break;
                }
            }
        }
        return newNode;
    }

    public void copyChildren(Node origNode, Node destNode) throws XMLProcessingException {
        Document destDoc = destNode.getOwnerDocument();
        NodeList nl = null;
        nl = origNode.getChildNodes();
        if (nl.getLength() != 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node childNode;
                if (nl.item(i) == null || (childNode = this.copyNode(nl.item(i), destDoc)) == null) continue;
                destNode.appendChild(childNode);
            }
        }
    }

    public void copyAttributes(Element origElt, Element destElt) throws XMLProcessingException {
        Document destDoc = destElt.getOwnerDocument();
        NamedNodeMap nm = origElt.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Attr attr = (Attr)this.copyNode(nm.item(i), destDoc);
            if (attr == null) continue;
            destElt.setAttributeNode(attr);
        }
    }

    public static void dumpNode(Node node, String filename) throws XMLProcessingException {
        try {
            FileOutputStream stream = new FileOutputStream(filename);
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
            XMLDOMBuilder.unparse(node, outWriter, 0);
            outWriter.flush();
            stream.flush();
            stream.close();
        }
        catch (IOException ex) {
            throw new XMLProcessingException("Can't open file : " + ex.getMessage());
        }
    }

    public static void dumpNode(Node node, OutputStream outputStream) throws XMLProcessingException {
        try {
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            XMLDOMBuilder.unparse(node, outWriter, 0);
            outWriter.write("\n");
            outWriter.flush();
        }
        catch (IOException ex) {
            throw new XMLProcessingException("Can't create out : " + ex.getMessage());
        }
    }

    public static void dumpNode(Node node, OutputStream outputStream, boolean stripEmptyNode) throws XMLProcessingException {
        try {
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            XMLDOMBuilder.unparse(node, outWriter, 0, stripEmptyNode);
            outWriter.write("\n");
            outWriter.flush();
        }
        catch (IOException ex) {
            throw new XMLProcessingException("Can't create out : " + ex.getMessage());
        }
    }

    public static void dumpChildrenOfNode(Node node, OutputStream outputStream) throws XMLProcessingException {
        try {
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                XMLDOMBuilder.unparse(child, outWriter, 0);
                outWriter.write("\n");
                outWriter.flush();
            }
        }
        catch (IOException ex) {
            throw new XMLProcessingException("Can't create out : " + ex.getMessage());
        }
    }

    public static void dumpChildrenOfNode(Node node, String filename) throws XMLProcessingException {
        try {
            FileOutputStream stream = new FileOutputStream(filename);
            XMLDOMBuilder.dumpChildrenOfNode(node, stream);
            stream.flush();
            stream.close();
        }
        catch (IOException ex) {
            throw new XMLProcessingException("Can't open file : " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        Document xmldoc = null;
        if (args.length != 1) {
            System.err.println("Usage: XMLDOMBuilder <XML file>");
            System.exit(1);
        }
        String xmlfilename = args[0];
        try {
            XMLDOMBuilder parser = new XMLDOMBuilder();
            xmldoc = parser.parse(xmlfilename);
            System.err.println("Result: ");
            XMLDOMBuilder.dumpNode((Node)xmldoc, System.err);
        }
        catch (XMLProcessingException xe) {
            System.err.println("Couldn't parse " + xmlfilename + " (" + xe.getMessage() + ")");
            System.exit(1);
        }
    }

    public void insertNodeFromString(Document doc, Node node, String str) throws XMLProcessingException {
        try {
            Node parentNode;
            Document dummyDoc = this.createDocFromString(str);
            if (dummyDoc != null && (parentNode = dummyDoc.getFirstChild()) != null) {
                for (Node curNode = parentNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
                    node.appendChild(doc.importNode(curNode, true));
                }
            }
        }
        catch (Exception e) {
            throw new XMLProcessingException("Can not insert node from XML string : " + e.getMessage());
        }
    }

    private Document createDocFromString(String str) throws XMLProcessingException {
        Document dummyDoc = null;
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("<?xml version=\"1.0\"?>");
        strBuff.append("<dummyDocument>");
        strBuff.append(str);
        strBuff.append("</dummyDocument>");
        try {
            StringReader strReader = new StringReader(strBuff.toString());
            strReader.ready();
            InputSource inputSrc = new InputSource(strReader);
            dummyDoc = this._documentBuilder.parse(inputSrc);
        }
        catch (IOException e) {
            throw new XMLProcessingException("Error while handling the stream : " + e.getMessage());
        }
        catch (SAXException se) {
            throw new XMLProcessingException("Error while parsing the stream : " + se.getMessage());
        }
        return dummyDoc;
    }

    private void dump(Node node, StreamResult stream) throws XMLProcessingException {
        Transformer transformer = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException se) {
            throw new XMLProcessingException("dump: " + se.getMessage());
        }
        try {
            transformer.transform(new DOMSource(node), stream);
        }
        catch (TransformerException te) {
            throw new XMLProcessingException("dump: transform failed (" + te.getMessage() + ")");
        }
    }

    private static void unparse(Node node, Writer outWriter, int indent) throws XMLProcessingException {
        XMLDOMBuilder.unparse(node, outWriter, indent, false);
    }

    private static void unparse(Node node, Writer outWriter, int indent, boolean stripEmptyNode) throws XMLProcessingException {
        short type = node.getNodeType();
        try {
            switch (type) {
                case 2: {
                    String attribValue = node.getNodeValue();
                    if (!stripEmptyNode && attribValue == null) {
                        outWriter.write(basicIndent + node.getNodeName() + "=\"!!!null!!!\"");
                        break;
                    }
                    if (stripEmptyNode) {
                        if (attribValue.trim().length() != 0) {
                            outWriter.write(basicIndent + node.getNodeName() + "=\"" + XMLDOMBuilder.escape(attribValue, true) + "\"");
                        }
                        break;
                    }
                    outWriter.write(basicIndent + node.getNodeName() + "=\"" + XMLDOMBuilder.escape(attribValue, true) + "\"");
                    break;
                }
                case 4: {
                    throw new XMLProcessingException("Tag exception : CDATA");
                }
                case 8: {
                    break;
                }
                case 11: {
                    throw new XMLProcessingException("Tag exception : DOC_FRAG");
                }
                case 9: {
                    outWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    if (node.hasChildNodes()) {
                        for (Node curChild = node.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                            outWriter.write("\n");
                            XMLDOMBuilder.unparse(curChild, outWriter, indent, stripEmptyNode);
                        }
                    }
                    break;
                }
                case 10: {
                    outWriter.write("<!DOCTYPE " + node.getNodeName() + ">\n");
                    break;
                }
                case 1: {
                    NamedNodeMap attribsnode = node.getAttributes();
                    if (stripEmptyNode && attribsnode.getLength() == 0 && !node.hasChildNodes() && node.getNodeValue() == null) break;
                    outWriter.write("<" + node.getNodeName());
                    for (int i = 0; i < attribsnode.getLength(); ++i) {
                        Node attrNode = attribsnode.item(i);
                        String attrValue = attrNode.getNodeValue();
                        if (!stripEmptyNode && attrValue == null) {
                            outWriter.write(basicIndent + attrNode.getNodeName() + "=\"!!!null!!!\"");
                            continue;
                        }
                        if (stripEmptyNode) {
                            if (attrValue.length() == 0) continue;
                            outWriter.write(basicIndent + attrNode.getNodeName() + "=\"" + XMLDOMBuilder.escape(attrValue, true) + "\"");
                            continue;
                        }
                        outWriter.write(basicIndent + attrNode.getNodeName() + "=\"" + XMLDOMBuilder.escape(attrValue, true) + "\"");
                    }
                    if (node.hasChildNodes()) {
                        outWriter.write(">");
                        Node firstChild = node.getFirstChild();
                        Node lastChild = node.getLastChild();
                        for (Node curChild = node.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                            if (curChild.getNodeType() != 3) {
                                if (curChild == firstChild) {
                                    outWriter.write("\n");
                                    XMLDOMBuilder.outputIndentation(outWriter, indent + 1);
                                } else if (curChild.getPreviousSibling() != null && curChild.getPreviousSibling().getNodeType() != 3) {
                                    outWriter.write("\n");
                                    XMLDOMBuilder.outputIndentation(outWriter, indent + 1);
                                }
                            }
                            XMLDOMBuilder.unparse(curChild, outWriter, indent + 1, stripEmptyNode);
                        }
                        if (firstChild.getNodeType() != 3 && lastChild.getNodeType() != 3) {
                            outWriter.write("\n");
                            XMLDOMBuilder.outputIndentation(outWriter, indent);
                        }
                        outWriter.write("</" + node.getNodeName() + ">");
                        break;
                    }
                    outWriter.write(" />");
                    break;
                }
                case 6: {
                    throw new XMLProcessingException("Tag exception : ENTITY");
                }
                case 5: {
                    throw new XMLProcessingException("Tag exception : ENTTIY_REF");
                }
                case 12: {
                    throw new XMLProcessingException("Tag exception : NOTATION");
                }
                case 7: {
                    XMLDOMBuilder.outputIndentation(outWriter, indent);
                    outWriter.write("<?" + node.getNodeName() + basicIndent + node.getNodeValue());
                    if (node.hasChildNodes()) {
                        outWriter.write(">");
                        XMLDOMBuilder.unparse(node.getFirstChild(), outWriter, indent + 1, stripEmptyNode);
                        outWriter.write("\n");
                        XMLDOMBuilder.outputIndentation(outWriter, indent);
                        outWriter.write("</" + node.getNodeName() + ">");
                        break;
                    }
                    outWriter.write(" ?>\n");
                    break;
                }
                case 3: {
                    String nodeValue = node.getNodeValue();
                    if (nodeValue.trim().length() > 0) {
                        outWriter.write(XMLDOMBuilder.escape(nodeValue));
                    }
                    break;
                }
                default: {
                    throw new XMLProcessingException("Tag exception : UNSUPPORTED NODE : " + type);
                }
            }
        }
        catch (Exception e) {
            throw new XMLProcessingException("An error occured while dumping : " + e.getMessage());
        }
    }

    private static void outputIndentation(Writer outWriter, int indent) throws XMLProcessingException {
        try {
            for (int i = 0; i < indent; ++i) {
                outWriter.write(basicIndent);
            }
        }
        catch (IOException ioe) {
            throw new XMLProcessingException("IO error while outputing indentation : " + ioe.getMessage());
        }
    }

    private static Node stripWhiteSpaceNodes(Node node) {
        boolean lastNodeRemoved = false;
        Node curNode = node.getFirstChild();
        while (curNode != null) {
            if (curNode.hasChildNodes()) {
                XMLDOMBuilder.stripWhiteSpaceNodes(curNode);
            }
            if (curNode.getNodeType() == 3 && curNode.getNodeValue() != null && (curNode.getNodeValue().trim().length() == 0 || curNode.getNodeValue().trim().endsWith("\n") || curNode.getNodeValue().trim().startsWith("\n")) && (curNode.getPreviousSibling() != null || curNode.getNextSibling() != null)) {
                node.removeChild(curNode);
                lastNodeRemoved = true;
            }
            curNode = lastNodeRemoved ? node.getFirstChild() : curNode.getNextSibling();
            lastNodeRemoved = false;
        }
        return node;
    }

    private static String escape(String original, boolean escapeQuotes) {
        String str2Return = StringUtils.replaceSubstring(original, "&", "&amp;");
        str2Return = StringUtils.replaceSubstring(str2Return, "<", "&lt;");
        str2Return = StringUtils.replaceSubstring(str2Return, ">", "&gt;");
        if (escapeQuotes) {
            str2Return = StringUtils.replaceSubstring(str2Return, "\"", "&quot;");
        }
        return str2Return;
    }

    private static String escape(String original) {
        return XMLDOMBuilder.escape(original, false);
    }

    static {
        _documentBuilderFactory = null;
        _documentBuilderFactory = DocumentBuilderFactory.newInstance();
        _documentBuilderFactory.setValidating(false);
        _documentBuilderFactory.setIgnoringComments(true);
        _documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        _documentBuilderFactory.setCoalescing(true);
        _documentBuilderFactory.setExpandEntityReferences(true);
        _documentBuilderFactory.setNamespaceAware(true);
    }
}

