/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.socs.SOCSAlarm;
import com.sun.comclient.calendar.socs.SOCSAttendee;
import com.sun.comclient.calendar.socs.SOCSOrganizer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSUtils {
    private static final int MINUTE_2_SECONDS = 60;
    private static final int HOUR_2_MINUTES = 60;
    private static final int HOUR_2_SECONDS = 3600;
    private static final int DAY_2_HOURS = 24;
    private static final int DAY_2_MINUTES = 1440;
    private static final int DAY_2_SECONDS = 86400;
    private static final int WEEK_2_DAYS = 7;
    private static final int WEEK_2_HOURS = 168;
    private static final int WEEK_2_MINUTES = 10080;
    private static final int WEEK_2_SECONDS = 604800;
    private static final int NEGATIVE_SIGN = -1;
    private static final int POSITIVE_SIGN = 1;
    static BitSet dontEncode;
    static final int caseDiff = 32;

    public static long toSeconds(Duration duration) {
        if (null == duration) {
            return 0L;
        }
        return duration.getSign() * (duration.getSeconds() + duration.getMinutes() * 60 + duration.getHours() * 3600 + duration.getDays() * 86400 + duration.getWeeks() * 604800);
    }

    public static Duration toDuration(long seconds) throws PropertiesException {
        int sign = 1;
        if (0L > seconds) {
            seconds = -1L * seconds;
            sign = -1;
        }
        int secs = (int)seconds % 60;
        int minutes = (int)((seconds -= (long)secs) % 3600L) / 60;
        int hours = (int)((seconds -= (long)(minutes * 60)) % 86400L) / 3600;
        int days = (int)(seconds -= (long)(hours * 3600)) / 86400;
        Duration duration = new Duration(days, hours, minutes, secs);
        duration.setSign(sign);
        return duration;
    }

    public static DateTime toEndDate(DateTime date, Duration duration) {
        if (null == date || null == duration) {
            return null;
        }
        DateTime endDate = (DateTime)date.clone();
        int sign = duration.getSign();
        endDate.add(3, sign * duration.getWeeks());
        endDate.add(6, sign * duration.getDays());
        endDate.add(11, sign * duration.getHours());
        endDate.add(12, sign * duration.getMinutes());
        endDate.add(13, sign * duration.getSeconds());
        return endDate;
    }

    public static Duration toDuration(DateTime startDate, DateTime endDate) throws PropertiesException {
        if (null == startDate || null == endDate) {
            return null;
        }
        long millSecsDiff = startDate.getTime().getTime() - endDate.getTime().getTime();
        long secsDiff = millSecsDiff / 1000L;
        return SOCSUtils.toDuration(secsDiff);
    }

    public static String urlEncode(String stringToEncode) {
        String urlEncodedString = null;
        if (stringToEncode == null) {
            return stringToEncode;
        }
        try {
            urlEncodedString = SOCSUtils.URLEncodeField(stringToEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            return stringToEncode;
        }
        return urlEncodedString;
    }

    public static Attach parseToAttach(Properties attachProp) {
        Attach attach = new Attach();
        Enumeration<?> attachPropNames = attachProp.propertyNames();
        while (attachPropNames.hasMoreElements()) {
            String propName = (String)attachPropNames.nextElement();
            String propValue = attachProp.getProperty(propName);
            if (propName.equals("FMTTYPE")) {
                attach.setFileType(propValue);
                continue;
            }
            if (!propName.equals("VALUE")) continue;
            attach.setValue(propValue);
        }
        return attach;
    }

    public static Attendee parseToAttendee(Properties attProp) throws PropertiesException {
        SOCSAttendee attendee = new SOCSAttendee();
        Enumeration<?> attPropNames = attProp.propertyNames();
        while (attPropNames.hasMoreElements()) {
            String propName = (String)attPropNames.nextElement();
            String propValue = attProp.getProperty(propName);
            if (propName.equals("ROLE")) {
                attendee.setRole(propValue);
                continue;
            }
            if (propName.equals("CUTYPE")) {
                attendee.setUserType(propValue);
                continue;
            }
            if (propName.equals("PARTSTAT")) {
                attendee.setParticipantStatus(propValue);
                continue;
            }
            if (propName.equals("CN")) {
                attendee.setCommonName(propValue);
                continue;
            }
            if (propName.equals("RSVP")) {
                if (propValue.equalsIgnoreCase("TRUE")) {
                    attendee.setRSVPRequired(true);
                    continue;
                }
                attendee.setRSVPRequired(false);
                continue;
            }
            if (propName.equals("DELEGATED-FROM")) {
                attendee.setDelegatedFrom(propValue);
                continue;
            }
            if (propName.equals("DELEGATED-TO")) {
                attendee.setDelegatedTo(propValue);
                continue;
            }
            if (propName.equals("LANGUAGE")) {
                attendee.setLanguage(propValue);
                continue;
            }
            if (propName.equals("SENTBY")) {
                attendee.setSentBy(propValue);
                continue;
            }
            if (propName.equals("DIR")) {
                attendee.setDir(propValue);
                continue;
            }
            if (propName.equals("MEMBER")) {
                attendee.setMember(propValue);
                continue;
            }
            if (propName.equals("ATTENDEE")) {
                attendee.setValue(propValue);
                continue;
            }
            if (!propName.equals("X-S1CS-EMAIL")) continue;
            attendee.setEmail(propValue);
        }
        return attendee;
    }

    public static String parseAttendeeToSOCS(Attendee attendee) throws PropertiesException {
        StringBuffer wcapFormat = new StringBuffer("");
        String temp = attendee.getRole();
        if (null != temp) {
            wcapFormat.append("ROLE=" + temp + "^");
        }
        if (null != (temp = attendee.getUserType())) {
            wcapFormat.append("CUTYPE=" + temp + "^");
        }
        if (null == (temp = attendee.getParticipantStatus())) {
            PropertiesException pe = new PropertiesException(3);
            throw pe;
        }
        wcapFormat.append("PARTSTAT=" + temp + "^");
        temp = attendee.getCommonName();
        if (null != temp) {
            wcapFormat.append("CN=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (attendee.isRSVPRequired()) {
            wcapFormat.append("RSVP=TRUE^");
        } else {
            wcapFormat.append("RSVP=FALSE^");
        }
        temp = attendee.getDelegatedFrom();
        if (null != temp) {
            wcapFormat.append("DELEGATED-FROM=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (null != (temp = attendee.getDelegatedTo())) {
            wcapFormat.append("DELEGATED-TO=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (null != (temp = attendee.getLanguage())) {
            wcapFormat.append("LANGUAGE=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (null != (temp = attendee.getSentBy())) {
            wcapFormat.append("SENTBY=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (null != (temp = attendee.getDir())) {
            wcapFormat.append("DIR=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (null != (temp = attendee.getMember())) {
            wcapFormat.append("MEMBER=" + SOCSUtils.urlEncode(temp) + "^");
        }
        if (null == (temp = attendee.getValue())) {
            PropertiesException pe = new PropertiesException(3);
            throw pe;
        }
        wcapFormat.append(SOCSUtils.urlEncode(temp));
        return wcapFormat.toString();
    }

    public static Organizer parseToOrganizer(Properties orgProp) {
        SOCSOrganizer organizer = new SOCSOrganizer();
        Enumeration<?> orgPropNames = orgProp.propertyNames();
        while (orgPropNames.hasMoreElements()) {
            String propName = (String)orgPropNames.nextElement();
            String propValue = orgProp.getProperty(propName);
            if (propName.equals("CN")) {
                organizer.setCommonName(propValue);
                continue;
            }
            if (propName.equals("LANGUAGE")) {
                organizer.setLanguage(propValue);
                continue;
            }
            if (propName.equals("X-NSCP-ORGANIZER-SENT-BY-UID")) {
                organizer.setSentBy(propValue);
                continue;
            }
            if (propName.equals("X-NSCP-ORGANIZER-UID")) {
                organizer.setDir(propValue);
                continue;
            }
            if (propName.equals("X-S1CS-EMAIL")) {
                organizer.setEmail(propValue);
                continue;
            }
            if (!propName.equals("ORGANIZER")) continue;
            organizer.setValue(propValue);
        }
        return organizer;
    }

    public static SOCSAlarm parseToVAlarm(Properties alarmProp) throws PropertiesException {
        SOCSAlarm alarm = new SOCSAlarm();
        Enumeration<?> alarmPropNames = alarmProp.propertyNames();
        while (alarmPropNames.hasMoreElements()) {
            String propName = (String)alarmPropNames.nextElement();
            String propValue = alarmProp.getProperty(propName);
            if (propName.equals("DESC")) {
                alarm.setDescription(propValue);
                continue;
            }
            if (propName.equals("ACTION")) {
                alarm.setAction(propValue);
                continue;
            }
            if (propName.equals("ATTENDEE")) {
                Object attObj = alarmProp.get(propName);
                if (!(attObj instanceof ArrayList)) continue;
                ArrayList col = (ArrayList)attObj;
                int len = col.size();
                for (int i = 0; i < len; ++i) {
                    Properties attProp = (Properties)col.get(i);
                    Attendee attendee = SOCSUtils.parseToAttendee(attProp);
                    alarm.addAttendee(attendee);
                }
                continue;
            }
            if (!propName.equals("TRIGGER")) continue;
            boolean isDateTime = false;
            Properties triggerProp = (Properties)alarmProp.get(propName);
            Enumeration<?> triggerPropNames = triggerProp.propertyNames();
            while (triggerPropNames.hasMoreElements()) {
                String triggerPropName = (String)triggerPropNames.nextElement();
                String triggerPropValue = triggerProp.getProperty(triggerPropName);
                if (triggerPropName.equals("VALUE")) {
                    if (triggerPropValue.equals("DATE-TIME")) {
                        isDateTime = true;
                        continue;
                    }
                    isDateTime = false;
                    continue;
                }
                if (!triggerPropName.equals("TRIGGER")) continue;
                if (isDateTime) {
                    alarm.setAbsTrigger(triggerPropValue);
                    continue;
                }
                alarm.setTrigger(new Duration(triggerPropValue));
            }
        }
        return alarm;
    }

    public static String parseRecurrencePatternToSOCS(RecurrencePattern rpat) {
        String wcapFormat = "\"" + SOCSUtils.urlEncode(rpat.generatePattern()) + "\"";
        return wcapFormat;
    }

    public static boolean isDateAllDay(String dtStr) {
        int idx = dtStr.indexOf("T");
        return idx <= 0;
    }

    public static boolean isUserOrganizer(String thisUserCalId, Organizer organizer) {
        if (organizer == null) {
            return true;
        }
        String orgValue = organizer.getValue().trim();
        return thisUserCalId.trim().equals(orgValue);
    }

    public static boolean isBitSet(int flags, int bitLocation) {
        return 0 != (flags & bitLocation);
    }

    public static int getSOCSStatus(String status) {
        if ((status = status.toUpperCase()).equals("CONFIRMED")) {
            return 0;
        }
        if (status.equals("CANCELLED")) {
            return 1;
        }
        if (status.equals("TENTATIVE")) {
            return 2;
        }
        if (status.equals("NEEDS-ACTION")) {
            return 3;
        }
        if (status.equals("COMPLETED")) {
            return 4;
        }
        if (status.equals("IN-PROCESS")) {
            return 5;
        }
        if (status.equals("DRAFT")) {
            return 6;
        }
        if (status.equals("FINAL")) {
            return 7;
        }
        return 0;
    }

    public static int getSOCSTransp(String transp) {
        if ((transp = transp.toUpperCase()).equals("OPAQUE")) {
            return 0;
        }
        if (transp.equals("TRANSPARENT")) {
            return 1;
        }
        return 0;
    }

    public static String URLEncodeField(String input, String enc) throws UnsupportedEncodingException {
        int inputLen = input.length();
        byte[] byteOut = input.getBytes(enc);
        StringBuffer result = new StringBuffer(inputLen * 4);
        for (int i = 0; i < byteOut.length; ++i) {
            int c = byteOut[i] & 0xFF;
            if (dontEncode.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                result.append((char)c);
                continue;
            }
            result.append('%');
            char ch = Character.forDigit(c >> 4 & 0xF, 16);
            if ('a' <= ch && ch <= 'f') {
                ch = (char)(ch - 32);
            }
            result.append(ch);
            ch = Character.forDigit(c & 0xF, 16);
            if ('a' <= ch && ch <= 'f') {
                ch = (char)(ch - 32);
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static DateTime parseToAllDayDateTime(String value, TimeZone tz) {
        if (value == null || tz == null) {
            return null;
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(4, 6)) - 1;
        int day = Integer.parseInt(value.substring(6, 8));
        DateTime tempDate = new DateTime(tz);
        tempDate.set(year, month, day);
        return tempDate;
    }

    public static String parseAllDayDateTimeToSOCS(DateTime allDayDate) {
        StringBuffer dateString = new StringBuffer("");
        int year = allDayDate.getYear();
        int month = allDayDate.getMonth() + 1;
        int day = allDayDate.getDay();
        dateString.append(year);
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month);
        if (day < 10) {
            dateString.append("0");
        }
        dateString.append(day);
        return dateString.toString();
    }

    public static String trim(String value) {
        if (value == null) {
            return value;
        }
        for (value = value.trim(); value != null && value.startsWith("\n"); value = value.substring(1)) {
        }
        while (value != null && value.endsWith("\n")) {
            value = value.substring(0, value.length());
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int versionToInt(String version) throws NumberFormatException {
        int count = 0;
        if (version == null) throw new NumberFormatException();
        if (version.length() <= 0) throw new NumberFormatException();
        char[] oldVerChars = version.toCharArray();
        if (oldVerChars == null) throw new NumberFormatException();
        if (oldVerChars.length <= 0) throw new NumberFormatException();
        for (int k = 0; k < oldVerChars.length; ++k) {
            if (oldVerChars[k] != '.') continue;
            ++count;
        }
        char[] newVersChar = new char[oldVerChars.length - count];
        int j = 0;
        for (int i = 0; i < oldVerChars.length; ++i) {
            if (oldVerChars[i] == '.') continue;
            newVersChar[j] = oldVerChars[i];
            ++j;
        }
        if (newVersChar == null) throw new NumberFormatException();
        if (newVersChar.length <= 0) throw new NumberFormatException();
        String newVer = String.valueOf(newVersChar);
        newVer.trim();
        return Integer.parseInt(newVer);
    }

    static {
        int i;
        dontEncode = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontEncode.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontEncode.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontEncode.set(i);
        }
        dontEncode.set(32);
        dontEncode.set(45);
        dontEncode.set(95);
        dontEncode.set(46);
        dontEncode.set(42);
    }
}

