/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSRequest;
import com.sun.comclient.calendar.socs.SOCSResponse;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class SOCSSession {
    private SOCSCalendarStore calStore;
    private String sessionID;
    private String userID;
    private String calendarID;
    private Properties userPrefs;
    private Properties serverPrefs;
    private TimeZone timezone;
    private String userName;
    private String password;
    private String proxyUser;

    public static SOCSSession getInstance(SOCSCalendarStore calStore) {
        return new SOCSSession(calStore, null, null, null, null, null, null);
    }

    private SOCSSession(SOCSCalendarStore calStore, String sessionID, String userID, String calendarID, String username, String password, String proxyUser) {
        this.calStore = calStore;
        this.sessionID = sessionID;
        this.userID = userID;
        this.calendarID = calendarID;
        this.userName = username;
        this.password = password;
        this.proxyUser = proxyUser;
    }

    public static SOCSSession login(SOCSCalendarStore calStore, String username, String password, String proxyUser) throws CalendarException {
        SOCSSession session;
        SOCSRequest request = new SOCSRequest(calStore);
        try {
            SOCSResponse response = request.login(username, password, proxyUser);
            Properties props = response.getProperties(0);
            session = new SOCSSession(calStore, props.getProperty("SESSION-ID"), props.getProperty("USER-ID"), props.getProperty("CALENDAR-ID"), username, password, proxyUser);
            session.refresh();
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        return session;
    }

    void validate() throws SOCSException {
        URL serviceURL = this.calStore.getServiceURL();
        SOCSRequest request = new SOCSRequest(serviceURL, this);
        SOCSResponse response = request.login(this.userName, this.password, this.proxyUser);
        Properties props = response.getProperties(0);
        this.sessionID = props.getProperty("SESSION-ID");
    }

    public void logout() {
        SOCSRequest request = new SOCSRequest(this);
        try {
            SOCSResponse response = request.logout();
        }
        catch (SOCSException e) {
            return;
        }
        this.calStore = null;
        this.sessionID = null;
        this.userID = null;
        this.calendarID = null;
        this.userPrefs = null;
        this.serverPrefs = null;
        this.userName = null;
        this.password = null;
        this.proxyUser = null;
    }

    public boolean isValid() {
        SOCSResponse response;
        SOCSRequest request = new SOCSRequest(this);
        try {
            response = request.isSOCSSessionValid();
        }
        catch (SOCSException e) {
            return false;
        }
        String check_id = null;
        Properties wcapProp = response.getProperties(0);
        if (wcapProp == null || wcapProp.isEmpty()) {
            return false;
        }
        check_id = wcapProp.getProperty("CHECK-ID");
        if (check_id == null) {
            return false;
        }
        return check_id.equals("1");
    }

    public void refresh() throws CalendarException {
        SOCSResponse response;
        if (this.calStore == null) {
            throw new IllegalStateException("SOCSSession has been closed");
        }
        SOCSRequest request = new SOCSRequest(this);
        try {
            response = request.getUserPrefs();
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        this.userPrefs = response.getProperties(2);
        this.serverPrefs = response.getProperties(3);
        if (this.getPreference("icsTimezone") != null) {
            TimeZone tz = TimeZone.getTimeZone(this.getPreference("icsTimezone").trim());
            this.setTimeZone(tz);
        }
    }

    public void update() throws CalendarException {
        if (this.calStore == null) {
            throw new IllegalStateException("SOCSSession has been closed");
        }
        SOCSRequest request = new SOCSRequest(this);
        try {
            SOCSResponse response = request.setUserPrefs(this.userPrefs);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
    }

    public String getDefaultCalendar() {
        return this.calendarID;
    }

    public SOCSCalendarStore getCalStore() {
        return this.calStore;
    }

    public String getID() {
        return this.sessionID;
    }

    public String getUserName() {
        return this.userID;
    }

    public String getCalendarID() {
        return this.calendarID;
    }

    public String getPreference(String name) {
        return this.userPrefs == null ? null : this.userPrefs.getProperty(name);
    }

    public Properties getPreferences() {
        return this.userPrefs;
    }

    public void setPreferences(Properties preferences) {
        this.userPrefs = preferences;
    }

    public String getServerPreference(String name) {
        return this.serverPrefs == null ? null : this.serverPrefs.getProperty(name);
    }

    public Properties getServerPreferences() {
        return this.serverPrefs;
    }

    public void setServerPreferences(Properties preferences) {
        this.serverPrefs = preferences;
    }

    public TimeZone getTimeZone() {
        if (this.timezone == null) {
            this.timezone = TimeZone.getDefault();
        }
        return this.timezone;
    }

    public void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public String toString() {
        return "SOCSSession[sessionID=" + this.sessionID + " userID=" + this.userID + " calendarID=" + this.calendarID + "]";
    }

    public Vector getSubscribedCalendars() {
        Vector<SOCSCalendar> calendars = new Vector<SOCSCalendar>();
        if (this.userPrefs == null) {
            return calendars;
        }
        String calListStr = this.userPrefs.getProperty("icsSubscribed");
        if (calListStr == null) {
            return calendars;
        }
        StringTokenizer strtok = new StringTokenizer(calListStr.trim(), ",");
        while (strtok.hasMoreTokens()) {
            SOCSCalendar cal = null;
            String calname = strtok.nextToken();
            StringTokenizer stTok = new StringTokenizer(calname, "$");
            String displayName = "";
            Object uid = null;
            if (!stTok.hasMoreTokens()) continue;
            String calId = stTok.nextToken();
            if (stTok.hasMoreTokens()) {
                displayName = stTok.nextToken();
            }
            cal = new SOCSCalendar(this.getCalStore(), calId, displayName);
            calendars.addElement(cal);
        }
        return calendars;
    }

    public Vector getSubscribedGroups() {
        Vector<SOCSCalendar> groups = new Vector<SOCSCalendar>();
        try {
            if (this.userPrefs == null) {
                return groups;
            }
            String groupListStr = this.userPrefs.getProperty("icsSet");
            if (groupListStr == null) {
                return groups;
            }
            StringTokenizer strtok = new StringTokenizer(groupListStr.trim(), ",");
            while (strtok.hasMoreTokens()) {
                SOCSCalendar group = null;
                String groupString = strtok.nextToken();
                StringTokenizer stTok = new StringTokenizer(groupString, "$");
                HashMap<String, String> prop = new HashMap<String, String>();
                while (stTok.hasMoreTokens()) {
                    String groupDetail = stTok.nextToken();
                    StringTokenizer sTok = new StringTokenizer(groupDetail, "=");
                    String key = null;
                    String value = null;
                    if (!sTok.hasMoreTokens()) continue;
                    key = sTok.nextToken();
                    if (sTok.hasMoreTokens()) {
                        value = sTok.nextToken();
                    }
                    prop.put(key, value);
                }
                try {
                    String groupName = null;
                    String calendarList = null;
                    String tzmode = null;
                    String tz = null;
                    String mergeInDayView = null;
                    String description = null;
                    Object obj = prop.get("name");
                    if (obj != null) {
                        groupName = obj.toString();
                    }
                    if ((obj = prop.get("calendar")) != null) {
                        calendarList = obj.toString();
                    }
                    if ((obj = prop.get("tzmode")) != null) {
                        tzmode = obj.toString();
                    }
                    if ((obj = prop.get("tz")) != null) {
                        tz = obj.toString();
                    }
                    if ((obj = prop.get("mergeInDayView")) != null) {
                        mergeInDayView = obj.toString();
                    }
                    if ((obj = prop.get("description")) != null) {
                        description = obj.toString();
                    }
                    group = new SOCSCalendar(null, calendarList, groupName);
                    groups.addElement(group);
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return groups;
    }

    public Vector searchForCalendars(String searchString, int searchOption, int maxResults) throws CalendarStoreException {
        return this.searchForCalendars(searchString, searchOption, maxResults, null);
    }

    public Vector searchForCalendars(String searchString, int searchOption, int maxResults, Properties requestProperties) throws CalendarStoreException {
        SOCSResponse response;
        SOCSRequest request = new SOCSRequest(this);
        Vector searchCalendars = new Vector();
        try {
            response = request.searchCalendars(searchString, searchOption, maxResults, requestProperties);
        }
        catch (SOCSException ex) {
            if (ex.getError() == 1) {
                try {
                    this.validate();
                    response = request.searchCalendars(searchString, searchOption, maxResults, requestProperties);
                }
                catch (SOCSException e) {
                    throw new CalendarStoreException(e.getMessage(), e.getError());
                }
            }
            throw new CalendarStoreException(ex.getMessage(), ex.getError());
        }
        searchCalendars = response.getCalendars();
        return searchCalendars;
    }

    public SOCSCalendar createCalendar(String cid, Properties props) throws CalendarStoreException {
        SOCSResponse response;
        SOCSRequest request = new SOCSRequest(this);
        SOCSCalendar newCal = null;
        try {
            response = request.createCalendar(cid, props);
        }
        catch (SOCSException ex) {
            if (ex.getError() == 1) {
                try {
                    this.validate();
                    response = request.createCalendar(cid, props);
                }
                catch (SOCSException e) {
                    throw new CalendarStoreException(e.getMessage(), e.getError());
                }
            }
            throw new CalendarStoreException(ex.getMessage(), ex.getError());
        }
        newCal = response.getFirstCalendar();
        return newCal;
    }

    public void deleteCalendar(String cid) throws CalendarStoreException {
        SOCSRequest request = new SOCSRequest(this);
        try {
            SOCSResponse response = request.deleteCalendar(cid);
        }
        catch (SOCSException ex) {
            if (ex.getError() == 1) {
                try {
                    this.validate();
                    SOCSResponse response = request.deleteCalendar(cid);
                }
                catch (SOCSException e) {
                    throw new CalendarStoreException(e.getMessage(), e.getError());
                }
            }
            throw new CalendarStoreException(ex.getMessage(), ex.getError());
        }
    }
}

