/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSParser;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;
import org.xml.sax.SAXException;

public class SOCSRequest {
    private URL serviceURL;
    private SOCSSession session;
    private SOCSCalendarStore store = null;
    private static String EVENT = "event";
    private static String TODO = "todo";
    private static String ALL = "all";
    private static String WCAP_ERROR_ICAL_FORMAT = "X-NSCP-WCAP-ERRNO:";
    private static String WCAP_ERROR_XML_FORMAT_START_TAG = "<X-NSCP-WCAP-ERRNO>";
    private static String WCAP_ERROR_HTMLJS_FORMAT = "var errno=";
    private static String WCAP_ERROR_XML_FORMAT_END_TAG = "</X-NSCP-WCAP-ERRNO>";
    private static String BOUNDARY = "---------------------------jcapiset001";
    private static int READ_AHEAD_LIMIT = 700;
    private static int MAXIMUM_BYTES_TO_CHECK_FOR_ERROR = 500;
    private static final transient String STRING_VALUE_ONE = "1";
    private static final transient String STRING_VALUE_ZERO = "0";
    private static final String PASSWORD_URL_ARG = "password=";
    private static final int PASSWORD_URL_ARG_LENGTH = "password=".length();
    private static final String AMP = "&";
    private static final String PASSWORD_MASK = "***";

    SOCSRequest(SOCSCalendarStore store) {
        this(store.getServiceURL(), null);
        this.store = store;
    }

    SOCSRequest(SOCSSession session) {
        this(session.getCalStore().getServiceURL(), session);
        this.store = session.getCalStore();
    }

    SOCSRequest(URL serviceURL, SOCSSession session) {
        if (serviceURL == null) {
            throw new IllegalArgumentException();
        }
        this.serviceURL = serviceURL;
        this.session = session;
        if (session != null) {
            this.store = session.getCalStore();
        }
    }

    HttpURLConnection postRequest(String command, ArrayList args) throws MalformedURLException, IOException {
        HttpURLConnection conn = null;
        StringBuffer urlargs = new StringBuffer(256);
        urlargs.append("?");
        if (null != args) {
            for (int i = 0; i < args.size(); ++i) {
                urlargs.append((String)args.get(i) + AMP);
            }
        }
        urlargs = urlargs.deleteCharAt(urlargs.length() - 1);
        try {
            conn = this.makePostRequest(this.serviceURL, command + urlargs);
            if (conn != null) {
                return conn;
            }
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException io) {
            throw io;
        }
        return conn;
    }

    private HttpURLConnection setExportMIMEHeaders(HttpURLConnection conn) throws IOException {
        conn.setRequestProperty("Content-type", "multipart/form-data; boundary=" + BOUNDARY);
        DataOutputStream outStream = null;
        outStream = new DataOutputStream(conn.getOutputStream());
        outStream.writeBytes("--" + BOUNDARY + "\r\n");
        return conn;
    }

    private HttpURLConnection setImportMIMEHeadersAndData(HttpURLConnection conn, String contentFormat, InputStream inStream) throws IOException {
        conn.setRequestProperty("Content-type", "multipart/form-data; boundary=" + BOUNDARY);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        outStream.writeBytes("--" + BOUNDARY + "\r\n");
        outStream.writeBytes("Content-type: " + contentFormat + "; ");
        outStream.writeBytes("\r\n");
        outStream.writeBytes("Content-disposition: form-data; ");
        outStream.writeBytes("filename=\"jcapi-import\" ");
        outStream.writeBytes("\r\n");
        outStream.writeBytes("\r\n");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        String buffer = null;
        while ((buffer = reader.readLine()) != null) {
            byte[] bytes = buffer.getBytes("UTF-8");
            outStream.write(bytes, 0, bytes.length);
            outStream.writeBytes("\r\n");
        }
        outStream.writeBytes("\r\n--" + BOUNDARY + "--" + "\r\n");
        return conn;
    }

    private int obtainWCAPError(BufferedReader reader) throws IOException {
        String buf = null;
        int wcapError = -1;
        int bytesRead = 0;
        reader.mark(READ_AHEAD_LIMIT);
        while ((buf = reader.readLine()) != null) {
            if ((bytesRead += buf.length()) <= MAXIMUM_BYTES_TO_CHECK_FOR_ERROR) {
                if (buf.startsWith(WCAP_ERROR_ICAL_FORMAT)) {
                    wcapError = Integer.parseInt(buf.substring(WCAP_ERROR_ICAL_FORMAT.length()));
                    break;
                }
                if (buf.startsWith(WCAP_ERROR_XML_FORMAT_START_TAG)) {
                    String wcapErrCodeTag = buf.substring(WCAP_ERROR_XML_FORMAT_START_TAG.length());
                    wcapError = Integer.parseInt(wcapErrCodeTag.substring(0, wcapErrCodeTag.indexOf(WCAP_ERROR_XML_FORMAT_END_TAG)));
                    break;
                }
                if (!buf.startsWith(WCAP_ERROR_HTMLJS_FORMAT)) continue;
                wcapError = Integer.parseInt(buf.substring(WCAP_ERROR_HTMLJS_FORMAT.length()));
                break;
            }
            if (wcapError != -1) break;
            wcapError = 0;
            break;
        }
        reader.reset();
        return wcapError;
    }

    private HttpURLConnection makePostRequest(URL serviceURL, String params) throws MalformedURLException, IOException {
        URL urltoConnect = null;
        HttpURLConnection connection = null;
        try {
            urltoConnect = new URL(serviceURL, params);
            connection = (HttpURLConnection)urltoConnect.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return connection;
    }

    private BufferedReader sendPostCommand(HttpURLConnection connection) throws IOException {
        BufferedReader response = null;
        if (connection != null) {
            connection.connect();
            response = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        }
        return response;
    }

    SOCSResponse request(String command, ArrayList args) throws SOCSException {
        return this.request(command, args, null);
    }

    SOCSResponse request(String command, ArrayList args, Properties props) throws SOCSException {
        SOCSResponse response;
        StringBuffer urlargs = new StringBuffer(256);
        URL url = null;
        String isPost = null;
        if (this.store != null) {
            isPost = this.store.getSession().getProperty("cal.http.usepost");
        }
        if (null == isPost || !isPost.equalsIgnoreCase("true")) {
            urlargs.append("?");
        }
        if (null != args) {
            for (int i = 0; i < args.size(); ++i) {
                urlargs.append((String)args.get(i) + AMP);
            }
        }
        urlargs.append("fmt-out=text/xml");
        try {
            SOCSParser parser = new SOCSParser(this.session);
            parser.setParsingProperties(props);
            if (isPost != null && isPost.equalsIgnoreCase("true")) {
                InputStream output = this.requestUsingPost(command, urlargs.toString());
                response = parser.parse(output);
            } else {
                url = new URL(this.serviceURL, command + urlargs);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                if (command.equalsIgnoreCase("get_freebusy.wcap")) {
                    // empty if block
                }
                conn.setInstanceFollowRedirects(true);
                InputStream httpresponse = conn.getInputStream();
                response = parser.parse(httpresponse);
            }
        }
        catch (ConnectException ce) {
            throw new SOCSException("Invalid Calendar Server name or port", 108);
        }
        catch (UnknownHostException uhe) {
            throw new SOCSException("Invalid Calendar Server name or port", 100);
        }
        catch (FileNotFoundException e1) {
            throw new SOCSException(" Unauthorized access to resource ", 101);
        }
        catch (SAXException saxe) {
            String exStr = "Parse error: " + command + urlargs + ": " + saxe;
            throw new SOCSException(SOCSRequest.maskPassword(exStr), 113);
        }
        catch (Exception e) {
            String exStr = "SOCS request failed: " + command + urlargs + ": " + e;
            throw new SOCSException(SOCSRequest.maskPassword(exStr), 104);
        }
        return response;
    }

    InputStream requestUsingPost(String command, String args) throws MalformedURLException, IOException {
        InputStream postResponse = null;
        HttpURLConnection conn = null;
        URL url = new URL(this.serviceURL, command);
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (command.equalsIgnoreCase("get_freebusy.wcap")) {
            // empty if block
        }
        conn.setInstanceFollowRedirects(true);
        conn.setRequestMethod("POST");
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(args);
        wr.flush();
        postResponse = conn.getInputStream();
        wr.close();
        return postResponse;
    }

    SOCSResponse login(String username, String password, String proxyUser) throws SOCSException {
        SOCSResponse response;
        if (username == null) {
            throw new SOCSException("null username", 105);
        }
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("user=" + SOCSUtils.urlEncode(username));
        if (password != null) {
            args.add(PASSWORD_URL_ARG + SOCSUtils.urlEncode(password));
        }
        if (proxyUser != null) {
            args.add("proxyauth=" + SOCSUtils.urlEncode(proxyUser));
        }
        if ((response = this.request("login.wcap", args)).getErrorNum() != 0 && response.getErrorNum() != 2) {
            throw new SOCSException(" login.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse logout() throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("id=" + this.session.getID());
        SOCSResponse response = this.request("logout.wcap", args);
        if (response.getErrorNum() != 0 && response.getErrorNum() != -1) {
            throw new SOCSException("logout.wcap failed " + response.getErrorNum(), 106);
        }
        return response;
    }

    SOCSResponse isSOCSSessionValid() throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("id=" + this.session.getID());
        SOCSResponse response = this.request("check_id.wcap", args);
        if (response.getErrorNum() > -1 && response.getErrorNum() != 0) {
            throw new SOCSException("check_id.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse getUserPrefs() throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("id=" + this.session.getID());
        SOCSResponse response = this.request("get_userprefs.wcap", args);
        if (response.getErrorNum() != 0) {
            throw new SOCSException("get_userprefs.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse setUserPrefs(Properties props) throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("id=" + this.session.getID());
        SOCSResponse response = this.request("set_userprefs.wcap", args);
        if (response.getErrorNum() != 0) {
            throw new SOCSException("set_userprefs.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse getCalProps(String calid) throws SOCSException {
        SOCSResponse response;
        if (this.session.getID() == null && calid == null) {
            throw new SOCSException("null session.getID() & calid", 109);
        }
        ArrayList<String> args = new ArrayList<String>(2);
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        if (calid != null) {
            args.add("calid=" + calid);
        }
        if ((response = this.request("get_calprops.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("get_calprops.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse setCalProps(String calid, Properties props) throws SOCSException {
        SOCSResponse response;
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        if (null == calid) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("id=" + this.session.getID());
        args.add("calid=" + calid);
        if (null != props) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                args.add(key + "=" + SOCSUtils.urlEncode(props.getProperty(key)));
            }
        }
        if ((response = this.request("set_calprops.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("set_calprops.wcap failed", response.getErrorNum());
        }
        return response;
    }

    public SOCSResponse fetchEventsTodos(String calid, DateTime dtstart, DateTime dtend, Properties parsingProps, int compTypes) throws SOCSException {
        SOCSResponse response;
        TimeZone tz;
        if (null == calid) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (null != this.session.getID()) {
            args.add("id=" + this.session.getID());
        }
        if (null != calid) {
            args.add("calid=" + SOCSUtils.urlEncode(calid));
        }
        if (null != dtstart) {
            args.add("dtstart=" + dtstart.toISO8601());
        }
        if (null != dtend) {
            args.add("dtend=" + dtend.toISO8601());
        }
        if (this.isBitSet(compTypes, 1) && this.isBitSet(compTypes, 2)) {
            args.add("component-type=all");
        } else if (this.isBitSet(compTypes, 1)) {
            args.add("component-type=event");
        } else if (this.isBitSet(compTypes, 2)) {
            args.add("component-type=todo");
        } else {
            throw new SOCSException(": requested fetch component types \"" + compTypes + "\" found to be invalid. -- Not a mask of ICalendar.VEVENT or ICalendar.VTODO or both", 105);
        }
        args.add("relativealarm=4");
        String isCompressed = null;
        String getInviteCount = null;
        String timeZoneId = null;
        String compstate = null;
        String isRecurring = null;
        if (parsingProps != null) {
            isCompressed = (String)parsingProps.get("cal.socs.compressed");
            getInviteCount = (String)parsingProps.get("cal.socs.invitecount");
            timeZoneId = (String)parsingProps.get("cal.socs.preferredTimezone");
            compstate = (String)parsingProps.get("cal.socs.compstate");
            isRecurring = (String)parsingProps.get("cal.socs.recurring");
        }
        if (null == isCompressed) {
            isCompressed = this.session.getCalStore().getSession().getProperty("cal.socs.compressed");
        }
        if (null == compstate) {
            compstate = this.session.getCalStore().getSession().getProperty("cal.socs.compstate");
        }
        if (null == isRecurring) {
            isRecurring = this.session.getCalStore().getSession().getProperty("cal.socs.recurring");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (timeZoneId != null && timeZoneId.length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        if (compstate != null && compstate.length() > 0) {
            args.add("compstate=" + compstate);
        }
        if (null != isCompressed && isCompressed.equalsIgnoreCase("true")) {
            args.add("compressed=1");
        }
        if (null != isRecurring && isRecurring.equalsIgnoreCase("true")) {
            args.add("recurring=1");
        }
        if (null != getInviteCount && getInviteCount.equalsIgnoreCase("true")) {
            args.add("invitecount=1");
        }
        if ((response = this.request("fetchcomponents_by_range.wcap", args, parsingProps)).getErrorNum() != 0) {
            throw new SOCSException(" fetchcomponents_by_range.wcap failed", response.getErrorNum());
        }
        return response;
    }

    public SOCSResponse searchEvents(String calid, DateTime dtStart, DateTime dtEnd, String filter, int searchOpts, Properties parsingProperties) throws SOCSException {
        TimeZone tz;
        if (null == calid) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (null != this.session.getID()) {
            args.add("id=" + this.session.getID());
        }
        if (null != calid) {
            args.add("calid=" + SOCSUtils.urlEncode(calid));
        }
        if (null != dtStart) {
            args.add("dtstart=" + dtStart.toISO8601());
        }
        if (null != dtEnd) {
            args.add("dtend=" + dtEnd.toISO8601());
        }
        if (null != filter) {
            args.add("filter=" + SOCSUtils.urlEncode(filter));
        }
        if (-1 != searchOpts) {
            args.add("searchOpts=" + searchOpts);
        }
        String isCompressed = null;
        String timeZoneId = null;
        String compstate = null;
        if (parsingProperties != null) {
            isCompressed = (String)parsingProperties.get("cal.socs.compressed");
            timeZoneId = (String)parsingProperties.get("cal.socs.preferredTimezone");
            compstate = (String)parsingProperties.get("cal.socs.compstate");
        }
        if (isCompressed == null) {
            isCompressed = this.session.getCalStore().getSession().getProperty("cal.socs.compressed");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (compstate == null) {
            compstate = this.session.getCalStore().getSession().getProperty("cal.socs.compstate");
        }
        if (null != isCompressed && isCompressed.equalsIgnoreCase("true")) {
            args.add("compressed=1");
        }
        if (timeZoneId != null && timeZoneId.length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        if (compstate != null && compstate.length() > 0) {
            args.add("compstate=" + compstate);
        }
        args.add("component-type=event");
        args.add("relativealarm=4");
        SOCSResponse response = this.request("fetchcomponents_by_range.wcap", args, parsingProperties);
        if (response.getErrorNum() != 0) {
            throw new SOCSException(" fetchcomponents_by_range.wcap failed", response.getErrorNum());
        }
        return response;
    }

    public SOCSResponse searchTodos(String calid, DateTime dtStart, DateTime dtEnd, String filter, int searchOpts, Properties parsingProperties) throws SOCSException {
        TimeZone tz;
        if (null == calid) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (null != this.session.getID()) {
            args.add("id=" + this.session.getID());
        }
        if (null != calid) {
            args.add("calid=" + SOCSUtils.urlEncode(calid));
        }
        if (null != dtStart) {
            args.add("dtstart=" + dtStart.toISO8601());
        }
        if (null != dtEnd) {
            args.add("dtend=" + dtEnd.toISO8601());
        }
        if (null != filter) {
            args.add("filter=" + SOCSUtils.urlEncode(filter));
        }
        if (-1 != searchOpts) {
            args.add("searchOpts=" + searchOpts);
        }
        String isCompressed = null;
        String timeZoneId = null;
        String compstate = null;
        if (parsingProperties != null) {
            isCompressed = (String)parsingProperties.get("cal.socs.compressed");
            timeZoneId = (String)parsingProperties.get("cal.socs.preferredTimezone");
            compstate = (String)parsingProperties.get("cal.socs.compstate");
        }
        if (isCompressed == null) {
            isCompressed = this.session.getCalStore().getSession().getProperty("cal.socs.compressed");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (compstate == null) {
            compstate = this.session.getCalStore().getSession().getProperty("cal.socs.compstate");
        }
        if (null != isCompressed && isCompressed.equalsIgnoreCase("true")) {
            args.add("compressed=1");
        }
        if (timeZoneId != null && timeZoneId.length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        if (compstate != null && compstate.length() > 0) {
            args.add("compstate=" + compstate);
        }
        args.add("component-type=todo");
        args.add("relativealarm=4");
        SOCSResponse response = this.request("fetchcomponents_by_range.wcap", args);
        if (response.getErrorNum() != 0) {
            throw new SOCSException(" fetchcomponents_by_range.wcap failed", response.getErrorNum());
        }
        return response;
    }

    public SOCSResponse fetchEventsTodos(String calid, String uid, String rid, String modifier, Properties parsingProperties, boolean flag) throws SOCSException {
        TimeZone tz;
        if (null == calid) {
            throw new SOCSException("null calid", 110);
        }
        if (null == uid) {
            throw new SOCSException("null uid", 105);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (null != this.session.getID()) {
            args.add("id=" + this.session.getID());
        }
        if (null != calid) {
            args.add("calid=" + calid);
        }
        if (null != uid) {
            args.add("uid=" + uid);
        }
        if (null != rid) {
            args.add("rid=" + rid);
        }
        if (null != modifier) {
            args.add("mod=" + this.getModifierValue(modifier));
        }
        String isCompressed = null;
        String timeZoneId = null;
        String compstate = null;
        String isRecurring = null;
        if (parsingProperties != null) {
            isCompressed = (String)parsingProperties.get("cal.socs.compressed");
            timeZoneId = (String)parsingProperties.get("cal.socs.preferredTimezone");
            compstate = (String)parsingProperties.get("cal.socs.compstate");
            isRecurring = (String)parsingProperties.get("cal.socs.recurring");
        }
        if (isCompressed == null) {
            isCompressed = this.session.getCalStore().getSession().getProperty("cal.socs.compressed");
        }
        if (null != isCompressed && isCompressed.equalsIgnoreCase("true")) {
            args.add("compressed=1");
        }
        if (isRecurring == null) {
            isRecurring = this.session.getCalStore().getSession().getProperty("cal.socs.recurring");
        }
        if (null != isRecurring && isRecurring.equalsIgnoreCase("true")) {
            args.add("recurring=1");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (timeZoneId != null && timeZoneId.length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        if (compstate == null) {
            compstate = this.session.getCalStore().getSession().getProperty("cal.socs.compstate");
        }
        if (compstate != null && compstate.length() > 0) {
            args.add("compstate=" + compstate);
        }
        args.add("relativealarm=4");
        SOCSResponse response = null;
        response = flag ? this.request("fetchevents_by_id.wcap", args, parsingProperties) : this.request("fetchtodos_by_id.wcap", args, parsingProperties);
        if (response.getErrorNum() != 0) {
            throw new SOCSException(" fetchcomponents_by_id.wcap failed", response.getErrorNum());
        }
        return response;
    }

    public SOCSResponse fetchFreeBusy(String calid, DateTime dtstart, DateTime dtend, Properties parsingProperties) throws SOCSException {
        SOCSResponse response;
        TimeZone tz;
        if (null == dtstart || null == dtend) {
            throw new SOCSException("null time range", 105);
        }
        if (null == calid) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (null != this.session.getID()) {
            args.add("id=" + this.session.getID());
        }
        if (null != calid) {
            if (calid.toUpperCase().startsWith("MAILTO:")) {
                calid = calid.substring(7);
                args.add("mail=" + SOCSUtils.urlEncode(calid));
            } else {
                args.add("calid=" + SOCSUtils.urlEncode(calid));
            }
        }
        args.add("dtstart=" + dtstart.toISO8601());
        args.add("dtend=" + dtend.toISO8601());
        String busyOnly = null;
        String timeZoneId = null;
        if (parsingProperties != null) {
            busyOnly = (String)parsingProperties.get("cal.socs.busyonly");
            timeZoneId = (String)parsingProperties.get("cal.socs.preferredTimezone");
        }
        if (busyOnly == null) {
            busyOnly = this.session.getCalStore().getSession().getProperty("cal.socs.busyonly");
        }
        if (busyOnly != null && busyOnly.equalsIgnoreCase("true")) {
            args.add("busyonly=1");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (timeZoneId != null && timeZoneId.length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        if ((response = this.request("get_freebusy.wcap", args, parsingProperties)).getErrorNum() != 0) {
            throw new SOCSException(" get_freebusy.wcap failed", response.getErrorNum());
        }
        return response;
    }

    BufferedReader exportCalendar(String calid, DateTime dtstart, DateTime dtend, String contentFormat) throws SOCSException {
        int wcapErrNum = -1;
        if (calid == null) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>();
        BufferedReader output = null;
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        args.add("calid=" + SOCSUtils.urlEncode(calid));
        if (dtstart == null) {
            args.add("dtstart=0");
        } else {
            args.add("dtstart=" + dtstart.toISO8601());
        }
        if (dtend == null) {
            args.add("dtend=0");
        } else {
            args.add("dtend=" + dtend.toISO8601());
        }
        args.add("content-out=" + contentFormat);
        HttpURLConnection conn = null;
        try {
            conn = this.postRequest("export.wcap", args);
        }
        catch (MalformedURLException mue) {
            throw new SOCSException(mue.getMessage(), 103);
        }
        catch (IOException io) {
            throw new SOCSException(io.getMessage(), 107);
        }
        try {
            conn = this.setExportMIMEHeaders(conn);
        }
        catch (ConnectException ce1) {
            throw new SOCSException("Invalid Calendar Server name or port.", 108);
        }
        catch (UnknownHostException uhe) {
            throw new SOCSException("Invalid Calendar Server name or port.", 100);
        }
        catch (IOException ioe1) {
            throw new SOCSException(ioe1.getMessage(), 107);
        }
        try {
            output = this.sendPostCommand(conn);
        }
        catch (FileNotFoundException e1) {
            throw new SOCSException(" Could not access the resource ", 101);
        }
        catch (IOException ie) {
            throw new SOCSException("Input/Output Error: " + ie.getMessage(), 107);
        }
        catch (Exception e) {
            throw new SOCSException("SOCS request failed: ", 104);
        }
        if (output == null) {
            throw new SOCSException("Could not export calendar ", 104);
        }
        try {
            wcapErrNum = this.obtainWCAPError(output);
        }
        catch (IOException ioe) {
            throw new SOCSException(ioe.getMessage(), 107);
        }
        if (wcapErrNum != 0) {
            throw new SOCSException(" Failed to export calendar ", wcapErrNum);
        }
        if (output == null) {
            throw new SOCSException(" Failed to export calendar " + calid, 104);
        }
        return output;
    }

    public void importCalendar(String calid, DateTime dtstart, DateTime dtend, String contentFormat, InputStream in) throws SOCSException {
        int wcapErrNum = -1;
        if (calid == null) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> args = new ArrayList<String>();
        BufferedReader output = null;
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        args.add("calid=" + SOCSUtils.urlEncode(calid));
        if (dtstart == null) {
            args.add("dtstart=0");
        } else {
            args.add("dtstart=" + dtstart.toISO8601());
        }
        if (dtend == null) {
            args.add("dtend=0");
        } else {
            args.add("dtend=" + dtend.toISO8601());
        }
        args.add("content-in=" + contentFormat);
        HttpURLConnection conn = null;
        try {
            conn = this.postRequest("import.wcap", args);
        }
        catch (MalformedURLException mue) {
            throw new SOCSException(mue.getMessage(), 103);
        }
        catch (IOException io) {
            throw new SOCSException(io.getMessage(), 104);
        }
        try {
            conn = this.setImportMIMEHeadersAndData(conn, contentFormat, in);
        }
        catch (ConnectException ce) {
            throw new SOCSException("Invalid Calendar Server name or port", 108);
        }
        catch (UnknownHostException uhe) {
            throw new SOCSException("Invalid Calendar Server name or port", 100);
        }
        catch (IOException io) {
            throw new SOCSException("Unable to read the data to be imported.", 107);
        }
        try {
            output = this.sendPostCommand(conn);
        }
        catch (IOException ie) {
            throw new SOCSException("Input/Output Error: " + ie.getMessage(), 107);
        }
        catch (Exception e) {
            throw new SOCSException("SOCS request failed. ", 104);
        }
        if (output == null) {
            throw new SOCSException("Could not Import calendar ", 104);
        }
        try {
            wcapErrNum = this.obtainWCAPError(output);
        }
        catch (IOException ioe) {
            throw new SOCSException(ioe.getMessage(), 107);
        }
        if (wcapErrNum != 0) {
            throw new SOCSException(" Failed to Import calendar ", wcapErrNum);
        }
        if (output == null) {
            throw new SOCSException(" Failed to Import calendar to " + calid, 104);
        }
    }

    SOCSResponse fetch(String calid, String uid) throws SOCSException {
        if (uid == null) {
            throw new SOCSException("null uid", 105);
        }
        ArrayList<String> args = new ArrayList<String>(3);
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        if (calid != null) {
            args.add("calid=" + calid);
        }
        args.add("uid=" + uid);
        SOCSResponse response = this.request("fetchevents_by_id.wcap", args);
        if (response.getErrorNum() != 0) {
            throw new SOCSException("fetchevents_by_id.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse storeEvent(String calid, VEvent event, String modifier, boolean notify, Properties requestProperties) throws SOCSException {
        SOCSResponse response;
        TimeZone tz;
        if (calid == null) {
            throw new SOCSException("null calid", 110);
        }
        if (event == null) {
            throw new SOCSException("null event", 105);
        }
        String timeZoneId = null;
        String excludedtstart = null;
        if (null != requestProperties) {
            timeZoneId = (String)requestProperties.get("cal.socs.preferredTimezone");
            excludedtstart = (String)requestProperties.get("cal.socs.excludeStartDateForRecurrence");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (null == excludedtstart) {
            excludedtstart = "false";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        if (excludedtstart.equalsIgnoreCase("true")) {
            args.add("excludedtstart=1");
        }
        if (null != timeZoneId && timeZoneId.trim().length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        args.add("calid=" + calid);
        SOCSEvent socsEvent = (SOCSEvent)event;
        socsEvent.parseToSOCS(args, calid);
        if (socsEvent.getStoreType() != -1 && socsEvent.getStoreType() == SOCSEvent.STORETYPE_MODIFY) {
            args.add("mod=" + this.getModifierValue(modifier));
            if (modifier != null && !modifier.equals("THIS_INSTANCE") && (socsEvent.hasRecurrenceDateChanged() || socsEvent.hasRecurrenceRuleChanged() || socsEvent.hasExceptionDateChanged() || socsEvent.hasExceptionRuleChanged())) {
                args.add("rchange=1");
            }
        }
        if (notify) {
            args.add("notify=1");
        }
        if ((response = this.request("storeevents.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("storeevents.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse storeTodo(String calid, VTodo todo, String modifier, boolean notify, Properties requestProperties) throws SOCSException {
        SOCSResponse response;
        TimeZone tz;
        if (calid == null) {
            throw new SOCSException("null calid", 110);
        }
        if (todo == null) {
            throw new SOCSException("null todo", 105);
        }
        String timeZoneId = null;
        String excludedtstart = null;
        if (null != requestProperties) {
            timeZoneId = (String)requestProperties.get("cal.socs.preferredTimezone");
            excludedtstart = (String)requestProperties.get("cal.socs.excludeStartDateForRecurrence");
        }
        if (null == timeZoneId && (tz = this.session.getCalStore().getSession().getTimeZone()) != null) {
            timeZoneId = tz.getID();
        }
        if (null == excludedtstart) {
            excludedtstart = "false";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        if (excludedtstart.equalsIgnoreCase("true")) {
            args.add("excludedtstart=1");
        }
        if (null != timeZoneId && timeZoneId.trim().length() > 0) {
            args.add("tzid=" + timeZoneId);
        }
        args.add("calid=" + calid);
        SOCSTodo socsTodo = (SOCSTodo)todo;
        socsTodo.parseToSOCS(args, calid);
        if (socsTodo.getStoreType() != -1 && socsTodo.getStoreType() == SOCSTodo.STORETYPE_MODIFY) {
            args.add("mod=" + this.getModifierValue(modifier));
            if (modifier != null && !modifier.equals("THIS_INSTANCE") && (socsTodo.hasRecurrenceDateChanged() || socsTodo.hasRecurrenceRuleChanged() || socsTodo.hasExceptionDateChanged() || socsTodo.hasExceptionRuleChanged())) {
                args.add("rchange=1");
            }
        }
        if (notify) {
            args.add("notify=1");
        }
        if ((response = this.request("storetodos.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("storetodos.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse deleteevents(String calid, VEvent event, String modifier, boolean notify) throws SOCSException {
        SOCSResponse response;
        if (calid == null) {
            throw new SOCSException("null calid", 110);
        }
        if (event == null) {
            throw new SOCSException("null event", 105);
        }
        ArrayList<String> args = new ArrayList<String>(6);
        String rid = null;
        try {
            if (event.hasProperty("RECURRENCE-ID")) {
                rid = event.getRecurrenceID().toISOString();
            }
            if (this.session.getID() != null) {
                args.add("id=" + this.session.getID());
            }
            args.add("calid=" + calid);
            args.add("uid=" + event.getID());
            args.add("rid=" + (rid != null ? rid : STRING_VALUE_ZERO));
            args.add("mod=" + this.getModifierValue(modifier));
        }
        catch (OperationNotSupportedException onse) {
        }
        catch (CalendarComponentException cce) {
            throw new SOCSException(cce.getError());
        }
        if (notify) {
            args.add("notify=1");
        }
        if ((response = this.request("deleteevents_by_id.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("deleteevents_by_id.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse deletetodos(String calid, VTodo todo, String modifier, boolean notify) throws SOCSException {
        SOCSResponse response;
        if (calid == null) {
            throw new SOCSException("null calid", 110);
        }
        if (todo == null) {
            throw new SOCSException("null todo", 105);
        }
        ArrayList<String> args = new ArrayList<String>(6);
        String rid = null;
        try {
            if (todo.hasProperty("RECURRENCE-ID")) {
                rid = todo.getRecurrenceID().toISOString();
            }
            if (this.session.getID() != null) {
                args.add("id=" + this.session.getID());
            }
            args.add("calid=" + calid);
            args.add("uid=" + todo.getID());
            args.add("rid=" + (rid != null ? rid : STRING_VALUE_ZERO));
            args.add("mod=" + this.getModifierValue(modifier));
        }
        catch (OperationNotSupportedException onse) {
        }
        catch (CalendarComponentException cce) {
            throw new SOCSException(cce.getError());
        }
        if (notify) {
            args.add("notify=1");
        }
        if ((response = this.request("deletetodos_by_id.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("deletetodos_by_id.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse searchCalendars(String searchString, int searchOption, int maxResults) throws SOCSException {
        return this.searchCalendars(searchString, searchOption, maxResults, null);
    }

    SOCSResponse searchCalendars(String searchString, int searchOption, int maxResults, Properties requestProperties) throws SOCSException {
        SOCSResponse response;
        ArrayList<String> args = new ArrayList<String>();
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        args.add("search-string=" + SOCSUtils.urlEncode(searchString));
        if (searchOption > 0) {
            args.add("searchOpts=" + Integer.toString(searchOption));
        }
        if (maxResults > 0) {
            args.add("maxResults=" + Integer.toString(maxResults));
        }
        if (null != requestProperties) {
            if (STRING_VALUE_ONE.equals((String)requestProperties.get("calid"))) {
                args.add("calid=1");
            } else if (STRING_VALUE_ZERO.equals((String)requestProperties.get("calid"))) {
                args.add("calid=0");
            }
            if (STRING_VALUE_ONE.equals((String)requestProperties.get("name"))) {
                args.add("name=1");
            } else if (STRING_VALUE_ZERO.equals((String)requestProperties.get("name"))) {
                args.add("name=0");
            }
            if (STRING_VALUE_ONE.equals((String)requestProperties.get("primaryOwner"))) {
                args.add("primaryOwner=1");
            } else if (STRING_VALUE_ZERO.equals((String)requestProperties.get("primaryOwner"))) {
                args.add("primaryOwner=0");
            }
        }
        if ((response = this.request("search_calprops.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("searchcalendar.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse createCalendar(String cid, Properties props) throws SOCSException {
        SOCSResponse response;
        ArrayList<String> args = new ArrayList<String>();
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        args.add("calid=" + SOCSUtils.urlEncode(cid));
        if (props != null && !props.isEmpty()) {
            args.add("set_calprops=1");
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                args.add(key + "=" + SOCSUtils.urlEncode(props.getProperty(key)));
            }
        }
        if ((response = this.request("createcalendar.wcap", args)).getErrorNum() != 0) {
            throw new SOCSException("createcalendar.wcap failed", response.getErrorNum());
        }
        return response;
    }

    SOCSResponse deleteCalendar(String cid) throws SOCSException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.session.getID() != null) {
            args.add("id=" + this.session.getID());
        }
        args.add("calid=" + SOCSUtils.urlEncode(cid));
        SOCSResponse response = this.request("deletecalendar.wcap", args);
        if (response.getErrorNum() != 0) {
            throw new SOCSException(" deletecalendar.wcap failed", response.getErrorNum());
        }
        return response;
    }

    private boolean isBitSet(int flags, int bitLocation) {
        return 0 != (flags & bitLocation);
    }

    private int getModifierValue(String modifier) throws SOCSException {
        if (null == modifier) {
            return 1;
        }
        if (modifier.equals("THIS_INSTANCE")) {
            return 1;
        }
        if (modifier.equals("THIS_AND_FUTURE")) {
            return 2;
        }
        if (modifier.equals("THIS_AND_PRIOR")) {
            return 3;
        }
        if (modifier.equals("THIS_AND_ALL")) {
            return 4;
        }
        throw new SOCSException(": recurrence modifier \"" + modifier + "\" found to be invalid", 105);
    }

    public SOCSResponse getProtoVersion() throws SOCSException {
        SOCSResponse resp = this.request("version.wcap", null);
        return resp;
    }

    public static String maskPassword(String data) {
        StringBuffer sb;
        block4: {
            int pswdIndex;
            if (null == data) {
                return data;
            }
            if (data.indexOf(PASSWORD_URL_ARG) < 0) {
                return data;
            }
            sb = new StringBuffer();
            int nextIndex = 0;
            while ((pswdIndex = data.indexOf(PASSWORD_URL_ARG, nextIndex)) != -1) {
                sb.append(data.substring(nextIndex, pswdIndex += PASSWORD_URL_ARG_LENGTH));
                int ampIndex = data.indexOf(AMP, pswdIndex);
                if (ampIndex != -1) {
                    sb.append(PASSWORD_MASK);
                    data = data.substring(ampIndex);
                    continue;
                }
                break block4;
            }
            sb.append(data);
        }
        return sb.toString();
    }
}

