/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusy;
import com.sun.comclient.calendar.FreeBusyException;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.VFreeBusy;
import com.sun.comclient.calendar.socs.SOCSSession;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSFreeBusy
extends VFreeBusy {
    private boolean hasDuration = false;
    public static final String FREEBUSY = "FREEBUSY";
    public static final String DTEND = "DTEND";
    public static final String FBTYPE = "FBTYPE";
    public static final String BUSY = "BUSY";
    public static final String BUSY_UNAVAILABLE = "BUSY-UNAVAILABLE";
    public static final String BUSY_TENTATIVE = "BUSY-TENTATIVE";
    public static final String FREE = "FREE";
    public static final String ATTENDEE = "ATTENDEE";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String DURATION = "DURATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String RSTATUS = "REQUEST-STATUS";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String CALID = "RELATIVE-CALID";
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();

    public SOCSFreeBusy(DateTime dtstart, DateTime dtend, FreeBusy[] freebusy) throws IllegalArgumentException {
        if (null == dtstart) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dtend) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        if (null == freebusy) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dtstart);
        this.setProperty(DTEND, dtend);
        this.setProperty(FREEBUSY, freebusy);
        this.hasDuration = false;
        this.removeProperty(DURATION);
    }

    public SOCSFreeBusy(DateTime dtstart, Duration duration, FreeBusy[] freebusy) throws IllegalArgumentException, PropertiesException {
        if (null == dtstart) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        if (null == freebusy) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dtstart);
        this.setDuration(duration);
        this.setProperty(FREEBUSY, freebusy);
        this.hasDuration = true;
        this.removeProperty(DTEND);
    }

    private String calendarComponentToRFC2445() {
        String[] rstatusList;
        String[] contactList;
        String[] commentList;
        Attendee[] aList;
        String data = new String("");
        if (null != this.getID()) {
            data = data + "\nUID:" + this.getID();
        }
        if (null != this.getUrl()) {
            data = data + "\nURL:" + this.getUrl();
        }
        if (null != this.getStamp()) {
            data = data + "\nDTSTAMP:" + this.getStamp().toISOString();
        }
        if (null != this.getOrganizer()) {
            data = data + "\n" + this.getOrganizer().toRFC2445();
        }
        if (null != (aList = this.getAttendees())) {
            for (int i = 0; i < aList.length; ++i) {
                data = data + "\n" + aList[i].toRFC2445();
            }
        }
        if (null != (commentList = this.getComments())) {
            for (int i = 0; i < commentList.length; ++i) {
                data = data + "\nCOMMENT:" + commentList[i];
            }
        }
        if (null != (contactList = this.getContacts())) {
            for (int i = 0; i < contactList.length; ++i) {
                data = data + "\nCONTACT:" + contactList[i];
            }
        }
        if (null != (rstatusList = this.getRequestStatus())) {
            for (int i = 0; i < rstatusList.length; ++i) {
                data = data + "\nRSTATUS:" + rstatusList[i];
            }
        }
        return data;
    }

    private String freeBusyToRFC2445(FreeBusy[] fb) {
        if (null == fb) {
            return null;
        }
        String data = new String("");
        for (int i = 0; i < fb.length; ++i) {
            data = data + "\n" + fb[i].toRFC2445();
        }
        return data;
    }

    private String freeBusyToString(FreeBusy[] fb) {
        if (null == fb) {
            return null;
        }
        String data = new String("");
        for (int i = 0; i < fb.length; ++i) {
            data = data + ";\n" + fb[i].toString();
        }
        return data;
    }

    private boolean getHasDuration() {
        boolean hasduration = false;
        try {
            hasduration = this.hasDuration();
        }
        catch (OperationNotSupportedException onse) {
            hasduration = false;
        }
        catch (CalendarComponentException cce) {
            hasduration = false;
        }
        return hasduration;
    }

    private FreeBusy[] getGetFreeBusy() {
        FreeBusy[] getfreebusy = null;
        try {
            getfreebusy = this.getFreeBusy();
        }
        catch (OperationNotSupportedException onse) {
            getfreebusy = null;
        }
        catch (CalendarComponentException cce) {
            getfreebusy = null;
        }
        return getfreebusy;
    }

    public String toRFC2445() {
        return "BEGIN:VFREEBUSY\nDTSTART:" + this.getStart().toISOString() + (this.getHasDuration() ? "\n" + this.getDuration().toRFC2445() : "\nDTEND:" + this.getEnd().toISOString()) + this.freeBusyToRFC2445(this.getGetFreeBusy()) + this.calendarComponentToRFC2445() + "\nEND:VFREEBUSY";
    }

    public String toString() {
        return "SOCSFreeBusy[" + super.toString() + ", hasDuration=\"" + this.getHasDuration() + "\"" + ", FreeBusy=\"" + this.freeBusyToString(this.getGetFreeBusy()) + "\"" + "]";
    }

    public boolean hasAttendee() {
        return this.hasProperty(ATTENDEE);
    }

    public Attendee getAttendee(String calid) {
        if (null == calid) {
            return null;
        }
        ArrayList alist = (ArrayList)this.getProperty(ATTENDEE);
        if (null == alist) {
            return null;
        }
        for (int i = 0; i < alist.size(); ++i) {
            Attendee attFromList = (Attendee)alist.get(i);
            if (!calid.equals(attFromList.getValue())) continue;
            return attFromList;
        }
        return null;
    }

    public Attendee[] getAttendees() {
        ArrayList alist = (ArrayList)this.getProperty(ATTENDEE);
        if (null == alist) {
            return null;
        }
        Attendee[] attendees = new Attendee[alist.size()];
        return alist.toArray(attendees);
    }

    public void addAttendee(Attendee attendee) {
        ArrayList<Attendee> alist = (ArrayList<Attendee>)this.getProperty(ATTENDEE);
        if (null == alist) {
            alist = new ArrayList<Attendee>();
            alist.add(attendee);
            this.setProperty(ATTENDEE, alist);
        } else {
            alist.add(attendee);
        }
    }

    public void removeAttendee(Attendee attendee) {
        if (null == attendee) {
            return;
        }
        String attVal = attendee.getValue();
        if (null == attVal) {
            return;
        }
        ArrayList alist = (ArrayList)this.getProperty(ATTENDEE);
        if (null != alist) {
            for (int i = 0; i < alist.size(); ++i) {
                Attendee attFromList = (Attendee)alist.get(i);
                if (!attVal.equals(attFromList.getValue())) continue;
                alist.remove(i);
                if (alist.size() > 0) break;
                this.removeProperty(ATTENDEE);
                break;
            }
        }
    }

    public void removeAllAttendees() {
        this.removeProperty(ATTENDEE);
    }

    public String[] getContacts() {
        ArrayList alist = (ArrayList)this.getProperty(CONTACT);
        if (null == alist) {
            return null;
        }
        String[] contacts = new String[alist.size()];
        return alist.toArray(contacts);
    }

    public void addContact(String contact) {
        if (null == contact) {
            return;
        }
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(CONTACT);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(contact);
            this.setProperty(CONTACT, alist);
        } else {
            alist.add(contact);
        }
    }

    public void removeContact(String contact) {
        if (null == contact) {
            return;
        }
        ArrayList alist = (ArrayList)this.getProperty(CONTACT);
        if (null != alist) {
            for (int i = 0; i < alist.size(); ++i) {
                if (!contact.equals((String)alist.get(i))) continue;
                alist.remove(i);
                if (alist.size() > 0) break;
                this.removeProperty(CONTACT);
                break;
            }
        }
    }

    public void removeAllContacts() {
        this.removeProperty(CONTACT);
    }

    public String[] getComments() {
        ArrayList alist = (ArrayList)this.getProperty(COMMENT);
        if (null == alist) {
            return null;
        }
        String[] comments = new String[alist.size()];
        return alist.toArray(comments);
    }

    public void addComment(String comment) {
        if (null == comment) {
            return;
        }
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(COMMENT);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(comment);
            this.setProperty(COMMENT, alist);
        } else {
            alist.add(comment);
        }
    }

    public void removeComment(String comment) {
        if (null == comment) {
            return;
        }
        ArrayList alist = (ArrayList)this.getProperty(COMMENT);
        if (null != alist) {
            for (int i = 0; i < alist.size(); ++i) {
                if (!comment.equals((String)alist.get(i))) continue;
                alist.remove(i);
                if (alist.size() > 0) break;
                this.removeProperty(COMMENT);
                break;
            }
        }
    }

    public void removeAllComments() {
        this.removeProperty(COMMENT);
    }

    public DateTime getStamp() {
        return (DateTime)this.getProperty(DTSTAMP);
    }

    public void setStamp(DateTime dtstamp) {
        this.setProperty(DTSTAMP, dtstamp);
    }

    public Duration getDuration() {
        return (Duration)this.getProperty(DURATION);
    }

    public void setDuration(Duration duration) {
        this.setProperty(DURATION, duration);
    }

    public Organizer getOrganizer() {
        return (Organizer)this.getProperty(ORGANIZER);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(ORGANIZER, organizer);
    }

    public boolean isCalIdTheOrganizer(String calId) {
        if (this.hasProperty(ORGANIZER)) {
            String orgValue = this.getOrganizer().getValue();
            if (orgValue == null) {
                return false;
            }
            return orgValue.equals(calId);
        }
        return false;
    }

    public String[] getRequestStatus() {
        ArrayList alist = (ArrayList)this.getProperty(RSTATUS);
        if (null == alist) {
            return null;
        }
        String[] requeststatus = new String[alist.size()];
        return alist.toArray(requeststatus);
    }

    public void addRequestStatus(String requeststatus) {
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(RSTATUS);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(requeststatus);
            this.setProperty(RSTATUS, alist);
        } else {
            alist.add(requeststatus);
        }
    }

    public void removeRequestStatus(String requeststatus) {
        int rstatusIndex;
        ArrayList alist = (ArrayList)this.getProperty(RSTATUS);
        if (null != alist && -1 != (rstatusIndex = alist.indexOf(requeststatus))) {
            alist.remove(rstatusIndex);
            if (alist.size() <= 0) {
                this.removeProperty(RSTATUS);
            }
        }
    }

    public void removeAllRequestStatus() {
        this.removeProperty(RSTATUS);
    }

    public String getID() {
        return (String)this.getProperty(UID);
    }

    public void setID(String uid) {
        this.setProperty(UID, uid);
    }

    public String getUrl() {
        return (String)this.getProperty(URL);
    }

    public void setUrl(String url) {
        this.setProperty(URL, url);
    }

    public String getCalID() {
        return (String)this.getProperty(CALID);
    }

    public void setCalID(String id) {
        this.setProperty(CALID, id);
    }

    public DateTime getStart() {
        return (DateTime)this.getProperty("DTSTART");
    }

    public void setStart(DateTime dtstart) {
        this.setProperty("DTSTART", dtstart);
    }

    public DateTime getEnd() {
        return (DateTime)this.getProperty(DTEND);
    }

    public void setEnd(DateTime dtend) {
        this.setProperty(DTEND, dtend);
    }

    public FreeBusy[] getFreeBusy() throws OperationNotSupportedException, CalendarComponentException {
        return (FreeBusy[])this.getProperty(FREEBUSY);
    }

    public boolean hasDuration() throws OperationNotSupportedException, CalendarComponentException {
        return this.hasDuration;
    }

    public static SOCSFreeBusy fromXML(SOCSSession session, Properties props, Properties parsingProperties) throws IllegalArgumentException, PropertiesException, ParseException, FreeBusyException {
        String calid;
        if (null == props) {
            throw new IllegalArgumentException("Null Argument passed: props is null");
        }
        if (null == session) {
            throw new IllegalArgumentException("Null Argument passed: session is null");
        }
        TimeZone tz = null;
        if (parsingProperties != null) {
            tz = (TimeZone)parsingProperties.get("com.socs.timezone");
        }
        if (null == tz) {
            tz = session.getCalStore().getSession().getTimeZone();
        }
        if (null == tz) {
            tz = session.getTimeZone();
        }
        ArrayList<FreeBusy> alist = new ArrayList<FreeBusy>();
        ArrayList fbVect = null;
        DateTime dtstart = null;
        DateTime dtend = null;
        if (null == props.getProperty("START")) {
            throw new IllegalArgumentException("The tag or property \"START\" is missing in Free/Busy XML response");
        }
        dtstart = new DateTime(props.getProperty("START"), tz);
        if (null == props.getProperty("END")) {
            throw new IllegalArgumentException("The tag or property \"END\" is missing in Free/Busy XML response");
        }
        dtend = new DateTime(props.getProperty("END"), tz);
        if (null == props.get("FB")) {
            throw new IllegalArgumentException("The tag or property \"FB\" is missing in Free/Busy XML response");
        }
        fbVect = (ArrayList)props.get("FB");
        for (int i = 0; i < fbVect.size(); ++i) {
            Properties fbProp = (Properties)fbVect.get(i);
            String fbPropData = null;
            String fbtype = fbProp.getProperty(FBTYPE);
            fbPropData = null == fbtype ? "FREEBUSY:" + fbProp.getProperty("FB") : "FREEBUSY;FBTYPE=" + fbtype + ":" + fbProp.getProperty("FB");
            FreeBusy[] fbInstances = FreeBusy.fromRFC2445(fbPropData, tz);
            for (int j = 0; j < fbInstances.length; ++j) {
                alist.add(fbInstances[j]);
            }
        }
        FreeBusy[] fbList = new FreeBusy[alist.size()];
        alist.toArray(fbList);
        SOCSFreeBusy socsfb = new SOCSFreeBusy(dtstart, dtend, fbList);
        if (null != socsfb && null != (calid = props.getProperty(CALID))) {
            socsfb.setCalID(calid);
        }
        return socsfb;
    }
}

