/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSAlarm;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.io.BufferedReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSEvent
extends VEvent {
    public static final String ATTENDEE = "ATTENDEE";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String DTSTART = "DTSTART";
    public static final String DURATION = "DURATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String RSTATUS = "REQUEST-STATUS";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String CALID = "RELATIVE-CALID";
    public static final String ALARM_COMPONENT = "ALARM";
    public static final String ATTACHMENT = "ATTACH";
    public static final String CATEGORIES = "CATEGORIES";
    public static final String CLASSIFICATION = "CLASS";
    public static final String CREATED = "CREATED";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String LAST_MODIFIED = "LAST-MODIFIED";
    public static final String LOCATION = "LOCATION";
    public static final String GEO = "GEO";
    public static final String PRIORITY = "PRIORITY";
    public static final String RECURRENCE_ID = "RECURRENCE-ID";
    public static final String RELATED_TO = "RELATED-TO";
    public static final String RESOURCES = "RESOURCES";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String STATUS = "STATUS";
    public static final String SUMMARY = "SUMMARY";
    public static final String EXCEPTION_DATES = "EXDATE";
    public static final String EXCEPTION_RULE = "EXRULE";
    public static final String RECURRENCE_DATES = "RDATE";
    public static final String RECURRENCE_RULE = "RRULE";
    public static final String TRANSP = "TRANSP";
    public static final String CLASSIFICATION_CONFIDENTIAL = "CONFIDENTIAL";
    public static final String CLASSIFICATION_PRIVATE = "PRIVATE";
    public static final String CLASSIFICATION_PUBLIC = "PUBLIC";
    public static final String STATUS_TENTATIVE = "TENTATIVE";
    public static final String STATUS_CONFIRMED = "CONFIRMED";
    public static final String STATUS_CANCELLED = "CANCELLED";
    public static String METHOD = "X-JCAPI-COMPONENTPROPS-METHOD";
    public static String TIMEZONE = "X-JCAPI-COMPONENTPROPS-TZID";
    public static String STORETYPE = "X-JCAPI-COMPONENTPROPS-STORETYPE";
    public static String REPLACE = "X-JCAPI-COMPONENTPROPS-REPLACE";
    public static int STORETYPE_NONE = 0;
    public static int STORETYPE_CREATE = 1;
    public static int STORETYPE_MODIFY = 2;
    public static int REPLACE_APPEND = 0;
    public static int REPLACE_UPDATE = 1;
    private static final Hashtable _statusValues = new Hashtable();
    private static final Hashtable _classificationValues = new Hashtable();
    private boolean hasAttendeeChanged;
    private boolean hasAttachmentChanged;
    private boolean hasAlarmChanged;
    private boolean hasCategoryChanged;
    private boolean hasContactChanged;
    private boolean hasDescriptionChanged;
    private boolean hasExceptionDateChanged;
    private boolean hasExceptionRuleChanged;
    private boolean hasLocationChanged;
    private boolean hasResourceChanged;
    private boolean hasRelatedToChanged;
    private boolean hasRecurrenceDateChanged;
    private boolean hasRecurrenceRuleChanged;
    private boolean hasSummaryChanged;
    private boolean hasUrlChanged;
    private int wcapVersionInUse;

    public SOCSEvent() {
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasResourceChanged = false;
        this.hasRelatedToChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
        this.wcapVersionInUse = 0;
        this.allDay = false;
    }

    public SOCSEvent(DateTime dtstart, DateTime dtend) {
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasResourceChanged = false;
        this.hasRelatedToChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
        this.wcapVersionInUse = 0;
        try {
            this.setStartTime(dtstart);
            this.setEndTime(dtend);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SOCSEvent(DateTime dtstart, DateTime dtend, String summary) {
        this(dtstart, dtend);
        this.setSummary(summary);
    }

    public SOCSEvent(DateTime dtstart, String summary) {
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasResourceChanged = false;
        this.hasRelatedToChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
        this.wcapVersionInUse = 0;
        try {
            this.setStartTime(dtstart);
            this.setSummary(summary);
            this.setAllDay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SOCSEvent(String uid, DateTime start, DateTime end, String summary, String description) {
        this(start, end, summary);
        this.setID(uid);
        this.setDescription(description);
    }

    public SOCSEvent(DateTime dtstart, DateTime dtend, String summary, String description) {
        this(dtstart, dtend, summary);
        this.setDescription(description);
    }

    private String[] _split(String src, char delim, int limit) {
        String[] result = new String[limit];
        int len = src.length();
        int start = 0;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (src.charAt(i) != delim) continue;
            if (count >= limit - 1) break;
            result[count] = src.substring(start, i);
            start = i + 1;
            ++count;
        }
        if (count < limit) {
            result[count] = src.substring(start, len);
        }
        return result;
    }

    public SOCSEvent(String rfcFormat) throws IllegalArgumentException, CalendarComponentException {
        block46: {
            this.hasAttendeeChanged = false;
            this.hasAttachmentChanged = false;
            this.hasAlarmChanged = false;
            this.hasCategoryChanged = false;
            this.hasContactChanged = false;
            this.hasDescriptionChanged = false;
            this.hasExceptionDateChanged = false;
            this.hasExceptionRuleChanged = false;
            this.hasLocationChanged = false;
            this.hasResourceChanged = false;
            this.hasRelatedToChanged = false;
            this.hasRecurrenceDateChanged = false;
            this.hasRecurrenceRuleChanged = false;
            this.hasSummaryChanged = false;
            this.hasUrlChanged = false;
            this.wcapVersionInUse = 0;
            BufferedReader eventDef = new BufferedReader(new StringReader(rfcFormat));
            try {
                StreamTokenizer st = null;
                String curLine = eventDef.readLine();
                st = new StreamTokenizer(new StringReader(curLine));
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase("BEGIN")) {
                    throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
                }
                if ((char)st.nextToken() != ':') {
                    throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
                }
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase("VEVENT")) {
                    throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
                }
                boolean isMultiLine = false;
                String previousKeyword = null;
                while (!(curLine = eventDef.readLine()).equalsIgnoreCase("END:VEVENT")) {
                    RecurrencePattern rpat;
                    String rpStr;
                    st = new StreamTokenizer(new StringReader(curLine));
                    st.nextToken();
                    String keyword = st.sval.toUpperCase();
                    String[] tokens = this._split(curLine, ':', 2);
                    if (tokens.length != 2) {
                        throw new IllegalArgumentException("Invalid VEVENT format(check " + keyword + "tag)");
                    }
                    if (keyword.equals(UID)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setID(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(DTSTART)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setStartTime(new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(SUMMARY)) {
                        isMultiLine = true;
                        previousKeyword = keyword;
                        this.setSummary(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(CALID)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setCalID(tokens[1]);
                        continue;
                    }
                    if (keyword.equals("DTEND")) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setEndTime(new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(DURATION)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setDuration(new Duration(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(DESCRIPTION)) {
                        isMultiLine = true;
                        previousKeyword = keyword;
                        this.setDescription(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(LOCATION)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setLocation(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(CLASSIFICATION)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setClassification(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(DTSTAMP)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setStamp(new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(SEQUENCE)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setSequence(Integer.parseInt(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(PRIORITY)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setPriority(Integer.parseInt(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(RECURRENCE_ID)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setProperty(RECURRENCE_ID, new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(TRANSP)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setProperty(TRANSP, tokens[1]);
                        continue;
                    }
                    if (keyword.equals(ORGANIZER)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        Organizer organizer = new Organizer(curLine);
                        this.setOrganizer(organizer);
                        continue;
                    }
                    if (keyword.equals(ATTENDEE)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        Attendee attendee = new Attendee(curLine);
                        this.addAttendee(attendee);
                        continue;
                    }
                    if (keyword.equals(EXCEPTION_DATES)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addExceptionDate(new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(EXCEPTION_RULE)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        rpStr = null == tokens[1] ? null : tokens[1].trim();
                        rpat = new RecurrencePattern(rpStr);
                        this.addExceptionRule(rpat);
                        continue;
                    }
                    if (keyword.equals(RECURRENCE_DATES)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addRecurrenceDate(new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(RECURRENCE_RULE)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        rpStr = null == tokens[1] ? null : tokens[1].trim();
                        rpat = new RecurrencePattern(rpStr);
                        this.addRecurrenceRule(rpat);
                        continue;
                    }
                    if (keyword.equals(STATUS)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setStatus(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(GEO)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setGeo(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(CREATED)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setProperty(CREATED, new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(LAST_MODIFIED)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.setProperty(LAST_MODIFIED, new DateTime(tokens[1]));
                        continue;
                    }
                    if (keyword.equals(ATTACHMENT)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        Attach attach = new Attach("RFC", curLine);
                        this.addAttachment(attach);
                        continue;
                    }
                    if (keyword.equals(COMMENT)) {
                        isMultiLine = true;
                        previousKeyword = keyword;
                        this.addComment(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(CATEGORIES)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addCategory(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(CONTACT)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addContact(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(RSTATUS)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addRequestStatus(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(RELATED_TO)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addRelatedTo(tokens[1]);
                        continue;
                    }
                    if (keyword.equals(RESOURCES)) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        this.addResource(tokens[1]);
                        continue;
                    }
                    if (curLine.equals("BEGIN:VALARM")) {
                        isMultiLine = false;
                        previousKeyword = keyword;
                        StringBuffer alarmBuf = new StringBuffer("BEGIN:VALARM\n");
                        while (!(curLine = eventDef.readLine()).equals("END:VALARM")) {
                            alarmBuf.append(curLine + "\n");
                        }
                        alarmBuf.append("END:VALARM");
                        SOCSAlarm alarm = new SOCSAlarm(this, alarmBuf.toString());
                        this.addAlarmComponent(alarm);
                        continue;
                    }
                    if (curLine.startsWith("X-") || !isMultiLine) continue;
                    String temp = null;
                    if (previousKeyword.equals(SUMMARY)) {
                        temp = this.getSummary();
                        curLine = temp + "\n" + curLine;
                        this.setSummary(curLine);
                    } else if (previousKeyword.equals(DESCRIPTION)) {
                        temp = this.getDescription();
                        curLine = temp + "\n" + curLine;
                        this.setDescription(curLine);
                    } else if (previousKeyword.equals(COMMENT)) {
                        String[] comment = this.getComments();
                        temp = comment[comment.length - 1];
                        curLine = temp + "\n" + curLine;
                        this.removeComment(temp);
                        this.addComment(curLine);
                    }
                    isMultiLine = true;
                    keyword = previousKeyword;
                }
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof CalendarComponentException)) break block46;
                throw (CalendarComponentException)e;
            }
        }
    }

    public SOCSEvent(SOCSEvent event) throws IllegalArgumentException, OperationNotSupportedException, CalendarComponentException {
        this(event.toRFC2445());
        if (event.hasProperty(METHOD)) {
            this.setMethod((String)event.getProperty(METHOD));
        }
        if (event instanceof SOCSEvent) {
            this.hasRecurrenceRuleChanged = event.hasRecurrenceRuleChanged();
            this.hasRecurrenceDateChanged = event.hasRecurrenceDateChanged();
        } else {
            this.hasRecurrenceRuleChanged = false;
            this.hasRecurrenceDateChanged = false;
        }
    }

    public void removeProperty(String property) {
        if (null == property) {
            return;
        }
        super.removeProperty(property);
        if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
            Integer ver = (Integer)this.getProperty("WCAP_VERSION_INT");
            this.wcapVersionInUse = ver;
        }
        if (this.wcapVersionInUse >= 300) {
            try {
                this.setReplace(REPLACE_UPDATE);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                // empty catch block
            }
        }
    }

    public boolean hasAttendee() {
        return this.hasProperty(ATTENDEE);
    }

    public Attendee getAttendee(String calid) {
        if (null == calid) {
            return null;
        }
        ArrayList alist = (ArrayList)this.getProperty(ATTENDEE);
        if (null == alist) {
            return null;
        }
        for (int i = 0; i < alist.size(); ++i) {
            Attendee attFromList = (Attendee)alist.get(i);
            if (!calid.equals(attFromList.getValue())) continue;
            return attFromList;
        }
        return null;
    }

    public Attendee[] getAttendees() {
        ArrayList alist = (ArrayList)this.getProperty(ATTENDEE);
        if (null == alist) {
            return null;
        }
        Attendee[] attendees = new Attendee[alist.size()];
        return alist.toArray(attendees);
    }

    public void addAttendee(Attendee attendee) {
        ArrayList<Attendee> alist = (ArrayList<Attendee>)this.getProperty(ATTENDEE);
        if (null == alist) {
            alist = new ArrayList<Attendee>();
            alist.add(attendee);
            this.setProperty(ATTENDEE, alist);
            this.hasAttendeeChanged = true;
        } else {
            alist.add(attendee);
            this.hasAttendeeChanged = true;
        }
    }

    public void removeAttendee(Attendee attendee) {
        if (null == attendee) {
            return;
        }
        String attVal = attendee.getValue();
        if (null == attVal) {
            return;
        }
        ArrayList alist = (ArrayList)this.getProperty(ATTENDEE);
        if (null != alist) {
            for (int i = 0; i < alist.size(); ++i) {
                Attendee attFromList = (Attendee)alist.get(i);
                if (!attVal.equals(attFromList.getValue())) continue;
                alist.remove(i);
                if (alist.size() <= 0) {
                    this.removeProperty(ATTENDEE);
                }
                this.hasAttendeeChanged = true;
                break;
            }
        }
    }

    public void removeAllAttendees() {
        this.removeProperty(ATTENDEE);
        this.hasAttendeeChanged = true;
    }

    public void setAttendeeChange(boolean flag) {
        this.hasAttendeeChanged = flag;
    }

    public boolean hasAttendeeChanged() {
        return this.hasAttendeeChanged;
    }

    public int getAcceptedAttendeesCount() {
        int acceptedAttendeesCount = 0;
        Attendee[] attendeeList = this.getAttendees();
        if (attendeeList == null) {
            return -1;
        }
        for (int i = 0; i < attendeeList.length; ++i) {
            if (!"ACCEPTED".equals(attendeeList[i].getParticipantStatus())) continue;
            ++acceptedAttendeesCount;
        }
        return acceptedAttendeesCount;
    }

    public int getDeclinedAttendeesCount() {
        int declinedAttendeesCount = 0;
        Attendee[] attendeeList = this.getAttendees();
        if (attendeeList == null) {
            return -1;
        }
        for (int i = 0; i < attendeeList.length; ++i) {
            if (!"DECLINED".equals(attendeeList[i].getParticipantStatus())) continue;
            ++declinedAttendeesCount;
        }
        return declinedAttendeesCount;
    }

    public int getTentativeAttendeesCount() {
        int tentativeAttendeesCount = 0;
        Attendee[] attendeeList = this.getAttendees();
        if (attendeeList == null) {
            return -1;
        }
        for (int i = 0; i < attendeeList.length; ++i) {
            if (!STATUS_TENTATIVE.equals(attendeeList[i].getParticipantStatus())) continue;
            ++tentativeAttendeesCount;
        }
        return tentativeAttendeesCount;
    }

    public int getPendingAttendeesCount() {
        int pendingAttendeesCount = 0;
        Attendee[] attendeeList = this.getAttendees();
        if (attendeeList == null) {
            return -1;
        }
        for (int i = 0; i < attendeeList.length; ++i) {
            if (!"NEEDS-ACTION".equals(attendeeList[i].getParticipantStatus())) continue;
            ++pendingAttendeesCount;
        }
        return pendingAttendeesCount;
    }

    public String[] getContacts() {
        ArrayList alist = (ArrayList)this.getProperty(CONTACT);
        if (null == alist) {
            return null;
        }
        String[] contacts = new String[alist.size()];
        return alist.toArray(contacts);
    }

    public void addContact(String contact) {
        if (null == contact) {
            return;
        }
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(CONTACT);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(contact);
            this.setProperty(CONTACT, alist);
            this.hasContactChanged = true;
        } else {
            alist.add(contact);
            this.hasContactChanged = true;
        }
    }

    public void removeContact(String contact) {
        if (null == contact) {
            return;
        }
        ArrayList alist = (ArrayList)this.getProperty(CONTACT);
        if (null != alist) {
            for (int i = 0; i < alist.size(); ++i) {
                if (!contact.equals((String)alist.get(i))) continue;
                alist.remove(i);
                if (alist.size() <= 0) {
                    this.removeProperty(CONTACT);
                }
                this.hasContactChanged = true;
                break;
            }
        }
    }

    public void removeAllContacts() {
        this.removeProperty(CONTACT);
        this.hasContactChanged = true;
    }

    public void setContactChange(boolean flag) {
        this.hasContactChanged = flag;
    }

    public boolean hasContactChanged() {
        return this.hasContactChanged;
    }

    public String[] getComments() {
        ArrayList alist = (ArrayList)this.getProperty(COMMENT);
        if (null == alist) {
            return null;
        }
        String[] comments = new String[alist.size()];
        return alist.toArray(comments);
    }

    public void addComment(String comment) {
        if (null == comment) {
            return;
        }
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(COMMENT);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(comment);
            this.setProperty(COMMENT, alist);
        } else {
            alist.add(comment);
        }
    }

    public void removeComment(String comment) {
        if (null == comment) {
            return;
        }
        ArrayList alist = (ArrayList)this.getProperty(COMMENT);
        if (null != alist) {
            for (int i = 0; i < alist.size(); ++i) {
                if (!comment.equals((String)alist.get(i))) continue;
                alist.remove(i);
                if (alist.size() > 0) break;
                this.removeProperty(COMMENT);
                break;
            }
        }
    }

    public void removeAllComments() {
        this.removeProperty(COMMENT);
    }

    public DateTime getStamp() {
        return (DateTime)this.getProperty(DTSTAMP);
    }

    public void setStamp(DateTime dtstamp) {
        this.setProperty(DTSTAMP, dtstamp);
    }

    public Duration getDuration() {
        return (Duration)this.getProperty(DURATION);
    }

    public Organizer getOrganizer() {
        return (Organizer)this.getProperty(ORGANIZER);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(ORGANIZER, organizer);
    }

    public boolean isCalIdTheOrganizer(String calId) {
        if (this.hasProperty(ORGANIZER)) {
            String orgValue = this.getOrganizer().getValue();
            if (orgValue == null) {
                return false;
            }
            return orgValue.equals(calId);
        }
        return false;
    }

    public String[] getRequestStatus() {
        ArrayList alist = (ArrayList)this.getProperty(RSTATUS);
        if (null == alist) {
            return null;
        }
        String[] requeststatus = new String[alist.size()];
        return alist.toArray(requeststatus);
    }

    public void addRequestStatus(String requeststatus) {
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(RSTATUS);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(requeststatus);
            this.setProperty(RSTATUS, alist);
        } else {
            alist.add(requeststatus);
        }
    }

    public void removeRequestStatus(String requeststatus) {
        int rstatusIndex;
        ArrayList alist = (ArrayList)this.getProperty(RSTATUS);
        if (null != alist && -1 != (rstatusIndex = alist.indexOf(requeststatus))) {
            alist.remove(rstatusIndex);
            if (alist.size() <= 0) {
                this.removeProperty(RSTATUS);
            }
        }
    }

    public void removeAllRequestStatus() {
        this.removeProperty(RSTATUS);
    }

    public String getID() {
        return (String)this.getProperty(UID);
    }

    public void setID(String uid) {
        this.setProperty(UID, uid);
    }

    public String getUrl() {
        return (String)this.getProperty(URL);
    }

    public void setUrl(String url) {
        this.setProperty(URL, url);
        this.hasUrlChanged = true;
    }

    public void setUrlChange(boolean flag) {
        this.hasUrlChanged = flag;
    }

    public boolean hasUrlChanged() {
        return this.hasUrlChanged;
    }

    public String getCalID() {
        return (String)this.getProperty(CALID);
    }

    public void setCalID(String id) {
        this.setProperty(CALID, id);
    }

    public DateTime getStart() {
        return (DateTime)this.getProperty(DTSTART);
    }

    public void setStart(DateTime dtstart) {
        this.setProperty(DTSTART, dtstart);
    }

    public DateTime getEnd() {
        return (DateTime)this.getProperty("DTEND");
    }

    public void setEnd(DateTime dtend) throws CalendarComponentException {
        if (this.hasProperty(DURATION)) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property name", 111);
            throw ex;
        }
        this.setProperty("DTEND", dtend);
    }

    public void setDuration(Duration duration) throws CalendarComponentException {
        if (this.hasProperty("DTEND")) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property name ", 111);
            throw ex;
        }
        this.setProperty(DURATION, duration);
    }

    public VAlarm[] getAlarmComponents() {
        ArrayList alist = (ArrayList)this.getProperty(ALARM_COMPONENT);
        if (alist == null) {
            return null;
        }
        VAlarm[] alarm = new VAlarm[alist.size()];
        return alist.toArray(alarm);
    }

    public void addAlarmComponent(VAlarm alarm) {
        ArrayList<VAlarm> alist = (ArrayList<VAlarm>)this.getProperty(ALARM_COMPONENT);
        if (null == alist) {
            alist = new ArrayList<VAlarm>();
            alist.add(alarm);
            this.setProperty(ALARM_COMPONENT, alist);
            this.hasAlarmChanged = true;
        } else {
            alist.add(alarm);
            this.hasAlarmChanged = true;
        }
    }

    public void removeAlarmComponent(VAlarm alarm) {
        int alarmIndex;
        ArrayList alist = (ArrayList)this.getProperty(ALARM_COMPONENT);
        if (null != alist && -1 != (alarmIndex = alist.indexOf(alarm))) {
            alist.remove(alarmIndex);
            if (alist.size() <= 0) {
                this.removeProperty(ALARM_COMPONENT);
            }
            this.hasAlarmChanged = true;
        }
    }

    public void removeAllAlarmComponents() {
        this.removeProperty(ALARM_COMPONENT);
        this.hasAlarmChanged = true;
    }

    public boolean hasAlarm() {
        return this.hasProperty(ALARM_COMPONENT);
    }

    public void setAlarmChange(boolean flag) {
        this.hasAlarmChanged = flag;
    }

    public boolean hasAlarmChanged() {
        return this.hasAlarmChanged;
    }

    public Attach[] getAttachments() {
        ArrayList alist = (ArrayList)this.getProperty(ATTACHMENT);
        if (alist == null) {
            return null;
        }
        Attach[] attachment = new Attach[alist.size()];
        return alist.toArray(attachment);
    }

    public void addAttachment(Attach attachment) {
        ArrayList<Attach> alist = (ArrayList<Attach>)this.getProperty(ATTACHMENT);
        if (null == alist) {
            alist = new ArrayList<Attach>();
            alist.add(attachment);
            this.setProperty(ATTACHMENT, alist);
            this.hasAttachmentChanged = true;
        } else {
            alist.add(attachment);
            this.hasAttachmentChanged = true;
        }
    }

    public void removeAttachment(Attach attachment) {
        int attachmentIndex;
        ArrayList alist = (ArrayList)this.getProperty(ATTACHMENT);
        if (null != alist && -1 != (attachmentIndex = alist.indexOf(attachment))) {
            alist.remove(attachmentIndex);
            if (alist.size() <= 0) {
                this.removeProperty(ATTACHMENT);
            }
            this.hasAttachmentChanged = true;
        }
    }

    public void removeAllAttachments() {
        this.removeProperty(ATTACHMENT);
        this.hasAttachmentChanged = true;
    }

    public void setAttachmentChange(boolean flag) {
        this.hasAttachmentChanged = flag;
    }

    public boolean hasAttachmentChanged() {
        return this.hasAttachmentChanged;
    }

    public String[] getCategories() {
        ArrayList alist = (ArrayList)this.getProperty(CATEGORIES);
        if (alist == null) {
            return null;
        }
        String[] categories = new String[alist.size()];
        return alist.toArray(categories);
    }

    public void addCategory(String category) {
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(CATEGORIES);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(category);
            this.setProperty(CATEGORIES, alist);
            this.hasCategoryChanged = true;
        } else {
            alist.add(category);
            this.hasCategoryChanged = true;
        }
    }

    public void removeCategory(String category) {
        int categoryIndex;
        ArrayList alist = (ArrayList)this.getProperty(CATEGORIES);
        if (null != alist && -1 != (categoryIndex = alist.indexOf(category))) {
            alist.remove(categoryIndex);
            if (alist.size() <= 0) {
                this.removeProperty(CATEGORIES);
            }
            this.hasCategoryChanged = true;
        }
    }

    public void removeAllCategories() {
        this.removeProperty(CATEGORIES);
        this.hasCategoryChanged = true;
    }

    public void setCategoryChange(boolean flag) {
        this.hasCategoryChanged = flag;
    }

    public boolean hasCategoryChanged() {
        return this.hasCategoryChanged;
    }

    public String getClassification() {
        return (String)this.getProperty(CLASSIFICATION);
    }

    public void setClassification(String classification) throws CalendarComponentException {
        if (!classification.toUpperCase().startsWith("X") && _classificationValues.get(classification.toUpperCase()) == null) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property Value", 112);
            throw ex;
        }
        this.setProperty(CLASSIFICATION, classification.toUpperCase());
    }

    public boolean isPublic() {
        if (this.hasProperty(CLASSIFICATION)) {
            return CLASSIFICATION_PUBLIC.equals(this.getClassification());
        }
        return false;
    }

    public DateTime getCreated() {
        return (DateTime)this.getProperty(CREATED);
    }

    public String getDescription() {
        return (String)this.getProperty(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, description);
        this.hasDescriptionChanged = true;
    }

    public void setDescriptionChange(boolean flag) {
        this.hasDescriptionChanged = flag;
    }

    public boolean hasDescriptionChanged() {
        return this.hasDescriptionChanged;
    }

    public DateTime getLastModified() {
        return (DateTime)this.getProperty(LAST_MODIFIED);
    }

    public void setLastModified(DateTime lastModified) {
        this.setProperty(LAST_MODIFIED, lastModified);
    }

    public String getLocation() {
        return (String)this.getProperty(LOCATION);
    }

    public void setLocation(String location) {
        this.setProperty(LOCATION, location);
        this.hasLocationChanged = true;
    }

    public void setLocationChange(boolean flag) {
        this.hasLocationChanged = flag;
    }

    public boolean hasLocationChanged() {
        return this.hasLocationChanged;
    }

    public String getGeo() {
        return (String)this.getProperty(GEO);
    }

    public void setGeo(String geo) throws CalendarComponentException {
        int geoSeparatorIndex = geo.indexOf(";");
        if (geoSeparatorIndex == -1) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property value", 112);
            throw ex;
        }
        try {
            Float latitude = new Float(geo.substring(0, geoSeparatorIndex));
            Float longitude = new Float(geo.substring(geoSeparatorIndex + 1));
        }
        catch (NumberFormatException e) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property value", 112);
            throw ex;
        }
        this.setProperty(GEO, geo);
    }

    public int getPriority() {
        Integer priority = (Integer)this.getProperty(PRIORITY);
        if (priority == null) {
            return -1;
        }
        return priority;
    }

    public void setPriority(int priority) throws CalendarComponentException {
        if (priority > 9 || priority < 0) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property value", 112);
            throw ex;
        }
        this.setProperty(PRIORITY, new Integer(priority));
    }

    public DateTime getRecurrenceID() {
        return (DateTime)this.getProperty(RECURRENCE_ID);
    }

    public boolean isRecurring() {
        return this.hasProperty(RECURRENCE_ID);
    }

    public String[] getRelatedTos() {
        ArrayList alist = (ArrayList)this.getProperty(RELATED_TO);
        if (null == alist) {
            return null;
        }
        String[] relatedTo = new String[alist.size()];
        return alist.toArray(relatedTo);
    }

    public void addRelatedTo(String relatedTo) {
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(RELATED_TO);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(relatedTo);
            this.setProperty(RELATED_TO, alist);
            this.hasRelatedToChanged = true;
        } else {
            alist.add(relatedTo);
            this.hasRelatedToChanged = true;
        }
    }

    public void removeRelatedTo(String relatedTo) {
        int relatedToIndex;
        ArrayList alist = (ArrayList)this.getProperty(RELATED_TO);
        if (null != alist && -1 != (relatedToIndex = alist.indexOf(relatedTo))) {
            alist.remove(relatedToIndex);
            if (alist.size() <= 0) {
                this.removeProperty(RELATED_TO);
            }
            this.hasRelatedToChanged = true;
        }
    }

    public void removeAllRelatedTos() {
        this.removeProperty(RELATED_TO);
        this.hasRelatedToChanged = true;
    }

    public void setRelatedToChange(boolean flag) {
        this.hasRelatedToChanged = flag;
    }

    public boolean hasRelatedToChanged() {
        return this.hasRelatedToChanged;
    }

    public String[] getResources() {
        ArrayList alist = (ArrayList)this.getProperty(RESOURCES);
        if (null == alist) {
            return null;
        }
        String[] resources = new String[alist.size()];
        return alist.toArray(resources);
    }

    public void addResource(String resource) {
        ArrayList<String> alist = (ArrayList<String>)this.getProperty(RESOURCES);
        if (null == alist) {
            alist = new ArrayList<String>();
            alist.add(resource);
            this.setProperty(RESOURCES, alist);
            this.hasResourceChanged = true;
        } else {
            alist.add(resource);
            this.hasResourceChanged = true;
        }
    }

    public void removeResource(String resource) {
        int resourceIndex;
        ArrayList alist = (ArrayList)this.getProperty(RESOURCES);
        if (null != alist && -1 != (resourceIndex = alist.indexOf(resource))) {
            alist.remove(resourceIndex);
            if (alist.size() <= 0) {
                this.removeProperty(RESOURCES);
            }
            this.hasResourceChanged = true;
        }
    }

    public void removeAllResources() {
        this.removeProperty(RESOURCES);
        this.hasResourceChanged = true;
    }

    public void setResourceChange(boolean flag) {
        this.hasResourceChanged = flag;
    }

    public boolean hasResourceChanged() {
        return this.hasResourceChanged;
    }

    public int getSequence() {
        Integer sequence = (Integer)this.getProperty(SEQUENCE);
        if (sequence == null) {
            return -1;
        }
        return sequence;
    }

    public void setSequence(int sequence) {
        this.setProperty(SEQUENCE, new Integer(sequence));
    }

    public String getStatus() {
        return (String)this.getProperty(STATUS);
    }

    public void setStatus(String status) throws CalendarComponentException {
        if (_statusValues.get(status.toUpperCase()) != null) {
            this.setProperty(STATUS, status.toUpperCase());
            return;
        }
        CalendarComponentException ex = new CalendarComponentException("Invalid Property value", 112);
        throw ex;
    }

    public String getSummary() {
        return (String)this.getProperty(SUMMARY);
    }

    public void setSummary(String summary) {
        this.setProperty(SUMMARY, summary);
        this.hasSummaryChanged = true;
    }

    public void setSummaryChange(boolean flag) {
        this.hasSummaryChanged = flag;
    }

    public boolean hasSummaryChanged() {
        return this.hasSummaryChanged;
    }

    public DateTime[] getExceptionDates() {
        ArrayList alist = (ArrayList)this.getProperty(EXCEPTION_DATES);
        if (alist == null) {
            return null;
        }
        DateTime[] exDates = new DateTime[alist.size()];
        return alist.toArray(exDates);
    }

    public void addExceptionDate(DateTime exceptionDate) {
        ArrayList<DateTime> alist = (ArrayList<DateTime>)this.getProperty(EXCEPTION_DATES);
        if (null == alist) {
            alist = new ArrayList<DateTime>();
            alist.add(exceptionDate);
            this.setProperty(EXCEPTION_DATES, alist);
            this.hasExceptionDateChanged = true;
        } else {
            alist.add(exceptionDate);
            this.hasExceptionDateChanged = true;
        }
    }

    private void addExceptionDate(DateTime exceptionDate, boolean recurrenceChangeFlag) {
        this.addExceptionDate(exceptionDate);
        this.hasExceptionDateChanged = recurrenceChangeFlag;
    }

    public void removeExceptionDate(DateTime exceptionDate) {
        int exceptionDateIndex;
        ArrayList alist = (ArrayList)this.getProperty(EXCEPTION_DATES);
        if (null != alist && -1 != (exceptionDateIndex = alist.indexOf(exceptionDate))) {
            alist.remove(exceptionDateIndex);
            if (alist.size() <= 0) {
                this.removeProperty(EXCEPTION_DATES);
            }
            this.hasExceptionDateChanged = true;
        }
    }

    public void removeAllExceptionDates() {
        this.removeProperty(EXCEPTION_DATES);
        this.hasExceptionDateChanged = true;
    }

    public boolean hasExceptionDateChanged() {
        return this.hasExceptionDateChanged;
    }

    public void setExceptionDateChange(boolean exceptionDateChanged) {
        this.hasExceptionDateChanged = exceptionDateChanged;
    }

    public RecurrencePattern[] getExceptionRules() {
        ArrayList alist = (ArrayList)this.getProperty(EXCEPTION_RULE);
        if (null == alist) {
            return null;
        }
        RecurrencePattern[] exrule = new RecurrencePattern[alist.size()];
        return alist.toArray(exrule);
    }

    public void addExceptionRule(RecurrencePattern exceptionRule) {
        ArrayList<RecurrencePattern> alist = (ArrayList<RecurrencePattern>)this.getProperty(EXCEPTION_RULE);
        if (null == alist) {
            alist = new ArrayList<RecurrencePattern>();
            alist.add(exceptionRule);
            this.setProperty(EXCEPTION_RULE, alist);
            this.hasExceptionRuleChanged = true;
        } else {
            alist.add(exceptionRule);
            this.hasExceptionRuleChanged = true;
        }
    }

    private void addExceptionRule(RecurrencePattern exceptionRule, boolean recurrenceChangeFlag) {
        this.addExceptionRule(exceptionRule);
        this.hasExceptionRuleChanged = recurrenceChangeFlag;
    }

    public void removeExceptionRule(RecurrencePattern exceptionRule) {
        int exruleIndex;
        ArrayList alist = (ArrayList)this.getProperty(EXCEPTION_RULE);
        if (null != alist && -1 != (exruleIndex = alist.indexOf(exceptionRule))) {
            alist.remove(exruleIndex);
            if (alist.size() <= 0) {
                this.removeProperty(EXCEPTION_RULE);
            }
            this.hasExceptionRuleChanged = true;
        }
    }

    public void removeAllExceptionRules() {
        this.removeProperty(EXCEPTION_RULE);
        this.hasExceptionRuleChanged = true;
    }

    public boolean hasExceptionRuleChanged() {
        return this.hasExceptionRuleChanged;
    }

    public void setExceptionRuleChange(boolean exceptionRuleChanged) {
        this.hasExceptionRuleChanged = exceptionRuleChanged;
    }

    public DateTime[] getRecurrenceDates() {
        ArrayList alist = (ArrayList)this.getProperty(RECURRENCE_DATES);
        if (alist == null) {
            return null;
        }
        DateTime[] rdate = new DateTime[alist.size()];
        return alist.toArray(rdate);
    }

    public void addRecurrenceDate(DateTime recurrenceDate) {
        ArrayList<DateTime> alist = (ArrayList<DateTime>)this.getProperty(RECURRENCE_DATES);
        if (null == alist) {
            alist = new ArrayList<DateTime>();
            alist.add(recurrenceDate);
            this.setProperty(RECURRENCE_DATES, alist);
            this.hasRecurrenceDateChanged = true;
        } else {
            alist.add(recurrenceDate);
            this.hasRecurrenceDateChanged = true;
        }
    }

    private void addRecurrenceDate(DateTime recurrenceDate, boolean recurrenceChangeFlag) {
        this.addRecurrenceDate(recurrenceDate);
        this.hasRecurrenceDateChanged = recurrenceChangeFlag;
    }

    public void removeRecurrenceDate(DateTime recurrenceDate) {
        int rdateIndex;
        ArrayList alist = (ArrayList)this.getProperty(RECURRENCE_DATES);
        if (null != alist && -1 != (rdateIndex = alist.indexOf(recurrenceDate))) {
            alist.remove(rdateIndex);
            if (alist.size() <= 0) {
                this.removeProperty(RECURRENCE_DATES);
            }
            this.hasRecurrenceDateChanged = true;
        }
    }

    public void removeAllRecurrenceDates() {
        this.removeProperty(RECURRENCE_DATES);
        this.hasRecurrenceDateChanged = true;
    }

    public boolean hasRecurrenceDateChanged() {
        return this.hasRecurrenceDateChanged;
    }

    public void setRecurrenceDateChange(boolean recurrenceDateChanged) {
        this.hasRecurrenceDateChanged = recurrenceDateChanged;
    }

    public RecurrencePattern[] getRecurrenceRules() {
        ArrayList alist = (ArrayList)this.getProperty(RECURRENCE_RULE);
        if (null == alist) {
            return null;
        }
        RecurrencePattern[] rrule = new RecurrencePattern[alist.size()];
        return alist.toArray(rrule);
    }

    public void addRecurrenceRule(RecurrencePattern recurrenceRule) {
        ArrayList<RecurrencePattern> alist = (ArrayList<RecurrencePattern>)this.getProperty(RECURRENCE_RULE);
        if (null == alist) {
            alist = new ArrayList<RecurrencePattern>();
            alist.add(recurrenceRule);
            this.setProperty(RECURRENCE_RULE, alist);
            this.hasRecurrenceRuleChanged = true;
        } else {
            alist.add(recurrenceRule);
            this.hasRecurrenceRuleChanged = true;
        }
    }

    private void addRecurrenceRule(RecurrencePattern recurrenceRule, boolean recurrenceChangeFlag) {
        this.addRecurrenceRule(recurrenceRule);
        this.hasRecurrenceRuleChanged = recurrenceChangeFlag;
    }

    public void removeRecurrenceRule(RecurrencePattern recurrenceRule) {
        int rruleIndex;
        ArrayList alist = (ArrayList)this.getProperty(RECURRENCE_RULE);
        if (null != alist && -1 != (rruleIndex = alist.indexOf(recurrenceRule))) {
            alist.remove(rruleIndex);
            if (alist.size() <= 0) {
                this.removeProperty(RECURRENCE_RULE);
            }
            this.hasRecurrenceRuleChanged = true;
        }
    }

    public void removeAllRecurrenceRules() {
        this.removeProperty(RECURRENCE_RULE);
        this.hasRecurrenceRuleChanged = true;
    }

    public boolean hasRecurrenceRuleChanged() {
        return this.hasRecurrenceRuleChanged;
    }

    public void setRecurrenceRuleChange(boolean recurrenceRuleChanged) {
        this.hasRecurrenceRuleChanged = recurrenceRuleChanged;
    }

    public boolean isConfirmed() {
        return this.hasProperty(STATUS) && this.getStatus().equalsIgnoreCase(STATUS_CONFIRMED);
    }

    public void setMethod(String method) {
        this.setProperty(METHOD, method);
    }

    public String getMethod() {
        return (String)this.getProperty(METHOD);
    }

    public void setStoreType(int storeType) throws CalendarComponentException, OperationNotSupportedException {
        if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
            Integer ver = (Integer)this.getProperty("WCAP_VERSION_INT");
            this.wcapVersionInUse = ver;
        }
        if (this.wcapVersionInUse < 300) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        if (storeType != STORETYPE_NONE && storeType != STORETYPE_CREATE && storeType != STORETYPE_MODIFY) {
            CalendarComponentException ex = new CalendarComponentException("Invalid Property value", 112);
            throw ex;
        }
        this.setProperty(STORETYPE, new Integer(storeType));
    }

    public int getStoreType() {
        Integer storeType = (Integer)this.getProperty(STORETYPE);
        if (storeType == null) {
            return -1;
        }
        return storeType;
    }

    public void setReplace(int replace) throws OperationNotSupportedException {
        if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
            Integer ver = (Integer)this.getProperty("WCAP_VERSION_INT");
            this.wcapVersionInUse = ver;
        }
        if (this.wcapVersionInUse < 300) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        this.setProperty(REPLACE, new Integer(replace));
    }

    public int getReplace() {
        Integer replace = (Integer)this.getProperty(REPLACE);
        if (replace == null) {
            return -1;
        }
        return replace;
    }

    public String toRFC2445() throws OperationNotSupportedException, CalendarComponentException {
        RecurrencePattern[] rpatList;
        int i;
        String rfc = "BEGIN:VEVENT";
        if (this.hasProperty(UID)) {
            rfc = rfc + "\nUID:" + this.getID();
        }
        if (this.hasProperty(DTSTART)) {
            rfc = this.isAllDay() ? rfc + "\nDTSTART:" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getStartTime()) : rfc + "\nDTSTART:" + this.getStartTime().toISO8601();
        }
        if (this.hasProperty(SUMMARY)) {
            rfc = rfc + "\nSUMMARY:" + this.getSummary();
        }
        if (this.hasProperty("DTEND")) {
            rfc = this.isAllDay() ? rfc + "\nDTEND:" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getEndTime()) : rfc + "\nDTEND:" + this.getEndTime().toISO8601();
        }
        if (this.hasProperty(DURATION)) {
            rfc = rfc + "\nDURATION:" + this.getDuration().toRFC2445();
        }
        if (this.hasProperty(CALID)) {
            rfc = rfc + "\nRELATIVE-CALID:" + this.getCalID();
        }
        if (this.hasProperty(DESCRIPTION)) {
            rfc = rfc + "\nDESCRIPTION:" + this.getDescription();
        }
        if (this.hasProperty(LOCATION)) {
            rfc = rfc + "\nLOCATION:" + this.getLocation();
        }
        if (this.hasProperty(CLASSIFICATION)) {
            rfc = rfc + "\nCLASS:" + this.getClassification();
        }
        if (this.hasProperty(DTSTAMP)) {
            rfc = rfc + "\nDTSTAMP:" + this.getStamp().toISO8601();
        }
        if (this.hasProperty(SEQUENCE)) {
            rfc = rfc + "\nSEQUENCE:" + Integer.toString(this.getSequence());
        }
        if (this.hasProperty(PRIORITY)) {
            rfc = rfc + "\nPRIORITY:" + Integer.toString(this.getPriority());
        }
        if (this.hasProperty(RECURRENCE_ID)) {
            rfc = rfc + "\nRECURRENCE-ID:" + this.getRecurrenceID().toISO8601();
        }
        if (this.hasProperty(TRANSP)) {
            rfc = rfc + "\nTRANSP:" + (String)this.getProperty(TRANSP);
        }
        if (this.hasProperty(ORGANIZER)) {
            rfc = rfc + "\n" + this.getOrganizer().toRFC2445();
        }
        if (this.hasAttendee()) {
            Attendee[] attendeeList = this.getAttendees();
            for (i = 0; i < attendeeList.length; ++i) {
                rfc = rfc + "\n" + attendeeList[i].toRFC2445();
            }
        }
        if (this.hasProperty(EXCEPTION_DATES)) {
            DateTime[] exdateList = this.getExceptionDates();
            for (i = 0; i < exdateList.length; ++i) {
                rfc = rfc + "\nEXDATE:" + exdateList[i].toISO8601();
            }
        }
        if (this.hasProperty(EXCEPTION_RULE)) {
            rpatList = this.getExceptionRules();
            for (i = 0; i < rpatList.length; ++i) {
                rfc = rfc + "\nEXRULE:" + rpatList[i].generatePattern();
            }
        }
        if (this.hasProperty(RECURRENCE_DATES)) {
            DateTime[] rdateList = this.getRecurrenceDates();
            for (i = 0; i < rdateList.length; ++i) {
                rfc = rfc + "\nRDATE:" + rdateList[i].toISO8601();
            }
        }
        if (this.hasProperty(RECURRENCE_RULE)) {
            rpatList = this.getRecurrenceRules();
            for (i = 0; i < rpatList.length; ++i) {
                rfc = rfc + "\nRRULE:" + rpatList[i].generatePattern();
            }
        }
        if (this.hasProperty(STATUS)) {
            rfc = rfc + "\nSTATUS:" + this.getStatus();
        }
        if (this.hasProperty(GEO)) {
            rfc = rfc + "\nGEO:" + this.getGeo();
        }
        if (this.hasProperty(CREATED)) {
            rfc = rfc + "\nCREATED:" + ((DateTime)this.getProperty(CREATED)).toISO8601();
        }
        if (this.hasProperty(LAST_MODIFIED)) {
            rfc = rfc + "\nLAST-MODIFIED:" + ((DateTime)this.getProperty(LAST_MODIFIED)).toISO8601();
        }
        if (this.hasProperty(ALARM_COMPONENT)) {
            VAlarm[] alarmList = this.getAlarmComponents();
            for (i = 0; i < alarmList.length; ++i) {
                rfc = rfc + "\n" + ((SOCSAlarm)alarmList[i]).toRFC2445();
            }
        }
        if (this.hasProperty(ATTACHMENT)) {
            Attach[] attachList = this.getAttachments();
            for (i = 0; i < attachList.length; ++i) {
                rfc = rfc + "\n" + attachList[i].toRFC2445();
            }
        }
        if (this.hasProperty(CATEGORIES)) {
            String[] categoryList = this.getCategories();
            for (i = 0; i < categoryList.length; ++i) {
                rfc = rfc + "\nCATEGORIES:" + categoryList[i];
            }
        }
        if (this.hasProperty(COMMENT)) {
            String[] commentList = this.getComments();
            for (i = 0; i < commentList.length; ++i) {
                rfc = rfc + "\nCOMMENT:" + commentList[i];
            }
        }
        if (this.hasProperty(CONTACT)) {
            String[] contactList = this.getContacts();
            for (i = 0; i < contactList.length; ++i) {
                rfc = rfc + "\nCONTACT:" + contactList[i];
            }
        }
        if (this.hasProperty(RSTATUS)) {
            String[] rstatusList = this.getRequestStatus();
            for (i = 0; i < rstatusList.length; ++i) {
                rfc = rfc + "\nRSTATUS:" + rstatusList[i];
            }
        }
        if (this.hasProperty(RELATED_TO)) {
            String[] relatedToList = this.getRelatedTos();
            for (i = 0; i < relatedToList.length; ++i) {
                rfc = rfc + "\nRELATED-TO:" + relatedToList[i];
            }
        }
        if (this.hasProperty(RESOURCES)) {
            String[] resourceList = this.getResources();
            for (i = 0; i < resourceList.length; ++i) {
                rfc = rfc + "\nRESOURCES:" + resourceList[i];
            }
        }
        rfc = rfc + "\nEND:VEVENT";
        return rfc;
    }

    public void loadFromStream(SOCSSession session, Properties props, Properties parsingProperties) throws ParseException {
        String tzid;
        TimeZone tz = null;
        if (parsingProperties != null && (tzid = (String)parsingProperties.get("cal.socs.preferredTimezone")) != null) {
            tz = TimeZone.getTimeZone(tzid);
        }
        if (tz == null) {
            tz = session.getCalStore().getSession().getTimeZone();
        }
        if (tz == null) {
            tz = session.getTimeZone();
        }
        this.wcapVersionInUse = session.getCalStore().getProtocolVersionInt();
        this.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
        int i = 0;
        int len = 0;
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            String value = props.getProperty(prop);
            try {
                RecurrencePattern rpat;
                ArrayList col;
                if (prop.equals(CLASSIFICATION)) {
                    this.setClassification(value);
                    continue;
                }
                if (prop.equals(CREATED)) {
                    this.setProperty(CREATED, new DateTime(value, tz));
                    continue;
                }
                if (prop.equals("DESC")) {
                    this.setDescription(value);
                    continue;
                }
                if (prop.equals("START")) {
                    if (SOCSUtils.isDateAllDay(value)) {
                        this.setAllDay(true);
                        this.setStartTime(SOCSUtils.parseToAllDayDateTime(value, tz));
                        continue;
                    }
                    this.setStartTime(new DateTime(value, tz));
                    continue;
                }
                if (prop.equals(GEO)) {
                    this.setGeo(value);
                    continue;
                }
                if (prop.equals("LAST-MOD")) {
                    this.setProperty(LAST_MODIFIED, new DateTime(value, tz));
                    continue;
                }
                if (prop.equals(LOCATION)) {
                    this.setLocation(value);
                    continue;
                }
                if (prop.equals(ORGANIZER)) {
                    Object orgObj = props.get(prop);
                    if (!(orgObj instanceof Properties)) continue;
                    Properties orgProp = (Properties)orgObj;
                    Organizer organizer = SOCSUtils.parseToOrganizer(orgProp);
                    this.setOrganizer(organizer);
                    continue;
                }
                if (prop.equals(PRIORITY)) {
                    this.setPriority(Integer.parseInt(value));
                    continue;
                }
                if (prop.equals(DTSTAMP)) {
                    this.setStamp(new DateTime(value, tz));
                    continue;
                }
                if (prop.equals(SEQUENCE)) {
                    this.setSequence(Integer.parseInt(value));
                    continue;
                }
                if (prop.equals(STATUS)) {
                    this.setStatus(value);
                    continue;
                }
                if (prop.equals(SUMMARY)) {
                    this.setSummary(value);
                    continue;
                }
                if (prop.equals(CALID)) {
                    this.setCalID(value);
                    continue;
                }
                if (prop.equals(TRANSP)) {
                    this.setProperty(TRANSP, value);
                    continue;
                }
                if (prop.equals(UID)) {
                    value = SOCSUtils.trim(value);
                    this.setID(value);
                    continue;
                }
                if (prop.equals(URL)) {
                    this.setProperty(URL, value);
                    continue;
                }
                if (prop.equals("RECURID")) {
                    this.setProperty(RECURRENCE_ID, new DateTime(value, tz));
                    continue;
                }
                if (prop.equals("END")) {
                    if (SOCSUtils.isDateAllDay(value)) {
                        this.setEndTime(SOCSUtils.parseToAllDayDateTime(value, tz));
                        continue;
                    }
                    this.setEndTime(new DateTime(value, tz));
                    continue;
                }
                if (prop.equals(DURATION)) {
                    this.setDuration(new Duration(value));
                    continue;
                }
                if (prop.equals(ATTACHMENT)) {
                    Object attachObj = props.get(prop);
                    if (!(attachObj instanceof ArrayList)) continue;
                    col = (ArrayList)attachObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        Properties attachProp = (Properties)col.get(i);
                        Attach attach = SOCSUtils.parseToAttach(attachProp);
                        this.addAttachment(attach);
                    }
                    continue;
                }
                if (prop.equals(ATTENDEE)) {
                    Object attObj = props.get(prop);
                    if (!(attObj instanceof ArrayList)) continue;
                    col = (ArrayList)attObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        Properties attProp = (Properties)col.get(i);
                        Attendee attendee = SOCSUtils.parseToAttendee(attProp);
                        this.addAttendee(attendee);
                    }
                    continue;
                }
                if (prop.equals(CATEGORIES)) {
                    Object categoryObj = props.get(prop);
                    if (!(categoryObj instanceof ArrayList)) continue;
                    col = (ArrayList)categoryObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String categoryValue = (String)col.get(i);
                        this.addCategory(categoryValue);
                    }
                    continue;
                }
                if (prop.equals(COMMENT)) {
                    Object commentObj = props.get(prop);
                    if (!(commentObj instanceof ArrayList)) continue;
                    col = (ArrayList)commentObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String commentValue = (String)col.get(i);
                        this.addComment(commentValue);
                    }
                    continue;
                }
                if (prop.equals(CONTACT)) {
                    Object contactObj = props.get(prop);
                    if (!(contactObj instanceof ArrayList)) continue;
                    col = (ArrayList)contactObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String contactValue = (String)col.get(i);
                        this.addContact(contactValue);
                    }
                    continue;
                }
                if (prop.equals(EXCEPTION_DATES)) {
                    Object exdateObj = props.get(prop);
                    if (!(exdateObj instanceof ArrayList)) continue;
                    col = (ArrayList)exdateObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String exdateValue = (String)col.get(i);
                        DateTime exdate = new DateTime(exdateValue, tz);
                        this.addRecurrenceDate(exdate, false);
                    }
                    continue;
                }
                if (prop.equals(EXCEPTION_RULE)) {
                    Object exruleObj = props.get(prop);
                    if (!(exruleObj instanceof ArrayList)) continue;
                    col = (ArrayList)exruleObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String exruleValue = (String)col.get(i);
                        exruleValue = null == exruleValue ? null : exruleValue.trim();
                        rpat = new RecurrencePattern(exruleValue);
                        this.addExceptionRule(rpat, false);
                    }
                    continue;
                }
                if (prop.equals(RSTATUS)) {
                    Object rstatusObj = props.get(prop);
                    if (!(rstatusObj instanceof ArrayList)) continue;
                    col = (ArrayList)rstatusObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String rstatusValue = (String)col.get(i);
                        this.addRequestStatus(rstatusValue);
                    }
                    continue;
                }
                if (prop.equals(RELATED_TO)) {
                    Object relatedtoObj = props.get(prop);
                    if (!(relatedtoObj instanceof ArrayList)) continue;
                    col = (ArrayList)relatedtoObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String relatedtoValue = (String)col.get(i);
                        this.addRelatedTo(relatedtoValue);
                    }
                    continue;
                }
                if (prop.equals(RESOURCES)) {
                    Object resourceObj = props.get(prop);
                    if (!(resourceObj instanceof ArrayList)) continue;
                    col = (ArrayList)resourceObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String resourceValue = (String)col.get(i);
                        this.addResource(resourceValue);
                    }
                    continue;
                }
                if (prop.equals(RECURRENCE_DATES)) {
                    Object rdateObj = props.get(prop);
                    if (!(rdateObj instanceof ArrayList)) continue;
                    col = (ArrayList)rdateObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String rdateValue = (String)col.get(i);
                        DateTime rdate = new DateTime(rdateValue, tz);
                        this.addRecurrenceDate(rdate, false);
                    }
                    continue;
                }
                if (prop.equals(RECURRENCE_RULE)) {
                    Object rruleObj = props.get(prop);
                    if (!(rruleObj instanceof ArrayList)) continue;
                    col = (ArrayList)rruleObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        String rruleValue = (String)col.get(i);
                        rruleValue = null == rruleValue ? null : rruleValue.trim();
                        rpat = new RecurrencePattern(rruleValue);
                        this.addRecurrenceRule(rpat, false);
                    }
                    continue;
                }
                if (prop.equals("VALARM")) {
                    Object alarmObj = props.get(prop);
                    if (!(alarmObj instanceof ArrayList)) continue;
                    col = (ArrayList)alarmObj;
                    len = col.size();
                    for (i = 0; i < len; ++i) {
                        Properties alarmProp = (Properties)col.get(i);
                        SOCSAlarm alarm = SOCSUtils.parseToVAlarm(alarmProp);
                        this.addAlarmComponent(alarm);
                    }
                    continue;
                }
                if (value == null) continue;
                this.setProperty(prop, value);
            }
            catch (PropertiesException pe) {
            }
            catch (OperationNotSupportedException onse) {
            }
            catch (CalendarComponentException cce) {}
        }
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasRelatedToChanged = false;
        this.hasResourceChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
    }

    public VAlarm createAlarm() throws OperationNotSupportedException {
        return new SOCSAlarm();
    }

    public void parseToSOCS(ArrayList args, String thisUserCalId) {
        String temp = null;
        boolean isUpdate = false;
        try {
            String[] commentList;
            int i;
            StringBuffer tempBuf;
            Organizer organizer;
            if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
                Integer ver = (Integer)this.getProperty("WCAP_VERSION_INT");
                this.wcapVersionInUse = ver;
            }
            if (this.wcapVersionInUse >= 300 && !(temp = Integer.toString(this.getStoreType())).equals("-1")) {
                args.add("storetype=" + SOCSUtils.urlEncode(temp));
                if (this.getStoreType() == STORETYPE_MODIFY) {
                    if (this.hasProperty(REPLACE)) {
                        temp = Integer.toString(this.getReplace());
                        if (!temp.equals("-1")) {
                            args.add("replace=" + SOCSUtils.urlEncode(temp));
                            if (this.getReplace() == REPLACE_UPDATE) {
                                isUpdate = true;
                            }
                        }
                    } else if (this.hasAlarmChanged || this.hasAttachmentChanged || this.hasAttendeeChanged || this.hasCategoryChanged || this.hasContactChanged || this.hasDescriptionChanged || this.hasExceptionDateChanged || this.hasExceptionRuleChanged || this.hasLocationChanged || this.hasRecurrenceDateChanged || this.hasRecurrenceRuleChanged || this.hasRelatedToChanged || this.hasResourceChanged || this.hasSummaryChanged || this.hasUrlChanged) {
                        args.add("replace=" + REPLACE_UPDATE);
                        isUpdate = true;
                    }
                }
            }
            if (null != (temp = this.getClassification())) {
                args.add("icsClass=" + temp);
            }
            if (null != (temp = this.getDescription())) {
                args.add("desc=" + SOCSUtils.urlEncode(temp));
            } else if (isUpdate && this.hasDescriptionChanged && this.wcapVersionInUse >= 300) {
                args.add("desc=");
            }
            temp = this.getGeo();
            if (null != temp) {
                args.add("geo=" + SOCSUtils.urlEncode(temp));
            }
            if (null != (temp = this.getLocation())) {
                args.add("location=" + SOCSUtils.urlEncode(temp));
            } else if (isUpdate && this.hasLocationChanged && this.wcapVersionInUse >= 300) {
                args.add("location=");
            }
            if (this.hasProperty(ORGANIZER) && null != (temp = (organizer = this.getOrganizer()).getValue())) {
                if (temp.toUpperCase().startsWith("MAILTO:")) {
                    temp = temp.substring(7);
                    args.add("orgEmail=" + SOCSUtils.urlEncode(temp));
                } else if (this.wcapVersionInUse >= 300) {
                    args.add("orgCalid=" + SOCSUtils.urlEncode(temp));
                } else {
                    args.add("orgUID=" + SOCSUtils.urlEncode(temp));
                }
                temp = organizer.getCommonName();
                if (null != temp && this.wcapVersionInUse >= 300) {
                    args.add("orgCN=" + SOCSUtils.urlEncode(temp));
                }
            }
            if (!(temp = Integer.toString(this.getPriority())).equals("-1")) {
                args.add("priority=" + SOCSUtils.urlEncode(temp));
            }
            if (null != this.getRecurrenceID()) {
                args.add("rid=" + this.getRecurrenceID().toISO8601());
            }
            if (!(temp = Integer.toString(this.getSequence())).equals("-1")) {
                args.add("sequence=" + SOCSUtils.urlEncode(temp));
            }
            if (null != (temp = this.getStatus())) {
                args.add("status=" + SOCSUtils.getSOCSStatus(temp));
            }
            if (null != (temp = this.getSummary())) {
                args.add("summary=" + SOCSUtils.urlEncode(temp));
            } else if (isUpdate && this.hasSummaryChanged && this.wcapVersionInUse >= 300) {
                args.add("summary=");
            }
            temp = this.getID();
            if (null != temp) {
                args.add("uid=" + SOCSUtils.urlEncode(temp));
            }
            if (null != (temp = (String)this.getProperty(URL))) {
                args.add("icsUrl=" + SOCSUtils.urlEncode(temp));
            } else if (isUpdate && this.hasUrlChanged && this.wcapVersionInUse >= 300) {
                args.add("icsUrl=");
            }
            temp = (String)this.getProperty(TRANSP);
            if (null != temp && this.wcapVersionInUse >= 300) {
                args.add("transparent=" + SOCSUtils.getSOCSTransp(temp));
            }
            if (this.isAllDay()) {
                args.add("isAllDay=1");
            } else {
                args.add("isAllDay=0");
            }
            if (this.getStartTime() != null) {
                if (this.isAllDay()) {
                    args.add("dtstart=" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getStartTime()));
                } else {
                    args.add("dtstart=" + this.getStartTime().toISO8601());
                }
            }
            if (this.getEndTime() != null) {
                if (this.isAllDay()) {
                    args.add("dtend=" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getEndTime()));
                } else {
                    args.add("dtend=" + this.getEndTime().toISO8601());
                }
            }
            if (this.hasProperty(DURATION)) {
                Duration duration = this.getDuration();
                temp = duration.toRFC2445();
                temp = temp.substring(9);
                args.add("duration=" + temp);
            }
            if (this.hasProperty(ATTACHMENT)) {
                Attach[] attachList = this.getAttachments();
                if (attachList != null) {
                    tempBuf = new StringBuffer("");
                    int numAttachments = attachList.length;
                    for (i = 0; i < numAttachments; ++i) {
                        if (i == numAttachments - 1) {
                            tempBuf.append(attachList[i].getValue());
                            continue;
                        }
                        tempBuf.append(attachList[i].getValue() + ";");
                    }
                    args.add("attachments=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasAttachmentChanged && this.wcapVersionInUse >= 300) {
                args.add("attachments=");
            }
            if (this.hasProperty(ATTENDEE)) {
                Attendee[] attendeeList = this.getAttendees();
                if (attendeeList != null) {
                    tempBuf = new StringBuffer("");
                    int numAttendees = attendeeList.length;
                    for (i = 0; i < numAttendees; ++i) {
                        try {
                            if (i == numAttendees - 1) {
                                tempBuf.append(SOCSUtils.parseAttendeeToSOCS(attendeeList[i]));
                                continue;
                            }
                            tempBuf.append(SOCSUtils.parseAttendeeToSOCS(attendeeList[i]) + ";");
                            continue;
                        }
                        catch (PropertiesException pe) {
                            // empty catch block
                        }
                    }
                    args.add("attendees=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasAttendeeChanged && this.wcapVersionInUse >= 300) {
                args.add("attendees=");
            }
            if (this.hasProperty(CATEGORIES)) {
                String[] categoryList = this.getCategories();
                if (categoryList != null) {
                    tempBuf = new StringBuffer("");
                    int numCategories = categoryList.length;
                    for (i = 0; i < numCategories; ++i) {
                        if (i == numCategories - 1) {
                            tempBuf.append(SOCSUtils.urlEncode(categoryList[i]));
                            continue;
                        }
                        tempBuf.append(SOCSUtils.urlEncode(categoryList[i]) + ";");
                    }
                    args.add("categories=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasCategoryChanged && this.wcapVersionInUse >= 300) {
                args.add("categories=");
            }
            if (this.hasProperty(COMMENT) && (commentList = this.getComments()) != null) {
                tempBuf = new StringBuffer("");
                int numComments = commentList.length;
                for (i = 0; i < numComments; ++i) {
                    if (i == numComments - 1) {
                        tempBuf.append(SOCSUtils.urlEncode(commentList[i]));
                        continue;
                    }
                    tempBuf.append(SOCSUtils.urlEncode(commentList[i]) + ";");
                }
                args.add("comments=" + tempBuf.toString());
                tempBuf = null;
            }
            if (this.hasProperty(CONTACT)) {
                String[] contactList = this.getContacts();
                if (contactList != null) {
                    tempBuf = new StringBuffer("");
                    int numContacts = contactList.length;
                    for (i = 0; i < numContacts; ++i) {
                        if (i == numContacts - 1) {
                            tempBuf.append(SOCSUtils.urlEncode(contactList[i]));
                            continue;
                        }
                        tempBuf.append(SOCSUtils.urlEncode(contactList[i]) + ";");
                    }
                    args.add("contacts=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasContactChanged && this.wcapVersionInUse >= 300) {
                args.add("contacts=");
            }
            if (this.hasProperty(EXCEPTION_DATES)) {
                DateTime[] exdateList = this.getExceptionDates();
                if (exdateList != null) {
                    tempBuf = new StringBuffer("");
                    int numExdates = exdateList.length;
                    for (i = 0; i < numExdates; ++i) {
                        if (i == numExdates - 1) {
                            tempBuf.append(exdateList[i].toISO8601());
                            continue;
                        }
                        tempBuf.append(exdateList[i].toISO8601() + ";");
                    }
                    args.add("exdates=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasExceptionDateChanged && this.wcapVersionInUse >= 300) {
                args.add("exdates=");
            }
            if (this.hasProperty(EXCEPTION_RULE)) {
                RecurrencePattern[] exruleList = this.getExceptionRules();
                if (exruleList != null) {
                    tempBuf = new StringBuffer("");
                    int numExrules = exruleList.length;
                    for (i = 0; i < numExrules; ++i) {
                        if (i == numExrules - 1) {
                            tempBuf.append(SOCSUtils.parseRecurrencePatternToSOCS(exruleList[i]));
                            continue;
                        }
                        tempBuf.append(SOCSUtils.parseRecurrencePatternToSOCS(exruleList[i]) + ";");
                    }
                    args.add("exrules=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasExceptionRuleChanged && this.wcapVersionInUse >= 300) {
                args.add("exrules=");
            }
            if (this.hasProperty(RELATED_TO)) {
                String[] relatedToList = this.getRelatedTos();
                if (relatedToList != null) {
                    tempBuf = new StringBuffer("");
                    int numRelatedTos = relatedToList.length;
                    for (i = 0; i < numRelatedTos; ++i) {
                        if (i == numRelatedTos - 1) {
                            tempBuf.append(SOCSUtils.urlEncode(relatedToList[i]));
                            continue;
                        }
                        tempBuf.append(SOCSUtils.urlEncode(relatedToList[i]) + ";");
                    }
                    args.add("relatedTos=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasRelatedToChanged && this.wcapVersionInUse >= 300) {
                args.add("relatedTos=");
            }
            if (this.hasProperty(RESOURCES)) {
                String[] resourceList = this.getResources();
                if (resourceList != null) {
                    tempBuf = new StringBuffer("");
                    int numResources = resourceList.length;
                    for (i = 0; i < numResources; ++i) {
                        if (i == numResources - 1) {
                            tempBuf.append(SOCSUtils.urlEncode(resourceList[i]));
                            continue;
                        }
                        tempBuf.append(SOCSUtils.urlEncode(resourceList[i]) + ";");
                    }
                    args.add("resources=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasResourceChanged && this.wcapVersionInUse >= 300) {
                args.add("resources=");
            }
            if (this.hasProperty(RECURRENCE_DATES)) {
                DateTime[] rdateList = this.getRecurrenceDates();
                if (rdateList != null) {
                    tempBuf = new StringBuffer("");
                    int numRdates = rdateList.length;
                    for (i = 0; i < numRdates; ++i) {
                        if (i == numRdates - 1) {
                            tempBuf.append(rdateList[i].toISO8601());
                            continue;
                        }
                        tempBuf.append(rdateList[i].toISO8601() + ";");
                    }
                    args.add("rdates=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasRecurrenceDateChanged && this.wcapVersionInUse >= 300) {
                args.add("rdates=");
            }
            if (this.hasProperty(RECURRENCE_RULE)) {
                RecurrencePattern[] rruleList = this.getRecurrenceRules();
                if (rruleList != null) {
                    tempBuf = new StringBuffer("");
                    int numRrules = rruleList.length;
                    for (i = 0; i < numRrules; ++i) {
                        if (i == numRrules - 1) {
                            tempBuf.append(SOCSUtils.parseRecurrencePatternToSOCS(rruleList[i]));
                            continue;
                        }
                        tempBuf.append(SOCSUtils.parseRecurrencePatternToSOCS(rruleList[i]) + ";");
                    }
                    args.add("rrules=" + tempBuf.toString());
                    tempBuf = null;
                }
            } else if (isUpdate && this.hasRecurrenceRuleChanged && this.wcapVersionInUse >= 300) {
                args.add("rrules=");
            }
            if (this.hasProperty(ALARM_COMPONENT)) {
                VAlarm[] alarmList = this.getAlarmComponents();
                if (alarmList != null) {
                    int numAlarms = alarmList.length;
                    for (i = 0; i < numAlarms; ++i) {
                        VAlarm alarm = alarmList[i];
                        temp = alarm.getAction();
                        if (null == temp) continue;
                        if (temp.equals("EMAIL")) {
                            Attendee[] attendeeList = alarm.getAttendees();
                            if (attendeeList != null) {
                                int numAttendees = attendeeList.length;
                                tempBuf = new StringBuffer("");
                                for (int j = 0; j < numAttendees; ++j) {
                                    temp = attendeeList[j].getValue();
                                    if (!temp.toUpperCase().startsWith("MAILTO:")) continue;
                                    if (j == numAttendees - 1) {
                                        tempBuf.append(temp.substring(7));
                                        continue;
                                    }
                                    tempBuf.append(temp.substring(7) + ";");
                                }
                                if (tempBuf.length() > 0) {
                                    args.add("alarmEmails=" + tempBuf.toString());
                                }
                            }
                            if (null != (temp = alarm.getAbsTrigger())) {
                                args.add("alarmStart=" + temp);
                            } else if (null != alarm.getTrigger()) {
                                temp = alarm.getTrigger().toRFC2445().substring(9);
                                args.add("alarmStart=" + temp);
                            }
                            temp = alarm.getDescription();
                            if (null == temp) continue;
                            args.add("alarmDescription=" + SOCSUtils.urlEncode(temp));
                            continue;
                        }
                        if (temp.equals("AUDIO")) {
                            temp = alarm.getAbsTrigger();
                            if (null != temp) {
                                args.add("alarmAudio=" + temp);
                            } else if (null != alarm.getTrigger()) {
                                temp = alarm.getTrigger().toRFC2445().substring(9);
                                args.add("alarmAudio=" + temp);
                            }
                            temp = alarm.getDescription();
                            if (null == temp) continue;
                            args.add("alarmDescription=" + SOCSUtils.urlEncode(temp));
                            continue;
                        }
                        if (temp.equals("DISPLAY")) {
                            temp = alarm.getAbsTrigger();
                            if (null != temp) {
                                args.add("alarmPopup=" + temp);
                            } else if (null != alarm.getTrigger()) {
                                temp = alarm.getTrigger().toRFC2445().substring(9);
                                args.add("alarmPopup=" + temp);
                            }
                            temp = alarm.getDescription();
                            if (null == temp) continue;
                            args.add("alarmDescription=" + SOCSUtils.urlEncode(temp));
                            continue;
                        }
                        if (!temp.equals("PROCEDURE")) continue;
                        temp = alarm.getAbsTrigger();
                        if (null != temp) {
                            args.add("alarmFlashing=" + temp);
                        } else if (null != alarm.getTrigger()) {
                            temp = alarm.getTrigger().toRFC2445().substring(9);
                            args.add("alarmFlashing=" + temp);
                        }
                        temp = alarm.getDescription();
                        if (null == temp) continue;
                        args.add("alarmDescription=" + SOCSUtils.urlEncode(temp));
                    }
                }
            } else if (isUpdate && this.hasAlarmChanged && this.wcapVersionInUse >= 300) {
                args.add("alarmStart=");
            }
            if (null != (temp = this.getMethod())) {
                if (temp.equalsIgnoreCase("PUBLISH")) {
                    args.add("method=1");
                } else if (temp.equalsIgnoreCase("REQUEST")) {
                    args.add("method=2");
                } else if (temp.equalsIgnoreCase("REPLY")) {
                    args.add("method=4");
                } else if (temp.equalsIgnoreCase("CANCEL")) {
                    args.add("method=8");
                } else if (temp.equalsIgnoreCase("MOVE")) {
                    args.add("method=16");
                } else if (temp.equalsIgnoreCase("COUNTER")) {
                    args.add("method=32");
                } else if (SOCSUtils.isUserOrganizer(thisUserCalId, this.getOrganizer())) {
                    args.add("method=2");
                } else {
                    args.add("method=4");
                }
            } else if (thisUserCalId != null && this.getOrganizer() != null) {
                if (SOCSUtils.isUserOrganizer(thisUserCalId, this.getOrganizer())) {
                    args.add("method=2");
                } else {
                    args.add("method=4");
                }
            }
        }
        catch (OperationNotSupportedException onse) {
        }
        catch (CalendarComponentException cce) {
            // empty catch block
        }
    }

    static {
        _statusValues.put(STATUS_TENTATIVE, "Dummy1");
        _statusValues.put(STATUS_CONFIRMED, "Dummy2");
        _statusValues.put(STATUS_CANCELLED, "Dummy3");
        _classificationValues.put(CLASSIFICATION_CONFIDENTIAL, "Dummy1");
        _classificationValues.put(CLASSIFICATION_PRIVATE, "Dummy2");
        _classificationValues.put(CLASSIFICATION_PUBLIC, "Dummy3");
    }
}

