/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VFreeBusy;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSFreeBusy;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSTodo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SOCSContentHandler
implements ContentHandler {
    static final int psNONE = 0;
    static final int psICAL = 1;
    static final int psERRNO = 2;
    static final int psWCAP = 3;
    static final int psCALPROPS = 4;
    static final int psPREFS = 5;
    static final int psSERVERPREFS = 6;
    static final int psEVENT = 7;
    static final int psEVENTALARM = 8;
    static final int psEVENTATTENDEE = 9;
    static final int psEVENTORGANIZER = 10;
    static final int psEVENTRDATE = 11;
    static final int psEVENTRRULE = 12;
    static final int psEVENTEXDATE = 13;
    static final int psEVENTEXRULE = 14;
    static final int psEVENTATTACH = 15;
    static final int psEVENTCATEGORY = 16;
    static final int psEVENTRELATEDTO = 17;
    static final int psEVENTRESOURCE = 18;
    static final int psEVENTRSTATUS = 19;
    static final int psEVENTCONTACT = 20;
    static final int psEVENTCOMMENT = 21;
    static final int psEVENTALARMATTENDEE = 22;
    static final int psEVENTALARMTRIGGER = 23;
    static final int psTODO = 24;
    static final int psTODOALARM = 25;
    static final int psTODOATTENDEE = 26;
    static final int psTODOORGANIZER = 27;
    static final int psTODORDATE = 28;
    static final int psTODORRULE = 29;
    static final int psTODOEXDATE = 30;
    static final int psTODOEXRULE = 31;
    static final int psTODOATTACH = 32;
    static final int psTODOCATEGORY = 33;
    static final int psTODORELATEDTO = 34;
    static final int psTODORESOURCE = 35;
    static final int psTODORSTATUS = 36;
    static final int psTODOCONTACT = 37;
    static final int psTODOCOMMENT = 38;
    static final int psTODOALARMATTENDEE = 39;
    static final int psTODOALARMTRIGGER = 40;
    static final int psFREEBUSY = 41;
    static final int psFREEBUSYFBTIME = 42;
    static final int psCHECK_ID = 43;
    static final int psRELATIVECALID = 44;
    static final int psWCAPVERSION = 45;
    SOCSSession session;
    SOCSResponse response;
    int pState;
    StringBuffer chars;
    String key;
    Properties parsingProperties;
    Properties event;
    Properties todo;
    Properties freebusy;
    Properties alarm;
    Properties attendee;
    Properties attach;
    Properties organizer;
    Properties fbtimeinterval;
    Properties trigger;
    ArrayList alarmCol;
    ArrayList attendeeCol;
    ArrayList rruleCol;
    ArrayList rdateCol;
    ArrayList exruleCol;
    ArrayList exdateCol;
    ArrayList attachCol;
    ArrayList contactCol;
    ArrayList commentCol;
    ArrayList categoryCol;
    ArrayList relatedtoCol;
    ArrayList resourceCol;
    ArrayList rstatusCol;
    ArrayList alarmAttendeeCol;
    ArrayList fbtimeCol;
    ArrayList events;
    ArrayList todos;
    ArrayList freebusys;
    Properties[] properties;
    int errCode = -1;
    int checkIdIndicator = -1;
    boolean wcapVersionPresent = false;

    public SOCSContentHandler(SOCSSession session) throws SAXException {
        this.session = session;
        this.response = new SOCSResponse();
        this.errCode = -1;
        this.checkIdIndicator = -1;
        this.properties = new Properties[4];
        this.events = new ArrayList();
        this.todos = new ArrayList();
        this.freebusys = new ArrayList();
    }

    public SOCSResponse getResponse() {
        return this.response;
    }

    public void setParsingProperties(Properties props) {
        this.parsingProperties = props;
    }

    public void startDocument() throws SAXException {
        this.pState = 0;
    }

    public void endDocument() throws SAXException {
        this.pState = 0;
    }

    public void startElement(String nsURI, String tag, String qName, Attributes attrs) throws SAXException {
        if (nsURI == null || "".equals(nsURI)) {
            tag = qName;
        }
        if (tag == null) {
            return;
        }
        if (tag.equals("iCal")) {
            this.pState = 1;
        } else if (tag.equals("iCalendar")) {
            this.pState = 0;
        } else if (tag.equals("EVENT")) {
            this.pState = 7;
            this.event = new Properties();
            this.alarmCol = new ArrayList();
            this.attendeeCol = new ArrayList();
            this.rruleCol = new ArrayList();
            this.rdateCol = new ArrayList();
            this.exruleCol = new ArrayList();
            this.exdateCol = new ArrayList();
            this.attachCol = new ArrayList();
            this.contactCol = new ArrayList();
            this.commentCol = new ArrayList();
            this.categoryCol = new ArrayList();
            this.relatedtoCol = new ArrayList();
            this.resourceCol = new ArrayList();
            this.rstatusCol = new ArrayList();
        } else if (tag.equals("TODO")) {
            this.pState = 24;
            this.todo = new Properties();
            this.alarmCol = new ArrayList();
            this.attendeeCol = new ArrayList();
            this.rruleCol = new ArrayList();
            this.rdateCol = new ArrayList();
            this.exruleCol = new ArrayList();
            this.exdateCol = new ArrayList();
            this.attachCol = new ArrayList();
            this.contactCol = new ArrayList();
            this.commentCol = new ArrayList();
            this.categoryCol = new ArrayList();
            this.relatedtoCol = new ArrayList();
            this.resourceCol = new ArrayList();
            this.rstatusCol = new ArrayList();
        } else if (tag.equals("FREEBUSY")) {
            this.pState = 41;
            this.freebusy = new Properties();
            this.fbtimeCol = new ArrayList();
        } else if (tag.equals("FB")) {
            if (41 == this.pState) {
                this.pState = 42;
                this.fbtimeinterval = new Properties();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String name = attrs.getQName(i);
                    String value = attrs.getValue(i);
                    this.fbtimeinterval.setProperty(name, value);
                }
            }
        } else if (tag.equals("ALARM")) {
            if (this.pState == 7) {
                this.pState = 8;
            } else if (this.pState == 24) {
                this.pState = 25;
            }
            this.alarmAttendeeCol = new ArrayList();
            this.alarm = new Properties();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.alarm.setProperty(name, value);
            }
        } else if (tag.equals("ORGANIZER")) {
            if (this.pState == 7) {
                this.pState = 10;
            } else if (this.pState == 24) {
                this.pState = 27;
            }
            this.organizer = new Properties();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.organizer.setProperty(name, value);
            }
        } else if (tag.equals("ATTENDEE")) {
            if (this.pState == 7) {
                this.pState = 9;
            } else if (this.pState == 24) {
                this.pState = 26;
            } else if (this.pState == 8) {
                this.pState = 22;
            } else if (this.pState == 25) {
                this.pState = 39;
            }
            this.attendee = new Properties();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.attendee.setProperty(name, value);
            }
        } else if (tag.equals("RRULE")) {
            if (this.pState == 7) {
                this.pState = 12;
            } else if (this.pState == 24) {
                this.pState = 29;
            }
        } else if (tag.equals("RDATE")) {
            if (this.pState == 7) {
                this.pState = 11;
            } else if (this.pState == 24) {
                this.pState = 28;
            }
        } else if (tag.equals("EXRULE")) {
            if (this.pState == 7) {
                this.pState = 14;
            } else if (this.pState == 24) {
                this.pState = 31;
            }
        } else if (tag.equals("EXDATE")) {
            if (this.pState == 7) {
                this.pState = 13;
            } else if (this.pState == 24) {
                this.pState = 30;
            }
        } else if (tag.equals("ATTACH")) {
            if (this.pState == 7) {
                this.pState = 15;
            } else if (this.pState == 24) {
                this.pState = 32;
            }
            this.attach = new Properties();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.attach.setProperty(name, value);
            }
        } else if (tag.equals("CATEGORIES")) {
            if (this.pState == 7) {
                this.pState = 16;
            } else if (this.pState == 24) {
                this.pState = 33;
            }
        } else if (tag.equals("RELATED")) {
            if (this.pState == 7) {
                this.pState = 17;
            } else if (this.pState == 24) {
                this.pState = 34;
            }
        } else if (tag.equals("RESOURCES")) {
            if (this.pState == 7) {
                this.pState = 18;
            } else if (this.pState == 24) {
                this.pState = 35;
            }
        } else if (tag.equals("RSTATUS")) {
            if (this.pState == 7) {
                this.pState = 19;
            } else if (this.pState == 24) {
                this.pState = 36;
            }
        } else if (tag.equals("CONTACT")) {
            if (this.pState == 7) {
                this.pState = 20;
            } else if (this.pState == 24) {
                this.pState = 37;
            }
        } else if (tag.equals("COMMENT")) {
            if (this.pState == 7) {
                this.pState = 21;
            } else if (this.pState == 24) {
                this.pState = 38;
            }
        } else if (tag.equals("TRIGGER")) {
            if (this.pState == 8) {
                this.pState = 23;
            } else if (this.pState == 25) {
                this.pState = 40;
            }
            this.trigger = new Properties();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.trigger.setProperty(name, value);
            }
        } else if (tag.equals("X-NSCP-CALPROPS-RELATIVE-CALID")) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.putProperty(1, name, value);
            }
            this.pState = 44;
            this.key = tag.substring(16);
        } else if (tag.equals("X-NSCP-WCAP-ERRNO")) {
            this.pState = 2;
        } else if (tag.equals("X-NSCP-WCAPVERSION")) {
            this.pState = 45;
            this.key = tag;
        } else if (tag.startsWith("X-NSCP-WCAP-PREF-")) {
            this.pState = 5;
            this.key = tag.substring(17);
        } else if (tag.startsWith("X-NSCP-WCAP-SERVER-PREF-")) {
            this.pState = 6;
            this.key = tag.substring(29);
        } else if (tag.startsWith("X-NSCP-WCAP-")) {
            this.pState = tag.equals("X-NSCP-WCAP-CHECK-ID") ? 43 : 3;
            this.key = tag.substring(12);
        } else if (tag.startsWith("X-NSCP-CALPROPS-") || tag.startsWith("X-S1CS-CALPROPS")) {
            this.pState = 4;
            this.key = tag.substring(16);
        }
        this.chars = new StringBuffer(256);
    }

    public void endElement(String nsURI, String tag, String qName) throws SAXException {
        if (nsURI == null || "".equals(nsURI)) {
            tag = qName;
        }
        int which = -1;
        switch (this.pState) {
            case 0: {
                break;
            }
            case 1: {
                if (!tag.equals("iCal")) break;
                if (this.errCode > -1 || this.checkIdIndicator > -1) {
                    SOCSCalendar calendar = new SOCSCalendar(this.properties, this.events, this.todos, this.freebusys, this.errCode);
                    this.properties = new Properties[4];
                    this.events = new ArrayList();
                    this.todos = new ArrayList();
                    this.freebusys = new ArrayList();
                    this.errCode = -1;
                    this.checkIdIndicator = -1;
                    this.response.addCalendar(calendar);
                    calendar = null;
                }
                if (this.wcapVersionPresent) {
                    SOCSCalendar dumCal = new SOCSCalendar(this.properties, null, null, null, 0);
                    this.properties = new Properties[4];
                    this.response.addCalendar(dumCal);
                    dumCal = null;
                    this.wcapVersionPresent = false;
                }
                this.pState = 0;
                break;
            }
            case 44: {
                which = 1;
                this.pState = 1;
                break;
            }
            case 2: {
                try {
                    this.errCode = Integer.parseInt(this.chars.toString());
                }
                catch (NumberFormatException e) {
                    this.errCode = -1;
                    throw new SAXException("Invalid ERRNO");
                }
                this.pState = 1;
                break;
            }
            case 43: {
                try {
                    this.checkIdIndicator = Integer.parseInt(this.chars.toString());
                }
                catch (NumberFormatException e) {
                    this.checkIdIndicator = -1;
                    throw new SAXException("Invalid CHECK-ID Value");
                }
                which = 0;
                this.pState = 1;
                break;
            }
            case 45: {
                which = 0;
                this.pState = 1;
                this.wcapVersionPresent = true;
                break;
            }
            case 3: {
                which = 0;
                this.pState = 1;
                break;
            }
            case 4: {
                which = 1;
                this.pState = 1;
                break;
            }
            case 5: {
                which = 2;
                this.pState = 1;
                break;
            }
            case 6: {
                which = 3;
                this.pState = 1;
                break;
            }
            case 7: {
                if (tag.equals("EVENT")) {
                    Properties calProp = this.getProperties(1);
                    if (calProp != null) {
                        if (calProp.getProperty("X-S1CS-EMAIL") != null) {
                            this.addProp(this.event, "RELATIVE-CALID", "mailto:" + calProp.getProperty("X-S1CS-EMAIL"));
                        } else {
                            this.addProp(this.event, "RELATIVE-CALID", calProp.getProperty("RELATIVE-CALID"));
                        }
                    }
                    if (!this.alarmCol.isEmpty()) {
                        this.addProp(this.event, "VALARM", this.alarmCol);
                    }
                    if (!this.attendeeCol.isEmpty()) {
                        this.addProp(this.event, "ATTENDEE", this.attendeeCol);
                    }
                    if (!this.rruleCol.isEmpty()) {
                        this.addProp(this.event, "RRULE", this.rruleCol);
                    }
                    if (this.rdateCol.isEmpty()) {
                        this.addProp(this.event, "RDATE", this.rdateCol);
                    }
                    if (!this.exruleCol.isEmpty()) {
                        this.addProp(this.event, "EXRULE", this.exruleCol);
                    }
                    if (!this.exdateCol.isEmpty()) {
                        this.addProp(this.event, "EXDATE", this.exdateCol);
                    }
                    if (!this.attachCol.isEmpty()) {
                        this.addProp(this.event, "ATTACH", this.attachCol);
                    }
                    if (!this.contactCol.isEmpty()) {
                        this.addProp(this.event, "CONTACT", this.contactCol);
                    }
                    if (!this.commentCol.isEmpty()) {
                        this.addProp(this.event, "COMMENT", this.commentCol);
                    }
                    if (!this.categoryCol.isEmpty()) {
                        this.addProp(this.event, "CATEGORIES", this.categoryCol);
                    }
                    if (!this.relatedtoCol.isEmpty()) {
                        this.addProp(this.event, "RELATED-TO", this.relatedtoCol);
                    }
                    if (!this.resourceCol.isEmpty()) {
                        this.addProp(this.event, "RESOURCES", this.resourceCol);
                    }
                    if (!this.rstatusCol.isEmpty()) {
                        this.addProp(this.event, "RSTATUS", this.rstatusCol);
                    }
                    this.addEvent(this.makeEvent(this.event, this.parsingProperties));
                    this.event = null;
                    this.alarmCol = null;
                    this.attendeeCol = null;
                    this.rruleCol = null;
                    this.rdateCol = null;
                    this.exruleCol = null;
                    this.exdateCol = null;
                    this.attachCol = null;
                    this.categoryCol = null;
                    this.relatedtoCol = null;
                    this.resourceCol = null;
                    this.rstatusCol = null;
                    this.pState = 1;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.event, tag, this.chars.toString());
                break;
            }
            case 8: {
                if (tag.equals("ALARM") && this.event != null) {
                    this.addProp(this.alarm, "ATTENDEE", this.alarmAttendeeCol);
                    this.pState = 7;
                    this.alarmCol.add(this.alarm);
                    this.alarmAttendeeCol = null;
                    this.alarm = null;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.alarm, tag, this.chars.toString());
                break;
            }
            case 10: {
                if (tag.equals("ORGANIZER") && this.event != null) {
                    this.pState = 7;
                    this.addProp(this.organizer, tag, this.chars.toString());
                    this.addProp(this.event, tag, this.organizer);
                    this.organizer = null;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.organizer, tag, this.chars.toString());
                break;
            }
            case 9: {
                if (tag.equals("ATTENDEE")) {
                    this.pState = 7;
                    this.addProp(this.attendee, tag, this.chars.toString());
                    this.attendeeCol.add(this.attendee);
                    this.attendee = null;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.attendee, tag, this.chars.toString());
                break;
            }
            case 12: {
                if (tag.equals("RRULE")) {
                    this.pState = 7;
                    this.rruleCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 11: {
                if (tag.equals("RDATE")) {
                    this.pState = 7;
                    this.rdateCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 14: {
                if (tag.equals("EXRULE")) {
                    this.pState = 7;
                    this.exruleCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 13: {
                if (tag.equals("EXDATE")) {
                    this.pState = 7;
                    this.exdateCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 15: {
                if (tag.equals("ATTACH")) {
                    this.pState = 7;
                    this.addProp(this.attach, "VALUE", this.chars.toString());
                    this.attachCol.add(this.attach);
                    this.attach = null;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.attach, tag, this.chars.toString());
                break;
            }
            case 16: {
                if (tag.equals("CATEGORIES")) {
                    this.pState = 7;
                    this.categoryCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 17: {
                if (tag.equals("RELATED")) {
                    this.pState = 7;
                    this.relatedtoCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 18: {
                if (tag.equals("RESOURCES")) {
                    this.pState = 7;
                    this.resourceCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 19: {
                if (tag.equals("RSTATUS")) {
                    this.pState = 7;
                    this.rstatusCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 20: {
                if (tag.equals("CONTACT")) {
                    this.pState = 7;
                    this.contactCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 21: {
                if (tag.equals("COMMENT")) {
                    this.pState = 7;
                    this.commentCol.add(this.chars.toString());
                    break;
                }
                if (this.event == null || this.chars == null) break;
                break;
            }
            case 22: {
                if (tag.equals("ATTENDEE")) {
                    this.pState = 8;
                    this.addProp(this.attendee, tag, this.chars.toString());
                    this.alarmAttendeeCol.add(this.attendee);
                    this.attendee = null;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.attendee, tag, this.chars.toString());
                break;
            }
            case 23: {
                if (tag.equals("TRIGGER")) {
                    this.pState = 8;
                    if (this.chars.toString() != null) {
                        this.addProp(this.trigger, "TRIGGER", this.chars.toString());
                    }
                    this.addProp(this.alarm, tag, this.trigger);
                    this.trigger = null;
                    break;
                }
                if (this.event == null || this.chars == null) break;
                this.addProp(this.trigger, tag, this.chars.toString());
                break;
            }
            case 24: {
                if (tag.equals("TODO")) {
                    Properties calProp = this.getProperties(1);
                    if (calProp != null) {
                        if (calProp.getProperty("X-S1CS-EMAIL") != null) {
                            this.addProp(this.todo, "RELATIVE-CALID", "mailto:" + calProp.getProperty("X-S1CS-EMAIL"));
                        } else {
                            this.addProp(this.todo, "RELATIVE-CALID", calProp.getProperty("RELATIVE-CALID"));
                        }
                    }
                    if (!this.alarmCol.isEmpty()) {
                        this.addProp(this.todo, "VALARM", this.alarmCol);
                    }
                    if (!this.attendeeCol.isEmpty()) {
                        this.addProp(this.todo, "ATTENDEE", this.attendeeCol);
                    }
                    if (!this.rruleCol.isEmpty()) {
                        this.addProp(this.todo, "RRULE", this.rruleCol);
                    }
                    if (!this.rdateCol.isEmpty()) {
                        this.addProp(this.todo, "RDATE", this.rdateCol);
                    }
                    if (!this.exruleCol.isEmpty()) {
                        this.addProp(this.todo, "EXRULE", this.exruleCol);
                    }
                    if (!this.exdateCol.isEmpty()) {
                        this.addProp(this.todo, "EXDATE", this.exdateCol);
                    }
                    if (!this.attachCol.isEmpty()) {
                        this.addProp(this.todo, "ATTACH", this.attachCol);
                    }
                    if (!this.contactCol.isEmpty()) {
                        this.addProp(this.todo, "CONTACT", this.contactCol);
                    }
                    if (!this.commentCol.isEmpty()) {
                        this.addProp(this.todo, "COMMENT", this.commentCol);
                    }
                    if (!this.categoryCol.isEmpty()) {
                        this.addProp(this.todo, "CATEGORIES", this.categoryCol);
                    }
                    if (!this.relatedtoCol.isEmpty()) {
                        this.addProp(this.todo, "RELATED-TO", this.relatedtoCol);
                    }
                    if (!this.resourceCol.isEmpty()) {
                        this.addProp(this.todo, "RESOURCES", this.resourceCol);
                    }
                    if (!this.rstatusCol.isEmpty()) {
                        this.addProp(this.todo, "RSTATUS", this.rstatusCol);
                    }
                    this.addTodo(this.makeTodo(this.todo, this.parsingProperties));
                    this.todo = null;
                    this.alarmCol = null;
                    this.attendeeCol = null;
                    this.rruleCol = null;
                    this.rdateCol = null;
                    this.exruleCol = null;
                    this.exdateCol = null;
                    this.attachCol = null;
                    this.categoryCol = null;
                    this.relatedtoCol = null;
                    this.resourceCol = null;
                    this.rstatusCol = null;
                    this.pState = 1;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.todo, tag, this.chars.toString());
                break;
            }
            case 25: {
                if (tag.equals("ALARM") && this.todo != null) {
                    this.addProp(this.alarm, "ATTENDEE", this.alarmAttendeeCol);
                    this.pState = 24;
                    this.alarmCol.add(this.alarm);
                    this.alarm = null;
                    this.alarmAttendeeCol = null;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.alarm, tag, this.chars.toString());
                break;
            }
            case 27: {
                if (tag.equals("ORGANIZER") && this.todo != null) {
                    this.pState = 24;
                    this.addProp(this.organizer, tag, this.chars.toString());
                    this.addProp(this.todo, tag, this.organizer);
                    this.organizer = null;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.organizer, tag, this.chars.toString());
                break;
            }
            case 26: {
                if (tag.equals("ATTENDEE")) {
                    this.pState = 24;
                    this.addProp(this.attendee, tag, this.chars.toString());
                    this.attendeeCol.add(this.attendee);
                    this.attendee = null;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.attendee, tag, this.chars.toString());
                break;
            }
            case 29: {
                if (tag.equals("RRULE")) {
                    this.pState = 24;
                    this.rruleCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 28: {
                if (tag.equals("RDATE")) {
                    this.pState = 24;
                    this.rdateCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 31: {
                if (tag.equals("EXRULE")) {
                    this.pState = 24;
                    this.exruleCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 30: {
                if (tag.equals("EXDATE")) {
                    this.pState = 24;
                    this.exdateCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 32: {
                if (tag.equals("ATTACH")) {
                    this.pState = 24;
                    this.addProp(this.attach, "VALUE", this.chars.toString());
                    this.attachCol.add(this.attach);
                    this.attach = null;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.attach, tag, this.chars.toString());
                break;
            }
            case 33: {
                if (tag.equals("CATEGORIES")) {
                    this.pState = 24;
                    this.categoryCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 34: {
                if (tag.equals("RELATED")) {
                    this.pState = 24;
                    this.relatedtoCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 35: {
                if (tag.equals("RESOURCES")) {
                    this.pState = 24;
                    this.resourceCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 36: {
                if (tag.equals("RSTATUS")) {
                    this.pState = 24;
                    this.rstatusCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 37: {
                if (tag.equals("CONTACT")) {
                    this.pState = 24;
                    this.contactCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 38: {
                if (tag.equals("COMMENT")) {
                    this.pState = 24;
                    this.commentCol.add(this.chars.toString());
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                break;
            }
            case 39: {
                if (tag.equals("ATTENDEE")) {
                    this.pState = 25;
                    this.addProp(this.attendee, tag, this.chars.toString());
                    this.alarmAttendeeCol.add(this.attendee);
                    this.attendee = null;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.attendee, tag, this.chars.toString());
                break;
            }
            case 40: {
                if (tag.equals("TRIGGER")) {
                    this.pState = 25;
                    if (this.chars.toString() != null) {
                        this.addProp(this.trigger, "TRIGGER", this.chars.toString());
                    }
                    this.addProp(this.alarm, tag, this.trigger);
                    this.trigger = null;
                    break;
                }
                if (this.todo == null || this.chars == null) break;
                this.addProp(this.trigger, tag, this.chars.toString());
                break;
            }
            case 41: {
                if (tag.equals("FREEBUSY")) {
                    Properties calProp = this.getProperties(1);
                    if (calProp != null) {
                        if (calProp.getProperty("X-S1CS-EMAIL") != null) {
                            this.addProp(this.freebusy, "RELATIVE-CALID", "mailto:" + calProp.getProperty("X-S1CS-EMAIL"));
                        } else {
                            this.addProp(this.freebusy, "RELATIVE-CALID", calProp.getProperty("RELATIVE-CALID"));
                        }
                    }
                    if (null != this.fbtimeCol) {
                        this.addProp(this.freebusy, "FB", this.fbtimeCol);
                    }
                    this.addFreeBusy(this.makeFreeBusy(this.freebusy, this.parsingProperties));
                    this.freebusy = null;
                    this.fbtimeCol = null;
                    this.pState = 1;
                    break;
                }
                if (this.freebusy == null || this.chars == null) break;
                this.addProp(this.freebusy, tag, this.chars.toString());
                break;
            }
            case 42: {
                if (tag.equals("FB")) {
                    this.pState = 41;
                    this.addProp(this.fbtimeinterval, tag, this.chars.toString());
                    this.fbtimeCol.add(this.fbtimeinterval);
                    this.fbtimeinterval = null;
                    break;
                }
                if (this.fbtimeinterval == null || this.chars == null) break;
                this.addProp(this.fbtimeinterval, tag, this.chars.toString());
            }
        }
        if (which != -1 && this.key != null && this.chars != null) {
            this.putProperty(which, this.key, this.chars.toString());
            this.key = null;
            this.pState = 1;
        }
        this.chars = null;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (buf[offset] == '\n' || buf[offset] == '\r') {
            buf[offset] = 32;
        } else {
            if (this.whitespace(buf[offset])) {
                ++offset;
                --len;
            }
            if (len > 0 && this.whitespace(buf[offset + len - 1])) {
                --len;
            }
        }
        if (this.chars != null && len > 0) {
            this.chars.append(buf, offset, len);
        }
    }

    boolean whitespace(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    SOCSTodo makeTodo(Properties props, Properties parsingProperties) throws SAXException {
        SOCSTodo todo = new SOCSTodo();
        try {
            todo.loadFromStream(this.session, props, parsingProperties);
        }
        catch (ParseException e) {
            throw new SAXException("Couldn't parse date string");
        }
        return todo;
    }

    SOCSEvent makeEvent(Properties props, Properties parsingProperties) throws SAXException {
        SOCSEvent event = new SOCSEvent();
        try {
            event.loadFromStream(this.session, props, parsingProperties);
        }
        catch (ParseException e) {
            throw new SAXException("Couldn't parse date string");
        }
        return event;
    }

    private SOCSFreeBusy makeFreeBusy(Properties props, Properties parsingProperties) throws SAXException {
        try {
            return SOCSFreeBusy.fromXML(this.session, props, parsingProperties);
        }
        catch (Exception e) {
            throw new SAXException(e.toString() + ": Couldn't parse Free/Busy XML response data");
        }
    }

    void addProp(Properties props, String tag, Object value) {
        Object orig = props.get(tag);
        if (orig != null) {
            props.put(tag, orig + ";" + value);
        } else {
            props.put(tag, value);
        }
    }

    void putProperty(int which, String key, String value) {
        Properties props = this.getProperties(which);
        if (props == null) {
            this.properties[which] = props = new Properties();
        }
        if (key != null && value != null) {
            Object orig = props.get(key);
            if (orig != null) {
                props.put(key, orig + ";" + value);
            } else {
                props.put(key, value);
            }
        }
    }

    Properties getProperties(int which) {
        SOCSCalendar.checkWhich(which);
        return this.properties[which];
    }

    void addEvent(VEvent event) {
        this.events.add(event);
    }

    void addTodo(VTodo todo) {
        this.todos.add(todo);
    }

    private void addFreeBusy(VFreeBusy freebusy) {
        this.freebusys.add(freebusy);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }
}

