/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.URLName;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSRequest;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class SOCSCalendarStore
extends CalendarStore {
    public static final int CONTAINS = 0;
    public static final int BEGINS_WITH = 1;
    public static final int ENDS_WITH = 2;
    public static final int EXACT = 3;
    public static final String MIN_SUPPORTED_VERSION_STRING = "2.0.0";
    public static final String WCAP_VERSION_3_0_0 = "3.0.0";
    public static final String WCAP_VERSION_3_1_0 = "3.1.0";
    public static final int WCAP_VERSION_3_0_0_INT = 300;
    public static final int WCAP_VERSION_3_1_0_INT = 310;
    SOCSSession socsSession = null;
    private URL serverURL = null;
    private String protoVersion = null;
    private int protoVersionInt = 0;
    private static String ICAL_FORMAT_TYPE = "text/calendar";
    private static String XML_FORMAT_TYPE = "text/xml";

    public SOCSCalendarStore(CalendarSession session) {
        super(session);
    }

    protected void connectURL(URLName url) throws CalendarStoreException {
        CalendarSession calSession = this.getSession();
        try {
            this.serverURL = url.getURL();
        }
        catch (MalformedURLException ex) {
            throw new CalendarStoreException(ex.toString(), 103);
        }
        this.makeValidSOCSSession();
        calSession.setProperty("cal.host", url.getHost());
        calSession.setProperty("cal.port", Integer.toString(url.getPort()));
        TimeZone tz = calSession.getTimeZone();
        if (tz == null && this.getSOCSSession().getPreference("icsTimezone") != null) {
            String tmp = this.getSOCSSession().getPreference("icsTimezone").trim();
            if (tmp.length() > 0) {
                calSession.setTimeZone(TimeZone.getTimeZone(tmp));
            } else {
                calSession.setTimeZone(TimeZone.getDefault());
            }
        }
        if (this.getSOCSSession().getPreference("ceDefaultAlarmEmail") != null) {
            this.getSession().setProperty("cal.reminderAddresses", this.getSOCSSession().getPreference("ceDefaultAlarmEmail"));
        }
        if (this.getSOCSSession().getPreference("ceClock") != null) {
            this.getSession().setProperty("cal.clock", this.getSOCSSession().getPreference("ceClock"));
        }
        if (this.getSOCSSession().getPreference("ceDefaultAlarmStart") != null) {
            this.getSession().setProperty("cal.defaultAlarmStart", this.getSOCSSession().getPreference("ceDefaultAlarmStart"));
        }
        if (this.getSOCSSession().getPreference("ceDateOrder") != null) {
            this.getSession().setProperty("cal.dateOrder", this.getSOCSSession().getPreference("ceDateOrder"));
        }
        if (this.getSOCSSession().getPreference("ceDateSeparator") != null) {
            this.getSession().setProperty("cal.dateSeparator", this.getSOCSSession().getPreference("ceDateSeparator"));
        }
        if (this.getSOCSSession().getPreference("ceDefaultView") != null) {
            this.getSession().setProperty("cal.defaultView", this.getSOCSSession().getPreference("ceDefaultView"));
        }
        if (this.getSOCSSession().getPreference("ceDayHead") != null) {
            this.getSession().setProperty("cal.dayStart", this.getSOCSSession().getPreference("ceDayHead"));
        }
        if (this.getSOCSSession().getPreference("ceDayTail") != null) {
            this.getSession().setProperty("cal.dayEnd", this.getSOCSSession().getPreference("ceDayTail"));
        }
        if (this.getSOCSSession().getPreference("icsFirstDay") != null) {
            this.getSession().setProperty("cal.firstDayOfWeek", this.getSOCSSession().getPreference("icsFirstDay"));
        }
    }

    public void disconnect() throws CalendarStoreException {
        if (this.socsSession != null) {
            this.socsSession.logout();
            this.socsSession = null;
            this.serverURL = null;
        }
    }

    public boolean isConnected() {
        if (this.socsSession == null) {
            return false;
        }
        return this.socsSession.isValid();
    }

    public ICalendar[] getCalendars() throws CalendarStoreException {
        Vector<ICalendar> userCalList = new Vector<ICalendar>();
        String defaultCalId = null;
        defaultCalId = this.getDefaultCalendarId();
        Vector calendars = this.getSOCSSession().getSubscribedCalendars();
        for (int i = 0; i < calendars.size(); ++i) {
            ICalendar cal = (ICalendar)calendars.elementAt(i);
            if (!cal.getCalID().startsWith(defaultCalId.trim())) continue;
            if (cal.getCalID().equals(defaultCalId)) {
                userCalList.addElement(cal);
                continue;
            }
            if (!cal.getCalID().startsWith(defaultCalId + ":")) continue;
            userCalList.addElement(cal);
        }
        Object[] result = null;
        result = new ICalendar[userCalList.size()];
        userCalList.copyInto(result);
        return result;
    }

    public String[] getSubscribedCalenders() throws CalendarStoreException {
        String[] result = null;
        Vector calendars = this.getSOCSSession().getSubscribedCalendars();
        result = new String[calendars.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new String(((ICalendar)calendars.elementAt(i)).getCalID());
        }
        return result;
    }

    public String verifyCalendarId(String cid) throws CalendarStoreException {
        if (cid == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        Vector searchedCals = this.getSOCSSession().searchForCalendars(cid, 0, 1);
        if (searchedCals.size() > 0) {
            return ((ICalendar)searchedCals.elementAt(0)).getCalID();
        }
        return null;
    }

    protected String getDefaultCalendarId() throws CalendarStoreException {
        return this.getSOCSSession().getDefaultCalendar();
    }

    protected ICalendar loadCalendar(String cid) throws CalendarStoreException {
        if (cid == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        return new SOCSCalendar(this, cid);
    }

    public ICalendar[] searchCalendars(String searchFilter, Properties requestProperties) throws CalendarStoreException {
        return this.searchCalendars(searchFilter, 0, 200, requestProperties);
    }

    public ICalendar[] searchCalendars(String searchFilter) throws CalendarStoreException {
        return this.searchCalendars(searchFilter, 0, 200);
    }

    public ICalendar[] searchCalendars(String searchString, int searchOpt, int maxResults) throws CalendarStoreException {
        return this.searchCalendars(searchString, searchOpt, maxResults, null);
    }

    public ICalendar[] searchCalendars(String searchString, int searchOpt, int maxResults, Properties requestProperties) throws CalendarStoreException {
        Vector searchCals = this.getSOCSSession().searchForCalendars(searchString, searchOpt, maxResults, requestProperties);
        Object[] result = null;
        if (searchCals != null) {
            result = new ICalendar[searchCals.size()];
            searchCals.copyInto(result);
        }
        return result;
    }

    protected void unloadCalendar(ICalendar calendar) throws CalendarStoreException {
        if (calendar == null) {
            throw new CalendarStoreException("Invalid Calendar object: null", 110);
        }
    }

    public ICalendar createCalendar(String cid) throws CalendarStoreException {
        return this.createCalendar(cid, null);
    }

    public ICalendar createCalendar(String cid, Properties props) throws CalendarStoreException {
        SOCSCalendar newCalendar = null;
        if (cid == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        newCalendar = this.getSOCSSession().createCalendar(cid, props);
        return newCalendar;
    }

    public void deleteCalendar(String cid) throws CalendarStoreException {
        if (cid == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        this.getSOCSSession().deleteCalendar(cid);
        this.closeCalendar(cid);
    }

    public BufferedReader exportCalendar(String cid, DateTime start, DateTime end, String contentFormat) throws CalendarStoreException {
        return this.exportCalendar(cid, start, end, contentFormat, null, -1);
    }

    public BufferedReader exportCalendar(String cid, DateTime start, DateTime end, String contentFormat, String host, int port) throws CalendarStoreException {
        SOCSRequest request = null;
        BufferedReader exportedCalendar = null;
        if (cid == null) {
            throw new CalendarStoreException("Illegal Calendar ID: null ", 110);
        }
        request = this.createAnonOrSessionReq(host, port);
        if (request == null) {
            throw new CalendarStoreException("Unable to export calendar  because, either a valid session doesnot exist or could not connect to backend service", 104);
        }
        if (contentFormat == null) {
            contentFormat = ICAL_FORMAT_TYPE;
        } else if (!contentFormat.equalsIgnoreCase(ICAL_FORMAT_TYPE) && !contentFormat.equalsIgnoreCase(XML_FORMAT_TYPE)) {
            throw new CalendarStoreException("Invalid Content Format specified: " + contentFormat, 105);
        }
        try {
            exportedCalendar = request.exportCalendar(cid, start, end, contentFormat);
        }
        catch (SOCSException e) {
            throw new CalendarStoreException("Failed to export calendar. " + e.getMessage(), e.getError());
        }
        return exportedCalendar;
    }

    public void importCalendar(String cid, String contentFormat, InputStream inputStream) throws CalendarStoreException {
        this.importCalendar(cid, null, null, contentFormat, inputStream);
    }

    public void importCalendar(String cid, DateTime start, DateTime end, String contentFormat, InputStream inputStream) throws CalendarStoreException {
        SOCSRequest request = null;
        SOCSSession session = null;
        if (cid == null) {
            throw new CalendarStoreException("Illegal Calendar ID: null ", 110);
        }
        if (!this.isConnected()) {
            throw new CalendarStoreException("No Valid Session. Cannot Import data.", 109);
        }
        session = this.getSOCSSession();
        request = new SOCSRequest(session);
        if (contentFormat == null) {
            contentFormat = ICAL_FORMAT_TYPE;
        } else if (!contentFormat.equalsIgnoreCase(ICAL_FORMAT_TYPE) && !contentFormat.equalsIgnoreCase(XML_FORMAT_TYPE)) {
            throw new CalendarStoreException("Invalid Content Format specified: " + contentFormat, 105);
        }
        try {
            request.importCalendar(cid, start, end, contentFormat, inputStream);
        }
        catch (SOCSException s) {
            throw new CalendarStoreException(s.getMessage(), s.getError());
        }
    }

    public URL getServiceURL() {
        return this.serverURL;
    }

    public SOCSSession getSOCSSession() throws CalendarStoreException {
        if (this.socsSession == null) {
            this.makeValidSOCSSession();
        }
        return this.socsSession;
    }

    private SOCSSession makeValidSOCSSession() throws CalendarStoreException {
        try {
            if (!this.isConnected()) {
                URLName url = this.getServiceUrl();
                String userName = url.getUsername();
                String userPassword = url.getPassword();
                CalendarSession calSession = this.getSession();
                if (userName == null || userName.length() == 0) {
                    userName = calSession.getProperty("cal.user");
                }
                if (userPassword == null || userPassword.length() == 0) {
                    userPassword = calSession.getProperty("cal.password");
                }
                this.setProtocolVersionToUse();
                this.socsSession = SOCSSession.login(this, userName, userPassword, calSession.getProperty("cal.proxyauth"));
            }
            return this.socsSession;
        }
        catch (CalendarException ex) {
            throw new CalendarStoreException(ex.getMessage(), ex.getError());
        }
    }

    private SOCSRequest createAnonOrSessionReq(String host, int port) throws CalendarStoreException {
        SOCSSession session = null;
        SOCSRequest request = null;
        URLName currentServiceURL = null;
        URLName newServiceURL = null;
        if (this.socsSession != null) {
            if (host != null) {
                if (port <= 0) {
                    port = -1;
                }
                if ((currentServiceURL = this.getServiceUrl()) != null && host.equalsIgnoreCase(currentServiceURL.getHost()) && port == currentServiceURL.getPort() && this.isConnected()) {
                    session = this.getSOCSSession();
                    request = new SOCSRequest(session);
                }
                if (currentServiceURL == null || session == null && request == null) {
                    newServiceURL = new URLName(this.getSession().getProperty("cal.protocol", "http"), host, port, "", null, null);
                    session = SOCSSession.getInstance(this);
                    try {
                        request = new SOCSRequest(newServiceURL.getURL(), session);
                    }
                    catch (MalformedURLException mue1) {
                        throw new CalendarStoreException("Incorrect Service URL", 103);
                    }
                }
            } else if (this.isConnected()) {
                session = this.getSOCSSession();
                request = new SOCSRequest(session);
            }
        }
        if (this.socsSession == null || request == null && session == null) {
            if (host == null) {
                throw new CalendarStoreException("Invalid Host: null", 105);
            }
            port = Integer.parseInt(this.getSession().getProperty("cal.port", "-1"));
            if (port <= 0) {
                port = -1;
            }
            newServiceURL = new URLName(this.getSession().getProperty("cal.protocol", "http"), host, port, "", null, null);
            session = SOCSSession.getInstance(this);
            try {
                request = new SOCSRequest(newServiceURL.getURL(), session);
            }
            catch (MalformedURLException mue1) {
                throw new CalendarStoreException("Incorrect Service URL", 103);
            }
        }
        return request;
    }

    public void setProtocolVersion(String version) {
        this.protoVersion = version;
    }

    public String getProtocolVersion() {
        return this.protoVersion;
    }

    public int getProtocolVersionInt() {
        return this.protoVersionInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProtocolVersionToUse() throws CalendarStoreException {
        Properties prop;
        String servVersion = null;
        boolean validServVersion = false;
        boolean validSetVersion = false;
        SOCSRequest socsReq = new SOCSRequest(this);
        SOCSResponse resp = null;
        try {
            resp = socsReq.getProtoVersion();
        }
        catch (SOCSException se1) {
            throw new CalendarStoreException(se1.getMessage(), se1.getError());
        }
        if (resp != null && (prop = resp.getProperties(0)) != null && (servVersion = prop.getProperty("X-NSCP-WCAPVERSION")) != null) {
            int servVers = 0;
            servVersion.trim();
            try {
                servVers = SOCSUtils.versionToInt(servVersion);
                validServVersion = true;
            }
            catch (NumberFormatException nfe3) {
                validServVersion = false;
                try {
                    servVers = SOCSUtils.versionToInt(MIN_SUPPORTED_VERSION_STRING);
                }
                catch (NumberFormatException nfe4) {
                    servVers = 200;
                }
            }
            if (this.protoVersion != null) {
                this.protoVersion.trim();
                int setVers = 0;
                try {
                    setVers = SOCSUtils.versionToInt(this.protoVersion);
                    validSetVersion = true;
                }
                catch (NumberFormatException nfe1) {
                    validSetVersion = false;
                    try {
                        setVers = SOCSUtils.versionToInt(MIN_SUPPORTED_VERSION_STRING);
                    }
                    catch (NumberFormatException nfe2) {
                        setVers = 200;
                    }
                }
                if (setVers > servVers) throw new CalendarStoreException("Unsupported Protocol version", 114);
                if (!validSetVersion) {
                    this.protoVersion = MIN_SUPPORTED_VERSION_STRING;
                }
                this.protoVersionInt = setVers;
            } else {
                this.protoVersion = validServVersion ? servVersion : MIN_SUPPORTED_VERSION_STRING;
                this.protoVersionInt = servVers;
            }
        }
        socsReq = null;
        resp = null;
        if (this.protoVersion != null) return;
        this.protoVersion = MIN_SUPPORTED_VERSION_STRING;
        this.protoVersionInt = 200;
    }
}

