/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.URLName;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VFreeBusy;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSFreeBusy;
import com.sun.comclient.calendar.socs.SOCSRequest;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SOCSCalendar
extends ICalendar {
    private ArrayList events = new ArrayList();
    private ArrayList todos = new ArrayList();
    private ArrayList freebusys = new ArrayList();
    private Properties[] properties = new Properties[4];
    private int errCode = -1;
    private String description = null;
    private String displayName = null;
    private static final transient String OWNER_CN_KEY = "COMMON-NAME";
    private static final transient String IS_INCLUDED_IN_FREEBUSY_KEY = "FB-INCLUDE";
    private static final transient String INVITE_COUNT_KEY = "INVITATION-COUNT";
    private String productId = "-//iPlanet/Calendar Hosting Server";
    private final String version = "2.0";
    private String method = null;
    private String calscale = null;
    private int wcapVersionInUse = 0;

    public SOCSCalendar(CalendarStore store, String calId) {
        super(store, calId);
        this.wcapVersionInUse = ((SOCSCalendarStore)store).getProtocolVersionInt();
    }

    public SOCSCalendar(CalendarStore store, String calId, String displayName) {
        super(store, calId);
        this.displayName = displayName;
        this.wcapVersionInUse = ((SOCSCalendarStore)store).getProtocolVersionInt();
    }

    public SOCSCalendar(Properties[] prop, ArrayList events, ArrayList todos, ArrayList freebusys, int errCode) {
        super(null, null);
        this.events = events;
        this.todos = todos;
        this.freebusys = freebusys;
        this.properties = prop;
        this.errCode = errCode;
        try {
            String ver;
            Properties calprops = this.getProperties(1);
            Properties wcapProps = this.getProperties(0);
            if (calprops != null) {
                this.displayName = calprops.getProperty("NAME");
                this.calId = calprops.getProperty("RELATIVE-CALID");
            }
            if (wcapProps != null && (ver = wcapProps.getProperty("X-NSCP-WCAPVERSION")) != null) {
                this.wcapVersionInUse = SOCSUtils.versionToInt(ver);
            }
        }
        catch (NumberFormatException ex1) {
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getVersion() {
        return "2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getCalScale() {
        return this.calscale;
    }

    public void setCalScale(String calscale) {
        this.calscale = calscale;
    }

    public VEvent createEvent() throws CalendarException, OperationNotSupportedException {
        SOCSEvent event = new SOCSEvent();
        event.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
        return event;
    }

    public VTodo createTodo() throws CalendarException, OperationNotSupportedException {
        SOCSTodo todo = new SOCSTodo();
        todo.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
        return todo;
    }

    public boolean isUserTheOwner(String uid, boolean ignoreCase) throws CalendarException, OperationNotSupportedException {
        if (uid == null) {
            return false;
        }
        Properties props = this.getCalProps();
        if (null == props) {
            throw new CalendarException("Couldn't read calendar properties");
        }
        if (ignoreCase ? uid.equalsIgnoreCase(props.getProperty("PRIMARY-OWNER")) : uid.equals(props.getProperty("PRIMARY-OWNER"))) {
            return true;
        }
        String owners = props.getProperty("OWNERS");
        if (null != owners) {
            StringTokenizer st = new StringTokenizer(owners, ";");
            while (st.hasMoreTokens()) {
                String nextOwner = (String)st.nextElement();
                if (!(ignoreCase ? uid.equalsIgnoreCase(nextOwner) : uid.equals(nextOwner))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDoubleBookingAllowed() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        String doubleBooking = this.getCalProps().getProperty("ALLOW-DOUBLEBOOKING");
        if (null == doubleBooking) {
            return true;
        }
        if (doubleBooking.equals("0")) {
            return false;
        }
        if (doubleBooking.equals("1")) {
            return true;
        }
        return true;
    }

    public void setDoubleBooking(boolean doubleBooking) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        Properties props = this.getProperties(1);
        if (null != props && null != props.getProperty("ALLOW-DOUBLEBOOKING")) {
            if (doubleBooking && props.getProperty("ALLOW-DOUBLEBOOKING").equals("1")) {
                return;
            }
            if (!doubleBooking && props.getProperty("ALLOW-DOUBLEBOOKING").equals("0")) {
                return;
            }
        }
        Properties doubleBooking_prop = new Properties();
        if (!doubleBooking) {
            doubleBooking_prop.setProperty("doublebooking", "0");
        } else {
            doubleBooking_prop.setProperty("doublebooking", "1");
        }
        this.setCalProps(doubleBooking_prop);
    }

    public TimeZone getTimeZone() throws CalendarException, OperationNotSupportedException {
        String tzStr = this.getCalProps().getProperty("TZID");
        if (null == tzStr) {
            return null;
        }
        return TimeZone.getTimeZone(tzStr.trim());
    }

    public void setTimeZone(TimeZone timezone) throws CalendarException, OperationNotSupportedException {
        if (null == timezone) {
            throw new CalendarException("Illegal Argument: null timezone", 105);
        }
        String tzStr = timezone.getID();
        Properties props = this.getProperties(1);
        if (null != props && null != props.getProperty("TZID") && props.getProperty("TZID").equals(tzStr)) {
            return;
        }
        Properties timzone_prop = new Properties();
        timzone_prop.setProperty("tzid", tzStr);
        this.setCalProps(timzone_prop);
    }

    public void setIncludeInAvailability(boolean flag) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        Properties props = this.getProperties(1);
        if (null != props && null != props.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY)) {
            if (flag && props.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY).equals("1")) {
                return;
            }
            if (!flag && props.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY).equals("0")) {
                return;
            }
        }
        Properties fbinclude_prop = new Properties();
        if (flag) {
            fbinclude_prop.setProperty("fbinclude", "1");
        } else {
            fbinclude_prop.setProperty("fbinclude", "0");
        }
        this.setCalProps(fbinclude_prop);
    }

    public boolean isIncludedInAvailability() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        String isIncludedInFB = this.getCalProps().getProperty(IS_INCLUDED_IN_FREEBUSY_KEY);
        if (null == isIncludedInFB) {
            return false;
        }
        if (isIncludedInFB.equals("0")) {
            return false;
        }
        return isIncludedInFB.equals("1");
    }

    public String getDisplayName() throws CalendarException, OperationNotSupportedException {
        return this.getCalProps().getProperty("NAME");
    }

    public String getRelativeCalId() throws CalendarException, OperationNotSupportedException {
        return this.getCalProps().getProperty("RELATIVE-CALID");
    }

    public String getOwnerEmailId() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.getCalProps().getProperty("X-S1CS-EMAIL");
    }

    public int getInvitationsCount() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        String val = null;
        val = this.getCalProps().getProperty(INVITE_COUNT_KEY);
        if (val != null && val.length() > 0) {
            return Integer.parseInt(val);
        }
        return 0;
    }

    public String getOwnerCommonName() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.getCalProps().getProperty(OWNER_CN_KEY);
    }

    public CalendarComponent[] fetchComponents(DateTime start, DateTime end, int componentTypes) throws CalendarException {
        return this.fetchComponents(start, end, null, componentTypes);
    }

    public CalendarComponent[] fetchComponents(DateTime start, DateTime end, Properties parsingProps, int componentTypes) throws CalendarException {
        if (!SOCSUtils.isBitSet(componentTypes, 7)) {
            throw new CalendarException("Illegal Argument: Requested fetch component types \"" + componentTypes + "\" is found to be invalid. -- Not a valid mask of any of ICalendar.VEVENT, ICalendar.VTODO, ICalendar.VFREEBUSY or ICalendar.VALL", 105);
        }
        ArrayList compList = new ArrayList();
        ArrayList eventList = new ArrayList();
        ArrayList todoList = new ArrayList();
        ArrayList freebusyList = new ArrayList();
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        int types2fetch = 0;
        if (SOCSUtils.isBitSet(componentTypes, 1)) {
            types2fetch |= 1;
        }
        if (SOCSUtils.isBitSet(componentTypes, 2)) {
            types2fetch |= 2;
        }
        if (0 != types2fetch) {
            try {
                response = request.fetchEventsTodos(this.getCalID(), start, end, parsingProps, types2fetch);
            }
            catch (SOCSException e) {
                throw new CalendarException(e.getMessage(), e.getError());
            }
            if (SOCSUtils.isBitSet(types2fetch, 1)) {
                eventList = response.getEvents();
            }
            if (SOCSUtils.isBitSet(types2fetch, 2)) {
                todoList = response.getTodos();
            }
            this.refresh(response);
        }
        if (SOCSUtils.isBitSet(componentTypes, 4)) {
            try {
                response = request.fetchFreeBusy(this.getCalID(), start, end, parsingProps);
            }
            catch (SOCSException e) {
                throw new CalendarException(e.getMessage(), e.getError());
            }
            freebusyList = response.getFreeBusy();
            this.refresh(response);
        }
        if (null != eventList) {
            compList.addAll(eventList);
        }
        if (null != todoList) {
            compList.addAll(todoList);
        }
        if (null != freebusyList) {
            compList.addAll(freebusyList);
        }
        CalendarComponent[] result = new CalendarComponent[compList.size()];
        compList.toArray(result);
        return result;
    }

    public CalendarComponent[] fetchComponents(String uid, String rid, String modifier) throws CalendarException, OperationNotSupportedException {
        ArrayList compList = new ArrayList();
        ArrayList eventList = new ArrayList();
        ArrayList todoList = new ArrayList();
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.fetchEventsTodos(this.getCalID(), uid, rid, modifier, null, true);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        eventList = response.getEvents();
        this.refresh(response);
        try {
            response = request.fetchEventsTodos(this.getCalID(), uid, rid, modifier, null, false);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        todoList = response.getTodos();
        this.refresh(response);
        if (null != eventList) {
            compList.addAll(eventList);
        }
        if (null != todoList) {
            compList.addAll(todoList);
        }
        CalendarComponent[] result = new CalendarComponent[compList.size()];
        compList.toArray(result);
        return result;
    }

    public CalendarComponent[] searchEvents(DateTime dtStart, DateTime dtEnd, String filter, int searchOpt) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchEvents(dtStart, dtEnd, filter, searchOpt, null);
    }

    public CalendarComponent[] searchEvents(DateTime dtStart, DateTime dtEnd, String filter, int searchOpt, Properties parsingProperties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        ArrayList eventList = new ArrayList();
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.searchEvents(this.getCalID(), dtStart, dtEnd, filter, searchOpt, parsingProperties);
        }
        catch (SOCSException ex) {
            throw new CalendarException(ex.getMessage(), ex.getError());
        }
        eventList = response.getEvents();
        this.refresh(response);
        CalendarComponent[] result = new CalendarComponent[eventList.size()];
        eventList.toArray(result);
        return result;
    }

    public CalendarComponent[] searchEvents(String filter, int searchOpt, Properties parsingProperties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchEvents(null, null, filter, searchOpt, parsingProperties);
    }

    public CalendarComponent[] searchEvents(String filter, int searchOpt) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchEvents(null, null, filter, searchOpt, null);
    }

    public CalendarComponent[] searchTodos(DateTime dtStart, DateTime dtEnd, String filter, int searchOpt) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchTodos(dtStart, dtEnd, filter, searchOpt, null);
    }

    public CalendarComponent[] searchTodos(DateTime dtStart, DateTime dtEnd, String filter, int searchOpt, Properties parsingProperties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        ArrayList todoList = new ArrayList();
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.searchTodos(this.getCalID(), dtStart, dtEnd, filter, searchOpt, parsingProperties);
        }
        catch (SOCSException ex) {
            throw new CalendarException(ex.getMessage(), ex.getError());
        }
        todoList = response.getTodos();
        this.refresh(response);
        CalendarComponent[] result = new CalendarComponent[todoList.size()];
        todoList.toArray(result);
        return result;
    }

    public CalendarComponent[] searchTodos(String filter, int searchOpt) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchTodos(null, null, filter, searchOpt, null);
    }

    public CalendarComponent[] searchTodos(String filter, int searchOpt, Properties parsingProperties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchTodos(null, null, filter, searchOpt, parsingProperties);
    }

    public static VFreeBusy fetchFreeBusy(String cid, DateTime start, DateTime end, String host, int port, Properties props) throws CalendarException {
        SOCSSession session = null;
        SOCSRequest request = null;
        SOCSResponse response = null;
        URLName tmpServiceURL = null;
        VFreeBusy fbInfo = null;
        if (cid == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (host == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (port <= 0) {
            port = -1;
        }
        if (props == null) {
            props = new Properties();
        }
        tmpServiceURL = new URLName("http", host, port, "", null, null);
        CalendarSession dummyCalSession = CalendarSession.getInstance(props);
        SOCSCalendarStore dummySOCSStore = new SOCSCalendarStore(dummyCalSession);
        session = SOCSSession.getInstance(dummySOCSStore);
        try {
            request = new SOCSRequest(tmpServiceURL.getURL(), session);
        }
        catch (MalformedURLException mue) {
            throw new CalendarException(mue.getMessage(), 103);
        }
        if (request == null) {
            throw new CalendarException("Unable to obtain Free/Busy because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            response = request.fetchFreeBusy(cid, start, end, null);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        catch (IllegalArgumentException iae1) {
            throw new CalendarException(iae1.getMessage(), 105);
        }
        ArrayList fbArray = response.getFreeBusy();
        if (fbArray.size() > 0) {
            fbInfo = (VFreeBusy)fbArray.get(0);
        }
        return fbInfo;
    }

    public static CalendarComponent[] searchEvents(String cid, DateTime start, DateTime end, String filter, int searchOpt, String host, int port, Properties props) throws CalendarException {
        SOCSSession session = null;
        SOCSRequest request = null;
        SOCSResponse response = null;
        URLName tmpServiceURL = null;
        ArrayList eventList = new ArrayList();
        if (cid == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (host == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (port <= 0) {
            port = -1;
        }
        if (props == null) {
            props = new Properties();
        }
        tmpServiceURL = new URLName("http", host, port, "", null, null);
        CalendarSession dummyCalSession = CalendarSession.getInstance(props);
        SOCSCalendarStore dummySOCSStore = new SOCSCalendarStore(dummyCalSession);
        session = SOCSSession.getInstance(dummySOCSStore);
        try {
            request = new SOCSRequest(tmpServiceURL.getURL(), session);
        }
        catch (MalformedURLException mue) {
            throw new CalendarException(mue.getMessage(), 103);
        }
        if (request == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            response = request.searchEvents(cid, start, end, filter, searchOpt, props);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        eventList = response.getEvents();
        CalendarComponent[] result = new CalendarComponent[eventList.size()];
        eventList.toArray(result);
        return result;
    }

    public static VEvent[] fetchEvents(String cid, String uid, String rid, String modifier, String host, int port, Properties props) throws CalendarException {
        SOCSSession session = null;
        SOCSRequest request = null;
        SOCSResponse response = null;
        URLName tmpServiceURL = null;
        ArrayList eventList = new ArrayList();
        if (cid == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (uid == null) {
            throw new CalendarException("Event uid is null ", 105);
        }
        if (host == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (port <= 0) {
            port = -1;
        }
        if (props == null) {
            props = new Properties();
        }
        tmpServiceURL = new URLName("http", host, port, "", null, null);
        CalendarSession dummyCalSession = CalendarSession.getInstance(props);
        SOCSCalendarStore dummySOCSStore = new SOCSCalendarStore(dummyCalSession);
        session = SOCSSession.getInstance(dummySOCSStore);
        try {
            request = new SOCSRequest(tmpServiceURL.getURL(), session);
        }
        catch (MalformedURLException mue) {
            throw new CalendarException(mue.getMessage(), 103);
        }
        if (request == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            response = request.fetchEventsTodos(cid, uid, rid, modifier, props, true);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        eventList = response.getEvents();
        VEvent[] result = new VEvent[eventList.size()];
        eventList.toArray(result);
        return result;
    }

    public static CalendarComponent[] fetchComponents(String cid, DateTime start, DateTime end, int compTypes, String host, int port, Properties props) throws CalendarException {
        SOCSSession session = null;
        SOCSRequest request = null;
        SOCSResponse response = null;
        URLName tmpServiceURL = null;
        if (!SOCSUtils.isBitSet(compTypes, 7)) {
            throw new CalendarException("Illegal Argument: Requested fetch component types \"" + compTypes + "\" is found to be invalid. -- Not a valid mask of any of ICalendar.VEVENT, ICalendar.VTODO, ICalendar.VFREEBUSY or ICalendar.VALL", 105);
        }
        ArrayList compList = new ArrayList();
        ArrayList eventList = new ArrayList();
        ArrayList todoList = new ArrayList();
        ArrayList freebusyList = new ArrayList();
        if (cid == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (host == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (port <= 0) {
            port = -1;
        }
        if (props == null) {
            props = new Properties();
        }
        tmpServiceURL = new URLName("http", host, port, "", null, null);
        CalendarSession dummyCalSession = CalendarSession.getInstance(props);
        SOCSCalendarStore dummySOCSStore = new SOCSCalendarStore(dummyCalSession);
        session = SOCSSession.getInstance(dummySOCSStore);
        try {
            request = new SOCSRequest(tmpServiceURL.getURL(), session);
        }
        catch (MalformedURLException mue) {
            throw new CalendarException(mue.getMessage(), 103);
        }
        if (request == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        int types2fetch = 0;
        if (SOCSUtils.isBitSet(compTypes, 1)) {
            types2fetch |= 1;
        }
        if (SOCSUtils.isBitSet(compTypes, 2)) {
            types2fetch |= 2;
        }
        if (types2fetch != 0) {
            try {
                response = request.fetchEventsTodos(cid, start, end, props, types2fetch);
            }
            catch (SOCSException e) {
                throw new CalendarException(e.getMessage(), e.getError());
            }
            if (SOCSUtils.isBitSet(types2fetch, 1)) {
                eventList = response.getEvents();
            }
            if (SOCSUtils.isBitSet(types2fetch, 2)) {
                todoList = response.getTodos();
            }
        }
        if (SOCSUtils.isBitSet(compTypes, 4)) {
            try {
                response = request.fetchFreeBusy(cid, start, end, null);
            }
            catch (SOCSException e) {
                throw new CalendarException(e.getMessage(), e.getError());
            }
            freebusyList = response.getFreeBusy();
        }
        if (!eventList.isEmpty()) {
            compList.addAll(eventList);
        }
        if (!todoList.isEmpty()) {
            compList.addAll(todoList);
        }
        if (!freebusyList.isEmpty()) {
            compList.addAll(freebusyList);
        }
        CalendarComponent[] result = new CalendarComponent[compList.size()];
        compList.toArray(result);
        return result;
    }

    public static Properties getCalProps(String cid, String host, int port, Properties props) throws CalendarException {
        SOCSSession session = null;
        SOCSRequest request = null;
        SOCSResponse response = null;
        URLName tmpServiceURL = null;
        if (cid == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (host == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (port <= 0) {
            port = -1;
        }
        if (props == null) {
            props = new Properties();
        }
        tmpServiceURL = new URLName("http", host, port, "", null, null);
        CalendarSession dummyCalSession = CalendarSession.getInstance(props);
        SOCSCalendarStore dummySOCSStore = new SOCSCalendarStore(dummyCalSession);
        session = SOCSSession.getInstance(dummySOCSStore);
        try {
            request = new SOCSRequest(tmpServiceURL.getURL(), session);
        }
        catch (MalformedURLException mue) {
            throw new CalendarException(mue.getMessage(), 103);
        }
        if (request == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            response = request.getCalProps(cid);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        Properties calProps = response.getProperties(1);
        return calProps;
    }

    public VEvent[] fetchEvents(String uid, String rid, String modifier) throws CalendarException, OperationNotSupportedException {
        return this.fetchEvents(uid, rid, modifier, null);
    }

    public VEvent[] fetchEvents(String uid, String rid, String modifier, Properties parsingProperties) throws CalendarException, OperationNotSupportedException {
        ArrayList eventList = new ArrayList();
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.fetchEventsTodos(this.getCalID(), uid, rid, modifier, parsingProperties, true);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        eventList = response.getEvents();
        this.refresh(response);
        if (null != eventList) {
            VEvent[] result = new VEvent[eventList.size()];
            eventList.toArray(result);
            return result;
        }
        return null;
    }

    public VTodo[] fetchTodos(String uid, String rid, String modifier) throws CalendarException, OperationNotSupportedException {
        return this.fetchTodos(uid, rid, modifier, null);
    }

    public VTodo[] fetchTodos(String uid, String rid, String modifier, Properties parsingProperties) throws CalendarException, OperationNotSupportedException {
        ArrayList todoList = new ArrayList();
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.fetchEventsTodos(this.getCalID(), uid, rid, modifier, parsingProperties, false);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        todoList = response.getTodos();
        this.refresh(response);
        if (null != todoList) {
            VTodo[] result = new VTodo[todoList.size()];
            todoList.toArray(result);
            return result;
        }
        return null;
    }

    public Properties getCalProps() throws CalendarException, OperationNotSupportedException {
        if (this.getProperties(1) != null) {
            return this.getProperties(1);
        }
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.getCalProps(this.getCalID());
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        this.refresh(response);
        return this.getProperties(1);
    }

    public void setCalProps(Properties props) throws CalendarException, OperationNotSupportedException {
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.setCalProps(this.getCalID(), props);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        this.refresh(response);
    }

    public void addEvent(VEvent event, boolean notify) throws CalendarException {
        this.addEvent(event, notify, null);
    }

    public void addEvent(VEvent event, boolean notify, Properties requestProperties) throws CalendarException {
        if (!event.hasProperty(SOCSEvent.STORETYPE) && this.wcapVersionInUse >= 300) {
            try {
                SOCSEvent socsEvent = (SOCSEvent)event;
                if (!socsEvent.hasProperty("WCAP_VERSION_INT")) {
                    socsEvent.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
                }
                socsEvent.setStoreType(SOCSEvent.STORETYPE_CREATE);
                event = socsEvent;
            }
            catch (CalendarComponentException e) {
                throw new CalendarException(e.getMessage(), e.getError());
            }
            catch (OperationNotSupportedException onse1) {
                throw new CalendarException(onse1.getMessage(), onse1.getError());
            }
        }
        this.modifyEvent(event, "THIS_INSTANCE", notify, requestProperties);
    }

    public void addTodo(VTodo todo, boolean notify) throws CalendarException {
        this.addTodo(todo, notify, null);
    }

    public void addTodo(VTodo todo, boolean notify, Properties requestProperties) throws CalendarException {
        if (!todo.hasProperty(SOCSTodo.STORETYPE) && this.wcapVersionInUse >= 300) {
            try {
                SOCSTodo socsTodo = (SOCSTodo)todo;
                if (!socsTodo.hasProperty("WCAP_VERSION_INT")) {
                    socsTodo.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
                }
                socsTodo.setStoreType(SOCSTodo.STORETYPE_CREATE);
                todo = socsTodo;
            }
            catch (CalendarComponentException e) {
                throw new CalendarException(e.getMessage(), e.getError());
            }
            catch (OperationNotSupportedException onse1) {
                throw new CalendarException(onse1.getMessage(), onse1.getError());
            }
        }
        this.modifyTodo(todo, "THIS_INSTANCE", notify, requestProperties);
    }

    public void modifyEvent(VEvent event, String modifier, boolean notify) throws CalendarException {
        this.modifyEvent(event, modifier, notify, null);
    }

    public void modifyEvent(VEvent event, String modifier, boolean notify, Properties requestProperties) throws CalendarException {
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            ArrayList eventList;
            if (!event.hasProperty(SOCSEvent.STORETYPE) && this.wcapVersionInUse >= 300) {
                SOCSEvent socsEvent = (SOCSEvent)event;
                if (!socsEvent.hasProperty("WCAP_VERSION_INT")) {
                    socsEvent.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
                }
                socsEvent.setStoreType(SOCSEvent.STORETYPE_MODIFY);
                event = socsEvent;
            }
            if (null != (eventList = (response = request.storeEvent(this.getCalID(), event, modifier, notify, requestProperties)).getEvents()) && eventList.size() > 0) {
                VEvent uidevent = (VEvent)eventList.get(0);
                event.setID(uidevent.getID());
            }
            this.refresh(response);
        }
        catch (SOCSException ex) {
            throw new CalendarException(ex.getMessage(), ex.getError());
        }
        catch (CalendarComponentException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (OperationNotSupportedException onse) {
            throw new CalendarException(onse.getMessage(), onse.getError());
        }
    }

    public void modifyTodo(VTodo todo, String modifier, boolean notify) throws CalendarException {
        this.modifyTodo(todo, modifier, notify, null);
    }

    public void modifyTodo(VTodo todo, String modifier, boolean notify, Properties requestProperties) throws CalendarException {
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            ArrayList todoList;
            if (!todo.hasProperty(SOCSTodo.STORETYPE) && this.wcapVersionInUse >= 300) {
                SOCSTodo socsTodo = (SOCSTodo)todo;
                if (!socsTodo.hasProperty("WCAP_VERSION_INT")) {
                    socsTodo.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
                }
                socsTodo.setStoreType(SOCSTodo.STORETYPE_MODIFY);
                todo = socsTodo;
            }
            if (null != (todoList = (response = request.storeTodo(this.getCalID(), todo, modifier, notify, requestProperties)).getTodos()) && todoList.size() > 0) {
                VTodo uidtodo = (VTodo)todoList.get(0);
                todo.setID(uidtodo.getID());
            }
            this.refresh(response);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (OperationNotSupportedException onse) {
            throw new CalendarException(onse.getMessage(), onse.getError());
        }
        catch (CalendarComponentException ccee) {
            // empty catch block
        }
    }

    public void deleteEvent(VEvent event, String modifier, boolean notify) throws CalendarException {
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.deleteevents(this.getCalID(), event, modifier, notify);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        this.refresh(response);
    }

    public void deleteTodo(VTodo todo, String modifier, boolean notify) throws CalendarException {
        SOCSSession session = this.getSOCSSession();
        SOCSRequest request = new SOCSRequest(session);
        SOCSResponse response = null;
        try {
            response = request.deletetodos(this.getCalID(), todo, modifier, notify);
        }
        catch (SOCSException e) {
            throw new CalendarException(e.getMessage(), e.getError());
        }
        this.refresh(response);
    }

    public void update() {
        try {
            this.setCalProps(this.properties[1]);
        }
        catch (OperationNotSupportedException o) {
            return;
        }
        catch (CalendarException e) {
            return;
        }
    }

    public String toRFC2445() {
        return "BEGIN:VCALENDAR\nVERSION:" + this.getVersion() + "\nPRODID:" + (null == this.getProductId() ? "" : this.getProductId()) + (null == this.getMethod() ? "" : "\nMETHOD:" + this.getMethod()) + (null == this.getCalScale() ? "" : "\nCALSCALE:" + this.getCalScale()) + this.convertToRFC2445(this.getEvents()) + this.convertToRFC2445(this.getTodos()) + this.convertToRFC2445(this.getFreeBusy()) + "\nEND:VCALENDAR";
    }

    public String toString() {
        return "SOCSCalendar[Version: " + this.getVersion() + "; ProdId: " + (null == this.getProductId() ? "" : this.getProductId()) + (null == this.getMethod() ? "" : "; Method: " + this.getMethod()) + (null == this.getCalScale() ? "" : "; CalScale: " + this.getCalScale()) + "\n; Events: " + this.convertToString(this.getEvents()) + "\n; Todos: " + this.convertToString(this.getTodos()) + "\n; FreeBusy: " + this.convertToString(this.getFreeBusy()) + "]";
    }

    public Properties getProperties(int which) {
        SOCSCalendar.checkWhich(which);
        return this.properties[which];
    }

    public static void checkWhich(int which) {
        if (which < 0 || which > 3) {
            throw new IllegalArgumentException();
        }
    }

    public ArrayList getEvents() {
        return this.events;
    }

    public ArrayList getTodos() {
        return this.todos;
    }

    public ArrayList getFreeBusy() {
        return this.freebusys;
    }

    public int getErrorNum() {
        return this.errCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(SOCSResponse response) {
        if (null != response) {
            SOCSCalendar sOCSCalendar = this;
            synchronized (sOCSCalendar) {
                Properties newProps;
                Properties oldProps = this.properties[1];
                this.properties[1] = newProps = response.getProperties(1);
                if (null != oldProps && null != newProps) {
                    if (null == newProps.getProperty(OWNER_CN_KEY) && null != oldProps.getProperty(OWNER_CN_KEY)) {
                        newProps.setProperty(OWNER_CN_KEY, oldProps.getProperty(OWNER_CN_KEY));
                    }
                    if (null == newProps.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY) && null != oldProps.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY)) {
                        newProps.setProperty(IS_INCLUDED_IN_FREEBUSY_KEY, oldProps.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY));
                    }
                    if (null == newProps.getProperty(INVITE_COUNT_KEY) && null != oldProps.getProperty(INVITE_COUNT_KEY)) {
                        newProps.setProperty(INVITE_COUNT_KEY, oldProps.getProperty(INVITE_COUNT_KEY));
                    }
                }
            }
        }
    }

    private String convertToRFC2445(ArrayList comps) {
        String rfcData = "";
        if (null == comps) {
            return rfcData;
        }
        for (int i = 0; i < comps.size(); ++i) {
            String s = null;
            CalendarComponent calComp = (CalendarComponent)comps.get(i);
            try {
                if (calComp instanceof VFreeBusy) {
                    s = ((SOCSFreeBusy)calComp).toRFC2445();
                } else if (calComp instanceof VEvent) {
                    s = ((SOCSEvent)calComp).toRFC2445();
                } else if (calComp instanceof VTodo) {
                    s = ((SOCSTodo)calComp).toRFC2445();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            rfcData = null == rfcData ? new String(s) : rfcData + "\n" + new String(s);
        }
        return rfcData;
    }

    private String convertToString(ArrayList comps) {
        String strData = "";
        if (null == comps) {
            return strData;
        }
        for (int i = 0; i < comps.size(); ++i) {
            String s = null;
            CalendarComponent calComp = (CalendarComponent)comps.get(i);
            if (calComp instanceof VFreeBusy) {
                s = ((VFreeBusy)calComp).toString();
            } else if (calComp instanceof VEvent) {
                s = ((VEvent)calComp).toString();
            } else if (calComp instanceof VTodo) {
                s = ((VTodo)calComp).toString();
            }
            strData = null == strData ? new String(s) : strData + "\n" + new String(s);
        }
        return strData;
    }

    private SOCSSession getSOCSSession() throws CalendarException {
        CalendarStore st = this.getStore();
        if (st instanceof SOCSCalendarStore) {
            try {
                return ((SOCSCalendarStore)st).getSOCSSession();
            }
            catch (CalendarStoreException stEx) {
                throw new CalendarException(stEx.getMessage());
            }
        }
        throw new CalendarException("Incorrect CalendarStore ");
    }
}

