/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.VAlarm;
import java.io.BufferedReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class SOCSAlarm
extends VAlarm {
    private CalendarComponent container;
    private String description;
    private String summary;
    private String action;
    private Duration trigger;
    private String related;
    private int repeatCount;
    private Duration repeatDuration;
    private String absTrigger;
    private Attach attachment;
    private ArrayList attendeeList;
    public static final String EMAIL = "EMAIL";
    public static final String AUDIO = "AUDIO";
    public static final String DISPLAY = "DISPLAY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String START = "START";
    public static final String END = "END";
    private static final Hashtable _actionValues = new Hashtable();
    private static final Hashtable _relatedValues = new Hashtable();

    public SOCSAlarm() {
        this.related = START;
        this.attendeeList = new ArrayList();
    }

    public SOCSAlarm(CalendarComponent container, String action, Duration trigger) throws PropertiesException {
        this.related = START;
        this.attendeeList = new ArrayList();
        this.container = container;
        this.setAction(action);
        this.trigger = trigger;
    }

    public SOCSAlarm(CalendarComponent container, String action, String absTrigger) throws PropertiesException {
        this.related = START;
        this.attendeeList = new ArrayList();
        this.container = container;
        this.setAction(action);
        this.absTrigger = absTrigger;
    }

    private String[] _split(String src, char delim, int limit) {
        String[] result = new String[limit];
        int len = src.length();
        int start = 0;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (src.charAt(i) != delim) continue;
            if (count >= limit - 1) break;
            result[count] = src.substring(start, i);
            start = i + 1;
            ++count;
        }
        if (count < limit) {
            result[count] = src.substring(start, len);
        }
        return result;
    }

    public SOCSAlarm(CalendarComponent container, String rfcString) throws IllegalArgumentException, PropertiesException {
        block28: {
            this.related = START;
            this.attendeeList = new ArrayList();
            BufferedReader alarmDef = new BufferedReader(new StringReader(rfcString));
            StreamTokenizer st = null;
            boolean emailPresent = false;
            try {
                String curLine = alarmDef.readLine();
                st = new StreamTokenizer(new StringReader(curLine));
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase("BEGIN")) {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                if ((char)st.nextToken() != ':') {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase("VALARM")) {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                while ((curLine = alarmDef.readLine()) != null) {
                    st = new StreamTokenizer(new StringReader(curLine));
                    st.nextToken();
                    String keyword = st.sval.toUpperCase();
                    if (keyword.equals("ACTION")) {
                        if ((char)st.nextToken() != ':') {
                            throw new IllegalArgumentException("Invalid VALARM format(check ACTION tag)");
                        }
                        st.nextToken();
                        this.setAction(st.sval);
                        if (!st.sval.equalsIgnoreCase(EMAIL)) continue;
                        emailPresent = true;
                        continue;
                    }
                    if (keyword.equals("TRIGGER")) {
                        char ch = (char)st.nextToken();
                        if (ch != ';' && ch != ':') {
                            throw new IllegalArgumentException("Invalid VALARM format(check TRIGGER tag)");
                        }
                        st.nextToken();
                        if (st.ttype == -3 && st.sval.toUpperCase().equals("VALUE")) {
                            String dtStr = "";
                            st.nextToken();
                            st.wordChars(45, 45);
                            st.nextToken();
                            st.nextToken();
                            block7: while (st.nextToken() != -1) {
                                switch (st.ttype) {
                                    case -3: {
                                        dtStr = dtStr + st.sval;
                                        continue block7;
                                    }
                                    case -2: {
                                        dtStr = dtStr + String.valueOf((int)st.nval);
                                        continue block7;
                                    }
                                }
                                char[] c = new char[]{(char)st.ttype};
                                dtStr = dtStr + new String(c);
                            }
                            this.absTrigger = dtStr;
                            continue;
                        }
                        String sign = "";
                        if ((char)st.ttype == '-') {
                            sign = "-";
                            st.nextToken();
                        }
                        String durStr = "DURATION:" + sign + st.sval;
                        this.trigger = new Duration(durStr);
                        continue;
                    }
                    if (keyword.equals("DURATION")) {
                        this.repeatDuration = new Duration(curLine);
                        continue;
                    }
                    if (keyword.equals("ATTACH")) {
                        this.attachment = new Attach("RFC", curLine);
                        continue;
                    }
                    if (keyword.equals("ATTENDEE")) {
                        if (!emailPresent) {
                            throw new IllegalArgumentException("Invalid VALARM format(ATTENDEE tag irrelevant)");
                        }
                        Attendee att = new Attendee(curLine);
                        this.attendeeList.add(att);
                        continue;
                    }
                    if (keyword.equals("DESCRIPTION")) {
                        String[] tokens = this._split(curLine, ':', 2);
                        if (tokens.length != 2) {
                            throw new IllegalArgumentException("Invalid VALARM format(check DESCRIPTION tag)");
                        }
                        this.description = tokens[1];
                        continue;
                    }
                    if (keyword.equals("SUMMARY")) {
                        String[] tokens = this._split(curLine, ':', 2);
                        if (tokens.length != 2) {
                            throw new IllegalArgumentException("Invalid VALARM format(check SUMMARY tag)");
                        }
                        this.summary = tokens[1];
                        continue;
                    }
                    if (!keyword.equals("REPEAT")) continue;
                    if ((char)st.nextToken() != ':') {
                        throw new IllegalArgumentException("Invalid VALARM format(check REPEAT tag)");
                    }
                    if (st.nextToken() != -2) {
                        throw new IllegalArgumentException("Invalid VALARM format(check REPEAT tag)");
                    }
                    this.setRepeatCount((int)st.nval);
                }
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof PropertiesException)) break block28;
                throw (PropertiesException)e;
            }
        }
    }

    public CalendarComponent getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAction() {
        return this.action;
    }

    public Duration getTrigger() {
        return this.trigger;
    }

    public String getAbsTrigger() {
        return this.absTrigger;
    }

    public String getRelated() {
        return this.related;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setAction(String action) throws PropertiesException {
        if (_actionValues.get(action.toUpperCase()) == null) {
            PropertiesException ex = new PropertiesException(PropertiesException.errorMessages[1]);
            throw ex;
        }
        this.action = action;
    }

    public void setTrigger(Duration trigger) {
        this.trigger = trigger;
        this.absTrigger = null;
    }

    public void setAbsTrigger(String absTrigger) {
        this.absTrigger = absTrigger;
        this.trigger = null;
    }

    public void setRelated(String related) throws PropertiesException {
        if (_relatedValues.get(related.toUpperCase()) == null) {
            PropertiesException ex = new PropertiesException(PropertiesException.errorMessages[1]);
            throw ex;
        }
        this.related = related;
    }

    public void setRepeatCount(int count) {
        this.repeatCount = count;
    }

    public void setRepeat(int count, Duration rptDuration) {
        this.repeatCount = count;
        this.repeatDuration = rptDuration;
    }

    public void addAttendee(Attendee attendee) {
        this.attendeeList.add(attendee);
    }

    public Attendee[] getAttendees() {
        if (this.attendeeList == null || this.attendeeList.size() == 0) {
            return null;
        }
        Attendee[] attendees = new Attendee[this.attendeeList.size()];
        return this.attendeeList.toArray(attendees);
    }

    public void removeAttendee(Attendee attendee) {
        if (this.attendeeList == null || this.attendeeList.size() == 0 || attendee == null) {
            return;
        }
        for (int i = 0; i < this.attendeeList.size(); ++i) {
            String attVal = attendee.getValue();
            if (attVal == null || !attVal.equals(((Attendee)this.attendeeList.get(i)).getValue())) continue;
            this.attendeeList.remove(i);
            break;
        }
    }

    public String toRFC2445() {
        String rfc = "BEGIN:VALARM\n";
        rfc = rfc + "ACTION:" + this.action + "\n";
        if (this.absTrigger != null) {
            rfc = rfc + "TRIGGER;VALUE=DATE-TIME:" + this.absTrigger + "\n";
        } else {
            StringTokenizer st = new StringTokenizer(this.trigger.toRFC2445(), ":");
            st.nextToken();
            rfc = rfc + "TRIGGER:" + st.nextToken() + "\n";
        }
        if (this.description != null) {
            rfc = rfc + "DESCRIPTION:" + this.description + "\n";
        }
        if (this.summary != null) {
            rfc = rfc + "SUMMARY:" + this.summary + "\n";
        }
        if (!this.related.equals(START)) {
            rfc = rfc + "RELATED:" + this.related + "\n";
        }
        if (this.repeatCount > 0) {
            rfc = rfc + "REPEAT:" + this.repeatCount + "\n";
        }
        if (this.repeatDuration != null) {
            rfc = rfc + this.repeatDuration.toRFC2445() + "\n";
        }
        if (this.attachment != null) {
            rfc = rfc + this.attachment.toRFC2445() + "\n";
        }
        if (this.attendeeList.size() > 0) {
            Iterator itr = this.attendeeList.iterator();
            while (itr.hasNext()) {
                rfc = rfc + ((Attendee)itr.next()).toRFC2445() + "\n";
            }
        }
        rfc = rfc + "END:VALARM";
        return rfc;
    }

    static {
        _actionValues.put(EMAIL, "Dummy1");
        _actionValues.put(AUDIO, "Dummy2");
        _actionValues.put(DISPLAY, "Dummy3");
        _actionValues.put(PROCEDURE, "Dummy4");
        _relatedValues.put(START, "Dummy1");
        _relatedValues.put(END, "Dummy2");
    }
}

