/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.PropertiesException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class RecurrencePattern {
    private int interval;
    private int numInstances = 0;
    private int frequency;
    private DateTime dtUntil = null;
    private String byMonthList = null;
    private String byDayList = null;
    private String byHourList = null;
    private String byMinuteList = null;
    private String bySecondsList = null;
    private String byMonthDayList = null;
    private String byWeekNumberList = null;
    private String byYearDayList = null;
    private String byInstancePosList = null;
    private String weekStart = "MO";
    public static final int SECONDLY = 10;
    public static final int MINUTELY = 20;
    public static final int HOURLY = 30;
    public static final int DAILY = 40;
    public static final int WEEKLY = 50;
    public static final int MONTHLY = 60;
    public static final int YEARLY = 70;
    public static final int FREQ = 101;
    public static final int INTERVAL = 201;
    public static final int COUNT = 301;
    public static final int UNTIL = 310;
    public static final int WKST = 325;
    public static final int BYSECOND = 401;
    public static final int BYMINUTE = 501;
    public static final int BYHOUR = 601;
    public static final int BYMONTH = 701;
    public static final int BYMONTHDAY = 710;
    public static final int BYDAY = 801;
    public static final int BYYEARDAY = 901;
    public static final int BYWEEKNO = 910;
    public static final int BYSETPOS = 920;
    public static final String THIS_INSTANCE = "THIS_INSTANCE";
    public static final String THIS_AND_FUTURE = "THIS_AND_FUTURE";
    public static final String THIS_AND_PRIOR = "THIS_AND_PRIOR";
    public static final String THIS_AND_ALL = "THIS_AND_ALL";
    private static final Hashtable paramTable = new Hashtable();
    private static final Hashtable freqTable = new Hashtable();

    private void processParams(String avPair) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(avPair, "=");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("Syntax error in Recurrence Pattern");
        }
        String attr = st.nextToken();
        String val = st.nextToken();
        try {
            Integer enumval = (Integer)paramTable.get(attr);
            if (enumval == null) {
                throw new IllegalArgumentException("Invalid Recurrence Pattern");
            }
            switch (enumval) {
                case 101: {
                    this.frequency = (Integer)freqTable.get(val);
                    return;
                }
                case 201: {
                    this.interval = Integer.parseInt(val);
                    return;
                }
                case 301: {
                    this.numInstances = Integer.parseInt(val);
                    return;
                }
                case 310: {
                    this.dtUntil = new DateTime(val, TimeZone.getTimeZone("GMT"));
                    return;
                }
                case 401: {
                    this.bySecondsList = val;
                    return;
                }
                case 501: {
                    this.byMinuteList = val;
                    return;
                }
                case 601: {
                    this.byHourList = val;
                    return;
                }
                case 801: {
                    this.byDayList = val;
                    return;
                }
                case 901: {
                    this.byYearDayList = val;
                    return;
                }
                case 910: {
                    this.byWeekNumberList = val;
                    return;
                }
                case 701: {
                    this.byMonthList = val;
                    return;
                }
                case 710: {
                    this.byMonthDayList = val;
                    return;
                }
                case 325: {
                    this.weekStart = val;
                    return;
                }
                case 920: {
                    this.byInstancePosList = val;
                    return;
                }
            }
            throw new IllegalArgumentException("RecurrencePattern: Invalid property value");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private String getListParam(String pm, String val) {
        if (val != null) {
            return ";" + pm + "=" + val;
        }
        return "";
    }

    public RecurrencePattern(int freq, int interval, int count) {
        this.frequency = freq;
        this.interval = interval;
        this.numInstances = count;
    }

    public RecurrencePattern(int freq, int interval) {
        this.frequency = freq;
        this.interval = interval;
        this.numInstances = -1;
    }

    public RecurrencePattern(int freq, int interval, DateTime dtUntil) {
        this.frequency = freq;
        this.interval = interval;
        this.dtUntil = dtUntil;
    }

    public RecurrencePattern(String freq, int interval, int count) {
        this.frequency = (Integer)freqTable.get(freq.toUpperCase());
        this.interval = interval;
        this.numInstances = count;
    }

    public RecurrencePattern(String freq, int interval) {
        this.frequency = (Integer)freqTable.get(freq.toUpperCase());
        this.interval = interval;
        this.numInstances = -1;
    }

    public RecurrencePattern(String pat) throws IllegalArgumentException {
        String s;
        StringTokenizer st = new StringTokenizer(pat, ":");
        String rpat = pat;
        this.numInstances = -1;
        this.interval = 1;
        if (st.countTokens() > 1) {
            s = st.nextToken();
            if (s != null && !s.equalsIgnoreCase("RRULE")) {
                throw new IllegalArgumentException("Not a Recurrence Pattern");
            }
            rpat = st.nextToken();
        }
        st = new StringTokenizer(rpat, ";");
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            this.processParams(s);
        }
    }

    public void setFrequency(String freq) throws PropertiesException {
        Integer val = (Integer)freqTable.get(freq);
        boolean fr = false;
        if (val == null) {
            throw new PropertiesException("RecurrencePattern:Invalid frequency value", 2);
        }
        this.frequency = val;
    }

    public void setUntilDate(DateTime dtUntil) {
        this.dtUntil = dtUntil;
    }

    public void setByMonth(String monthList) {
        this.byMonthList = monthList;
    }

    public void setByDay(String dayList) {
        this.byDayList = dayList;
    }

    public void setByHour(String hourList) {
        this.byHourList = hourList;
    }

    public void setByMinute(String minList) {
        this.byMinuteList = minList;
    }

    public void setBySecond(String secList) {
        this.bySecondsList = secList;
    }

    public void setByMonthDay(String mDayList) {
        this.byMonthDayList = mDayList;
    }

    public void setByYearDay(String yDayList) {
        this.byYearDayList = yDayList;
    }

    public void setByWeekNumber(String weekNumList) {
        this.byWeekNumberList = weekNumList;
    }

    public void setInstancePos(String posList) {
        this.byInstancePosList = posList;
    }

    public void setWeekStart(String wkst) {
        this.weekStart = wkst;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public String getFrequency() {
        Integer val = new Integer(this.frequency);
        int len = freqTable.size();
        Enumeration keys = freqTable.keys();
        for (int i = 0; i < len; ++i) {
            String key = (String)keys.nextElement();
            if (!((Integer)freqTable.get(key)).equals(val)) continue;
            return key;
        }
        return null;
    }

    public DateTime getUntilDate() {
        return this.dtUntil;
    }

    public int getCount() {
        return this.numInstances;
    }

    public String getByMonth() {
        return this.byMonthList;
    }

    public String getByDay() {
        return this.byDayList;
    }

    public String getByHour() {
        return this.byHourList;
    }

    public String getByMinute() {
        return this.byMinuteList;
    }

    public String getBySecond() {
        return this.bySecondsList;
    }

    public String getByMonthDay() {
        return this.byMonthDayList;
    }

    public String getByYearDay() {
        return this.byYearDayList;
    }

    public String getByWeekNumber() {
        return this.byWeekNumberList;
    }

    public String getByInstancePos() {
        return this.byInstancePosList;
    }

    public String getWeekStart() {
        return this.weekStart;
    }

    public String generatePattern() {
        String pat = "FREQ=" + this.getFrequency();
        pat = pat + ";INTERVAL=" + this.interval;
        if (this.dtUntil != null) {
            pat = pat + ";UNTIL=" + this.dtUntil.toISO8601();
        } else if (this.numInstances != -1) {
            pat = pat + ";COUNT=" + this.numInstances;
        }
        pat = pat + this.getListParam("WKST", this.weekStart);
        pat = pat + this.getListParam("BYSECOND", this.bySecondsList);
        pat = pat + this.getListParam("BYMINUTE", this.byMinuteList);
        pat = pat + this.getListParam("BYHOUR", this.byHourList);
        pat = pat + this.getListParam("BYDAY", this.byDayList);
        pat = pat + this.getListParam("BYMONTH", this.byMonthList);
        pat = pat + this.getListParam("BYMONTHDAY", this.byMonthDayList);
        pat = pat + this.getListParam("BYYEARDAY", this.byYearDayList);
        pat = pat + this.getListParam("BYWEEKNO", this.byWeekNumberList);
        pat = pat + this.getListParam("BYSETPOS", this.byInstancePosList);
        pat = pat + this.getListParam("BYYEARDAY", this.byYearDayList);
        return pat;
    }

    public String toRFC2445() {
        return this.generatePattern();
    }

    static {
        paramTable.put("FREQ", new Integer(101));
        paramTable.put("INTERVAL", new Integer(201));
        paramTable.put("COUNT", new Integer(301));
        paramTable.put("UNTIL", new Integer(310));
        paramTable.put("BYSECOND", new Integer(401));
        paramTable.put("BYMINUTE", new Integer(501));
        paramTable.put("BYHOUR", new Integer(601));
        paramTable.put("BYMONTH", new Integer(701));
        paramTable.put("BYMONTHDAY", new Integer(710));
        paramTable.put("BYDAY", new Integer(801));
        paramTable.put("WKST", new Integer(325));
        paramTable.put("BYWEEKNO", new Integer(910));
        paramTable.put("BYYEARDAY", new Integer(901));
        paramTable.put("BYSETPOS", new Integer(920));
        freqTable.put("SECONDLY", new Integer(10));
        freqTable.put("MINUTELY", new Integer(20));
        freqTable.put("HOURLY", new Integer(30));
        freqTable.put("DAILY", new Integer(40));
        freqTable.put("WEEKLY", new Integer(50));
        freqTable.put("MONTHLY", new Integer(60));
        freqTable.put("YEARLY", new Integer(70));
    }
}

