/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.PropertiesException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;

public class Organizer {
    public static final String COMMON_NAME = "CN";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String SENTBY = "SENTBY";
    public static final String DIR = "DIR";
    protected String commonName;
    protected String dirURL;
    protected String sentBy;
    protected String myValue;
    protected String lang;

    public Organizer() {
    }

    public Organizer(String cn, String val) {
        this.commonName = cn;
        this.myValue = val;
    }

    public Organizer(String rfcFormat) throws IllegalArgumentException {
        block10: {
            StreamTokenizer st = new StreamTokenizer(new StringReader(rfcFormat));
            st.wordChars(64, 64);
            st.wordChars(32, 32);
            String value = "";
            try {
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase("ORGANIZER")) {
                    throw new IllegalArgumentException("Invalid ORGANIZER definition format(see RFC2445)");
                }
                char ch = (char)st.nextToken();
                String avPair = "";
                while (ch == ';') {
                    st.nextToken();
                    avPair = avPair + st.sval;
                    st.nextToken();
                    avPair = avPair + "=";
                    st.nextToken();
                    avPair = avPair + st.sval;
                    this.processParams(avPair);
                    avPair = "";
                    ch = (char)st.nextToken();
                }
                if (ch != ':') {
                    throw new IllegalArgumentException("Missing ORGANIZER value(see RFC2445)");
                }
                block7: while (st.nextToken() != -1) {
                    switch (st.ttype) {
                        case -3: {
                            value = value + st.sval;
                            continue block7;
                        }
                        case -2: {
                            value = value + String.valueOf(st.nval);
                            continue block7;
                        }
                    }
                    char[] c = new char[]{(char)st.ttype};
                    value = value + new String(c);
                }
                this.myValue = value;
            }
            catch (Exception e) {
                if (!(e instanceof IllegalArgumentException)) break block10;
                throw (IllegalArgumentException)e;
            }
        }
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getSentBy() {
        return this.sentBy;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getDir() {
        return this.dirURL;
    }

    public void setSentBy(String name) {
        this.sentBy = name;
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public void setCommonName(String cn) {
        this.commonName = cn;
    }

    public void setDir(String dir) {
        this.dirURL = dir;
    }

    public void setValue(String val) {
        this.myValue = val;
    }

    protected void processParams(String avPair) throws IllegalArgumentException, PropertiesException {
        StringTokenizer st = new StringTokenizer(avPair, "=");
        if (st.countTokens() <= 1) {
            throw new IllegalArgumentException("Syntax error in Organizer(or subclass) object");
        }
        String attr = st.nextToken();
        String val = st.nextToken();
        if ((attr = attr.toUpperCase()).equals(COMMON_NAME)) {
            this.commonName = val;
        } else if (attr.equals("SENT-BY")) {
            this.sentBy = val;
        } else if (attr.equals(LANGUAGE)) {
            this.lang = val;
        } else if (attr.equals(DIR)) {
            this.dirURL = val;
        }
    }

    public String toRFC2445() {
        String out = "ORGANIZER";
        if (this.commonName != null) {
            out = out + ";CN=" + this.commonName;
        }
        if (this.dirURL != null) {
            out = out + ";DIR=" + this.dirURL;
        }
        if (this.sentBy != null) {
            out = out + ";SENT-BY=" + this.sentBy;
        }
        if (this.lang != null) {
            out = out + ";LANGUAGE=" + this.lang;
        }
        if (this.myValue != null) {
            out = out + ":" + this.myValue;
        }
        return out;
    }
}

