/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import java.util.Properties;
import java.util.TimeZone;

public abstract class ICalendar {
    private CalendarStore store;
    protected String calId;
    public static final int VEVENT = 1;
    public static final int VTODO = 2;
    public static final int VFREEBUSY = 4;
    public static final int VALL = 7;

    protected ICalendar(CalendarStore store, String calId) {
        this.store = store;
        this.calId = calId;
    }

    public String getCalID() {
        return this.calId;
    }

    public CalendarStore getStore() {
        return this.store;
    }

    public abstract VEvent createEvent() throws CalendarException, OperationNotSupportedException;

    public abstract VTodo createTodo() throws CalendarException, OperationNotSupportedException;

    public boolean isUserTheOwner() throws CalendarException, OperationNotSupportedException {
        return this.isUserTheOwner(false);
    }

    public boolean isUserTheOwner(boolean ignoreCase) throws CalendarException, OperationNotSupportedException {
        return this.isUserTheOwner(this.getStore().getSession().getProperty("cal.user"), ignoreCase);
    }

    public boolean isUserTheOwner(String uid) throws CalendarException, OperationNotSupportedException {
        return this.isUserTheOwner(uid, false);
    }

    public abstract boolean isUserTheOwner(String var1, boolean var2) throws CalendarException, OperationNotSupportedException;

    public abstract TimeZone getTimeZone() throws CalendarException, OperationNotSupportedException;

    public abstract void setTimeZone(TimeZone var1) throws CalendarException, OperationNotSupportedException;

    public abstract String getDisplayName() throws CalendarException, OperationNotSupportedException;

    public CalendarComponent[] fetchComponents(int componentTypes) throws CalendarException {
        TimeZone timezone = this.getStore().getSession().getTimeZone();
        DateTime today = null;
        today = null == timezone ? new DateTime() : new DateTime(timezone);
        return this.fetchComponents(today, componentTypes);
    }

    public CalendarComponent[] fetchComponents(DateTime day, int componentTypes) throws CalendarException {
        if (null == day) {
            throw new CalendarException("Illegal Argument: null day");
        }
        DateTime start = (DateTime)day.clone();
        DateTime end = (DateTime)day.clone();
        start.setTime(0, 0, 0);
        end.setTime(23, 59, 59);
        return this.fetchComponents(start, end, componentTypes);
    }

    public CalendarComponent[] fetchComponents(DateTime start, Duration duration, int componentTypes) throws CalendarException {
        if (null == start) {
            throw new CalendarException("Illegal Argument: null start");
        }
        if (null == duration) {
            throw new CalendarException("Illegal Argument: null duration");
        }
        DateTime end = (DateTime)start.clone();
        end.add(duration);
        return this.fetchComponents(start, end, componentTypes);
    }

    public abstract CalendarComponent[] fetchComponents(DateTime var1, DateTime var2, int var3) throws CalendarException;

    public CalendarComponent[] fetchComponents(String uid) throws CalendarException, OperationNotSupportedException {
        return this.fetchComponents(uid, null, null);
    }

    public abstract CalendarComponent[] fetchComponents(String var1, String var2, String var3) throws CalendarException, OperationNotSupportedException;

    public VEvent[] fetchEvents(String uid) throws CalendarException, OperationNotSupportedException {
        return this.fetchEvents(uid, null, null);
    }

    public abstract VEvent[] fetchEvents(String var1, String var2, String var3) throws CalendarException, OperationNotSupportedException;

    public VTodo[] fetchTodos(String uid) throws CalendarException, OperationNotSupportedException {
        return this.fetchTodos(uid, null, null);
    }

    public abstract VTodo[] fetchTodos(String var1, String var2, String var3) throws CalendarException, OperationNotSupportedException;

    public abstract Properties getCalProps() throws CalendarException, OperationNotSupportedException;

    public abstract void setCalProps(Properties var1) throws CalendarException, OperationNotSupportedException;

    public abstract void addEvent(VEvent var1, boolean var2) throws CalendarException;

    public abstract void addTodo(VTodo var1, boolean var2) throws CalendarException;

    public abstract void modifyEvent(VEvent var1, String var2, boolean var3) throws CalendarException;

    public abstract void modifyTodo(VTodo var1, String var2, boolean var3) throws CalendarException;

    public abstract void deleteEvent(VEvent var1, String var2, boolean var3) throws CalendarException;

    public abstract void deleteTodo(VTodo var1, String var2, boolean var3) throws CalendarException;

    public void update() {
    }

    public abstract String toRFC2445();

    public abstract String toString();
}

