/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusyException;
import com.sun.comclient.calendar.PropertiesException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class FreeBusy {
    private static final String FREEBUSY = "FREEBUSY";
    private static final String FBTYPE = "FBTYPE";
    private static final String DURATION = "DURATION";
    private String fbtype = "BUSY";
    private DateTime dtstart = null;
    private DateTime dtend = null;
    private Duration duration = null;
    private boolean hasDuration = false;
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();

    public FreeBusy(String fbtype, DateTime dtstart, DateTime dtend) throws IllegalArgumentException {
        if (null == fbtype) {
            throw new IllegalArgumentException("input given for \"fbtype\" argument was found to be null");
        }
        if (null == dtstart) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dtend) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        this.fbtype = fbtype;
        this.dtstart = dtstart;
        this.dtend = dtend;
        this.duration = null;
        this.hasDuration = false;
    }

    public FreeBusy(String fbtype, DateTime dtstart, Duration duration) throws IllegalArgumentException {
        if (null == fbtype) {
            throw new IllegalArgumentException("input given for \"fbtype\" argument was found to be null");
        }
        if (null == dtstart) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        this.fbtype = fbtype;
        this.dtstart = dtstart;
        this.dtend = null;
        this.duration = duration;
        this.hasDuration = true;
    }

    public static FreeBusy[] fromRFC2445(String rfcForm) throws IllegalArgumentException, FreeBusyException, ParseException, PropertiesException {
        return FreeBusy.fromRFC2445(rfcForm, null);
    }

    public static FreeBusy[] fromRFC2445(String rfcForm, TimeZone timezone) throws IllegalArgumentException, FreeBusyException, ParseException, PropertiesException {
        int index;
        if (null == rfcForm) {
            throw new IllegalArgumentException("input given for \"rfcForm\" argument was found to be null");
        }
        String inputStr = new String(rfcForm.toUpperCase());
        String prefix1 = "FREEBUSY:";
        String prefix2 = "FREEBUSY;FBTYPE=";
        String fb_type = "BUSY";
        if (inputStr.startsWith(prefix1)) {
            inputStr = inputStr.substring(prefix1.length(), inputStr.length());
        } else if (inputStr.startsWith(prefix2)) {
            index = (inputStr = inputStr.substring(prefix2.length(), inputStr.length())).indexOf(":");
            if (-1 == index || inputStr.startsWith(":")) {
                throw FreeBusy.getInvalidFormatException(rfcForm);
            }
            fb_type = inputStr.substring(0, index);
            inputStr = inputStr.substring(index + 1, inputStr.length());
        } else {
            throw FreeBusy.getInvalidFormatException(rfcForm);
        }
        if (0 == inputStr.length()) {
            throw FreeBusy.getInvalidFormatException(rfcForm);
        }
        ArrayList<FreeBusy> alist = new ArrayList<FreeBusy>();
        StringTokenizer st = new StringTokenizer(inputStr, ",");
        while (st.hasMoreTokens()) {
            DateTime start_time;
            String nextElem = (String)st.nextElement();
            index = nextElem.indexOf("/");
            if (-1 == index) {
                throw FreeBusy.getInvalidFormatException(rfcForm);
            }
            String start_part = nextElem.substring(0, index);
            String end_part = nextElem.substring(index + 1, nextElem.length());
            if (0 == start_part.length() || 0 == end_part.length()) {
                throw FreeBusy.getInvalidFormatException(rfcForm);
            }
            FreeBusy fb_object = null;
            DateTime dateTime = start_time = null == timezone ? new DateTime(start_part) : new DateTime(start_part, timezone);
            if (end_part.startsWith("P") || end_part.startsWith("p")) {
                Duration duration = new Duration(end_part);
                fb_object = new FreeBusy(fb_type, start_time, duration);
            } else {
                DateTime end_time = null == timezone ? new DateTime(end_part) : new DateTime(end_part, timezone);
                fb_object = new FreeBusy(fb_type, start_time, end_time);
            }
            alist.add(fb_object);
        }
        FreeBusy[] fb_objects = new FreeBusy[alist.size()];
        alist.toArray(fb_objects);
        return fb_objects;
    }

    public String toRFC2445() {
        return "FREEBUSY;FBTYPE=" + this.getFBtype() + ":" + this.getStart().toISOString() + "/" + (this.hasDuration() ? this.getDuration().toRFC2445().substring(rfcDurationPrefixLength) : this.getEnd().toISOString());
    }

    public String toString() {
        return "FreeBusy[fbtype=" + this.getFBtype() + "; start=" + this.getStart().toISOString() + "; hasDuration=" + this.hasDuration() + "; end=" + (null == this.getEnd() ? null : this.getEnd().toISOString()) + "; duration=" + (null == this.getDuration() ? null : this.getDuration().toRFC2445().substring(rfcDurationPrefixLength)) + "]";
    }

    public String getFBtype() {
        return this.fbtype;
    }

    public DateTime getStart() {
        return this.dtstart;
    }

    public DateTime getEnd() {
        return this.dtend;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }

    private static FreeBusyException getInvalidFormatException(String data) {
        return new FreeBusyException("Cannot parse the input string <" + data + "> -- does not confirm to \"FREEBUSY\" property format as specified in RFC 2445");
    }
}

