/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.PropertiesException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;

public class Duration {
    private static final int MINUTE_2_SECONDS = 60;
    private static final int HOUR_2_MINUTES = 60;
    private static final int HOUR_2_SECONDS = 3600;
    private static final int DAY_2_HOURS = 24;
    private static final int DAY_2_MINUTES = 1440;
    private static final int DAY_2_SECONDS = 86400;
    private static final int WEEK_2_DAYS = 7;
    private static final int WEEK_2_HOURS = 168;
    private static final int WEEK_2_MINUTES = 10080;
    private static final int WEEK_2_SECONDS = 604800;
    private static final int NEGATIVE_SIGN = -1;
    private static final int POSITIVE_SIGN = 1;
    private int weeks = 0;
    private int days = 0;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private int sign = 1;

    public Duration() {
    }

    public Duration(int weeks) throws PropertiesException {
        if (weeks < 1) {
            throw new PropertiesException("Invalid weeks value", 2);
        }
        this.weeks = weeks;
    }

    public Duration(int hours, int minutes) throws PropertiesException {
        this._init(0, hours, minutes, 0);
    }

    public Duration(int days, int hours, int minutes, int seconds) throws PropertiesException {
        this._init(days, hours, minutes, seconds);
    }

    private void _init(int days, int hours, int minutes, int seconds) throws PropertiesException {
        if (days < 0 || days > 366) {
            throw new PropertiesException("Invalid days value", 2);
        }
        if (hours < 0 || hours > 23) {
            throw new PropertiesException("Invalid hours value", 2);
        }
        if (minutes < 0 || minutes > 59) {
            throw new PropertiesException("Invalid minutes value", 2);
        }
        if (seconds < 0 || seconds > 59) {
            throw new PropertiesException("Invalid seconds value", 2);
        }
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.sign = 1;
        this.weeks = 0;
    }

    private void _init(long seconds) throws PropertiesException {
        int sign = 1;
        if (0L > seconds) {
            seconds = -1L * seconds;
            sign = -1;
        }
        int secs = (int)seconds % 60;
        int minutes = (int)((seconds -= (long)secs) % 3600L) / 60;
        int hours = (int)((seconds -= (long)(minutes * 60)) % 86400L) / 3600;
        int days = (int)(seconds -= (long)(hours * 3600)) / 86400;
        this._init(days, hours, minutes, secs);
        this.setSign(sign);
    }

    public Duration(long seconds) throws PropertiesException {
        this._init(seconds);
    }

    public Duration(DateTime startDate, DateTime endDate) throws PropertiesException, IllegalArgumentException {
        if (null == startDate) {
            throw new IllegalArgumentException("null startDate");
        }
        if (null == endDate) {
            throw new IllegalArgumentException("null endDate");
        }
        long millSecsDiff = startDate.getTime().getTime() - endDate.getTime().getTime();
        long secsDiff = millSecsDiff / 1000L;
        this._init(secsDiff);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Duration(String rfcFormat) throws PropertiesException, IllegalArgumentException {
        if (null == rfcFormat) {
            throw new IllegalArgumentException("null rfcFormat");
        }
        String value = "";
        String text = rfcFormat;
        boolean timePresent = false;
        boolean numPresent = false;
        int curValue = 0;
        if (rfcFormat.startsWith("DURATION")) {
            StringTokenizer tok = new StringTokenizer(rfcFormat, ":");
            if (tok.countTokens() != 2) {
                throw new PropertiesException("Duration:Invalid format.");
            }
            tok.nextToken();
            text = tok.nextToken();
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(text));
        try {
            st.ordinaryChar(68);
            st.ordinaryChar(87);
            st.ordinaryChar(72);
            st.ordinaryChar(77);
            st.ordinaryChar(83);
            st.ordinaryChar(80);
            st.ordinaryChar(84);
            char ch = (char)st.nextToken();
            if (ch != 'P' && ch != '-' && ch != '+') {
                throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
            }
            if (ch == '-') {
                this.sign = -1;
                ch = (char)st.nextToken();
                if (ch != 'P') {
                    throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                }
            }
            boolean daysSeen = false;
            st.nextToken();
            if (st.ttype == -2) {
                curValue = (int)st.nval;
                ch = (char)st.nextToken();
                if (ch == 'W') {
                    this.weeks = curValue;
                    return;
                }
                if (ch != 'D') throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                this.days = curValue;
                daysSeen = true;
                ch = (char)st.nextToken();
                if (st.ttype != -1 && ch != 'T') {
                    throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                }
            } else if ((char)st.ttype != 'T') {
                throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
            }
            boolean numState = false;
            int valSeen = 0;
            block5: while (st.nextToken() != -1) {
                switch (st.ttype) {
                    case -2: {
                        curValue = (int)st.nval;
                        numState = true;
                        ++valSeen;
                        continue block5;
                    }
                }
                ch = (char)st.ttype;
                if (ch != 'H' && ch != 'M' && ch != 'S') throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                ++valSeen;
                if (!numState) {
                    throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                }
                numState = false;
                if (ch == 'H') {
                    this.hours = curValue;
                    continue;
                }
                if (ch == 'M') {
                    this.minutes = curValue;
                    continue;
                }
                if (ch != 'S') continue;
                this.seconds = curValue;
            }
            if (daysSeen || valSeen >= 2) return;
            throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            if (!(e instanceof PropertiesException)) return;
            throw (PropertiesException)e;
        }
    }

    public int getSign() {
        return this.sign < 0 ? -1 : 1;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    public String toRFC2445() {
        String rfc = "DURATION:";
        if (this.sign < 0) {
            rfc = rfc + "-";
        }
        rfc = rfc + "P";
        if (this.weeks > 0) {
            rfc = rfc + this.weeks + "W";
            return rfc;
        }
        if (this.days > 0) {
            rfc = rfc + this.days + "D";
        }
        if (this.hours + this.minutes + this.seconds > 0) {
            rfc = rfc + "T";
            if (this.hours > 0) {
                rfc = rfc + this.hours + "H";
            }
            if (this.minutes > 0) {
                rfc = rfc + this.minutes + "M";
            }
            if (this.seconds > 0) {
                rfc = rfc + this.seconds + "S";
            }
        }
        return rfc;
    }

    public long toSeconds() {
        return this.getSign() * (this.getSeconds() + this.getMinutes() * 60 + this.getHours() * 3600 + this.getDays() * 86400 + this.getWeeks() * 604800);
    }
}

